/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.FrameSerializer$;
import org.http4s.blaze.http.http2.HeaderAggregatingFrameListener;
import org.http4s.blaze.http.http2.HeaderDecoder;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.InboundStreamState;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.StreamState;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001\u0002\b\u0010\tiA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tG\u0001\u0011\t\u0011)A\u0005I!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u00035\u0001\u0011\u0005S\u0007C\u0003Z\u0001\u0011\u0005#\fC\u0003`\u0001\u0011\u0005\u0003\rC\u0003q\u0001\u0011\u0005\u0013\u000fC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\b\u0001!\t%!\u0003\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014!9\u0011q\u0005\u0001\u0005B\u0005%\u0002bBA,\u0001\u0011\u0005\u0013\u0011\f\u0002\u0015'\u0016\u001c8/[8o\rJ\fW.\u001a'jgR,g.\u001a:\u000b\u0005A\t\u0012!\u00025uiB\u0014$B\u0001\n\u0014\u0003\u0011AG\u000f\u001e9\u000b\u0005Q)\u0012!\u00022mCj,'B\u0001\f\u0018\u0003\u0019AG\u000f\u001e95g*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011A$H\u0007\u0002\u001f%\u0011ad\u0004\u0002\u001f\u0011\u0016\fG-\u001a:BO\u001e\u0014XmZ1uS:<gI]1nK2K7\u000f^3oKJ\fqa]3tg&|g\u000e\u0005\u0002\u001dC%\u0011!e\u0004\u0002\f'\u0016\u001c8/[8o\u0007>\u0014X-\u0001\u0005jg\u000ec\u0017.\u001a8u!\t)\u0003&D\u0001'\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0005\u001d\u0011un\u001c7fC:\fQ\u0002[3bI\u0016\u0014H)Z2pI\u0016\u0014\bC\u0001\u000f-\u0013\tisBA\u0007IK\u0006$WM\u001d#fG>$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\tA\n$g\r\t\u00039\u0001AQa\b\u0003A\u0002\u0001BQa\t\u0003A\u0002\u0011BQA\u000b\u0003A\u0002-\nac\u001c8D_6\u0004H.\u001a;f\u0011\u0016\fG-\u001a:t\rJ\fW.\u001a\u000b\u0006mer4)\u0012\t\u00039]J!\u0001O\b\u0003\rI+7/\u001e7u\u0011\u0015QT\u00011\u0001<\u0003!\u0019HO]3b[&#\u0007CA\u0013=\u0013\tidEA\u0002J]RDQaP\u0003A\u0002\u0001\u000b\u0001\u0002\u001d:j_JLG/\u001f\t\u00039\u0005K!AQ\b\u0003\u0011A\u0013\u0018n\u001c:jifDQ\u0001R\u0003A\u0002\u0011\n\u0011\"\u001a8e'R\u0014X-Y7\t\u000b\u0019+\u0001\u0019A$\u0002\u000f!,\u0017\rZ3sgB\u0011\u0001J\u0016\b\u0003\u0013Rs!AS*\u000f\u0005-\u0013fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\ty\u0015$\u0001\u0004=e>|GOP\u0005\u00021%\u0011acF\u0005\u0003)UI!AE\n\n\u0005U\u000b\u0012a\u00029bG.\fw-Z\u0005\u0003/b\u0013q\u0001S3bI\u0016\u00148O\u0003\u0002V#\u0005QrN\\\"p[BdW\r^3QkND\u0007K]8nSN,gI]1nKR!ag\u0017/_\u0011\u0015Qd\u00011\u0001<\u0011\u0015if\u00011\u0001<\u0003)\u0001(o\\7jg\u0016$\u0017\n\u001a\u0005\u0006\r\u001a\u0001\raR\u0001\f_:$\u0015\r^1Ge\u0006lW\rF\u00037C\n$g\u000eC\u0003;\u000f\u0001\u00071\bC\u0003d\u000f\u0001\u0007A%\u0001\u0004jg2\u000b7\u000f\u001e\u0005\u0006K\u001e\u0001\rAZ\u0001\u0005I\u0006$\u0018\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006\u0019a.[8\u000b\u0003-\fAA[1wC&\u0011Q\u000e\u001b\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B8\b\u0001\u0004Y\u0014\u0001\u00024m_^\fqb\u001c8Qe&|'/\u001b;z\rJ\fW.\u001a\u000b\u0004mI\u001c\b\"\u0002\u001e\t\u0001\u0004Y\u0004\"B \t\u0001\u0004!\bCA;y\u001d\tab/\u0003\u0002x\u001f\u0005A\u0001K]5pe&$\u00180\u0003\u0002zu\nIA)\u001a9f]\u0012,g\u000e\u001e\u0006\u0003o>\t\u0001c\u001c8SgR\u001cFO]3b[\u001a\u0013\u0018-\\3\u0015\u0007Yjh\u0010C\u0003;\u0013\u0001\u00071\b\u0003\u0004\u0000\u0013\u0001\u0007\u0011\u0011A\u0001\u0005G>$W\rE\u0002&\u0003\u0007I1!!\u0002'\u0005\u0011auN\\4\u0002'=tw+\u001b8e_^,\u0006\u000fZ1uK\u001a\u0013\u0018-\\3\u0015\u000bY\nY!!\u0004\t\u000biR\u0001\u0019A\u001e\t\r\u0005=!\u00021\u0001<\u00035\u0019\u0018N_3J]\u000e\u0014X-\\3oi\u0006YqN\u001c)j]\u001e4%/Y7f)\u00151\u0014QCA\r\u0011\u0019\t9b\u0003a\u0001I\u0005\u0019\u0011mY6\t\r\u0015\\\u0001\u0019AA\u000e!\u0015)\u0013QDA\u0011\u0013\r\tyB\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004K\u0005\r\u0012bAA\u0013M\t!!)\u001f;f\u0003=ygnU3ui&twm\u001d$sC6,Gc\u0001\u001c\u0002,!9\u0011Q\u0006\u0007A\u0002\u0005=\u0012\u0001C:fiRLgnZ:\u0011\u000b\u0015\n\t$!\u000e\n\u0007\u0005MbE\u0001\u0004PaRLwN\u001c\t\u0007\u0003o\ty$!\u0012\u000f\t\u0005e\u0012Q\b\b\u0004\u001b\u0006m\u0012\"A\u0014\n\u0005U3\u0013\u0002BA!\u0003\u0007\u00121aU3r\u0015\t)f\u0005\u0005\u0003\u0002H\u0005Ec\u0002BA%\u0003\u001br1!SA&\u0013\t\u0001\u0012#C\u0002\u0002P=\tQ\u0002\u0013;uaJ\u001aV\r\u001e;j]\u001e\u001c\u0018\u0002BA*\u0003+\u0012qaU3ui&twMC\u0002\u0002P=\tQb\u001c8H_\u0006;\u0018-\u001f$sC6,Gc\u0002\u001c\u0002\\\u0005}\u00131\r\u0005\u0007\u0003;j\u0001\u0019A\u001e\u0002\u00151\f7\u000f^*ue\u0016\fW\u000eC\u0004\u0002b5\u0001\r!!\u0001\u0002\u0013\u0015\u0014(o\u001c:D_\u0012,\u0007bBA3\u001b\u0001\u0007\u00111D\u0001\nI\u0016\u0014Wo\u001a#bi\u0006\u0004")
public class SessionFrameListener
extends HeaderAggregatingFrameListener {
    private final SessionCore session;
    private final boolean isClient;

    @Override
    public Result onCompleteHeadersFrame(int streamId, Priority priority, boolean endStream, Seq<Tuple2<String, String>> headers) {
        Option<StreamState> option = this.session.streamManager().get(streamId);
        if (option instanceof Some) {
            Some some = (Some)option;
            StreamState stream = (StreamState)some.value();
            return stream.invokeInboundHeaders(priority, endStream, headers);
        }
        if (None$.MODULE$.equals(option)) {
            Either<Http2Exception, InboundStreamState> either = this.session.streamManager().newInboundStream(streamId);
            if (either instanceof Left) {
                Left left = (Left)either;
                Http2Exception ex = (Http2Exception)left.value();
                return new Error(ex);
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                InboundStreamState is = (InboundStreamState)right.value();
                return is.invokeInboundHeaders(priority, endStream, headers);
            }
            throw new MatchError(either);
        }
        throw new MatchError(option);
    }

    @Override
    public Result onCompletePushPromiseFrame(int streamId, int promisedId, Seq<Tuple2<String, String>> headers) {
        if (!this.isClient) {
            return new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(46).append("Server received PUSH_PROMISE frame for stream ").append(streamId).toString()));
        }
        if (!this.session.localSettings().pushEnabled()) {
            return new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received PUSH_PROMISE frame then they are disallowed"));
        }
        return this.session.streamManager().handlePushPromise(streamId, promisedId, headers);
    }

    @Override
    public Result onDataFrame(int streamId, boolean isLast, ByteBuffer data, int flow) {
        Option<StreamState> option = this.session.streamManager().get(streamId);
        if (option instanceof Some) {
            Some some = (Some)option;
            StreamState stream = (StreamState)some.value();
            return stream.invokeInboundData(isLast, data, flow);
        }
        if (None$.MODULE$.equals(option)) {
            if (!this.session.sessionFlowControl().sessionInboundObserved(flow)) {
                String msg = new StringBuilder(76).append("data frame for inactive stream (id ").append(streamId).append(") overflowed ").append("session flow window. Size: ").append(flow).append(".").toString();
                return new Error(Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().goaway(msg));
            }
            if (this.session.idManager().isIdleId(streamId)) {
                return new Error(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(31).append("DATA on uninitialized stream (").append(streamId).append(")").toString()));
            }
            return new Error(Http2Exception$.MODULE$.STREAM_CLOSED().rst(streamId));
        }
        throw new MatchError(option);
    }

    @Override
    public Result onPriorityFrame(int streamId, Priority.Dependent priority) {
        return Continue$.MODULE$;
    }

    @Override
    public Result onRstStreamFrame(int streamId, long code) {
        Http2StreamException ex = Http2Exception$.MODULE$.errorGenerator(code).rst(streamId);
        return this.session.streamManager().rstStream(ex);
    }

    @Override
    public Result onWindowUpdateFrame(int streamId, int sizeIncrement) {
        return this.session.streamManager().flowWindowUpdate(streamId, sizeIncrement);
    }

    @Override
    public Result onPingFrame(boolean ack, byte[] data) {
        Object object;
        if (!ack) {
            object = BoxesRunTime.boxToBoolean((boolean)this.session.writeController().write(this.session.http2Encoder().pingAck(data)));
        } else {
            this.session.pingManager().pingAckReceived(data);
            object = BoxedUnit.UNIT;
        }
        return Continue$.MODULE$;
    }

    @Override
    public Result onSettingsFrame(Option<scala.collection.immutable.Seq<Http2Settings.Setting>> settings) {
        Option<scala.collection.immutable.Seq<Http2Settings.Setting>> option = settings;
        if (None$.MODULE$.equals(option)) {
            return Continue$.MODULE$;
        }
        if (option instanceof Some) {
            Error result;
            MaybeError maybeError;
            Some some = (Some)option;
            scala.collection.immutable.Seq settings2 = (scala.collection.immutable.Seq)some.value();
            MutableHttp2Settings remoteSettings = this.session.remoteSettings();
            int initialInitialWindowSize = remoteSettings.initialWindowSize();
            int initialHeaderTableSize = remoteSettings.headerTableSize();
            Option<Http2Exception> option2 = remoteSettings.updateSettings((scala.collection.immutable.Seq<Http2Settings.Setting>)settings2);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Http2Exception ex = (Http2Exception)some2.value();
                maybeError = new Error(ex);
            } else if (None$.MODULE$.equals(option2)) {
                int diff;
                if (remoteSettings.headerTableSize() != initialHeaderTableSize) {
                    this.session.http2Encoder().setMaxTableSize(remoteSettings.headerTableSize());
                }
                maybeError = (diff = remoteSettings.initialWindowSize() - initialInitialWindowSize) == 0 ? Continue$.MODULE$ : this.session.streamManager().initialFlowWindowChange(diff);
            } else {
                throw new MatchError(option2);
            }
            Error error = result = maybeError;
            Continue$ continue$ = Continue$.MODULE$;
            Object object = !(error != null ? !((Object)error).equals(continue$) : continue$ != null) ? BoxesRunTime.boxToBoolean((boolean)this.session.writeController().write(FrameSerializer$.MODULE$.mkSettingsAckFrame())) : BoxedUnit.UNIT;
            return result;
        }
        throw new MatchError(option);
    }

    @Override
    public Result onGoAwayFrame(int lastStream, long errorCode, byte[] debugData) {
        String message = new String(debugData, StandardCharsets.UTF_8);
        this.session.invokeGoAway(lastStream, new Http2SessionException(errorCode, message));
        return Continue$.MODULE$;
    }

    public SessionFrameListener(SessionCore session, boolean isClient, HeaderDecoder headerDecoder) {
        this.session = session;
        this.isClient = isClient;
        super(session.localSettings(), headerDecoder);
    }
}

