/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import scala.math.package$;

public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private int markSize;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.markSize = -1;
    }

    @Override
    public int read() {
        int n;
        if (this.buffer.hasRemaining()) {
            --this.markSize;
            n = this.buffer.get() & 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int n;
        if (!this.buffer.hasRemaining()) {
            n = -1;
        } else {
            int readSize = package$.MODULE$.min(len, this.buffer.remaining());
            this.markSize -= readSize;
            this.buffer.get(b, off, readSize);
            n = readSize;
        }
        return n;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this.markSize = readlimit;
        this.buffer.mark();
    }

    @Override
    public void reset() {
        if (this.markSize < 0) {
            throw new IOException("Invalid mark");
        }
        this.markSize = -1;
        this.buffer.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

