/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.HttpClientSession;
import org.http4s.blaze.http.HttpClientSession$Busy$;
import org.http4s.blaze.http.HttpClientSession$Closed$;
import org.http4s.blaze.http.HttpClientSession$Ready$;
import org.http4s.blaze.http.http2.BufferUnderflow$;
import org.http4s.blaze.http.http2.Connection;
import org.http4s.blaze.http.http2.Connection$Closed$;
import org.http4s.blaze.http.http2.Connection$Draining$;
import org.http4s.blaze.http.http2.Connection$Running$;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.FlowStrategy;
import org.http4s.blaze.http.http2.FrameDecoder;
import org.http4s.blaze.http.http2.FrameEncoder;
import org.http4s.blaze.http.http2.FrameSerializer$;
import org.http4s.blaze.http.http2.HeaderDecoder;
import org.http4s.blaze.http.http2.HeaderEncoder;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.PingManager;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.SessionFlowControl;
import org.http4s.blaze.http.http2.SessionFlowControlImpl;
import org.http4s.blaze.http.http2.SessionFrameListener;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.http.http2.StreamIdManager;
import org.http4s.blaze.http.http2.StreamIdManager$;
import org.http4s.blaze.http.http2.StreamManager;
import org.http4s.blaze.http.http2.StreamManagerImpl;
import org.http4s.blaze.http.http2.StreamState;
import org.http4s.blaze.http.http2.WriteController;
import org.http4s.blaze.http.http2.WriteControllerImpl;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.SerialExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ConnectionImpl
extends SessionCore
implements Connection {
    private final TailStage<ByteBuffer> tailStage;
    private final Http2Settings localSettings;
    private final MutableHttp2Settings remoteSettings;
    private final Option<Function1<Object, LeafBuilder<StreamFrame>>> inboundStreamBuilder;
    private final ExecutionContext parentExecutor;
    private final Logger logger;
    private final Promise<BoxedUnit> closedPromise;
    private final FrameDecoder frameDecoder;
    private volatile Connection.State currentState;
    private boolean sentGoAway;
    private final ExecutionContext serialExecutor;
    private final FrameEncoder http2Encoder;
    private final StreamIdManager idManager;
    private final WriteController writeController;
    private final PingManager pingManager;
    private final SessionFlowControl sessionFlowControl;
    private final StreamManager streamManager;

    public ConnectionImpl(TailStage<ByteBuffer> tailStage, Http2Settings localSettings, MutableHttp2Settings remoteSettings, FlowStrategy flowStrategy, Option<Function1<Object, LeafBuilder<StreamFrame>>> inboundStreamBuilder, ExecutionContext parentExecutor) {
        this.tailStage = tailStage;
        this.localSettings = localSettings;
        this.remoteSettings = remoteSettings;
        this.inboundStreamBuilder = inboundStreamBuilder;
        this.parentExecutor = parentExecutor;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.ConnectionImpl");
        this.closedPromise = Promise$.MODULE$.apply();
        this.frameDecoder = new FrameDecoder(localSettings, new SessionFrameListener(this, this.isClient(), new HeaderDecoder(localSettings.maxHeaderListSize(), true, localSettings.headerTableSize())));
        this.currentState = Connection$Running$.MODULE$;
        this.sentGoAway = false;
        this.serialExecutor = new SerialExecutionContext(parentExecutor, this){
            private final ConnectionImpl $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(ConnectionImpl.org$http4s$blaze$http$http2$ConnectionImpl$$_$$anon$superArg$1$1(parentExecutor$2));
            }

            public void reportFailure(Throwable cause) {
                this.$outer.invokeShutdownWithError((Option<Throwable>)Some$.MODULE$.apply((Object)cause), "SerialExecutor");
            }
        };
        this.http2Encoder = new FrameEncoder(remoteSettings, new HeaderEncoder(remoteSettings.maxHeaderListSize()));
        this.idManager = StreamIdManager$.MODULE$.apply(this.isClient());
        this.writeController = new WriteControllerImpl(this, 65536, tailStage);
        this.pingManager = new PingManager(this);
        this.sessionFlowControl = new SessionFlowControlImpl(this, flowStrategy);
        this.streamManager = new StreamManagerImpl(this, inboundStreamBuilder);
        this.readLoop(BufferTools$.MODULE$.emptyBuffer());
        this.onClose().onComplete((Function1)(JProcedure1 & Serializable)_$1 -> tailStage.closePipeline((Option)None$.MODULE$), parentExecutor);
    }

    @Override
    public Http2Settings localSettings() {
        return this.localSettings;
    }

    @Override
    public MutableHttp2Settings remoteSettings() {
        return this.remoteSettings;
    }

    private boolean isClient() {
        return this.inboundStreamBuilder.isEmpty();
    }

    @Override
    public ExecutionContext serialExecutor() {
        return this.serialExecutor;
    }

    @Override
    public FrameEncoder http2Encoder() {
        return this.http2Encoder;
    }

    @Override
    public StreamIdManager idManager() {
        return this.idManager;
    }

    @Override
    public WriteController writeController() {
        return this.writeController;
    }

    @Override
    public PingManager pingManager() {
        return this.pingManager;
    }

    @Override
    public SessionFlowControl sessionFlowControl() {
        return this.sessionFlowControl;
    }

    @Override
    public StreamManager streamManager() {
        return this.streamManager;
    }

    private void readLoop(ByteBuffer remainder) {
        this.tailStage.channelRead(this.tailStage.channelRead$default$1(), this.tailStage.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                this.invokeShutdownWithError((Option<Throwable>)Some$.MODULE$.apply((Object)ex), "readLoop-read");
            } else if (try_ instanceof Success) {
                ByteBuffer next = (ByteBuffer)((Success)try_).value();
                Logger Logger_this = this.logger;
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Read data: " + next);
                }
                ByteBuffer data = BufferTools$.MODULE$.concatBuffers(remainder, next);
                Logger Logger_this2 = this.logger;
                if (Logger_this2.isDebugEnabled()) {
                    Logger_this2.debug("Handling inbound data.");
                }
                this.go$1(data);
            } else {
                throw new MatchError((Object)try_);
            }
        }, this.serialExecutor());
    }

    @Override
    public double quality() {
        double d;
        if (this.state().closing() || !this.idManager().unusedOutboundStreams()) {
            d = 0.0;
        } else {
            int maxConcurrent = this.remoteSettings().maxConcurrentStreams();
            int currentStreams = this.activeStreams();
            d = maxConcurrent == 0 || maxConcurrent <= currentStreams ? 0.0 : 1.0 - (double)currentStreams / (double)maxConcurrent;
        }
        return d;
    }

    @Override
    public HttpClientSession.Status status() {
        Mirror.Singleton singleton;
        Connection.State state = this.state();
        if (Connection$Draining$.MODULE$.equals(state)) {
            singleton = HttpClientSession$Busy$.MODULE$;
        } else if (Connection$Closed$.MODULE$.equals(state)) {
            singleton = HttpClientSession$Closed$.MODULE$;
        } else if (Connection$Running$.MODULE$.equals(state)) {
            singleton = this.quality() == 0.0 ? HttpClientSession$Busy$.MODULE$ : HttpClientSession$Ready$.MODULE$;
        } else {
            throw new MatchError((Object)state);
        }
        return singleton;
    }

    @Override
    public int activeStreams() {
        return this.streamManager().size();
    }

    @Override
    public Future<Duration> ping() {
        Promise p = Promise$.MODULE$.apply();
        this.serialExecutor().execute(new Runnable(p, this){
            private final Promise p$1;
            private final ConnectionImpl $outer;
            {
                this.p$1 = p$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.p$1.completeWith(this.$outer.pingManager().ping());
            }
        });
        return p.future();
    }

    @Override
    public Future<BoxedUnit> drainSession(Duration gracePeriod) {
        this.serialExecutor().execute(new Runnable(gracePeriod, this){
            private final Duration gracePeriod$1;
            private final ConnectionImpl $outer;
            {
                this.gracePeriod$1 = gracePeriod$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.invokeDrain(this.gracePeriod$1);
            }
        });
        return this.onClose();
    }

    @Override
    public HeadStage<StreamFrame> newOutboundStream() {
        return this.streamManager().newOutboundStream();
    }

    @Override
    public Future<BoxedUnit> onClose() {
        return this.closedPromise.future();
    }

    @Override
    public Connection.State state() {
        return this.currentState;
    }

    @Override
    public void invokeShutdownWithError(Option<Throwable> ex, String phase) {
        Connection.State state = this.state();
        Connection$Closed$ connection$Closed$ = Connection$Closed$.MODULE$;
        if (state == null ? connection$Closed$ != null : !state.equals(connection$Closed$)) {
            None$ none$;
            this.currentState = Connection$Closed$.MODULE$;
            Option<Throwable> option = ex;
            if (None$.MODULE$.equals(option) || option instanceof Some && Command.EOF$.MODULE$.equals(((Some)option).value())) {
                none$ = None$.MODULE$;
            } else if (option instanceof Some) {
                Throwable throwable = (Throwable)((Some)option).value();
                if (throwable instanceof Http2Exception) {
                    Http2Exception e = (Http2Exception)throwable;
                    none$ = Some$.MODULE$.apply((Object)e);
                } else {
                    Throwable other = throwable;
                    Logger Logger_this = this.logger;
                    if (Logger_this.isWarnEnabled()) {
                        Logger_this.warn("Shutting down HTTP/2 with unhandled exception in phase " + phase, other);
                    }
                    none$ = Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.INTERNAL_ERROR().goaway("Unhandled internal exception"));
                }
            } else {
                throw new MatchError(option);
            }
            None$ http2Ex = none$;
            this.streamManager().forceClose((Option<Throwable>)http2Ex);
            this.sendGoAway((Http2Exception)http2Ex.getOrElse(ConnectionImpl::invokeShutdownWithError$$anonfun$1));
            this.writeController().close().onComplete((Function1 & Serializable)_$2 -> {
                Promise promise;
                this.tailStage.closePipeline((Option)None$.MODULE$);
                Option option = ex;
                if (option instanceof Some) {
                    Throwable ex = (Throwable)((Some)option).value();
                    promise = this.closedPromise.failure(ex);
                } else if (None$.MODULE$.equals(option)) {
                    promise = this.closedPromise.success((Object)BoxedUnit.UNIT);
                } else {
                    throw new MatchError((Object)option);
                }
                return promise;
            }, this.serialExecutor());
        }
    }

    @Override
    public void invokeDrain(Duration gracePeriod) {
        Connection.State state = this.currentState;
        Connection$Running$ connection$Running$ = Connection$Running$.MODULE$;
        if (!(state != null ? !state.equals(connection$Running$) : connection$Running$ != null)) {
            Http2SessionException noError = Http2Exception$.MODULE$.NO_ERROR().goaway("Session draining for duration " + gracePeriod);
            this.sendGoAway(noError);
            this.doDrain(this.idManager().lastOutboundStream(), noError);
            Runnable work = new Runnable(gracePeriod, this){
                private final Duration gracePeriod$1;
                private final ConnectionImpl $outer;
                {
                    this.gracePeriod$1 = gracePeriod$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    this.$outer.invokeShutdownWithError((Option<Throwable>)None$.MODULE$, "drainSession(" + this.gracePeriod$1 + ")");
                }
            };
            Cancelable c = Execution$.MODULE$.scheduler().schedule(work, this.serialExecutor(), gracePeriod);
            this.onClose().onComplete((Function1)(JProcedure1 & Serializable)_$3 -> c.cancel(), Execution$.MODULE$.directec());
        }
    }

    @Override
    public void invokeGoAway(int lastHandledOutboundStream, Http2SessionException error) {
        this.sendGoAway(Http2Exception$.MODULE$.NO_ERROR().goaway("Session received GOAWAY with code " + error.code()));
        this.doDrain(lastHandledOutboundStream, error);
    }

    private void doDrain(int lastHandledOutboundStream, Http2SessionException error) {
        Connection.State state = this.currentState;
        Connection$Closed$ connection$Closed$ = Connection$Closed$.MODULE$;
        if (state == null ? connection$Closed$ != null : !state.equals(connection$Closed$)) {
            this.currentState = Connection$Draining$.MODULE$;
            this.streamManager().drain(lastHandledOutboundStream, error).flatMap((Function1 & Serializable)_$4 -> this.writeController().close(), this.serialExecutor()).onComplete((Function1)(JProcedure1 & Serializable)_$5 -> this.invokeShutdownWithError((Option<Throwable>)None$.MODULE$, ""), this.serialExecutor());
        }
    }

    private void sendGoAway(Http2Exception ex) {
        if (!this.sentGoAway) {
            this.sentGoAway = true;
            ByteBuffer frame = FrameSerializer$.MODULE$.mkGoAwayFrame(this.idManager().lastInboundStream(), ex);
            this.writeController().write(frame);
        }
    }

    public static final ExecutionContext org$http4s$blaze$http$http2$ConnectionImpl$$_$$anon$superArg$1$1(ExecutionContext parentExecutor$1) {
        return parentExecutor$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void go$1(ByteBuffer data$1) {
        Result result;
        while (Continue$.MODULE$.equals(result = this.frameDecoder.decodeBuffer(data$1))) {
        }
        if (BufferUnderflow$.MODULE$.equals(result)) {
            this.readLoop(data$1);
            return;
        } else {
            if (!(result instanceof Error)) throw new MatchError((Object)result);
            Error error = Error$.MODULE$.unapply((Error)result);
            Http2Exception http2Exception = error._1();
            if (http2Exception instanceof Http2StreamException) {
                Http2StreamException ex = (Http2StreamException)http2Exception;
                Option<StreamState> option = this.streamManager().get(ex.stream());
                if (option instanceof Some) {
                    StreamState stream = (StreamState)((Some)option).value();
                    stream.doCloseWithError((Option<Throwable>)Some$.MODULE$.apply((Object)ex));
                    return;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    ByteBuffer msg = FrameSerializer$.MODULE$.mkRstStreamFrame(ex.stream(), ex.code());
                    this.writeController().write(msg);
                }
                return;
            } else {
                Http2Exception ex = http2Exception;
                this.invokeShutdownWithError((Option<Throwable>)Some$.MODULE$.apply((Object)ex), "readLoop-decode");
            }
        }
    }

    private static final Http2SessionException invokeShutdownWithError$$anonfun$1() {
        return Http2Exception$.MODULE$.NO_ERROR().goaway("No Error");
    }
}

