/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import org.http4s.blaze.http.http2.FlowStrategy;
import org.http4s.blaze.http.http2.FlowStrategy$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.SessionFlowControl;
import org.http4s.blaze.http.http2.StreamFlowWindow;

public final class DefaultFlowStrategy
implements FlowStrategy {
    private final Http2Settings localSettings;

    public DefaultFlowStrategy(Http2Settings localSettings) {
        this.localSettings = localSettings;
    }

    @Override
    public int checkSession(SessionFlowControl session) {
        return this.check(this.localSettings.initialWindowSize(), session.sessionInboundWindow(), session.sessionUnconsumedBytes());
    }

    @Override
    public FlowStrategy.Increment checkStream(StreamFlowWindow stream) {
        int sessionAck = this.checkSession(stream.sessionFlowControl());
        int streamAck = this.check(this.localSettings.initialWindowSize(), stream.streamInboundWindow(), stream.streamUnconsumedBytes());
        return FlowStrategy$.MODULE$.increment(sessionAck, streamAck);
    }

    private int check(int initialWindow, int currentWindow, int unConsumed) {
        int unacked = initialWindow - currentWindow;
        int unackedConsumed = unacked - unConsumed;
        return unackedConsumed >= initialWindow / 2 ? unackedConsumed : 0;
    }
}

