/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.BufferUnderflow$;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.FrameListener;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Priority$Dependent$;
import org.http4s.blaze.http.http2.Priority$NoPriority$;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.SettingsDecoder$;
import org.http4s.blaze.http.http2.SettingsDecoder$SettingsFrame$;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import org.http4s.blaze.http.http2.bits$Masks$;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class FrameDecoder {
    private final Http2Settings localSettings;
    private final FrameListener listener;

    public static int getLengthField(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getLengthField(byteBuffer);
    }

    public static int getStreamId(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getStreamId(byteBuffer);
    }

    public static String hexStr(int n) {
        return FrameDecoder$.MODULE$.hexStr(n);
    }

    public FrameDecoder(Http2Settings localSettings, FrameListener listener) {
        this.localSettings = localSettings;
        this.listener = listener;
    }

    public final Result decodeBuffer(ByteBuffer buffer) {
        return buffer.remaining() < bits$.MODULE$.HeaderSize() ? BufferUnderflow$.MODULE$ : this.doDecodeBuffer(buffer);
    }

    private Result doDecodeBuffer(ByteBuffer buffer) {
        Result result;
        block23: {
            buffer.mark();
            int len = FrameDecoder$.MODULE$.getLengthField(buffer);
            byte frameType = buffer.get();
            byte flags = buffer.get();
            int streamId = FrameDecoder$.MODULE$.getStreamId(buffer);
            if (this.localSettings.maxFrameSize() < len) {
                result = Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway("HTTP2 packet is too large to handle. Stream: " + streamId));
            } else if (frameType != bits$FrameTypes$.MODULE$.CONTINUATION() && this.listener.inHeaderSequence()) {
                String msg = "Received frame type " + FrameDecoder$.MODULE$.hexStr(frameType) + " while in HEADERS sequence";
                result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
            } else if (frameType == bits$FrameTypes$.MODULE$.CONTINUATION() && !this.listener.inHeaderSequence()) {
                result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received CONTINUATION frame outside of a HEADERS sequence"));
            } else if (buffer.remaining() < len) {
                buffer.reset();
                result = BufferUnderflow$.MODULE$;
            } else {
                int oldLimit = buffer.limit();
                int endOfFrame = buffer.position() + len;
                buffer.limit(endOfFrame);
                try {
                    try {
                        byte by = frameType;
                        if (bits$FrameTypes$.MODULE$.DATA() == by) {
                            result = this.decodeDataFrame(buffer, streamId, flags);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.HEADERS() == by) {
                            result = this.decodeHeaderFrame(buffer, streamId, flags);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.PRIORITY() == by) {
                            result = this.decodePriorityFrame(buffer, streamId);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.RST_STREAM() == by) {
                            result = this.decodeRstStreamFrame(buffer, streamId);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.SETTINGS() == by) {
                            result = this.decodeSettingsFrame(buffer, streamId, flags);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.PUSH_PROMISE() == by) {
                            result = this.decodePushPromiseFrame(buffer, streamId, flags);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.PING() == by) {
                            result = this.decodePingFrame(buffer, streamId, flags);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.GOAWAY() == by) {
                            result = this.decodeGoAwayFrame(buffer, streamId);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.WINDOW_UPDATE() == by) {
                            result = this.decodeWindowUpdateFrame(buffer, streamId);
                            break block23;
                        }
                        if (bits$FrameTypes$.MODULE$.CONTINUATION() == by) {
                            result = this.decodeContinuationFrame(buffer, streamId, flags);
                            break block23;
                        }
                        byte code = by;
                        result = this.onExtensionFrame(code, streamId, flags, buffer.slice());
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        result = Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway("Frame type " + FrameDecoder$.MODULE$.hexStr(frameType) + " and size " + len + " underflowed"));
                    }
                }
                finally {
                    buffer.limit(oldLimit);
                    buffer.position(endOfFrame);
                }
            }
        }
        return result;
    }

    public Result onExtensionFrame(byte code, int streamId, byte flags, ByteBuffer buffer) {
        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)code), (Object)BoxesRunTime.boxToInteger((int)streamId), (Object)BoxesRunTime.boxToByte((byte)flags), (Object)buffer);
        return Continue$.MODULE$;
    }

    private Result decodeDataFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Data frame with stream id 0x0"));
        } else {
            MaybeError maybeError;
            int flowBytes = buffer.remaining();
            if (!bits$Flags$.MODULE$.PADDED(flags)) {
                maybeError = Continue$.MODULE$;
            } else {
                int padding = buffer.get() & 0xFF;
                maybeError = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$limitPadding(padding, buffer);
            }
            Continue$ r = maybeError;
            result = !r.success() ? r : this.listener.onDataFrame(streamId, bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice(), flowBytes);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Result decodeHeaderFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Headers frame with stream id 0x0"));
            return result;
        }
        int padding = !bits$Flags$.MODULE$.PADDED(flags) ? 0 : buffer.get() & 0xFF;
        Priority priority = !bits$Flags$.MODULE$.PRIORITY(flags) ? Priority$NoPriority$.MODULE$ : FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$getPriority(buffer);
        MaybeError r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$limitPadding(padding, buffer);
        if (!r.success()) {
            result = r;
            return result;
        }
        Priority priority2 = priority;
        if (priority2 instanceof Priority.Dependent) {
            Priority.Dependent dependent = Priority$Dependent$.MODULE$.unapply((Priority.Dependent)priority2);
            int n = dependent._1();
            boolean bl = dependent._2();
            int n2 = dependent._3();
            int dep = n;
            if (dep == streamId) {
                result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Header stream id " + FrameDecoder$.MODULE$.hexStr(streamId) + " depends on itself."));
                return result;
            }
        }
        result = this.listener.onHeadersFrame(streamId, priority, bits$Flags$.MODULE$.END_HEADERS(flags), bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice());
        return result;
    }

    private Result decodePriorityFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId == 0) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Priority frame with stream id 0x0"));
        } else if (buffer.remaining() != 5) {
            String msg = "Invalid PRIORITY frame size, required 5, received" + buffer.remaining();
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().rst(streamId, msg));
        } else {
            Priority.Dependent priority = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$getPriority(buffer);
            result = priority.dependentStreamId() == streamId ? Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, "Priority frame depends on itself")) : this.listener.onPriorityFrame(streamId, priority);
        }
        return result;
    }

    private Result decodeRstStreamFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId == 0) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("RST_STREAM frame with stream id 0x0"));
        } else if (buffer.remaining() != 4) {
            String msg = "Invalid RST_STREAM frame size. Required 4 bytes, received " + buffer.remaining();
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else {
            long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
            result = this.listener.onRstStreamFrame(streamId, code);
        }
        return result;
    }

    private Result decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        SettingsDecoder.SettingsFrame settingsFrame;
        Either<Http2Exception, SettingsDecoder.SettingsFrame> either = SettingsDecoder$.MODULE$.decodeSettingsFrame(buffer, streamId, flags);
        if (either instanceof Right && (settingsFrame = (SettingsDecoder.SettingsFrame)((Right)either).value()) != null) {
            Option<Seq<Http2Settings.Setting>> option;
            SettingsDecoder.SettingsFrame settingsFrame2 = SettingsDecoder$SettingsFrame$.MODULE$.unapply(settingsFrame);
            Option<Seq<Http2Settings.Setting>> settings = option = settingsFrame2._1();
            result = this.listener.onSettingsFrame(settings);
        } else if (either instanceof Left) {
            Http2Exception ex = (Http2Exception)((Left)either).value();
            result = Error$.MODULE$.apply(ex);
        } else {
            throw new MatchError(either);
        }
        return result;
    }

    private Result decodePushPromiseFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with stream id 0x0"));
        } else {
            MaybeError r;
            int padding = !bits$Flags$.MODULE$.PADDED(flags) ? 0 : buffer.get() & 0xFF;
            int promisedId = FrameDecoder$.MODULE$.getStreamId(buffer);
            result = promisedId == 0 ? Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with promised stream id 0x0")) : (promisedId == streamId ? Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with promised stream of the same stream " + FrameDecoder$.MODULE$.hexStr(streamId))) : (!(r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$limitPadding(padding, buffer)).success() ? r : this.listener.onPushPromiseFrame(streamId, promisedId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice())));
        }
        return result;
    }

    private Result decodePingFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        int PingSize = 8;
        if (streamId != 0) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PING frame with stream id " + FrameDecoder$.MODULE$.hexStr(streamId) + " != 0x0"));
        } else if (buffer.remaining() != PingSize) {
            String msg = "Invalid PING frame size. Expected 8, received " + buffer.remaining();
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else {
            byte[] pingBytes = new byte[PingSize];
            buffer.get(pingBytes);
            result = this.listener.onPingFrame(bits$Flags$.MODULE$.ACK(flags), pingBytes);
        }
        return result;
    }

    private Result decodeGoAwayFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (streamId != 0) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("GOAWAY frame with stream id " + FrameDecoder$.MODULE$.hexStr(streamId) + " != 0x0."));
        } else {
            int lastStream = bits$Flags$.MODULE$.DepID(buffer.getInt());
            long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            result = this.listener.onGoAwayFrame(lastStream, code, data);
        }
        return result;
    }

    private Result decodeWindowUpdateFrame(ByteBuffer buffer, int streamId) {
        Result result;
        if (buffer.remaining() != 4) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway("WindowUpdate with invalid frame size. Expected 4, found " + buffer.remaining()));
        } else {
            int size = buffer.getInt() & bits$Masks$.MODULE$.INT31();
            if (size != 0) {
                result = this.listener.onWindowUpdateFrame(streamId, size);
            } else {
                String msg = "WINDOW_UPDATE with invalid update size 0";
                result = Error$.MODULE$.apply(streamId == 0 ? Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg) : Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, msg));
            }
        }
        return result;
    }

    private Result decodeContinuationFrame(ByteBuffer buffer, int streamId, byte flags) {
        Result result;
        if (streamId == 0) {
            String msg = "CONTINUATION frame with invalid stream dependency on 0x0";
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        } else {
            result = this.listener.onContinuationFrame(streamId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
        }
        return result;
    }
}

