/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FrameSerializer$;
import org.http4s.blaze.http.http2.HeaderEncoder;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.util.BufferTools$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.package$;

public final class FrameEncoder {
    private final Http2Settings remoteSettings;
    private final HeaderEncoder headerEncoder;

    public FrameEncoder(Http2Settings remoteSettings, HeaderEncoder headerEncoder) {
        this.remoteSettings = remoteSettings;
        this.headerEncoder = headerEncoder;
    }

    private int maxFrameSize() {
        return this.remoteSettings.maxFrameSize();
    }

    public void setMaxTableSize(int size) {
        this.headerEncoder.maxTableSize(size);
    }

    public ByteBuffer sessionWindowUpdate(int size) {
        return this.streamWindowUpdate(0, size);
    }

    public ByteBuffer streamWindowUpdate(int streamId, int size) {
        return FrameSerializer$.MODULE$.mkWindowUpdateFrame(streamId, size);
    }

    public ByteBuffer pingFrame(byte[] data) {
        return FrameSerializer$.MODULE$.mkPingFrame(false, data);
    }

    public ByteBuffer pingAck(byte[] data) {
        return FrameSerializer$.MODULE$.mkPingFrame(true, data);
    }

    public ByteBuffer rstFrame(int streamId, long errorCode) {
        return FrameSerializer$.MODULE$.mkRstStreamFrame(streamId, errorCode);
    }

    public Seq<ByteBuffer> dataFrame(int streamId, boolean endStream, ByteBuffer data) {
        ArrayBuffer arrayBuffer;
        int limit = this.maxFrameSize();
        if (data.remaining() <= limit) {
            arrayBuffer = FrameSerializer$.MODULE$.mkDataFrame(streamId, endStream, 0, data);
        } else {
            ArrayBuffer acc = new ArrayBuffer();
            while (data.hasRemaining()) {
                ByteBuffer thisData = BufferTools$.MODULE$.takeSlice(data, package$.MODULE$.min(data.remaining(), limit));
                boolean eos = endStream && !data.hasRemaining();
                acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkDataFrame(streamId, eos, 0, thisData));
            }
            arrayBuffer = acc;
        }
        return arrayBuffer;
    }

    public Seq<ByteBuffer> headerFrame(int streamId, Priority priority, boolean endStream, Seq<Tuple2<String, String>> headers) {
        ArrayBuffer arrayBuffer;
        int headersPrioritySize;
        ByteBuffer rawHeaders = this.headerEncoder.encodeHeaders(headers);
        int limit = this.maxFrameSize();
        int n = headersPrioritySize = priority.isDefined() ? 5 : 0;
        if (rawHeaders.remaining() + headersPrioritySize <= limit) {
            arrayBuffer = FrameSerializer$.MODULE$.mkHeaderFrame(streamId, priority, true, endStream, 0, rawHeaders);
        } else {
            ArrayBuffer acc = new ArrayBuffer();
            ByteBuffer headersBuf = BufferTools$.MODULE$.takeSlice(rawHeaders, limit - headersPrioritySize);
            acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkHeaderFrame(streamId, priority, false, endStream, 0, headersBuf));
            while (rawHeaders.hasRemaining()) {
                int size = package$.MODULE$.min(limit, rawHeaders.remaining());
                ByteBuffer continueBuf = BufferTools$.MODULE$.takeSlice(rawHeaders, size);
                boolean endHeaders = !rawHeaders.hasRemaining();
                acc.$plus$plus$eq(FrameSerializer$.MODULE$.mkContinuationFrame(streamId, endHeaders, continueBuf));
            }
            arrayBuffer = acc;
        }
        return arrayBuffer;
    }
}

