/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.FrameListener;
import org.http4s.blaze.http.http2.HeaderAggregatingFrameListener$PHeaders$;
import org.http4s.blaze.http.http2.HeaderAggregatingFrameListener$PPromise$;
import org.http4s.blaze.http.http2.HeaderDecoder;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.util.BufferTools$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class HeaderAggregatingFrameListener
implements FrameListener {
    private final Http2Settings localSettings;
    private final HeaderDecoder headerDecoder;
    public final HeaderAggregatingFrameListener$PHeaders$ PHeaders$lzy1;
    public final HeaderAggregatingFrameListener$PPromise$ PPromise$lzy1;
    private PartialFrame hInfo;

    public HeaderAggregatingFrameListener(Http2Settings localSettings, HeaderDecoder headerDecoder) {
        this.localSettings = localSettings;
        this.headerDecoder = headerDecoder;
        this.PHeaders$lzy1 = new HeaderAggregatingFrameListener$PHeaders$(this);
        this.PPromise$lzy1 = new HeaderAggregatingFrameListener$PPromise$(this);
        this.hInfo = null;
    }

    private final HeaderAggregatingFrameListener$PHeaders$ PHeaders() {
        return this.PHeaders$lzy1;
    }

    private final HeaderAggregatingFrameListener$PPromise$ PPromise() {
        return this.PPromise$lzy1;
    }

    public abstract Result onCompleteHeadersFrame(int var1, Priority var2, boolean var3, Seq var4);

    public abstract Result onCompletePushPromiseFrame(int var1, int var2, Seq var3);

    public final void setMaxHeaderTableSize(int maxSize) {
        this.headerDecoder.setMaxHeaderTableSize(maxSize);
    }

    @Override
    public final boolean inHeaderSequence() {
        return this.hInfo != null;
    }

    @Override
    public final Result onHeadersFrame(int streamId, Priority priority, boolean endHeaders, boolean endStream, ByteBuffer buffer) {
        Result result;
        if (this.inHeaderSequence()) {
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received HEADERS frame while in in headers sequence. Stream id " + FrameDecoder$.MODULE$.hexStr(streamId)));
        } else if (buffer.remaining() > this.localSettings.maxHeaderListSize()) {
            result = this.headerSizeError(buffer.remaining(), streamId);
        } else if (endHeaders) {
            MaybeError r = this.headerDecoder.decode(buffer, streamId, true);
            if (!r.success()) {
                result = r;
            } else {
                scala.collection.immutable.Seq<Tuple2<String, String>> hs = this.headerDecoder.finish();
                result = this.onCompleteHeadersFrame(streamId, priority, endStream, (Seq)hs);
            }
        } else {
            this.hInfo = this.PHeaders().apply(streamId, priority, endStream, buffer);
            result = Continue$.MODULE$;
        }
        return result;
    }

    @Override
    public final Result onPushPromiseFrame(int streamId, int promisedId, boolean endHeaders, ByteBuffer buffer) {
        Result result;
        if (this.localSettings.maxHeaderListSize() < buffer.remaining()) {
            result = this.headerSizeError(buffer.remaining(), streamId);
        } else if (endHeaders) {
            MaybeError r = this.headerDecoder.decode(buffer, streamId, true);
            if (!r.success()) {
                result = r;
            } else {
                scala.collection.immutable.Seq<Tuple2<String, String>> hs = this.headerDecoder.finish();
                result = this.onCompletePushPromiseFrame(streamId, promisedId, (Seq)hs);
            }
        } else {
            this.hInfo = this.PPromise().apply(streamId, promisedId, buffer);
            result = Continue$.MODULE$;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final Result onContinuationFrame(int streamId, boolean endHeaders, ByteBuffer buffer) {
        Result result;
        if (this.hInfo.streamId() != streamId) {
            String msg = "Invalid CONTINUATION frame: stream Id's don't match. " + ("Expected " + this.hInfo.streamId() + ", received " + streamId);
            result = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
            return result;
        } else {
            int totalSize = buffer.remaining() + this.hInfo.buffer().remaining();
            if (this.localSettings.maxHeaderListSize() < totalSize) {
                result = this.headerSizeError(totalSize, streamId);
                return result;
            } else {
                ByteBuffer newBuffer = BufferTools$.MODULE$.concatBuffers(this.hInfo.buffer(), buffer);
                if (endHeaders) {
                    MaybeError r = this.headerDecoder.decode(newBuffer, streamId, true);
                    if (!r.success()) {
                        result = r;
                        return result;
                    } else {
                        scala.collection.immutable.Seq<Tuple2<String, String>> hs = this.headerDecoder.finish();
                        PartialFrame i = this.hInfo;
                        this.hInfo = null;
                        PartialFrame partialFrame = i;
                        if (partialFrame instanceof PHeaders && ((PHeaders)partialFrame).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PHeaders$$$outer() == this) {
                            PHeaders pHeaders = this.PHeaders().unapply((PHeaders)partialFrame);
                            int n = pHeaders._1();
                            Priority priority = pHeaders._2();
                            boolean bl = pHeaders._3();
                            ByteBuffer byteBuffer = pHeaders._4();
                            int sid = n;
                            Priority pri = priority;
                            boolean es = bl;
                            result = this.onCompleteHeadersFrame(sid, pri, es, (Seq)hs);
                            return result;
                        } else {
                            if (!(partialFrame instanceof PPromise) || ((PPromise)partialFrame).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PPromise$$$outer() != this) throw new MatchError((Object)partialFrame);
                            PPromise pPromise = this.PPromise().unapply((PPromise)partialFrame);
                            int n = pPromise._1();
                            int n2 = pPromise._2();
                            ByteBuffer byteBuffer = pPromise._3();
                            int sid = n;
                            int pro = n2;
                            result = this.onCompletePushPromiseFrame(sid, pro, (Seq)hs);
                        }
                    }
                    return result;
                } else {
                    this.hInfo.buffer_$eq(newBuffer);
                    result = Continue$.MODULE$;
                }
            }
        }
        return result;
    }

    private Error headerSizeError(int size, int streamId) {
        String msg = "Stream(" + FrameDecoder$.MODULE$.hexStr(streamId) + ") sent too large of " + ("a header block. Received: " + size + ". Limit: " + this.localSettings.maxHeaderListSize());
        return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
    }

    private class PHeaders
    implements PartialFrame,
    Product,
    Serializable {
        private final int streamId;
        private final Priority priority;
        private final boolean endStream;
        private ByteBuffer buffer;
        private final HeaderAggregatingFrameListener $outer;

        public PHeaders(HeaderAggregatingFrameListener $outer, int streamId, Priority priority, boolean endStream, ByteBuffer buffer) {
            this.streamId = streamId;
            this.priority = priority;
            this.endStream = endStream;
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.priority()));
            n = Statics.mix((int)n, (int)(this.endStream() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buffer()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PHeaders)) return false;
            if (((PHeaders)object).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PHeaders$$$outer() != this.$outer) return false;
            PHeaders pHeaders = (PHeaders)object;
            if (this.streamId() != pHeaders.streamId()) return false;
            if (this.endStream() != pHeaders.endStream()) return false;
            Priority priority = this.priority();
            Priority priority2 = pHeaders.priority();
            if (priority == null) {
                if (priority2 != null) {
                    return false;
                }
            } else if (!priority.equals(priority2)) return false;
            ByteBuffer byteBuffer = this.buffer();
            ByteBuffer byteBuffer2 = pHeaders.buffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            if (!pHeaders.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PHeaders;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PHeaders";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "streamId";
                    break;
                }
                case 1: {
                    string = "priority";
                    break;
                }
                case 2: {
                    string = "endStream";
                    break;
                }
                case 3: {
                    string = "buffer";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public Priority priority() {
            return this.priority;
        }

        public boolean endStream() {
            return this.endStream;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void buffer_$eq(ByteBuffer x$1) {
            this.buffer = x$1;
        }

        public PHeaders copy(int streamId, Priority priority, boolean endStream, ByteBuffer buffer) {
            return new PHeaders(this.$outer, streamId, priority, endStream, buffer);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public Priority copy$default$2() {
            return this.priority();
        }

        public boolean copy$default$3() {
            return this.endStream();
        }

        public ByteBuffer copy$default$4() {
            return this.buffer();
        }

        public int _1() {
            return this.streamId();
        }

        public Priority _2() {
            return this.priority();
        }

        public boolean _3() {
            return this.endStream();
        }

        public ByteBuffer _4() {
            return this.buffer();
        }

        public final HeaderAggregatingFrameListener org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PHeaders$$$outer() {
            return this.$outer;
        }
    }

    private class PPromise
    implements PartialFrame,
    Product,
    Serializable {
        private final int streamId;
        private final int promisedId;
        private ByteBuffer buffer;
        private final HeaderAggregatingFrameListener $outer;

        public PPromise(HeaderAggregatingFrameListener $outer, int streamId, int promisedId, ByteBuffer buffer) {
            this.streamId = streamId;
            this.promisedId = promisedId;
            this.buffer = buffer;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.streamId());
            n = Statics.mix((int)n, (int)this.promisedId());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.buffer()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PPromise)) return false;
            if (((PPromise)object).org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PPromise$$$outer() != this.$outer) return false;
            PPromise pPromise = (PPromise)object;
            if (this.streamId() != pPromise.streamId()) return false;
            if (this.promisedId() != pPromise.promisedId()) return false;
            ByteBuffer byteBuffer = this.buffer();
            ByteBuffer byteBuffer2 = pPromise.buffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            if (!pPromise.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PPromise;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PPromise";
        }

        public Object productElement(int n) {
            Comparable<ByteBuffer> comparable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    comparable = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    comparable = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    comparable = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return comparable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "streamId";
                    break;
                }
                case 1: {
                    string = "promisedId";
                    break;
                }
                case 2: {
                    string = "buffer";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        public int promisedId() {
            return this.promisedId;
        }

        @Override
        public ByteBuffer buffer() {
            return this.buffer;
        }

        @Override
        public void buffer_$eq(ByteBuffer x$1) {
            this.buffer = x$1;
        }

        public PPromise copy(int streamId, int promisedId, ByteBuffer buffer) {
            return new PPromise(this.$outer, streamId, promisedId, buffer);
        }

        public int copy$default$1() {
            return this.streamId();
        }

        public int copy$default$2() {
            return this.promisedId();
        }

        public ByteBuffer copy$default$3() {
            return this.buffer();
        }

        public int _1() {
            return this.streamId();
        }

        public int _2() {
            return this.promisedId();
        }

        public ByteBuffer _3() {
            return this.buffer();
        }

        public final HeaderAggregatingFrameListener org$http4s$blaze$http$http2$HeaderAggregatingFrameListener$PPromise$$$outer() {
            return this.$outer;
        }
    }

    private interface PartialFrame {
        public int streamId();

        public ByteBuffer buffer();

        public void buffer_$eq(ByteBuffer var1);
    }
}

