/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2StreamException;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2$;
import scala.collection.mutable.HashMap;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class Http2Exception$
implements Mirror.Sum,
Serializable {
    private static final HashMap<Object, Http2Exception.ErrorGenerator> exceptionsMap;
    private static final Http2Exception.ErrorGenerator NO_ERROR;
    private static final Http2Exception.ErrorGenerator PROTOCOL_ERROR;
    private static final Http2Exception.ErrorGenerator INTERNAL_ERROR;
    private static final Http2Exception.ErrorGenerator FLOW_CONTROL_ERROR;
    private static final Http2Exception.ErrorGenerator SETTINGS_TIMEOUT;
    private static final Http2Exception.ErrorGenerator STREAM_CLOSED;
    private static final Http2Exception.ErrorGenerator FRAME_SIZE_ERROR;
    private static final Http2Exception.ErrorGenerator REFUSED_STREAM;
    private static final Http2Exception.ErrorGenerator CANCEL;
    private static final Http2Exception.ErrorGenerator COMPRESSION_ERROR;
    private static final Http2Exception.ErrorGenerator CONNECT_ERROR;
    private static final Http2Exception.ErrorGenerator ENHANCE_YOUR_CALM;
    private static final Http2Exception.ErrorGenerator INADEQUATE_SECURITY;
    private static final Http2Exception.ErrorGenerator HTTP_1_1_REQUIRED;
    public static final Http2Exception$ MODULE$;

    private Http2Exception$() {
    }

    static {
        MODULE$ = new Http2Exception$();
        exceptionsMap = new HashMap();
        NO_ERROR = MODULE$.mkErrorGen(0L, "NO_ERROR");
        PROTOCOL_ERROR = MODULE$.mkErrorGen(1L, "PROTOCOL_ERROR");
        INTERNAL_ERROR = MODULE$.mkErrorGen(2L, "INTERNAL_ERROR");
        FLOW_CONTROL_ERROR = MODULE$.mkErrorGen(3L, "FLOW_CONTROL_ERROR");
        SETTINGS_TIMEOUT = MODULE$.mkErrorGen(4L, "SETTINGS_TIMEOUT");
        STREAM_CLOSED = MODULE$.mkErrorGen(5L, "STREAM_CLOSED");
        FRAME_SIZE_ERROR = MODULE$.mkErrorGen(6L, "FRAME_SIZE_ERROR");
        REFUSED_STREAM = MODULE$.mkErrorGen(7L, "REFUSED_STREAM");
        CANCEL = MODULE$.mkErrorGen(8L, "CANCEL");
        COMPRESSION_ERROR = MODULE$.mkErrorGen(9L, "COMPRESSION_ERROR");
        CONNECT_ERROR = MODULE$.mkErrorGen(10L, "CONNECT_ERROR");
        ENHANCE_YOUR_CALM = MODULE$.mkErrorGen(11L, "ENHANCE_YOUR_CALM");
        INADEQUATE_SECURITY = MODULE$.mkErrorGen(12L, "INADEQUATE_SECURITY");
        HTTP_1_1_REQUIRED = MODULE$.mkErrorGen(13L, "HTTP_1_1_REQUIRED");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Http2Exception$.class);
    }

    public Http2Exception.ErrorGenerator errorGenerator(long code) {
        Http2Exception.ErrorGenerator errorGenerator;
        Option option = exceptionsMap.get((Object)BoxesRunTime.boxToLong((long)code));
        if (option instanceof Some) {
            Http2Exception.ErrorGenerator gen;
            errorGenerator = gen = (Http2Exception.ErrorGenerator)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            errorGenerator = new Http2Exception.ErrorGenerator(code, "UNKNOWN(0x" + Integer.toHexString((int)code) + ")");
        } else {
            throw new MatchError((Object)option);
        }
        return errorGenerator;
    }

    public String errorName(long code) {
        return this.errorGenerator(code).name();
    }

    private Http2Exception.ErrorGenerator mkErrorGen(long code, String name) {
        Http2Exception.ErrorGenerator g = new Http2Exception.ErrorGenerator(code, name);
        exceptionsMap.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)code), (Object)g));
        return g;
    }

    public Http2Exception.ErrorGenerator NO_ERROR() {
        return NO_ERROR;
    }

    public Http2Exception.ErrorGenerator PROTOCOL_ERROR() {
        return PROTOCOL_ERROR;
    }

    public Http2Exception.ErrorGenerator INTERNAL_ERROR() {
        return INTERNAL_ERROR;
    }

    public Http2Exception.ErrorGenerator FLOW_CONTROL_ERROR() {
        return FLOW_CONTROL_ERROR;
    }

    public Http2Exception.ErrorGenerator SETTINGS_TIMEOUT() {
        return SETTINGS_TIMEOUT;
    }

    public Http2Exception.ErrorGenerator STREAM_CLOSED() {
        return STREAM_CLOSED;
    }

    public Http2Exception.ErrorGenerator FRAME_SIZE_ERROR() {
        return FRAME_SIZE_ERROR;
    }

    public Http2Exception.ErrorGenerator REFUSED_STREAM() {
        return REFUSED_STREAM;
    }

    public Http2Exception.ErrorGenerator CANCEL() {
        return CANCEL;
    }

    public Http2Exception.ErrorGenerator COMPRESSION_ERROR() {
        return COMPRESSION_ERROR;
    }

    public Http2Exception.ErrorGenerator CONNECT_ERROR() {
        return CONNECT_ERROR;
    }

    public Http2Exception.ErrorGenerator ENHANCE_YOUR_CALM() {
        return ENHANCE_YOUR_CALM;
    }

    public Http2Exception.ErrorGenerator INADEQUATE_SECURITY() {
        return INADEQUATE_SECURITY;
    }

    public Http2Exception.ErrorGenerator HTTP_1_1_REQUIRED() {
        return HTTP_1_1_REQUIRED;
    }

    public int ordinal(Http2Exception x$0) {
        int n;
        Http2Exception http2Exception = x$0;
        if (http2Exception instanceof Http2StreamException) {
            n = 0;
        } else if (http2Exception instanceof Http2SessionException) {
            n = 1;
        } else {
            throw new MatchError((Object)http2Exception);
        }
        return n;
    }
}

