/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2SessionException$;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.Http2StreamException$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.util.control.NoStackTrace;

public abstract class Http2Exception
extends Exception
implements NoStackTrace,
Product {
    private final String msg;

    public static ErrorGenerator CANCEL() {
        return Http2Exception$.MODULE$.CANCEL();
    }

    public static ErrorGenerator COMPRESSION_ERROR() {
        return Http2Exception$.MODULE$.COMPRESSION_ERROR();
    }

    public static ErrorGenerator CONNECT_ERROR() {
        return Http2Exception$.MODULE$.CONNECT_ERROR();
    }

    public static ErrorGenerator ENHANCE_YOUR_CALM() {
        return Http2Exception$.MODULE$.ENHANCE_YOUR_CALM();
    }

    public static ErrorGenerator FLOW_CONTROL_ERROR() {
        return Http2Exception$.MODULE$.FLOW_CONTROL_ERROR();
    }

    public static ErrorGenerator FRAME_SIZE_ERROR() {
        return Http2Exception$.MODULE$.FRAME_SIZE_ERROR();
    }

    public static ErrorGenerator HTTP_1_1_REQUIRED() {
        return Http2Exception$.MODULE$.HTTP_1_1_REQUIRED();
    }

    public static ErrorGenerator INADEQUATE_SECURITY() {
        return Http2Exception$.MODULE$.INADEQUATE_SECURITY();
    }

    public static ErrorGenerator INTERNAL_ERROR() {
        return Http2Exception$.MODULE$.INTERNAL_ERROR();
    }

    public static ErrorGenerator NO_ERROR() {
        return Http2Exception$.MODULE$.NO_ERROR();
    }

    public static ErrorGenerator PROTOCOL_ERROR() {
        return Http2Exception$.MODULE$.PROTOCOL_ERROR();
    }

    public static ErrorGenerator REFUSED_STREAM() {
        return Http2Exception$.MODULE$.REFUSED_STREAM();
    }

    public static ErrorGenerator SETTINGS_TIMEOUT() {
        return Http2Exception$.MODULE$.SETTINGS_TIMEOUT();
    }

    public static ErrorGenerator STREAM_CLOSED() {
        return Http2Exception$.MODULE$.STREAM_CLOSED();
    }

    public static ErrorGenerator errorGenerator(long l) {
        return Http2Exception$.MODULE$.errorGenerator(l);
    }

    public static String errorName(long l) {
        return Http2Exception$.MODULE$.errorName(l);
    }

    public static int ordinal(Http2Exception http2Exception) {
        return Http2Exception$.MODULE$.ordinal(http2Exception);
    }

    public Http2Exception(String msg) {
        this.msg = msg;
        super(msg);
        NoStackTrace.$init$((NoStackTrace)this);
    }

    public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
        return super.fillInStackTrace();
    }

    public abstract long code();

    public final String name() {
        return Http2Exception$.MODULE$.errorName(this.code());
    }

    public final Http2StreamException toStreamException(int streamId) {
        Http2StreamException http2StreamException;
        Http2StreamException ex;
        Http2Exception http2Exception = this;
        if (http2Exception instanceof Http2StreamException && (ex = (Http2StreamException)http2Exception).stream() == streamId) {
            http2StreamException = ex;
        } else {
            Http2Exception ex2 = http2Exception;
            http2StreamException = new Http2StreamException(streamId, ex2.code(), ex2.getMessage());
        }
        return http2StreamException;
    }

    public final Http2SessionException toSessionException() {
        Http2SessionException http2SessionException;
        Http2Exception http2Exception = this;
        if (http2Exception instanceof Http2StreamException) {
            Http2StreamException http2StreamException = Http2StreamException$.MODULE$.unapply((Http2StreamException)http2Exception);
            int n = http2StreamException._1();
            long l = http2StreamException._2();
            String string = http2StreamException._3();
            long code = l;
            String msg = string;
            http2SessionException = Http2SessionException$.MODULE$.apply(code, msg);
        } else if (http2Exception instanceof Http2SessionException) {
            Http2SessionException ex;
            http2SessionException = ex = (Http2SessionException)http2Exception;
        } else {
            throw new MatchError((Object)http2Exception);
        }
        return http2SessionException;
    }

    public final boolean isRefusedStream() {
        return this.code() == Http2Exception$.MODULE$.REFUSED_STREAM().code();
    }

    public final ByteBuffer msgBuffer() {
        return ByteBuffer.wrap(this.msg.getBytes(StandardCharsets.UTF_8));
    }

    public static final class ErrorGenerator {
        private final long code;
        private final String name;
        private final String toString;

        public ErrorGenerator(long code, String name) {
            this.code = code;
            this.name = name;
            this.toString = "" + name + "(0x" + Integer.toHexString((int)code) + ")";
        }

        public long code() {
            return this.code;
        }

        public String name() {
            return this.name;
        }

        public Http2Exception goaway() {
            return Http2SessionException$.MODULE$.apply(this.code(), this.name());
        }

        public Http2SessionException goaway(String msg) {
            return Http2SessionException$.MODULE$.apply(this.code(), this.name() + ": " + msg);
        }

        public Http2StreamException rst(int stream) {
            return this.rst(stream, this.name());
        }

        public Http2StreamException rst(int stream, String msg) {
            return Http2StreamException$.MODULE$.apply(stream, this.code(), msg);
        }

        public Option<Tuple2<Option<Object>, String>> unapply(Http2Exception ex) {
            None$ none$;
            if (ex.code() == this.code()) {
                None$ none$2;
                Http2Exception http2Exception = ex;
                if (http2Exception instanceof Http2StreamException) {
                    Http2StreamException ex2 = (Http2StreamException)http2Exception;
                    none$2 = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ex2.stream()));
                } else {
                    none$2 = None$.MODULE$;
                }
                None$ stream = none$2;
                Option option = (Option)Predef$.MODULE$.ArrowAssoc((Object)stream);
                none$ = Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)option, (Object)ex.getMessage()));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public boolean unapply(int code) {
            return (long)code == this.code();
        }

        public String toString() {
            return this.toString;
        }
    }
}

