/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.OutboundStreamState;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.StreamFlowWindow;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.http.http2.StreamStateImpl;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class OutboundStreamStateImpl
extends StreamStateImpl
implements OutboundStreamState {
    private final SessionCore session;
    private int lazyStreamId;
    private StreamFlowWindow lazyFlowWindow;

    public OutboundStreamStateImpl(SessionCore session) {
        this.session = session;
        super(session);
        this.lazyStreamId = -1;
        this.lazyFlowWindow = null;
    }

    private Nothing$ uninitializedException() {
        throw new IllegalStateException("Stream uninitialized");
    }

    public abstract Option<Object> registerStream();

    @Override
    public final boolean initialized() {
        return this.lazyStreamId != -1;
    }

    public final String name() {
        String id = this.initialized() ? Integer.toString(this.streamId()) : "uninitialized";
        return "OutboundStreamState(" + id + ")";
    }

    @Override
    public final int streamId() {
        if (!this.initialized()) {
            throw this.uninitializedException();
        }
        return this.lazyStreamId;
    }

    @Override
    public final StreamFlowWindow flowWindow() {
        if (!this.initialized()) {
            throw this.uninitializedException();
        }
        return this.lazyFlowWindow;
    }

    @Override
    public final void invokeStreamWrite(StreamFrame msg, Promise<BoxedUnit> p) {
        if (this.initialized()) {
            super.invokeStreamWrite(msg, p);
        } else if (this.session.state().closing()) {
            Http2StreamException ex = Http2Exception$.MODULE$.REFUSED_STREAM().rst(0, "Session closed before stream was initialized");
            p.failure((Throwable)ex);
        } else {
            Option<Object> option = this.registerStream();
            if (option instanceof Some) {
                int freshId = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                this.lazyFlowWindow = this.session.sessionFlowControl().newStreamFlowWindow(freshId);
                this.lazyStreamId = freshId;
                Logger Logger_this = this.logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Created new OutboundStream with id " + freshId + ".");
                }
                super.invokeStreamWrite(msg, p);
            } else if (None$.MODULE$.equals(option)) {
                this.session.invokeDrain((Duration)Duration$.MODULE$.Inf());
                Http2StreamException ex = Http2Exception$.MODULE$.REFUSED_STREAM().rst(0, "Session is out of outbound stream IDs");
                p.failure((Throwable)ex);
            } else {
                throw new MatchError(option);
            }
        }
    }
}

