/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FlowStrategy;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings$DefaultSettings$;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.SessionFlowControl;
import org.http4s.blaze.http.http2.StreamFlowWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.math.package$;

public class SessionFlowControlImpl
extends SessionFlowControl {
    public final SessionCore org$http4s$blaze$http$http2$SessionFlowControlImpl$$session;
    private final FlowStrategy flowStrategy;
    public final Logger org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
    public int org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow;
    public int org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow;
    public int org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound;

    public SessionFlowControlImpl(SessionCore session, FlowStrategy flowStrategy) {
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session = session;
        this.flowStrategy = flowStrategy;
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.SessionFlowControlImpl");
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow = Http2Settings$DefaultSettings$.MODULE$.INITIAL_WINDOW_SIZE();
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow = Http2Settings$DefaultSettings$.MODULE$.INITIAL_WINDOW_SIZE();
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound = 0;
    }

    public void onSessonBytesConsumed(int consumed) {
        int n = consumed;
        int sessionUpdate = this.flowStrategy.checkSession(this);
        if (0 < sessionUpdate) {
            this.sessionInboundAcked(sessionUpdate);
            this.sendSessionWindowUpdate(sessionUpdate);
        }
    }

    public void sendSessionWindowUpdate(int updateSize) {
        ByteBuffer frame = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().sessionWindowUpdate(updateSize);
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(frame);
    }

    public void onStreamBytesConsumed(StreamFlowWindow stream, int consumed) {
        int n = consumed;
        FlowStrategy.Increment update = this.flowStrategy.checkStream(stream);
        if (0 < update.session()) {
            this.sessionInboundAcked(update.session());
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().sessionWindowUpdate(update.session()));
        }
        if (0 < update.stream()) {
            stream.streamInboundAcked(update.stream());
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().streamWindowUpdate(stream.streamId(), update.stream()));
        }
    }

    public void sendStreamWindowUpdate(int stream, int updateSize) {
        ByteBuffer frame = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.http2Encoder().streamWindowUpdate(stream, updateSize);
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.writeController().write(frame);
    }

    @Override
    public final StreamFlowWindow newStreamFlowWindow(int streamId) {
        Predef$.MODULE$.require(0 < streamId);
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("Created new stream: " + streamId);
        }
        return new StreamFlowWindowImpl(this, streamId);
    }

    @Override
    public final int sessionInboundWindow() {
        return this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow;
    }

    @Override
    public final boolean sessionInboundObserved(int count) {
        boolean bl;
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("Observed " + count + " inbound session bytes. " + this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString());
        }
        Predef$.MODULE$.require(0 <= count);
        if (this.sessionInboundWindow() < count) {
            bl = false;
        } else {
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow -= count;
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound += count;
            bl = true;
        }
        return bl;
    }

    @Override
    public final void sessionInboundAcked(int count) {
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("Acked " + count + " inbound session bytes. " + this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString());
        }
        Predef$.MODULE$.require(0 <= count);
        this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow += count;
    }

    @Override
    public final void sessionInboundConsumed(int count) {
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("Consumed " + count + " inbound session bytes. " + this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString());
        }
        Predef$.MODULE$.require(0 <= count);
        if (count > this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound) {
            String msg = "Consumed more bytes (" + count + ") than had been accounted for (" + this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound + ")";
            throw new IllegalStateException(msg);
        }
        if (count > 0) {
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound -= count;
            this.onSessonBytesConsumed(count);
        }
    }

    @Override
    public final int sessionUnconsumedBytes() {
        return this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound;
    }

    @Override
    public final int sessionOutboundWindow() {
        return this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow;
    }

    @Override
    public final Option<Http2Exception> sessionOutboundAcked(int count) {
        Some some;
        Logger Logger_this = this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("" + count + " outbound session bytes were ACKed. " + this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString());
        }
        if (count <= 0) {
            some = Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Invalid session WINDOW_UPDATE: size <= 0."));
        } else if (Integer.MAX_VALUE - this.sessionOutboundWindow() < count) {
            some = Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().goaway("Session flow control exceeded max window."));
        } else {
            this.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow += count;
            some = None$.MODULE$;
        }
        return some;
    }

    public String org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString() {
        return "Session: {inbound: " + this.sessionInboundWindow() + ", unconsumed: " + this.sessionUnconsumedBytes() + ", outbound: " + this.sessionOutboundWindow() + "}";
    }

    private final class StreamFlowWindowImpl
    extends StreamFlowWindow {
        private final int streamId;
        private int _streamInboundWindow;
        private int _streamOutboundWindow;
        private int _streamUnconsumedInbound;
        private final SessionFlowControlImpl $outer;

        public StreamFlowWindowImpl(SessionFlowControlImpl $outer, int streamId) {
            this.streamId = streamId;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this._streamInboundWindow = $outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.localSettings().initialWindowSize();
            this._streamOutboundWindow = $outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$session.remoteSettings().initialWindowSize();
            this._streamUnconsumedInbound = 0;
        }

        @Override
        public int streamId() {
            return this.streamId;
        }

        @Override
        public SessionFlowControl sessionFlowControl() {
            return this.$outer;
        }

        @Override
        public int streamUnconsumedBytes() {
            return this._streamUnconsumedInbound;
        }

        @Override
        public int streamOutboundWindow() {
            return this._streamOutboundWindow;
        }

        @Override
        public Option<Http2Exception> streamOutboundAcked(int count) {
            None$ none$;
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Stream(" + this.streamId() + ") had " + count + " outbound bytes ACKed. " + this.streamWindowString());
            }
            if (count <= 0) {
                none$ = Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Invalid stream (" + this.streamId() + ") WINDOW_UPDATE: size <= 0."));
            } else if (Integer.MAX_VALUE - this.streamOutboundWindow() < count) {
                none$ = Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().rst(this.streamId(), "Stream flow control exceeded max window."));
            } else {
                this._streamOutboundWindow += count;
                none$ = None$.MODULE$;
            }
            return none$;
        }

        @Override
        public Option<Http2Exception> remoteSettingsInitialWindowChange(int delta) {
            None$ none$;
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Stream(" + this.streamId() + ") outbound window adjusted by " + delta + " bytes. " + this.streamWindowString());
            }
            if (Integer.MAX_VALUE - this.streamOutboundWindow() < delta) {
                none$ = Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().goaway("Flow control exceeded max window for stream " + this.streamId() + "."));
            } else {
                this._streamOutboundWindow += delta;
                none$ = None$.MODULE$;
            }
            return none$;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int outboundRequest(int request) {
            void var2_2;
            Predef$.MODULE$.require(0 <= request);
            int withdrawal = package$.MODULE$.min(this.$outer.sessionOutboundWindow(), package$.MODULE$.min(request, this.streamOutboundWindow()));
            this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionOutboundWindow -= withdrawal;
            this._streamOutboundWindow -= withdrawal;
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Stream(" + this.streamId() + ") requested " + request + " outbound bytes, " + withdrawal + " were granted. " + this.streamWindowString());
            }
            return (int)var2_2;
        }

        @Override
        public int streamInboundWindow() {
            return this._streamInboundWindow;
        }

        @Override
        public boolean inboundObserved(int count) {
            boolean bl;
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Stream(" + this.streamId() + ") observed " + count + " inbound bytes. " + this.streamWindowString());
            }
            Predef$.MODULE$.require(0 <= count);
            if (count > this.streamInboundWindow() || count > this.$outer.sessionInboundWindow()) {
                Logger Logger_this2 = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
                if (Logger_this2.isInfoEnabled()) {
                    Logger_this2.info("Stream(" + this.streamId() + ") observed " + count + " inbound bytes which overflowed inbound window. " + this.streamWindowString());
                }
                bl = false;
            } else {
                this._streamUnconsumedInbound += count;
                this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound += count;
                this._streamInboundWindow -= count;
                this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionInboundWindow -= count;
                bl = true;
            }
            return bl;
        }

        @Override
        public void inboundConsumed(int count) {
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Stream(" + this.streamId() + ") consumed " + count + " inbound bytes. " + this.streamWindowString());
            }
            Predef$.MODULE$.require(0 <= count);
            Predef$.MODULE$.require(count <= this.streamUnconsumedBytes());
            Predef$.MODULE$.require(count <= this.$outer.sessionUnconsumedBytes());
            if (0 < count) {
                this._streamUnconsumedInbound -= count;
                this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$_sessionUnconsumedInbound -= count;
                this.$outer.onSessonBytesConsumed(count);
                this.$outer.onStreamBytesConsumed(this, count);
            }
        }

        @Override
        public void streamInboundAcked(int count) {
            Logger Logger_this = this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$logger;
            if (Logger_this.isTraceEnabled()) {
                Logger_this.trace("Stream(" + this.streamId() + ") ACKed " + count + " bytes. " + this.streamWindowString());
            }
            Predef$.MODULE$.require(0 <= count);
            this._streamInboundWindow += count;
        }

        private String streamWindowString() {
            return "" + this.$outer.org$http4s$blaze$http$http2$SessionFlowControlImpl$$sessionWindowString() + ", Stream(" + this.streamId() + "): " + ("{inbound: " + this.streamInboundWindow() + ", unconsumed: " + this.streamUnconsumedBytes() + ", outbound: " + this.streamOutboundWindow() + "}");
        }

        public final SessionFlowControlImpl org$http4s$blaze$http$http2$SessionFlowControlImpl$StreamFlowWindowImpl$$$outer() {
            return this.$outer;
        }
    }
}

