/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Http2Settings$Setting$;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.MutableHttp2Settings$;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.SettingsDecoder$SettingsFrame$;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.util.Either;
import scala.util.Right;
import scala.util.Right$;

public final class SettingsDecoder$
implements Serializable {
    public static final SettingsDecoder$SettingsFrame$ SettingsFrame;
    public static final SettingsDecoder$ MODULE$;

    private SettingsDecoder$() {
    }

    static {
        MODULE$ = new SettingsDecoder$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SettingsDecoder$.class);
    }

    public Either<Http2Exception, SettingsDecoder.SettingsFrame> decodeSettingsFrame(ByteBuffer buffer) {
        Either<Http2Exception, SettingsDecoder.SettingsFrame> either;
        int len = FrameDecoder$.MODULE$.getLengthField(buffer);
        if (len + bits$.MODULE$.HeaderSize() - bits$.MODULE$.LengthFieldSize() != buffer.remaining()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        byte tpe = buffer.get();
        if (tpe != bits$FrameTypes$.MODULE$.SETTINGS()) {
            either = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Expected SETTINGS frame"));
        } else {
            byte flags = buffer.get();
            int streamId = FrameDecoder$.MODULE$.getStreamId(buffer);
            either = this.decodeSettingsFrame(buffer, streamId, flags);
        }
        return either;
    }

    public Either<Http2Exception, SettingsDecoder.SettingsFrame> decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        Right right;
        int len = buffer.remaining();
        boolean isAck = bits$Flags$.MODULE$.ACK(flags);
        if (len % 6 != 0) {
            String msg = "SETTINGS frame payload must be multiple of 6 bytes, size: " + len;
            right = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else if (isAck && len != 0) {
            int settingsCount = len / 6;
            String msg = "SETTINGS ACK frame with settings payload (" + settingsCount + " settings)";
            right = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        } else if (streamId != 0) {
            right = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("SETTINGS frame with invalid stream id: " + streamId));
        } else {
            SettingsDecoder.SettingsFrame settingsFrame;
            Right$ right$ = package$.MODULE$.Right();
            if (isAck) {
                settingsFrame = SettingsDecoder$SettingsFrame$.MODULE$.apply((Option<Seq<Http2Settings.Setting>>)None$.MODULE$);
            } else {
                ReusableBuilder settings = package$.MODULE$.Vector().newBuilder();
                while (buffer.hasRemaining()) {
                    int id = buffer.getShort() & 0xFFFF;
                    int value = buffer.getInt();
                    settings.$plus$eq((Object)Http2Settings$Setting$.MODULE$.apply(id, value));
                }
                settingsFrame = SettingsDecoder$SettingsFrame$.MODULE$.apply((Option<Seq<Http2Settings.Setting>>)Some$.MODULE$.apply(settings.result()));
            }
            right = right$.apply((Object)settingsFrame);
        }
        return right;
    }

    public Either<Http2Exception, MutableHttp2Settings> settingsFromFrame(Seq<Http2Settings.Setting> settings) {
        Right right;
        MutableHttp2Settings next = MutableHttp2Settings$.MODULE$.default();
        Option<Http2Exception> option = next.updateSettings(settings);
        if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Right().apply((Object)next);
        } else if (option instanceof Some) {
            Http2Exception ex = (Http2Exception)((Some)option).value();
            right = package$.MODULE$.Left().apply((Object)ex);
        } else {
            throw new MatchError(option);
        }
        return right;
    }
}

