/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.InboundStreamState;
import org.http4s.blaze.http.http2.InboundStreamStateImpl;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.MaybeError$;
import org.http4s.blaze.http.http2.OutboundStreamState;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.StreamFlowWindow;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.http.http2.StreamManager;
import org.http4s.blaze.http.http2.StreamState;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;

public final class StreamManagerImpl
implements StreamManager {
    public final SessionCore org$http4s$blaze$http$http2$StreamManagerImpl$$session;
    private final Option<Function1<Object, LeafBuilder<StreamFrame>>> inboundStreamBuilder;
    private final Logger logger;
    public final HashMap<Object, StreamState> org$http4s$blaze$http$http2$StreamManagerImpl$$streams;
    public Option<Promise<BoxedUnit>> org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;

    public StreamManagerImpl(SessionCore session, Option<Function1<Object, LeafBuilder<StreamFrame>>> inboundStreamBuilder) {
        this.org$http4s$blaze$http$http2$StreamManagerImpl$$session = session;
        this.inboundStreamBuilder = inboundStreamBuilder;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.StreamManagerImpl");
        this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams = new HashMap();
        this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP = None$.MODULE$;
    }

    public SessionCore org$http4s$blaze$http$http2$StreamManagerImpl$$OutboundStreamStateImpl$superArg$1() {
        return this.org$http4s$blaze$http$http2$StreamManagerImpl$$session;
    }

    @Override
    public int size() {
        return this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.size();
    }

    @Override
    public boolean isEmpty() {
        return this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MaybeError initialFlowWindowChange(int diff) {
        void var2_2;
        MaybeError result = Continue$.MODULE$;
        Iterator it = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.valuesIterator();
        while (it.hasNext()) {
            Continue$ continue$ = result;
            Continue$ continue$2 = Continue$.MODULE$;
            if (continue$ != null ? !continue$.equals(continue$2) : continue$2 != null) break;
            StreamState stream = (StreamState)it.next();
            Option<Http2Exception> option = stream.flowWindow().remoteSettingsInitialWindowChange(diff);
            if (None$.MODULE$.equals(option)) {
                stream.outboundFlowWindowChanged();
                continue;
            }
            if (option instanceof Some) {
                Http2Exception ex = (Http2Exception)((Some)option).value();
                result = Error$.MODULE$.apply(ex.toSessionException());
                continue;
            }
            throw new MatchError(option);
        }
        return var2_2;
    }

    @Override
    public Option<StreamState> get(int id) {
        return this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.get((Object)BoxesRunTime.boxToInteger((int)id));
    }

    @Override
    public void forceClose(Option<Throwable> cause) {
        Vector ss = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.values().toVector();
        ss.foreach((Function1)(JProcedure1 & Serializable)stream -> {
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)stream.streamId()));
            stream.doCloseWithError(cause);
        });
        Option<Promise<BoxedUnit>> option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;
        if (option instanceof Some) {
            Promise p = (Promise)((Some)option).value();
            p.trySuccess((Object)BoxedUnit.UNIT);
        } else if (None$.MODULE$.equals(option)) {
            Promise p = Promise$.MODULE$.apply();
            p.trySuccess((Object)BoxedUnit.UNIT);
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP = Some$.MODULE$.apply((Object)p);
        } else {
            throw new MatchError(option);
        }
    }

    @Override
    public Either<Http2Exception, InboundStreamState> newInboundStream(int streamId) {
        Left left;
        if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().observeInboundId(streamId)) {
            String msg = this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isOutboundId(streamId) ? "Received HEADERS frame for idle outbound stream id " + streamId : "Received HEADERS frame for non-idle inbound stream id " + streamId;
            left = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        } else if (this.inboundStreamBuilder.isEmpty()) {
            left = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Client received request for new inbound stream (" + streamId + ") without push promise"));
        } else if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP.isDefined()) {
            left = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.REFUSED_STREAM().rst(streamId, "Session draining"));
        } else if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.localSettings().maxConcurrentStreams() <= this.size()) {
            left = package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.REFUSED_STREAM().rst(streamId));
        } else {
            LeafBuilder leafBuilder = (LeafBuilder)((Function1)this.inboundStreamBuilder.get()).apply((Object)BoxesRunTime.boxToInteger((int)streamId));
            StreamFlowWindow streamFlowWindow = this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.sessionFlowControl().newStreamFlowWindow(streamId);
            InboundStreamStateImpl streamState = new InboundStreamStateImpl(this.org$http4s$blaze$http$http2$StreamManagerImpl$$session, streamId, streamFlowWindow);
            if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.put((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)streamState).isEmpty()) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            leafBuilder.base((HeadStage)streamState);
            streamState.sendInboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
            left = package$.MODULE$.Right().apply((Object)streamState);
        }
        return left;
    }

    @Override
    public MaybeError rstStream(Http2StreamException cause) {
        MaybeError maybeError;
        Option option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)cause.stream()));
        if (option instanceof Some) {
            StreamState streamState = (StreamState)((Some)option).value();
            streamState.doCloseWithError((Option<Throwable>)Some$.MODULE$.apply((Object)cause));
            maybeError = Continue$.MODULE$;
        } else if (None$.MODULE$.equals(option)) {
            maybeError = this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isIdleId(cause.stream()) ? Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("RST_STREAM for idle stream id " + cause.stream())) : Continue$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return maybeError;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean streamClosed(StreamState streamState) {
        void var2_2;
        block1: {
            boolean result = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)streamState.streamId())).isDefined();
            Option<Promise<BoxedUnit>> option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;
            if (!(option instanceof Some)) break block1;
            Promise p = (Promise)((Some)option).value();
            if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.isEmpty()) {
                p.trySuccess((Object)BoxedUnit.UNIT);
            }
        }
        return (boolean)var2_2;
    }

    @Override
    public Result handlePushPromise(int streamId, int promisedId, Seq headers) {
        Error error;
        if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isIdleOutboundId(streamId)) {
            error = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received PUSH_PROMISE for associated to an idle stream (" + streamId + ")"));
        } else if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isInboundId(promisedId)) {
            error = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received PUSH_PROMISE frame with illegal stream id: " + promisedId));
        } else if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().observeInboundId(promisedId)) {
            error = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received PUSH_PROMISE frame on non-idle stream"));
        } else {
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("Rejecting pushed stream " + promisedId + " associated with stream " + streamId);
            }
            error = Error$.MODULE$.apply(Http2Exception$.MODULE$.REFUSED_STREAM().rst(promisedId, "Server push not supported"));
        }
        return error;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MaybeError flowWindowUpdate(int streamId, int sizeIncrement) {
        MaybeError maybeError;
        if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isIdleId(streamId)) {
            maybeError = Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("WINDOW_UPDATE on uninitialized stream (" + streamId + ")"));
        } else if (streamId == 0) {
            void var3_3;
            MaybeError result = MaybeError$.MODULE$.apply(this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.sessionFlowControl().sessionOutboundAcked(sizeIncrement));
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("Session flow update: " + sizeIncrement + ". Result: " + result);
            }
            if (result.success()) {
                this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.values().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.outboundFlowWindowChanged());
            }
            maybeError = var3_3;
        } else {
            Option option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.get((Object)BoxesRunTime.boxToInteger((int)streamId));
            if (None$.MODULE$.equals(option)) {
                Logger Logger_this = this.logger;
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Stream WINDOW_UPDATE(" + sizeIncrement + ") for closed stream " + streamId);
                }
                maybeError = Continue$.MODULE$;
            } else if (option instanceof Some) {
                StreamState stream = (StreamState)((Some)option).value();
                MaybeError result = MaybeError$.MODULE$.apply(stream.flowWindow().streamOutboundAcked(sizeIncrement));
                Logger Logger_this = this.logger;
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Stream(" + stream.streamId() + ") WINDOW_UPDATE(" + sizeIncrement + "). Result: " + result);
                }
                if (result.success()) {
                    stream.outboundFlowWindowChanged();
                }
                maybeError = result;
            } else {
                throw new MatchError((Object)option);
            }
        }
        return maybeError;
    }

    @Override
    public Future<BoxedUnit> drain(int lastHandledOutboundStream, Http2SessionException reason) {
        Future future;
        Option<Promise<BoxedUnit>> option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;
        if (option instanceof Some) {
            Promise p = (Promise)((Some)option).value();
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("Received a second GOAWAY(" + lastHandledOutboundStream, (Throwable)reason);
            }
            future = p.future();
        } else if (None$.MODULE$.equals(option)) {
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("StreamManager.goaway(" + lastHandledOutboundStream + ")", (Throwable)reason);
            }
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                block1: {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) break block1;
                    int id = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    StreamState stream = (StreamState)tuple2._2();
                    if (lastHandledOutboundStream < id && this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isOutboundId(id)) {
                        this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)id));
                        Http2StreamException ex = Http2Exception$.MODULE$.REFUSED_STREAM().rst(id, reason.msg());
                        stream.doCloseWithError((Option<Throwable>)Some$.MODULE$.apply((Object)ex));
                    }
                }
            });
            Promise p = Promise$.MODULE$.apply();
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP = Some$.MODULE$.apply((Object)p);
            future = p.future();
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    @Override
    public OutboundStreamState newOutboundStream() {
        return new OutboundStreamStateImpl(this);
    }

    private class OutboundStreamStateImpl
    extends org.http4s.blaze.http.http2.OutboundStreamStateImpl {
        private final StreamManagerImpl $outer;

        public OutboundStreamStateImpl(StreamManagerImpl $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer.org$http4s$blaze$http$http2$StreamManagerImpl$$OutboundStreamStateImpl$superArg$1());
        }

        @Override
        public Option<Object> registerStream() {
            None$ none$;
            if (this.$outer.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP.isDefined()) {
                none$ = None$.MODULE$;
            } else {
                Option<Object> option = this.$outer.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().takeOutboundId();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    int freshId = BoxesRunTime.unboxToInt((Object)some.value());
                    Some id = some;
                    if (!this.$outer.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.put((Object)BoxesRunTime.boxToInteger((int)freshId), (Object)this).isEmpty()) {
                        throw Scala3RunTime$.MODULE$.assertFailed();
                    }
                    none$ = id;
                } else if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
            }
            return none$;
        }

        public final StreamManagerImpl org$http4s$blaze$http$http2$StreamManagerImpl$OutboundStreamStateImpl$$$outer() {
            return this.$outer;
        }
    }
}

