/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.DataFrame;
import org.http4s.blaze.http.http2.DataFrame$;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.HeadersFrame;
import org.http4s.blaze.http.http2.HeadersFrame$;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.http.http2.StreamState;
import org.http4s.blaze.http.http2.StreamStateImpl$;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.BufferTools$;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;

public abstract class StreamStateImpl
implements Stage,
Head,
HeadStage,
StreamState {
    private Logger logger;
    private Tail _nextStage;
    private final SessionCore session;
    private final ArrayDeque<StreamFrame> pendingInboundMessages;
    private Promise<StreamFrame> pendingRead;
    private Promise<BoxedUnit> writePromise;
    private StreamFrame pendingOutboundFrame;
    private boolean interestRegistered;
    private Option<Throwable> closedReason;
    private boolean sentEndStream;
    private boolean receivedEndStream;

    public StreamStateImpl(SessionCore session) {
        this.session = session;
        Stage.$init$((Stage)this);
        Head.$init$((Head)this);
        this.pendingInboundMessages = new ArrayDeque(1);
        this.pendingRead = null;
        this.writePromise = null;
        this.pendingOutboundFrame = null;
        this.interestRegistered = false;
        this.closedReason = None$.MODULE$;
        this.sentEndStream = false;
        this.receivedEndStream = false;
        Statics.releaseFence();
    }

    public final Logger logger() {
        return this.logger;
    }

    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Tail _nextStage() {
        return this._nextStage;
    }

    public void _nextStage_$eq(Tail x$1) {
        this._nextStage = x$1;
    }

    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$((Stage)this, (Command.InboundCommand)cmd);
    }

    private void doRegisterWriteInterest() {
        if (!this.interestRegistered) {
            this.interestRegistered = true;
            if (!this.session.writeController().registerWriteInterest(this)) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
        }
    }

    private boolean streamIsClosed() {
        return this.closedReason.isDefined();
    }

    public Future<StreamFrame> readRequest(int size) {
        int n = size;
        Promise p = Promise$.MODULE$.apply();
        this.session.serialExecutor().execute(new Runnable(p, this){
            private final Promise p$1;
            private final StreamStateImpl $outer;
            {
                this.p$1 = p$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.org$http4s$blaze$http$http2$StreamStateImpl$$invokeStreamRead((Promise<StreamFrame>)this.p$1);
            }
        });
        return p.future();
    }

    public void org$http4s$blaze$http$http2$StreamStateImpl$$invokeStreamRead(Promise<StreamFrame> p) {
        if (this.pendingRead != null) {
            this.doCloseWithError((Option<Throwable>)Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId())));
            p.failure((Throwable)new IllegalStateException("Already have an outstanding read on a stream (" + this.streamId() + ")"));
        } else if (this.streamIsClosed()) {
            p.failure((Throwable)this.closedReason.get());
        } else {
            StreamFrame streamFrame = this.pendingInboundMessages.poll();
            if (streamFrame == null) {
                if (this.receivedEndStream) {
                    p.failure((Throwable)Command.EOF$.MODULE$);
                } else {
                    this.pendingRead = p;
                }
            } else {
                StreamFrame msg = streamFrame;
                int flowBytes = msg.flowBytes();
                if (0 < flowBytes) {
                    this.flowWindow().inboundConsumed(flowBytes);
                }
                p.success((Object)msg);
            }
        }
    }

    public final Future<BoxedUnit> writeRequest(StreamFrame msg) {
        Promise p = Promise$.MODULE$.apply();
        this.session.serialExecutor().execute(new Runnable(msg, p, this){
            private final StreamFrame msg$1;
            private final Promise p$1;
            private final StreamStateImpl $outer;
            {
                this.msg$1 = msg$2;
                this.p$1 = p$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.invokeStreamWrite(this.msg$1, (Promise<BoxedUnit>)this.p$1);
            }
        });
        return p.future();
    }

    public void invokeStreamWrite(StreamFrame msg, Promise<BoxedUnit> p) {
        if (this.writePromise != null) {
            this.doCloseWithError((Option<Throwable>)Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId())));
            p.failure((Throwable)new IllegalStateException("Already a pending write on this stream (" + this.streamId() + ")"));
        } else if (this.sentEndStream) {
            p.failure((Throwable)new IllegalStateException("Stream(" + this.streamId() + ") already closed"));
        } else if (this.streamIsClosed()) {
            this.sentEndStream = msg.endStream();
            p.failure((Throwable)this.closedReason.get());
        } else {
            this.sentEndStream = msg.endStream();
            this.pendingOutboundFrame = msg;
            this.writePromise = p;
            if (msg.flowBytes() == 0 || this.flowWindow().outboundWindowAvailable()) {
                this.doRegisterWriteInterest();
            }
        }
    }

    @Override
    public final void outboundFlowWindowChanged() {
        if (this.writePromise != null && this.flowWindow().outboundWindowAvailable()) {
            this.doRegisterWriteInterest();
        }
    }

    @Override
    public final Seq<ByteBuffer> performStreamWrite() {
        Seq<ByteBuffer> seq;
        this.interestRegistered = false;
        if (this.writePromise == null) {
            seq = package$.MODULE$.Nil();
        } else {
            StreamFrame streamFrame = this.pendingOutboundFrame;
            if (streamFrame instanceof HeadersFrame) {
                HeadersFrame headersFrame = HeadersFrame$.MODULE$.unapply((HeadersFrame)streamFrame);
                Priority priority = headersFrame._1();
                boolean bl = headersFrame._2();
                Seq seq2 = headersFrame._3();
                Priority priority2 = priority;
                boolean endStream = bl;
                Seq hs = seq2;
                Seq<ByteBuffer> data = this.session.http2Encoder().headerFrame(this.streamId(), priority2, endStream, (Seq<Tuple2<String, String>>)hs);
                Promise<BoxedUnit> p = this.writePromise;
                this.writePromise = null;
                this.pendingOutboundFrame = null;
                p.success((Object)BoxedUnit.UNIT);
                seq = data;
            } else if (streamFrame instanceof DataFrame) {
                DataFrame dataFrame = DataFrame$.MODULE$.unapply((DataFrame)streamFrame);
                boolean bl = dataFrame._1();
                ByteBuffer byteBuffer = dataFrame._2();
                boolean endStream = bl;
                ByteBuffer data = byteBuffer;
                int requested = scala.math.package$.MODULE$.min(this.session.remoteSettings().maxFrameSize(), data.remaining());
                int allowedBytes = this.flowWindow().outboundRequest(requested);
                Logger Logger_this = this.logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Allowed: " + allowedBytes + ", data: " + this.pendingOutboundFrame);
                }
                if (allowedBytes == this.pendingOutboundFrame.flowBytes()) {
                    Seq<ByteBuffer> buffers = this.session.http2Encoder().dataFrame(this.streamId(), endStream, data);
                    Promise<BoxedUnit> p = this.writePromise;
                    this.writePromise = null;
                    this.pendingOutboundFrame = null;
                    p.success((Object)BoxedUnit.UNIT);
                    seq = buffers;
                } else if (allowedBytes == 0) {
                    seq = package$.MODULE$.Nil();
                } else {
                    ByteBuffer slice = BufferTools$.MODULE$.takeSlice(data, allowedBytes);
                    Seq<ByteBuffer> buffers = this.session.http2Encoder().dataFrame(this.streamId(), false, slice);
                    if (this.flowWindow().streamOutboundWindow() > 0) {
                        this.doRegisterWriteInterest();
                    }
                    seq = buffers;
                }
            } else {
                throw new MatchError((Object)streamFrame);
            }
        }
        return seq;
    }

    @Override
    public final MaybeError invokeInboundData(boolean endStream, ByteBuffer data, int flowBytes) {
        MaybeError maybeError;
        if (this.receivedEndStream) {
            maybeError = Error$.MODULE$.apply(Http2Exception$.MODULE$.STREAM_CLOSED().rst(this.streamId(), "Stream(" + this.streamId() + ") received DATA frame after EOS"));
        } else if (this.streamIsClosed()) {
            maybeError = Error$.MODULE$.apply(Http2Exception$.MODULE$.STREAM_CLOSED().goaway("Stream(" + this.streamId() + ") received DATA after stream was closed"));
        } else if (this.flowWindow().inboundObserved(flowBytes)) {
            this.receivedEndStream = endStream;
            int consumed = this.queueMessage(DataFrame$.MODULE$.apply(endStream, data)) ? flowBytes : flowBytes - data.remaining();
            this.flowWindow().inboundConsumed(consumed);
            maybeError = Continue$.MODULE$;
        } else {
            maybeError = Error$.MODULE$.apply(Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().goaway("stream(" + this.streamId() + ") flow control error"));
        }
        return maybeError;
    }

    @Override
    public final MaybeError invokeInboundHeaders(Priority priority, boolean endStream, Seq headers) {
        MaybeError maybeError;
        if (this.receivedEndStream) {
            maybeError = Error$.MODULE$.apply(Http2Exception$.MODULE$.STREAM_CLOSED().rst(this.streamId(), "Stream(" + this.streamId() + " received HEADERS frame after EOS"));
        } else if (this.streamIsClosed()) {
            maybeError = Error$.MODULE$.apply(Http2Exception$.MODULE$.STREAM_CLOSED().goaway("Stream(" + this.streamId() + ") received HEADERS after stream was closed"));
        } else {
            if (endStream) {
                this.receivedEndStream = true;
            }
            this.queueMessage(HeadersFrame$.MODULE$.apply(priority, endStream, headers));
            maybeError = Continue$.MODULE$;
        }
        return maybeError;
    }

    public final void doClosePipeline(Option<Throwable> cause) {
        this.session.serialExecutor().execute(new Runnable(cause, this){
            private final Option cause$1;
            private final StreamStateImpl $outer;
            {
                this.cause$1 = cause$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.doCloseWithError((Option<Throwable>)this.cause$1);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void doCloseWithError(Option<Throwable> cause) {
        Object object;
        Some<Throwable> some;
        if (this.streamIsClosed()) return;
        Option<Throwable> option = cause;
        if (None$.MODULE$.equals(option)) {
            some = StreamStateImpl$.org$http4s$blaze$http$http2$StreamStateImpl$$$SomeEOF;
        } else {
            Option<Throwable> other = option;
            some = other;
        }
        this.closedReason = some;
        this.clearDataChannels((Throwable)this.closedReason.get());
        Option<Throwable> option2 = cause;
        if (None$.MODULE$.equals(option2)) {
            object = !this.sentEndStream || !this.receivedEndStream ? Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.CANCEL().rst(this.streamId())) : None$.MODULE$;
        } else {
            if (!(option2 instanceof Some)) throw new MatchError(option2);
            Throwable throwable = (Throwable)((Some)option2).value();
            if (throwable instanceof Http2Exception) {
                Http2Exception ex = (Http2Exception)throwable;
                object = Some$.MODULE$.apply((Object)ex);
            } else {
                Throwable other = throwable;
                Logger Logger_this = this.logger();
                if (Logger_this.isWarnEnabled()) {
                    Logger_this.warn("Unknown error in stream(" + this.streamId() + ")", other);
                }
                object = Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId(), "Unhandled error in stream pipeline"));
            }
        }
        None$ http2Ex = object;
        boolean wasRegistered = this.initialized() && this.session.streamManager().streamClosed(this);
        None$ none$ = http2Ex;
        if (none$ instanceof Some) {
            Http2Exception http2Exception = (Http2Exception)((Some)none$).value();
            if (http2Exception instanceof Http2StreamException) {
                Http2StreamException http2StreamException;
                Http2StreamException ex = http2StreamException = (Http2StreamException)http2Exception;
                if (!wasRegistered) {
                    Http2StreamException ex2 = http2StreamException;
                    Logger Logger_this = this.logger();
                    if (!Logger_this.isDebugEnabled()) return;
                    Logger_this.debug("Stream (" + this.streamId() + ") closed but not sending RST", (Throwable)ex2);
                    return;
                }
                Logger Logger_this = this.logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Sending stream (" + this.streamId() + ") RST", (Throwable)ex);
                }
                ByteBuffer frame = this.session.http2Encoder().rstFrame(this.streamId(), ex.code());
                this.session.writeController().write(frame);
                return;
            }
            if (http2Exception instanceof Http2SessionException) {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Stream(" + this.streamId() + ") finished with session exception");
                }
                this.session.invokeShutdownWithError((Option<Throwable>)http2Ex, "streamFinished");
                return;
            }
        }
        if (!None$.MODULE$.equals(none$)) throw new MatchError((Object)none$);
    }

    private boolean queueMessage(StreamFrame msg) {
        boolean bl;
        if (this.pendingRead == null) {
            this.pendingInboundMessages.offer(msg);
            bl = false;
        } else {
            this.pendingRead.success((Object)msg);
            this.pendingRead = null;
            bl = true;
        }
        return bl;
    }

    private void clearDataChannels(Throwable ex) {
        if (this.pendingRead == null) {
            int pendingBytes = 0;
            while (!this.pendingInboundMessages.isEmpty()) {
                pendingBytes += this.pendingInboundMessages.poll().flowBytes();
            }
            this.flowWindow().sessionFlowControl().sessionInboundConsumed(pendingBytes);
        } else {
            Promise<StreamFrame> p = this.pendingRead;
            this.pendingRead = null;
            p.failure(ex);
        }
        if (this.writePromise != null) {
            Promise<BoxedUnit> p = this.writePromise;
            this.writePromise = null;
            this.pendingOutboundFrame = null;
            p.failure(ex);
        }
    }
}

