/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.WriteController;
import org.http4s.blaze.http.http2.WriteControllerImpl$Closed$;
import org.http4s.blaze.http.http2.WriteControllerImpl$Closing$;
import org.http4s.blaze.http.http2.WriteControllerImpl$Flushing$;
import org.http4s.blaze.http.http2.WriteControllerImpl$Idle$;
import org.http4s.blaze.http.http2.WriteInterest;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.package$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class WriteControllerImpl
implements WriteController {
    private final SessionCore session;
    private final int highWaterMark;
    private final TailStage<ByteBuffer> tailStage;
    private final Logger logger;
    private final ArrayDeque<WriteInterest> interestedStreams;
    private final ArrayDeque<scala.collection.immutable.Seq<ByteBuffer>> pendingWrites;
    private State state;

    public WriteControllerImpl(SessionCore session, int highWaterMark, TailStage<ByteBuffer> tailStage) {
        this.session = session;
        this.highWaterMark = highWaterMark;
        this.tailStage = tailStage;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.WriteControllerImpl");
        this.interestedStreams = new ArrayDeque();
        this.pendingWrites = new ArrayDeque();
        this.state = WriteControllerImpl$Idle$.MODULE$;
    }

    @Override
    public Future<BoxedUnit> close() {
        Future future;
        State state = this.state;
        if (WriteControllerImpl$Idle$.MODULE$.equals(state)) {
            this.state = WriteControllerImpl$Closed$.MODULE$;
            future = package$.MODULE$.FutureUnit();
        } else if (WriteControllerImpl$Flushing$.MODULE$.equals(state)) {
            Promise p = Promise$.MODULE$.apply();
            this.state = WriteControllerImpl$Closing$.MODULE$.apply((Promise<BoxedUnit>)p);
            future = p.future();
        } else if (state instanceof Closing) {
            Promise<BoxedUnit> promise;
            Closing closing = WriteControllerImpl$Closing$.MODULE$.unapply((Closing)state);
            Promise<BoxedUnit> p = promise = closing._1();
            future = p.future();
        } else if (WriteControllerImpl$Closed$.MODULE$.equals(state)) {
            future = package$.MODULE$.FutureUnit();
        } else {
            throw new MatchError((Object)state);
        }
        return future;
    }

    private boolean pendingInterests() {
        return !this.pendingWrites.isEmpty() || !this.interestedStreams.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(scala.collection.immutable.Seq<ByteBuffer> data) {
        State state;
        block3: {
            block2: {
                state = this.state;
                if (WriteControllerImpl$Idle$.MODULE$.equals(state) || WriteControllerImpl$Flushing$.MODULE$.equals(state)) break block2;
                if (!(state instanceof Closing)) break block3;
                Closing closing = WriteControllerImpl$Closing$.MODULE$.unapply((Closing)state);
                Promise<BoxedUnit> promise = closing._1();
            }
            this.pendingWrites.addLast(data);
            this.maybeWrite();
            return true;
        }
        if (!WriteControllerImpl$Closed$.MODULE$.equals(state)) throw new MatchError((Object)state);
        return false;
    }

    @Override
    public boolean write(ByteBuffer data) {
        return this.write((scala.collection.immutable.Seq<ByteBuffer>)scala.package$.MODULE$.Nil().$colon$colon((Object)data));
    }

    @Override
    public boolean registerWriteInterest(WriteInterest interest) {
        boolean bl;
        State state = this.state;
        if (WriteControllerImpl$Closed$.MODULE$.equals(state)) {
            bl = false;
        } else {
            this.interestedStreams.add(interest);
            this.maybeWrite();
            bl = true;
        }
        return bl;
    }

    private void maybeWrite() {
        State state = this.state;
        WriteControllerImpl$Idle$ writeControllerImpl$Idle$ = WriteControllerImpl$Idle$.MODULE$;
        if (!(state != null ? !state.equals(writeControllerImpl$Idle$) : writeControllerImpl$Idle$ != null)) {
            this.state = WriteControllerImpl$Flushing$.MODULE$;
            this.doWrite();
        }
    }

    /*
     * WARNING - void declaration
     */
    private int addDirectWrites(ArrayBuffer<ByteBuffer> dest) {
        void var2_2;
        int written = 0;
        while (!this.pendingWrites.isEmpty()) {
            written += this.addBuffs(dest, (Seq<ByteBuffer>)((Seq)this.pendingWrites.poll()));
        }
        return (int)var2_2;
    }

    private int addBuffs(ArrayBuffer<ByteBuffer> dest, Seq<ByteBuffer> data) {
        IntRef written = IntRef.create((int)0);
        data.foreach((Function1)(JProcedure1 & Serializable)buf -> {
            int rem = buf.remaining();
            if (0 < rem) {
                int n;
                written$1.elem = n = written$1.elem + rem;
                dest.$plus$eq(buf);
            }
        });
        return written.elem;
    }

    private void doWrite() {
        ArrayBuffer toWrite = new ArrayBuffer();
        int bytesToWrite = this.addDirectWrites((ArrayBuffer<ByteBuffer>)toWrite);
        while (!this.interestedStreams.isEmpty() && bytesToWrite < this.highWaterMark) {
            try {
                Seq<ByteBuffer> data = this.interestedStreams.poll().performStreamWrite();
                bytesToWrite += this.addBuffs((ArrayBuffer<ByteBuffer>)toWrite, data);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    Logger Logger_this = this.logger;
                    if (!Logger_this.isErrorEnabled()) continue;
                    Logger_this.error("Unhandled exception performing stream write operation", t);
                    continue;
                }
                throw throwable;
            }
        }
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug("Flushing " + bytesToWrite + " to the wire");
        }
        this.tailStage.channelWrite((Seq)toWrite).onComplete((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            Try try_ = x$1;
            if (!(try_ instanceof Success)) {
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Throwable t = ((Failure)try_).exception();
                this.session.invokeShutdownWithError((Option<Throwable>)Some$.MODULE$.apply((Object)t), "WriteController.doWrite");
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            State state = this.state;
            if (WriteControllerImpl$Idle$.MODULE$.equals(state)) {
                throw new IllegalStateException("Write finished to find Idle state");
            }
            if (WriteControllerImpl$Flushing$.MODULE$.equals(state)) {
                if (this.pendingInterests()) {
                    this.doWrite();
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                this.state = WriteControllerImpl$Idle$.MODULE$;
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            if (!(state instanceof Closing)) {
                if (!WriteControllerImpl$Closed$.MODULE$.equals(state)) throw new MatchError((Object)state);
                throw new IllegalStateException("Shouldn't get here");
            }
            Closing closing = WriteControllerImpl$Closing$.MODULE$.unapply((Closing)state);
            Promise<BoxedUnit> promise = closing._1();
            if (this.pendingInterests()) {
                this.doWrite();
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            Promise<BoxedUnit> p = promise;
            this.state = WriteControllerImpl$Closed$.MODULE$;
            boxedUnit = p.success((Object)BoxedUnit.UNIT);
            return boxedUnit;
        }, this.session.serialExecutor());
    }

    private static class Closing
    implements State,
    Product,
    Serializable {
        private final Promise p;

        public static Closing apply(Promise<BoxedUnit> promise) {
            return WriteControllerImpl$Closing$.MODULE$.apply(promise);
        }

        public static Closing fromProduct(Product product) {
            return WriteControllerImpl$Closing$.MODULE$.fromProduct(product);
        }

        public static Closing unapply(Closing closing) {
            return WriteControllerImpl$Closing$.MODULE$.unapply(closing);
        }

        public Closing(Promise<BoxedUnit> p) {
            this.p = p;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Closing)) return false;
            Closing closing = (Closing)object;
            Promise<BoxedUnit> promise = this.p();
            Promise<BoxedUnit> promise2 = closing.p();
            if (promise == null) {
                if (promise2 != null) {
                    return false;
                }
            } else if (!promise.equals(promise2)) return false;
            if (!closing.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Closing;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Closing";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "p";
        }

        public Promise<BoxedUnit> p() {
            return this.p;
        }

        public Closing copy(Promise<BoxedUnit> p) {
            return new Closing(p);
        }

        public Promise<BoxedUnit> copy$default$1() {
            return this.p();
        }

        public Promise<BoxedUnit> _1() {
            return this.p();
        }
    }

    private static interface State {
    }
}

