/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.http4s.blaze.http.http2.BufferUnderflow$;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.FrameDecoder$;
import org.http4s.blaze.http.http2.FrameListener;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Priority$Dependent$;
import org.http4s.blaze.http.http2.Priority$NoPriority$;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SettingsDecoder;
import org.http4s.blaze.http.http2.SettingsDecoder$;
import org.http4s.blaze.http.http2.SettingsDecoder$SettingsFrame$;
import org.http4s.blaze.http.http2.bits$;
import org.http4s.blaze.http.http2.bits$Flags$;
import org.http4s.blaze.http.http2.bits$FrameTypes$;
import org.http4s.blaze.http.http2.bits$Masks$;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class FrameDecoder {
    private final Http2Settings localSettings;
    private final FrameListener listener;

    public static int getLengthField(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getLengthField(byteBuffer);
    }

    public static int getStreamId(ByteBuffer byteBuffer) {
        return FrameDecoder$.MODULE$.getStreamId(byteBuffer);
    }

    public static String hexStr(int n) {
        return FrameDecoder$.MODULE$.hexStr(n);
    }

    public FrameDecoder(Http2Settings localSettings, FrameListener listener) {
        this.localSettings = localSettings;
        this.listener = listener;
    }

    public final Result decodeBuffer(ByteBuffer buffer) {
        if (buffer.remaining() < bits$.MODULE$.HeaderSize()) {
            return BufferUnderflow$.MODULE$;
        }
        return this.doDecodeBuffer(buffer);
    }

    private Result doDecodeBuffer(ByteBuffer buffer) {
        Result result;
        block19: {
            buffer.mark();
            int len = FrameDecoder$.MODULE$.getLengthField(buffer);
            byte frameType = buffer.get();
            byte flags = buffer.get();
            int streamId = FrameDecoder$.MODULE$.getStreamId(buffer);
            if (this.localSettings.maxFrameSize() < len) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringBuilder(45).append("HTTP2 packet is too large to handle. Stream: ").append(streamId).toString()));
            }
            if (frameType != bits$FrameTypes$.MODULE$.CONTINUATION() && this.listener.inHeaderSequence()) {
                String msg = new StringBuilder(46).append("Received frame type ").append(FrameDecoder$.MODULE$.hexStr(frameType)).append(" while in HEADERS sequence").toString();
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
            }
            if (frameType == bits$FrameTypes$.MODULE$.CONTINUATION() && !this.listener.inHeaderSequence()) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received CONTINUATION frame outside of a HEADERS sequence"));
            }
            if (buffer.remaining() < len) {
                buffer.reset();
                return BufferUnderflow$.MODULE$;
            }
            int oldLimit = buffer.limit();
            int endOfFrame = buffer.position() + len;
            buffer.limit(endOfFrame);
            try {
                try {
                    byte by = frameType;
                    if (bits$FrameTypes$.MODULE$.DATA() == by) {
                        result = this.decodeDataFrame(buffer, streamId, flags);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.HEADERS() == by) {
                        result = this.decodeHeaderFrame(buffer, streamId, flags);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.PRIORITY() == by) {
                        result = this.decodePriorityFrame(buffer, streamId);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.RST_STREAM() == by) {
                        result = this.decodeRstStreamFrame(buffer, streamId);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.SETTINGS() == by) {
                        result = this.decodeSettingsFrame(buffer, streamId, flags);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.PUSH_PROMISE() == by) {
                        result = this.decodePushPromiseFrame(buffer, streamId, flags);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.PING() == by) {
                        result = this.decodePingFrame(buffer, streamId, flags);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.GOAWAY() == by) {
                        result = this.decodeGoAwayFrame(buffer, streamId);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.WINDOW_UPDATE() == by) {
                        result = this.decodeWindowUpdateFrame(buffer, streamId);
                        break block19;
                    }
                    if (bits$FrameTypes$.MODULE$.CONTINUATION() == by) {
                        result = this.decodeContinuationFrame(buffer, streamId, flags);
                        break block19;
                    }
                    byte code = by;
                    result = this.onExtensionFrame(code, streamId, flags, buffer.slice());
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    result = Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringBuilder(33).append("Frame type ").append(FrameDecoder$.MODULE$.hexStr(frameType)).append(" and size ").append(len).append(" underflowed").toString()));
                }
            }
            finally {
                buffer.limit(oldLimit);
                buffer.position(endOfFrame);
            }
        }
        return result;
    }

    public Result onExtensionFrame(byte code, int streamId, byte flags, ByteBuffer buffer) {
        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)code), (Object)BoxesRunTime.boxToInteger((int)streamId), (Object)BoxesRunTime.boxToByte((byte)flags), (Object)buffer);
        return Continue$.MODULE$;
    }

    private Result decodeDataFrame(ByteBuffer buffer, int streamId, byte flags) {
        Continue$ r;
        MaybeError maybeError;
        if (streamId == 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Data frame with stream id 0x0"));
        }
        int flowBytes = buffer.remaining();
        if (!bits$Flags$.MODULE$.PADDED(flags)) {
            maybeError = Continue$.MODULE$;
        } else {
            int padding = buffer.get() & 0xFF;
            maybeError = r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$limitPadding(padding, buffer);
        }
        if (!r.success()) {
            return r;
        }
        return this.listener.onDataFrame(streamId, bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice(), flowBytes);
    }

    private Result decodeHeaderFrame(ByteBuffer buffer, int streamId, byte flags) {
        if (streamId == 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Headers frame with stream id 0x0"));
        }
        int padding = !bits$Flags$.MODULE$.PADDED(flags) ? 0 : buffer.get() & 0xFF;
        Priority priority = !bits$Flags$.MODULE$.PRIORITY(flags) ? Priority$NoPriority$.MODULE$ : FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$getPriority(buffer);
        MaybeError r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$limitPadding(padding, buffer);
        if (!r.success()) {
            return r;
        }
        Priority priority2 = priority;
        if (priority2 instanceof Priority.Dependent) {
            Priority.Dependent dependent = Priority$Dependent$.MODULE$.unapply((Priority.Dependent)priority2);
            int n = dependent._1();
            boolean bl = dependent._2();
            int n2 = dependent._3();
            int dep = n;
            if (dep == streamId) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(36).append("Header stream id ").append(FrameDecoder$.MODULE$.hexStr(streamId)).append(" depends on itself.").toString()));
            }
        }
        return this.listener.onHeadersFrame(streamId, priority, bits$Flags$.MODULE$.END_HEADERS(flags), bits$Flags$.MODULE$.END_STREAM(flags), buffer.slice());
    }

    private Result decodePriorityFrame(ByteBuffer buffer, int streamId) {
        if (streamId == 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Priority frame with stream id 0x0"));
        }
        if (buffer.remaining() != 5) {
            String msg = new StringBuilder(49).append("Invalid PRIORITY frame size, required 5, received").append(buffer.remaining()).toString();
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().rst(streamId, msg));
        }
        Priority.Dependent priority = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$getPriority(buffer);
        if (priority.dependentStreamId() == streamId) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, "Priority frame depends on itself"));
        }
        return this.listener.onPriorityFrame(streamId, priority);
    }

    private Result decodeRstStreamFrame(ByteBuffer buffer, int streamId) {
        if (streamId == 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("RST_STREAM frame with stream id 0x0"));
        }
        if (buffer.remaining() != 4) {
            String msg = new StringBuilder(58).append("Invalid RST_STREAM frame size. Required 4 bytes, received ").append(buffer.remaining()).toString();
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        }
        long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
        return this.listener.onRstStreamFrame(streamId, code);
    }

    private Result decodeSettingsFrame(ByteBuffer buffer, int streamId, byte flags) {
        SettingsDecoder.SettingsFrame settingsFrame;
        Either<Http2Exception, SettingsDecoder.SettingsFrame> either = SettingsDecoder$.MODULE$.decodeSettingsFrame(buffer, streamId, flags);
        if (either instanceof Right && (settingsFrame = (SettingsDecoder.SettingsFrame)((Right)either).value()) != null) {
            Option<Seq<Http2Settings.Setting>> option;
            SettingsDecoder.SettingsFrame settingsFrame2 = SettingsDecoder$SettingsFrame$.MODULE$.unapply(settingsFrame);
            Option<Seq<Http2Settings.Setting>> settings = option = settingsFrame2._1();
            return this.listener.onSettingsFrame(settings);
        }
        if (either instanceof Left) {
            Http2Exception ex = (Http2Exception)((Left)either).value();
            return Error$.MODULE$.apply(ex);
        }
        throw new MatchError(either);
    }

    private Result decodePushPromiseFrame(ByteBuffer buffer, int streamId, byte flags) {
        if (streamId == 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with stream id 0x0"));
        }
        int padding = !bits$Flags$.MODULE$.PADDED(flags) ? 0 : buffer.get() & 0xFF;
        int promisedId = FrameDecoder$.MODULE$.getStreamId(buffer);
        if (promisedId == 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("PUSH_PROMISE frame with promised stream id 0x0"));
        }
        if (promisedId == streamId) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(59).append("PUSH_PROMISE frame with promised stream of the same stream ").append(FrameDecoder$.MODULE$.hexStr(streamId)).toString()));
        }
        MaybeError r = FrameDecoder$.MODULE$.org$http4s$blaze$http$http2$FrameDecoder$$$limitPadding(padding, buffer);
        if (!r.success()) {
            return r;
        }
        return this.listener.onPushPromiseFrame(streamId, promisedId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
    }

    private Result decodePingFrame(ByteBuffer buffer, int streamId, byte flags) {
        int PingSize = 8;
        if (streamId != 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(33).append("PING frame with stream id ").append(FrameDecoder$.MODULE$.hexStr(streamId)).append(" != 0x0").toString()));
        }
        if (buffer.remaining() != PingSize) {
            String msg = new StringBuilder(46).append("Invalid PING frame size. Expected 8, received ").append(buffer.remaining()).toString();
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(msg));
        }
        byte[] pingBytes = new byte[PingSize];
        buffer.get(pingBytes);
        return this.listener.onPingFrame(bits$Flags$.MODULE$.ACK(flags), pingBytes);
    }

    private Result decodeGoAwayFrame(ByteBuffer buffer, int streamId) {
        if (streamId != 0) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(36).append("GOAWAY frame with stream id ").append(FrameDecoder$.MODULE$.hexStr(streamId)).append(" != 0x0.").toString()));
        }
        int lastStream = bits$Flags$.MODULE$.DepID(buffer.getInt());
        long code = (long)buffer.getInt() & bits$Masks$.MODULE$.INT32();
        byte[] data = new byte[buffer.remaining()];
        buffer.get(data);
        return this.listener.onGoAwayFrame(lastStream, code, data);
    }

    private Result decodeWindowUpdateFrame(ByteBuffer buffer, int streamId) {
        if (buffer.remaining() != 4) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.FRAME_SIZE_ERROR().goaway(new StringBuilder(56).append("WindowUpdate with invalid frame size. Expected 4, found ").append(buffer.remaining()).toString()));
        }
        int size = buffer.getInt() & bits$Masks$.MODULE$.INT31();
        if (size != 0) {
            return this.listener.onWindowUpdateFrame(streamId, size);
        }
        String msg = "WINDOW_UPDATE with invalid update size 0";
        return Error$.MODULE$.apply(streamId == 0 ? Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg) : Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(streamId, msg));
    }

    private Result decodeContinuationFrame(ByteBuffer buffer, int streamId, byte flags) {
        if (streamId == 0) {
            String msg = "CONTINUATION frame with invalid stream dependency on 0x0";
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        }
        return this.listener.onContinuationFrame(streamId, bits$Flags$.MODULE$.END_HEADERS(flags), buffer.slice());
    }
}

