/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.FrameSerializer$;
import org.http4s.blaze.http.http2.HeaderAggregatingFrameListener;
import org.http4s.blaze.http.http2.HeaderDecoder;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException$;
import org.http4s.blaze.http.http2.Http2Settings;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.InboundStreamState;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.MutableHttp2Settings;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.StreamState;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class SessionFrameListener
extends HeaderAggregatingFrameListener {
    private final SessionCore session;
    private final boolean isClient;

    public SessionFrameListener(SessionCore session, boolean isClient, HeaderDecoder headerDecoder) {
        this.session = session;
        this.isClient = isClient;
        super(session.localSettings(), headerDecoder);
    }

    @Override
    public Result onCompleteHeadersFrame(int streamId, Priority priority, boolean endStream, Seq<Tuple2<String, String>> headers) {
        Option<StreamState> option = this.session.streamManager().get(streamId);
        if (option instanceof Some) {
            StreamState stream = (StreamState)((Some)option).value();
            return stream.invokeInboundHeaders(priority, endStream, headers);
        }
        if (None$.MODULE$.equals(option)) {
            Either<Http2Exception, InboundStreamState> either = this.session.streamManager().newInboundStream(streamId);
            if (either instanceof Left) {
                Http2Exception ex = (Http2Exception)((Left)either).value();
                return Error$.MODULE$.apply(ex);
            }
            if (either instanceof Right) {
                InboundStreamState is = (InboundStreamState)((Right)either).value();
                return is.invokeInboundHeaders(priority, endStream, headers);
            }
            throw new MatchError(either);
        }
        throw new MatchError(option);
    }

    @Override
    public Result onCompletePushPromiseFrame(int streamId, int promisedId, Seq<Tuple2<String, String>> headers) {
        if (!this.isClient) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(46).append("Server received PUSH_PROMISE frame for stream ").append(streamId).toString()));
        }
        if (!this.session.localSettings().pushEnabled()) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received PUSH_PROMISE frame then they are disallowed"));
        }
        return this.session.streamManager().handlePushPromise(streamId, promisedId, headers);
    }

    @Override
    public Result onDataFrame(int streamId, boolean isLast, ByteBuffer data, int flow) {
        Option<StreamState> option = this.session.streamManager().get(streamId);
        if (option instanceof Some) {
            StreamState stream = (StreamState)((Some)option).value();
            return stream.invokeInboundData(isLast, data, flow);
        }
        if (None$.MODULE$.equals(option)) {
            if (!this.session.sessionFlowControl().sessionInboundObserved(flow)) {
                String msg = new StringBuilder(48).append("data frame for inactive stream (id ").append(streamId).append(") overflowed ").append(new StringBuilder(28).append("session flow window. Size: ").append(flow).append(".").toString()).toString();
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.FLOW_CONTROL_ERROR().goaway(msg));
            }
            if (this.session.idManager().isIdleId(streamId)) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(31).append("DATA on uninitialized stream (").append(streamId).append(")").toString()));
            }
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.STREAM_CLOSED().rst(streamId));
        }
        throw new MatchError(option);
    }

    @Override
    public Result onPriorityFrame(int streamId, Priority.Dependent priority) {
        return Continue$.MODULE$;
    }

    @Override
    public Result onRstStreamFrame(int streamId, long code) {
        Http2StreamException ex = Http2Exception$.MODULE$.errorGenerator(code).rst(streamId);
        return this.session.streamManager().rstStream(ex);
    }

    @Override
    public Result onWindowUpdateFrame(int streamId, int sizeIncrement) {
        return this.session.streamManager().flowWindowUpdate(streamId, sizeIncrement);
    }

    @Override
    public Result onPingFrame(boolean ack, byte[] data) {
        Object object;
        if (!ack) {
            object = BoxesRunTime.boxToBoolean((boolean)this.session.writeController().write(this.session.http2Encoder().pingAck(data)));
        } else {
            this.session.pingManager().pingAckReceived(data);
            object = BoxedUnit.UNIT;
        }
        return Continue$.MODULE$;
    }

    @Override
    public Result onSettingsFrame(Option<scala.collection.immutable.Seq<Http2Settings.Setting>> settings) {
        Option<scala.collection.immutable.Seq<Http2Settings.Setting>> option = settings;
        if (None$.MODULE$.equals(option)) {
            return Continue$.MODULE$;
        }
        if (option instanceof Some) {
            Error result;
            MaybeError maybeError;
            scala.collection.immutable.Seq settings2 = (scala.collection.immutable.Seq)((Some)option).value();
            MutableHttp2Settings remoteSettings = this.session.remoteSettings();
            int initialInitialWindowSize = remoteSettings.initialWindowSize();
            int initialHeaderTableSize = remoteSettings.headerTableSize();
            Option<Http2Exception> option2 = remoteSettings.updateSettings((scala.collection.immutable.Seq<Http2Settings.Setting>)settings2);
            if (option2 instanceof Some) {
                Http2Exception ex = (Http2Exception)((Some)option2).value();
                maybeError = Error$.MODULE$.apply(ex);
            } else if (None$.MODULE$.equals(option2)) {
                int diff;
                if (remoteSettings.headerTableSize() != initialHeaderTableSize) {
                    this.session.http2Encoder().setMaxTableSize(remoteSettings.headerTableSize());
                }
                maybeError = (diff = remoteSettings.initialWindowSize() - initialInitialWindowSize) == 0 ? Continue$.MODULE$ : this.session.streamManager().initialFlowWindowChange(diff);
            } else {
                throw new MatchError(option2);
            }
            Error error = result = maybeError;
            Continue$ continue$ = Continue$.MODULE$;
            if (!(error != null ? !((Object)error).equals(continue$) : continue$ != null)) {
                this.session.writeController().write(FrameSerializer$.MODULE$.mkSettingsAckFrame());
            }
            return result;
        }
        throw new MatchError(option);
    }

    @Override
    public Result onGoAwayFrame(int lastStream, long errorCode, byte[] debugData) {
        String message = new String(debugData, StandardCharsets.UTF_8);
        this.session.invokeGoAway(lastStream, Http2SessionException$.MODULE$.apply(errorCode, message));
        return Continue$.MODULE$;
    }
}

