/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import scala.math.package$;

public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;
    private int markSize;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.markSize = -1;
    }

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            --this.markSize;
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        int readSize = package$.MODULE$.min(len, this.buffer.remaining());
        this.markSize -= readSize;
        this.buffer.get(b, off, readSize);
        return readSize;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void mark(int readlimit) {
        this.markSize = readlimit;
        this.buffer.mark();
    }

    @Override
    public void reset() {
        if (this.markSize >= 0) {
            this.markSize = -1;
            this.buffer.reset();
            return;
        }
        throw new IOException("Invalid mark");
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

