/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import java.io.Serializable;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.Http2Exception;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2SessionException;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.InboundStreamState;
import org.http4s.blaze.http.http2.InboundStreamStateImpl;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.http.http2.MaybeError$;
import org.http4s.blaze.http.http2.OutboundStreamState;
import org.http4s.blaze.http.http2.Result;
import org.http4s.blaze.http.http2.SessionCore;
import org.http4s.blaze.http.http2.StreamFlowWindow;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.http.http2.StreamManager;
import org.http4s.blaze.http.http2.StreamState;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class StreamManagerImpl
implements StreamManager {
    public final SessionCore org$http4s$blaze$http$http2$StreamManagerImpl$$session;
    private final Option<Function1<Object, LeafBuilder<StreamFrame>>> inboundStreamBuilder;
    private final Logger logger;
    public final HashMap<Object, StreamState> org$http4s$blaze$http$http2$StreamManagerImpl$$streams;
    public Option<Promise<BoxedUnit>> org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;

    public StreamManagerImpl(SessionCore session, Option<Function1<Object, LeafBuilder<StreamFrame>>> inboundStreamBuilder) {
        this.org$http4s$blaze$http$http2$StreamManagerImpl$$session = session;
        this.inboundStreamBuilder = inboundStreamBuilder;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.http.http2.StreamManagerImpl");
        this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams = new HashMap();
        this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP = None$.MODULE$;
    }

    @Override
    public int size() {
        return this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.size();
    }

    @Override
    public boolean isEmpty() {
        return this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.isEmpty();
    }

    @Override
    public MaybeError initialFlowWindowChange(int diff) {
        MaybeError result = Continue$.MODULE$;
        Iterator it = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.valuesIterator();
        while (it.hasNext()) {
            Continue$ continue$ = result;
            Continue$ continue$2 = Continue$.MODULE$;
            if (continue$ != null ? !continue$.equals(continue$2) : continue$2 != null) break;
            StreamState stream = (StreamState)it.next();
            Option<Http2Exception> option = stream.flowWindow().remoteSettingsInitialWindowChange(diff);
            if (None$.MODULE$.equals(option)) {
                stream.outboundFlowWindowChanged();
                continue;
            }
            if (option instanceof Some) {
                Http2Exception ex = (Http2Exception)((Some)option).value();
                result = Error$.MODULE$.apply(ex.toSessionException());
                continue;
            }
            throw new MatchError(option);
        }
        return result;
    }

    @Override
    public Option<StreamState> get(int id) {
        return this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.get((Object)BoxesRunTime.boxToInteger((int)id));
    }

    @Override
    public void forceClose(Option<Throwable> cause) {
        Vector ss = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.values().toVector();
        ss.foreach((Function1)(JProcedure1 & Serializable)stream -> {
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)stream.streamId()));
            stream.doCloseWithError(cause);
        });
        Option<Promise<BoxedUnit>> option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;
        if (option instanceof Some) {
            Promise p = (Promise)((Some)option).value();
            p.trySuccess((Object)BoxedUnit.UNIT);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            Promise p = Promise$.MODULE$.apply();
            p.trySuccess((Object)BoxedUnit.UNIT);
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP = Some$.MODULE$.apply((Object)p);
            return;
        }
        throw new MatchError(option);
    }

    @Override
    public Either<Http2Exception, InboundStreamState> newInboundStream(int streamId) {
        if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().observeInboundId(streamId)) {
            String msg = this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isOutboundId(streamId) ? new StringBuilder(51).append("Received HEADERS frame for idle outbound stream id ").append(streamId).toString() : new StringBuilder(54).append("Received HEADERS frame for non-idle inbound stream id ").append(streamId).toString();
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(msg));
        }
        if (this.inboundStreamBuilder.isEmpty()) {
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(70).append("Client received request for new inbound stream (").append(streamId).append(") without push promise").toString()));
        }
        if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP.isDefined()) {
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.REFUSED_STREAM().rst(streamId, "Session draining"));
        }
        if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.localSettings().maxConcurrentStreams() <= this.size()) {
            return package$.MODULE$.Left().apply((Object)Http2Exception$.MODULE$.REFUSED_STREAM().rst(streamId));
        }
        LeafBuilder leafBuilder = (LeafBuilder)((Function1)this.inboundStreamBuilder.get()).apply((Object)BoxesRunTime.boxToInteger((int)streamId));
        StreamFlowWindow streamFlowWindow = this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.sessionFlowControl().newStreamFlowWindow(streamId);
        InboundStreamStateImpl streamState = new InboundStreamStateImpl(this.org$http4s$blaze$http$http2$StreamManagerImpl$$session, streamId, streamFlowWindow);
        if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.put((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)streamState).isEmpty()) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        leafBuilder.base((HeadStage)streamState);
        streamState.sendInboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
        return package$.MODULE$.Right().apply((Object)streamState);
    }

    @Override
    public MaybeError rstStream(Http2StreamException cause) {
        Option option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)cause.stream()));
        if (option instanceof Some) {
            StreamState streamState = (StreamState)((Some)option).value();
            streamState.doCloseWithError((Option<Throwable>)Some$.MODULE$.apply((Object)cause));
            return Continue$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isIdleId(cause.stream())) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(30).append("RST_STREAM for idle stream id ").append(cause.stream()).toString()));
            }
            return Continue$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public boolean streamClosed(StreamState streamState) {
        boolean result;
        block1: {
            result = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)streamState.streamId())).isDefined();
            Option<Promise<BoxedUnit>> option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;
            if (!(option instanceof Some)) break block1;
            Promise p = (Promise)((Some)option).value();
            if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.isEmpty()) {
                p.trySuccess((Object)BoxedUnit.UNIT);
            }
        }
        return result;
    }

    @Override
    public Result handlePushPromise(int streamId, int promisedId, Seq<Tuple2<String, String>> headers) {
        block3: {
            if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isIdleOutboundId(streamId)) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(57).append("Received PUSH_PROMISE for associated to an idle stream (").append(streamId).append(")").toString()));
            }
            if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isInboundId(promisedId)) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(52).append("Received PUSH_PROMISE frame with illegal stream id: ").append(promisedId).toString()));
            }
            if (!this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().observeInboundId(promisedId)) {
                return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway("Received PUSH_PROMISE frame on non-idle stream"));
            }
            Logger Logger_this = this.logger;
            if (!Logger_this.isDebugEnabled()) break block3;
            Logger_this.debug(new StringBuilder(48).append("Rejecting pushed stream ").append(promisedId).append(" associated with stream ").append(streamId).toString());
        }
        return Error$.MODULE$.apply(Http2Exception$.MODULE$.REFUSED_STREAM().rst(promisedId, "Server push not supported"));
    }

    @Override
    public MaybeError flowWindowUpdate(int streamId, int sizeIncrement) {
        if (this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isIdleId(streamId)) {
            return Error$.MODULE$.apply(Http2Exception$.MODULE$.PROTOCOL_ERROR().goaway(new StringBuilder(40).append("WINDOW_UPDATE on uninitialized stream (").append(streamId).append(")").toString()));
        }
        if (streamId == 0) {
            MaybeError result = MaybeError$.MODULE$.apply(this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.sessionFlowControl().sessionOutboundAcked(sizeIncrement));
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(31).append("Session flow update: ").append(sizeIncrement).append(". Result: ").append(result).toString());
            }
            if (result.success()) {
                this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.values().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.outboundFlowWindowChanged());
            }
            return result;
        }
        Option option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.get((Object)BoxesRunTime.boxToInteger((int)streamId));
        if (None$.MODULE$.equals(option)) {
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(41).append("Stream WINDOW_UPDATE(").append(sizeIncrement).append(") for closed stream ").append(streamId).toString());
            }
            return Continue$.MODULE$;
        }
        if (option instanceof Some) {
            StreamState stream = (StreamState)((Some)option).value();
            MaybeError result = MaybeError$.MODULE$.apply(stream.flowWindow().streamOutboundAcked(sizeIncrement));
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(34).append("Stream(").append(stream.streamId()).append(") WINDOW_UPDATE(").append(sizeIncrement).append("). Result: ").append(result).toString());
            }
            if (result.success()) {
                stream.outboundFlowWindowChanged();
            }
            return result;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Future<BoxedUnit> drain(int lastHandledOutboundStream, Http2SessionException reason) {
        Option<Promise<BoxedUnit>> option = this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP;
        if (option instanceof Some) {
            Promise p = (Promise)((Some)option).value();
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(25).append("Received a second GOAWAY(").append(lastHandledOutboundStream).toString(), (Throwable)reason);
            }
            return p.future();
        }
        if (None$.MODULE$.equals(option)) {
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(22).append("StreamManager.goaway(").append(lastHandledOutboundStream).append(")").toString(), (Throwable)reason);
            }
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    int id = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    StreamState stream = (StreamState)tuple2._2();
                    if (lastHandledOutboundStream < id && this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().isOutboundId(id)) {
                        this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.remove((Object)BoxesRunTime.boxToInteger((int)id));
                        Http2StreamException ex = Http2Exception$.MODULE$.REFUSED_STREAM().rst(id, reason.msg());
                        stream.doCloseWithError((Option<Throwable>)Some$.MODULE$.apply((Object)ex));
                        return;
                    }
                }
            });
            Promise p = Promise$.MODULE$.apply();
            this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP = Some$.MODULE$.apply((Object)p);
            return p.future();
        }
        throw new MatchError(option);
    }

    @Override
    public OutboundStreamState newOutboundStream() {
        return new OutboundStreamStateImpl();
    }

    public class OutboundStreamStateImpl
    extends org.http4s.blaze.http.http2.OutboundStreamStateImpl {
        public OutboundStreamStateImpl() {
            if (StreamManagerImpl.this == null) {
                throw new NullPointerException();
            }
            super(StreamManagerImpl.this.org$http4s$blaze$http$http2$StreamManagerImpl$$session);
        }

        @Override
        public Option<Object> registerStream() {
            if (StreamManagerImpl.this.org$http4s$blaze$http$http2$StreamManagerImpl$$drainingP.isDefined()) {
                return None$.MODULE$;
            }
            Option<Object> option = StreamManagerImpl.this.org$http4s$blaze$http$http2$StreamManagerImpl$$session.idManager().takeOutboundId();
            if (option instanceof Some) {
                Some some = (Some)option;
                int freshId = BoxesRunTime.unboxToInt((Object)some.value());
                Some id = some;
                if (!StreamManagerImpl.this.org$http4s$blaze$http$http2$StreamManagerImpl$$streams.put((Object)BoxesRunTime.boxToInteger((int)freshId), (Object)this).isEmpty()) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                return id;
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError(option);
        }

        public final /* synthetic */ StreamManagerImpl org$http4s$blaze$http$http2$StreamManagerImpl$OutboundStreamStateImpl$$$outer() {
            return StreamManagerImpl.this;
        }
    }
}

