/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.effect.ConcurrentEffect;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.http4s.Uri;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.client.BlazeConnection;
import org.http4s.blaze.client.Http1Connection;
import org.http4s.blaze.client.ParserMode;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.client.ConnectionFailure;
import org.http4s.client.RequestKey;
import org.http4s.headers.User;
import org.http4s.internal.SSLContextOption;
import org.http4s.internal.SSLContextOption$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u000e\u001c\r\u0011B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011]\u0003!\u0011!Q\u0001\nQB\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\t3\u0002\u0011\t\u0011)A\u0005i!A!\f\u0001B\u0001B\u0003%A\u0007\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003]\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u0011=\u0004!\u0011!Q\u0001\nAD\u0001B\u001e\u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\to\u0002\u0011\t\u0011)A\u0005q\"Q\u00111\u0006\u0001\u0003\u0002\u0003\u0006Y!!\f\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\!I\u00111\u0011\u0001C\u0002\u0013%\u0011Q\u0011\u0005\t\u0003'\u0003\u0001\u0015!\u0003\u0002\b\"9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\t\t\u000f\u0001C\u0005\u0003GDq!a=\u0001\t\u0013\t)P\u0001\u0007IiR\u0004\u0018gU;qa>\u0014HO\u0003\u0002\u001d;\u000511\r\\5f]RT!AH\u0010\u0002\u000b\td\u0017M_3\u000b\u0005\u0001\n\u0013A\u00025uiB$4OC\u0001#\u0003\ry'oZ\u0002\u0001+\r)\u0013\u0011I\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017\u0001E:tY\u000e{g\u000e^3yi>\u0003H/[8o!\tq\u0013'D\u00010\u0015\t\u0001t$\u0001\u0005j]R,'O\\1m\u0013\t\u0011tF\u0001\tT'2\u001buN\u001c;fqR|\u0005\u000f^5p]\u0006Q!-\u001e4gKJ\u001c\u0016N_3\u0011\u0005\u001d*\u0014B\u0001\u001c)\u0005\rIe\u000e^\u0001\u0019CNLhn\u00195s_:|Wo]\"iC:tW\r\\$s_V\u0004\bcA\u0014:w%\u0011!\b\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005q\u001aU\"A\u001f\u000b\u0005yz\u0014\u0001C2iC:tW\r\\:\u000b\u0005\u0001\u000b\u0015a\u00018j_*\t!)\u0001\u0003kCZ\f\u0017B\u0001#>\u0005a\t5/\u001f8dQJ|gn\\;t\u0007\"\fgN\\3m\u000fJ|W\u000f]\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0015\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002L\u0011\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\ng\u000eDW\rZ;mKJ\u0004\"AT)\u000e\u0003=S!\u0001U\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003%>\u0013\u0011\u0003V5dW^CW-\u001a7Fq\u0016\u001cW\u000f^8s\u0003m\u0019\u0007.Z2l\u000b:$\u0007o\\5oi&#WM\u001c;jM&\u001c\u0017\r^5p]B\u0011q%V\u0005\u0003-\"\u0012qAQ8pY\u0016\fg.A\nnCb\u0014Vm\u001d9p]N,G*\u001b8f'&TX-A\bnCbDU-\u00193fe2+gn\u001a;i\u00031i\u0017\r_\"ik:\\7+\u001b>f\u0003I\u0019\u0007.\u001e8l\u0005V4g-\u001a:NCb\u001c\u0016N_3\u0002\u0015A\f'o]3s\u001b>$W\r\u0005\u0002^=6\t1$\u0003\u0002`7\tQ\u0001+\u0019:tKJlu\u000eZ3\u0002\u0013U\u001cXM]!hK:$\bcA\u0014:EB\u00111MZ\u0007\u0002I*\u0011QmH\u0001\bQ\u0016\fG-\u001a:t\u0013\t9GMA\bVg\u0016\u0014H%\\5okN\fu-\u001a8u\u00039\u0019\u0007.\u00198oK2|\u0005\u000f^5p]N\u0004\"A[7\u000e\u0003-T!\u0001\\\u000f\u0002\u000f\rD\u0017M\u001c8fY&\u0011an\u001b\u0002\u000f\u0007\"\fgN\\3m\u001fB$\u0018n\u001c8t\u00039\u0019wN\u001c8fGR$\u0016.\\3pkR\u0004\"!\u001d;\u000e\u0003IT!a\u001d%\u0002\u0011\u0011,(/\u0019;j_:L!!\u001e:\u0003\u0011\u0011+(/\u0019;j_:\f1\"\u001b3mKRKW.Z8vi\u0006Qq-\u001a;BI\u0012\u0014Xm]:\u0011\u000b\u001dJ80!\u0001\n\u0005iD#!\u0003$v]\u000e$\u0018n\u001c82!\tah0D\u0001~\u0015\tar$\u0003\u0002\u0000{\nQ!+Z9vKN$8*Z=\u0011\u0011\u0005\r\u00111CA\r\u0003?qA!!\u0002\u0002\u00109!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\r\na\u0001\u0010:p_Rt\u0014\"A\u0015\n\u0007\u0005E\u0001&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0011q\u0003\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005E\u0001\u0006\u0005\u0003\u0002\u0004\u0005m\u0011\u0002BA\u000f\u0003/\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nB\u0003\rqW\r^\u0005\u0005\u0003S\t\u0019CA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\f\u0011A\u0012\t\u0007\u0003_\tI$!\u0010\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\ta!\u001a4gK\u000e$(BAA\u001c\u0003\u0011\u0019\u0017\r^:\n\t\u0005m\u0012\u0011\u0007\u0002\u0011\u0007>t7-\u001e:sK:$XI\u001a4fGR\u0004B!a\u0010\u0002B1\u0001AaBA\"\u0001\t\u0007\u0011Q\t\u0002\u0002\rV!\u0011qIA+#\u0011\tI%a\u0014\u0011\u0007\u001d\nY%C\u0002\u0002N!\u0012qAT8uQ&tw\rE\u0002(\u0003#J1!a\u0015)\u0005\r\te.\u001f\u0003\t\u0003/\n\tE1\u0001\u0002H\t\tq,\u0001\u0004=S:LGO\u0010\u000b#\u0003;\n\u0019'!\u001a\u0002h\u0005%\u00141NA7\u0003_\n\t(a\u001d\u0002v\u0005]\u0014\u0011PA>\u0003{\ny(!!\u0015\t\u0005}\u0013\u0011\r\t\u0005;\u0002\ti\u0004C\u0004\u0002,I\u0001\u001d!!\f\t\u000b1\u0012\u0002\u0019A\u0017\t\u000bM\u0012\u0002\u0019\u0001\u001b\t\u000b]\u0012\u0002\u0019\u0001\u001d\t\u000b\u0015\u0013\u0002\u0019\u0001$\t\u000b1\u0013\u0002\u0019A'\t\u000bM\u0013\u0002\u0019\u0001+\t\u000b]\u0013\u0002\u0019\u0001\u001b\t\u000ba\u0013\u0002\u0019\u0001\u001b\t\u000be\u0013\u0002\u0019\u0001\u001b\t\u000bi\u0013\u0002\u0019\u0001\u001b\t\u000bm\u0013\u0002\u0019\u0001/\t\u000b\u0001\u0014\u0002\u0019A1\t\u000b!\u0014\u0002\u0019A5\t\u000b=\u0014\u0002\u0019\u00019\t\u000bY\u0014\u0002\u0019\u00019\t\u000b]\u0014\u0002\u0019\u0001=\u0002#\r|gN\\3di&|g.T1oC\u001e,'/\u0006\u0002\u0002\bB!\u0011\u0011RAH\u001b\t\tYIC\u0002\u0002\u000e.\fAA\\5pe%!\u0011\u0011SAF\u0005Q\u0019E.[3oi\u000eC\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0006\u00112m\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:!\u0003)i\u0017m[3DY&,g\u000e\u001e\u000b\u0005\u00033\u000b\t\u000b\u0005\u0004\u0002@\u0005\u0005\u00131\u0014\t\u0006;\u0006u\u0015QH\u0005\u0004\u0003?[\"a\u0004\"mCj,7i\u001c8oK\u000e$\u0018n\u001c8\t\r\u0005\rV\u00031\u0001|\u0003)\u0011X-];fgR\\U-_\u0001\u000eEVLG\u000e\u001a)ja\u0016d\u0017N\\3\u0015\r\u0005%\u0016qVAY!\u00159\u00151VAN\u0013\r\ti\u000b\u0013\u0002\u0007\rV$XO]3\t\r\u0005\rf\u00031\u0001|\u0011\u001d\t\u0019L\u0006a\u0001\u0003?\tA!\u00193ee\u0006Y!-^5mIN#\u0018mZ3t)\u0019\tI,a2\u0002JBA\u00111AA\n\u0003w\u000bY\n\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\t-Q\u0001\u0005Y\u0006tw-\u0003\u0003\u0002F\u0006}&!F%mY\u0016<\u0017\r\\*uCR,W\t_2faRLwN\u001c\u0005\u0007\u0003G;\u0002\u0019A>\t\u000f\u0005-w\u00031\u0001\u0002N\u0006!\u0001.Z1e!\u0019\ty-!6\u0002Z6\u0011\u0011\u0011\u001b\u0006\u0004\u0003'l\u0012\u0001\u00039ja\u0016d\u0017N\\3\n\t\u0005]\u0017\u0011\u001b\u0002\n\u0011\u0016\fGm\u0015;bO\u0016\u0004B!a7\u0002^6\tq(C\u0002\u0002`~\u0012!BQ=uK\n+hMZ3s\u0003Qi\u0017m[3JI2,G+[7f_V$8\u000b^1hKR\u0011\u0011Q\u001d\t\u0005Oe\n9\u000f\u0005\u0004\u0002j\u0006=\u0018\u0011\\\u0007\u0003\u0003WT1!!< \u0003%\u0011G.\u0019>fG>\u0014X-\u0003\u0003\u0002r\u0006-(\u0001E%eY\u0016$\u0016.\\3pkR\u001cF/Y4f\u00031i\u0017m[3Tg2\u001cF/Y4f)\u0011\t9Pa\u0002\u0011\u0011\u0005\r\u00111CA^\u0003s\u0004BaJ\u001d\u0002|B!\u0011Q B\u0002\u001b\t\tyP\u0003\u0003\u0003\u0002\u0005E\u0017AB:uC\u001e,7/\u0003\u0003\u0003\u0006\u0005}(\u0001C*T\u0019N#\u0018mZ3\t\r\u0005\r\u0016\u00041\u0001|\u0001")
public final class Http1Support<F> {
    private final SSLContextOption sslContextOption;
    private final ExecutionContext executionContext;
    private final TickWheelExecutor scheduler;
    private final boolean checkEndpointIdentification;
    private final int maxResponseLineSize;
    private final int maxHeaderLength;
    private final int maxChunkSize;
    private final int chunkBufferMaxSize;
    private final ParserMode parserMode;
    private final Option<User.minusAgent> userAgent;
    private final Duration idleTimeout;
    private final Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress;
    private final ConcurrentEffect<F> F;
    private final ClientChannelFactory connectionManager;

    private ClientChannelFactory connectionManager() {
        return this.connectionManager;
    }

    public F makeClient(RequestKey requestKey) {
        Object object;
        Either either = (Either)this.getAddress.apply((Object)requestKey);
        if (either instanceof Right) {
            Right right = (Right)either;
            InetSocketAddress a = (InetSocketAddress)right.value();
            object = org.http4s.blazecore.util.package$.MODULE$.fromFutureNoShift(this.F.delay((Function0 & Serializable)() -> this.buildPipeline(requestKey, a)), this.F);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            object = this.F.raiseError((Object)t);
        } else {
            throw new MatchError((Object)either);
        }
        return (F)object;
    }

    private Future<BlazeConnection<F>> buildPipeline(RequestKey requestKey, InetSocketAddress addr) {
        return this.connectionManager().connect((SocketAddress)addr, this.connectionManager().connect$default$2()).transformWith((Function1 & Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Future future2;
                Success success = (Success)try_;
                HeadStage head = (HeadStage)success.value();
                Either either = this.buildStages(requestKey, (HeadStage<ByteBuffer>)head);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    BlazeConnection connection = (BlazeConnection)right.value();
                    head.inboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
                    future2 = Future$.MODULE$.successful((Object)connection);
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    IllegalStateException e = (IllegalStateException)left.value();
                    future2 = Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, (Throwable)e));
                } else {
                    throw new MatchError(either);
                }
                future = future2;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                future = Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, e));
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, this.executionContext);
    }

    private Either<IllegalStateException, BlazeConnection<F>> buildStages(RequestKey requestKey, HeadStage<ByteBuffer> head) {
        Option<IdleTimeoutStage<ByteBuffer>> idleTimeoutStage = this.makeIdleTimeoutStage();
        Either<IllegalStateException, Option<SSLStage>> ssl = this.makeSslStage(requestKey);
        Http1Connection connection = new Http1Connection(requestKey, this.executionContext, this.maxResponseLineSize, this.maxHeaderLength, this.maxChunkSize, this.chunkBufferMaxSize, this.parserMode, this.userAgent, idleTimeoutStage, this.F);
        return ssl.map((Function1 & Serializable)sslStage -> {
            LeafBuilder builder1 = LeafBuilder$.MODULE$.apply((TailStage)connection);
            LeafBuilder builder2 = (LeafBuilder)idleTimeoutStage.fold((Function0 & Serializable)() -> builder1, (Function1 & Serializable)x$1 -> builder1.prepend((MidStage)x$1));
            LeafBuilder builder3 = (LeafBuilder)sslStage.fold((Function0 & Serializable)() -> builder2, (Function1 & Serializable)x$2 -> builder2.prepend((MidStage)x$2));
            builder3.base(head);
            return connection;
        });
    }

    private Option<IdleTimeoutStage<ByteBuffer>> makeIdleTimeoutStage() {
        None$ none$;
        Duration duration = this.idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            none$ = new Some((Object)new IdleTimeoutStage(finiteDuration, this.scheduler, this.executionContext));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<IllegalStateException, Option<SSLStage>> makeSslStage(RequestKey requestKey) {
        Left left;
        Option maybeSSLContext;
        Option option;
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        Uri.Scheme scheme = requestKey2.scheme();
        Uri.Authority auth = requestKey2.authority();
        Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
        Uri.Scheme scheme3 = scheme;
        if (scheme2 == null) {
            if (scheme3 != null) {
                return package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
        } else if (!scheme2.equals(scheme3)) return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        if ((option = (maybeSSLContext = SSLContextOption$.MODULE$.toMaybeSSLContext(this.sslContextOption))) instanceof Some) {
            Some some = (Some)option;
            SSLContext sslContext = (SSLContext)some.value();
            SSLEngine eng = sslContext.createSSLEngine(auth.host().value(), BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 443)));
            eng.setUseClientMode(true);
            if (this.checkEndpointIdentification) {
                SSLParameters sslParams = eng.getSSLParameters();
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                eng.setSSLParameters(sslParams);
            }
            left = package$.MODULE$.Right().apply((Object)new Some((Object)new SSLStage(eng, SSLStage$.MODULE$.$lessinit$greater$default$2())));
            return left;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            left = package$.MODULE$.Left().apply((Object)new IllegalStateException("No SSLContext configured for this client. Try `withSslContext` on the `BlazeClientBuilder`, or do not make https calls."));
        }
        return left;
    }

    public Http1Support(SSLContextOption sslContextOption, int bufferSize, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ExecutionContext executionContext, TickWheelExecutor scheduler, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, Option<User.minusAgent> userAgent, ChannelOptions channelOptions, Duration connectTimeout, Duration idleTimeout, Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress, ConcurrentEffect<F> F) {
        this.sslContextOption = sslContextOption;
        this.executionContext = executionContext;
        this.scheduler = scheduler;
        this.checkEndpointIdentification = checkEndpointIdentification;
        this.maxResponseLineSize = maxResponseLineSize;
        this.maxHeaderLength = maxHeaderLength;
        this.maxChunkSize = maxChunkSize;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.parserMode = parserMode;
        this.userAgent = userAgent;
        this.idleTimeout = idleTimeout;
        this.getAddress = getAddress;
        this.F = F;
        this.connectionManager = new ClientChannelFactory(bufferSize, asynchronousChannelGroup, channelOptions, scheduler, connectTimeout);
    }
}

