/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import cats.syntax.package;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.http4s.Uri;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.client.BlazeConnection;
import org.http4s.blaze.client.Http1Connection;
import org.http4s.blaze.client.ParserMode;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.ExecutionContextConfig;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.client.ConnectionFailure;
import org.http4s.client.RequestKey;
import org.http4s.headers.User;
import org.http4s.internal.SSLContextOption;
import org.http4s.internal.SSLContextOption$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t5b\u0001B\u000e\u001d\r\u0015B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011a\u0003!\u0011!Q\u0001\nUB\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t5\u0002\u0011\t\u0011)A\u0005k!A1\f\u0001B\u0001B\u0003%Q\u0007\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011A\u0004!\u0011!Q\u0001\nED\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Q\u0011q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005\r\u0004A!A!\u0002\u0017\t)\u0007C\u0004\u0002r\u0001!\t!a\u001d\t\u0013\u0005u\u0005A1A\u0005\n\u0005}\u0005\u0002CAW\u0001\u0001\u0006I!!)\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u0011\u001d\u00119\u0002\u0001C\u0005\u00053\u0011A\u0002\u0013;uaF\u001aV\u000f\u001d9peRT!!\b\u0010\u0002\r\rd\u0017.\u001a8u\u0015\ty\u0002%A\u0003cY\u0006TXM\u0003\u0002\"E\u00051\u0001\u000e\u001e;qiMT\u0011aI\u0001\u0004_J<7\u0001A\u000b\u0004M\u0005=1C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006\u00012o\u001d7D_:$X\r\u001f;PaRLwN\u001c\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003gA\u0012\u0001cU*M\u0007>tG/\u001a=u\u001fB$\u0018n\u001c8\u0002\u0015\t,hMZ3s'&TX\r\u0005\u0002)m%\u0011q'\u000b\u0002\u0004\u0013:$\u0018\u0001G1ts:\u001c\u0007N]8o_V\u001c8\t[1o]\u0016dwI]8vaB\u0019\u0001F\u000f\u001f\n\u0005mJ#AB(qi&|g\u000e\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006A1\r[1o]\u0016d7O\u0003\u0002B\u0005\u0006\u0019a.[8\u000b\u0003\r\u000bAA[1wC&\u0011QI\u0010\u0002\u0019\u0003NLhn\u00195s_:|Wo]\"iC:tW\r\\$s_V\u0004\u0018AF3yK\u000e,H/[8o\u0007>tG/\u001a=u\u0007>tg-[4\u0011\u0005![U\"A%\u000b\u0005)\u0003\u0013!\u00032mCj,7m\u001c:f\u0013\ta\u0015J\u0001\fFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u000e{gNZ5h\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002P%6\t\u0001K\u0003\u0002R=\u0005!Q\u000f^5m\u0013\t\u0019\u0006KA\tUS\u000e\\w\u000b[3fY\u0016CXmY;u_J\f1d\u00195fG.,e\u000e\u001a9pS:$\u0018\nZ3oi&4\u0017nY1uS>t\u0007C\u0001\u0015W\u0013\t9\u0016FA\u0004C_>dW-\u00198\u0002'5\f\u0007PU3ta>t7/\u001a'j]\u0016\u001c\u0016N_3\u0002\u001f5\f\u0007\u0010S3bI\u0016\u0014H*\u001a8hi\"\fA\"\\1y\u0007\",hn[*ju\u0016\f!c\u00195v].\u0014UO\u001a4fe6\u000b\u0007pU5{K\u0006Q\u0001/\u0019:tKJlu\u000eZ3\u0011\u0005y{V\"\u0001\u000f\n\u0005\u0001d\"A\u0003)beN,'/T8eK\u0006IQo]3s\u0003\u001e,g\u000e\u001e\t\u0004Qi\u001a\u0007C\u00013h\u001b\u0005)'B\u00014!\u0003\u001dAW-\u00193feNL!\u0001[3\u0003\u001fU\u001bXM\u001d\u0013nS:,8/Q4f]R\fab\u00195b]:,Gn\u00149uS>t7\u000f\u0005\u0002l]6\tAN\u0003\u0002n=\u000591\r[1o]\u0016d\u0017BA8m\u00059\u0019\u0005.\u00198oK2|\u0005\u000f^5p]N\fabY8o]\u0016\u001cG\u000fV5nK>,H\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006AA-\u001e:bi&|gN\u0003\u0002wS\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005a\u001c(\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u0017%$G.\u001a+j[\u0016|W\u000f^\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014\b#\u0002?\u0002\b\u0005-Q\"A?\u000b\u0005y|\u0018aA:uI*!\u0011\u0011AA\u0002\u0003\u0019)gMZ3di*\u0011\u0011QA\u0001\u0005G\u0006$8/C\u0002\u0002\nu\u0014!\u0002R5ta\u0006$8\r[3s!\u0011\ti!a\u0004\r\u0001\u00119\u0011\u0011\u0003\u0001C\u0002\u0005M!!\u0001$\u0016\t\u0005U\u00111E\t\u0005\u0003/\ti\u0002E\u0002)\u00033I1!a\u0007*\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001KA\u0010\u0013\r\t\t#\u000b\u0002\u0004\u0003:LH\u0001CA\u0013\u0003\u001f\u0011\r!!\u0006\u0003\t}#C%M\u0001\u000bO\u0016$\u0018\t\u001a3sKN\u001c\bc\u0002\u0015\u0002,\u0005=\u0012\u0011H\u0005\u0004\u0003[I#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t\t$!\u000e\u000e\u0005\u0005M\"BA\u000f!\u0013\u0011\t9$a\r\u0003\u0015I+\u0017/^3ti.+\u0017\u0010\u0005\u0005\u0002<\u0005-\u0013\u0011KA,\u001d\u0011\ti$a\u0012\u000f\t\u0005}\u0012QI\u0007\u0003\u0003\u0003R1!a\u0011%\u0003\u0019a$o\\8u}%\t!&C\u0002\u0002J%\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002N\u0005=#AB#ji\",'OC\u0002\u0002J%\u0002B!a\u000f\u0002T%!\u0011QKA(\u0005%!\u0006N]8xC\ndW\r\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\tiFQ\u0001\u0004]\u0016$\u0018\u0002BA1\u00037\u0012\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003\u00051\u0005CBA4\u0003[\nY!\u0004\u0002\u0002j)\u0019\u00111N@\u0002\r-,'O\\3m\u0013\u0011\ty'!\u001b\u0003\u000b\u0005\u001b\u0018P\\2\u0002\rqJg.\u001b;?)\u0011\n)(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u000b9)!#\u0002\f\u00065\u0015qRAI\u0003'\u000b)*a&\u0002\u001a\u0006mE\u0003BA<\u0003s\u0002BA\u0018\u0001\u0002\f!9\u00111M\nA\u0004\u0005\u0015\u0004\"B\u0017\u0014\u0001\u0004q\u0003\"\u0002\u001b\u0014\u0001\u0004)\u0004\"\u0002\u001d\u0014\u0001\u0004I\u0004\"\u0002$\u0014\u0001\u00049\u0005\"B'\u0014\u0001\u0004q\u0005\"\u0002+\u0014\u0001\u0004)\u0006\"\u0002-\u0014\u0001\u0004)\u0004\"B-\u0014\u0001\u0004)\u0004\"\u0002.\u0014\u0001\u0004)\u0004\"B.\u0014\u0001\u0004)\u0004\"\u0002/\u0014\u0001\u0004i\u0006\"B1\u0014\u0001\u0004\u0011\u0007\"B5\u0014\u0001\u0004Q\u0007\"\u00029\u0014\u0001\u0004\t\b\"B=\u0014\u0001\u0004\t\b\"\u0002>\u0014\u0001\u0004Y\bbBA\u0014'\u0001\u0007\u0011\u0011F\u0001\u0012G>tg.Z2uS>tW*\u00198bO\u0016\u0014XCAAQ!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATY\u0006!a.[83\u0013\u0011\tY+!*\u0003)\rc\u0017.\u001a8u\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z\u0003I\u0019wN\u001c8fGRLwN\\'b]\u0006<WM\u001d\u0011\u0002\u00155\f7.Z\"mS\u0016tG\u000f\u0006\u0003\u00024\u0006m\u0006CBA\u0007\u0003\u001f\t)\fE\u0003_\u0003o\u000bY!C\u0002\u0002:r\u0011qB\u00117bu\u0016\u001cuN\u001c8fGRLwN\u001c\u0005\b\u0003{3\u0002\u0019AA\u0018\u0003)\u0011X-];fgR\\U-_\u0001\u000eEVLG\u000e\u001a)ja\u0016d\u0017N\\3\u0015\u0011\u0005\r\u00171ZAg\u0003#\u0004b!!2\u0002H\u0006UV\"A;\n\u0007\u0005%WO\u0001\u0004GkR,(/\u001a\u0005\b\u0003{;\u0002\u0019AA\u0018\u0011\u001d\tym\u0006a\u0001\u0003/\nA!\u00193ee\"9\u00111[\fA\u0002\u0005U\u0017\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\u0011\t)-a6\n\u0007\u0005eWO\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006Y!-^5mIN#\u0018mZ3t)!\ty.!<\u0002p\n\u001d\u0001\u0003CA\u001e\u0003\u0017\n\t/!.\u0011\t\u0005\r\u0018\u0011^\u0007\u0003\u0003KT1!a:C\u0003\u0011a\u0017M\\4\n\t\u0005-\u0018Q\u001d\u0002\u0016\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o\u0011\u001d\ti\f\u0007a\u0001\u0003_Aq!!=\u0019\u0001\u0004\t\u00190\u0001\u0003iK\u0006$\u0007CBA{\u0003w\fy0\u0004\u0002\u0002x*\u0019\u0011\u0011 \u0010\u0002\u0011AL\u0007/\u001a7j]\u0016LA!!@\u0002x\nI\u0001*Z1e'R\fw-\u001a\t\u0005\u0005\u0003\u0011\u0019!D\u0001A\u0013\r\u0011)\u0001\u0011\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBAj1\u0001\u0007\u0011Q[\u0001\u0015[\u0006\\W-\u00133mKRKW.Z8viN#\u0018mZ3\u0015\t\t5!Q\u0003\t\u0005Qi\u0012y\u0001E\u0003I\u0005#\ty0C\u0002\u0003\u0014%\u0013\u0001#\u00133mKRKW.Z8viN#\u0018mZ3\t\u000f\u0005M\u0017\u00041\u0001\u0002V\u0006aQ.Y6f'Nd7\u000b^1hKR!!1\u0004B\u0016!!\tY$a\u0013\u0002b\nu\u0001\u0003\u0002\u0015;\u0005?\u0001BA!\t\u0003(5\u0011!1\u0005\u0006\u0005\u0005K\t90\u0001\u0004ti\u0006<Wm]\u0005\u0005\u0005S\u0011\u0019C\u0001\u0005T'2\u001bF/Y4f\u0011\u001d\tiL\u0007a\u0001\u0003_\u0001")
public final class Http1Support<F> {
    private final SSLContextOption sslContextOption;
    private final ExecutionContextConfig executionContextConfig;
    private final TickWheelExecutor scheduler;
    private final boolean checkEndpointIdentification;
    private final int maxResponseLineSize;
    private final int maxHeaderLength;
    private final int maxChunkSize;
    private final int chunkBufferMaxSize;
    private final ParserMode parserMode;
    private final Option<User.minusAgent> userAgent;
    private final Duration idleTimeout;
    private final Dispatcher<F> dispatcher;
    private final Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress;
    private final Async<F> F;
    private final ClientChannelFactory connectionManager;

    private ClientChannelFactory connectionManager() {
        return this.connectionManager;
    }

    public F makeClient(RequestKey requestKey) {
        Either either = (Either)this.getAddress.apply((Object)requestKey);
        if (either instanceof Right) {
            Right right = (Right)either;
            InetSocketAddress a = (InetSocketAddress)right.value();
            return (F)org.http4s.blazecore.util.package$.MODULE$.fromFutureNoShift(package.all$.MODULE$.toFlatMapOps(this.executionContextConfig.getExecutionContext(this.F), this.F).flatMap((Function1 & Serializable)ec -> $this.F.delay((Function0 & Serializable)() -> this.buildPipeline(requestKey, a, (ExecutionContext)ec))), this.F);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            return (F)this.F.raiseError((Object)t);
        }
        throw new MatchError((Object)either);
    }

    private Future<BlazeConnection<F>> buildPipeline(RequestKey requestKey, InetSocketAddress addr, ExecutionContext executionContext) {
        return this.connectionManager().connect((SocketAddress)addr, this.connectionManager().connect$default$2()).transformWith((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                HeadStage head = (HeadStage)success.value();
                Either either = this.buildStages(requestKey, (HeadStage<ByteBuffer>)head, executionContext);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    BlazeConnection connection = (BlazeConnection)right.value();
                    head.inboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
                    return Future$.MODULE$.successful((Object)connection);
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    IllegalStateException e = (IllegalStateException)left.value();
                    return Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, (Throwable)e));
                }
                throw new MatchError(either);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                return Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, e));
            }
            throw new MatchError((Object)try_);
        }, executionContext);
    }

    private Either<IllegalStateException, BlazeConnection<F>> buildStages(RequestKey requestKey, HeadStage<ByteBuffer> head, ExecutionContext executionContext) {
        Option<IdleTimeoutStage<ByteBuffer>> idleTimeoutStage = this.makeIdleTimeoutStage(executionContext);
        Either<IllegalStateException, Option<SSLStage>> ssl = this.makeSslStage(requestKey);
        Http1Connection connection = new Http1Connection(requestKey, executionContext, this.maxResponseLineSize, this.maxHeaderLength, this.maxChunkSize, this.chunkBufferMaxSize, this.parserMode, this.userAgent, idleTimeoutStage, this.dispatcher, this.F);
        return ssl.map((Function1 & Serializable)sslStage -> {
            LeafBuilder builder1 = LeafBuilder$.MODULE$.apply((TailStage)connection);
            LeafBuilder builder2 = (LeafBuilder)idleTimeoutStage.fold((Function0 & Serializable)() -> builder1, (Function1 & Serializable)x$1 -> builder1.prepend((MidStage)x$1));
            LeafBuilder builder3 = (LeafBuilder)sslStage.fold((Function0 & Serializable)() -> builder2, (Function1 & Serializable)x$2 -> builder2.prepend((MidStage)x$2));
            builder3.base(head);
            return connection;
        });
    }

    private Option<IdleTimeoutStage<ByteBuffer>> makeIdleTimeoutStage(ExecutionContext executionContext) {
        Duration duration = this.idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            return new Some((Object)new IdleTimeoutStage(finiteDuration, this.scheduler, executionContext));
        }
        return None$.MODULE$;
    }

    private Either<IllegalStateException, Option<SSLStage>> makeSslStage(RequestKey requestKey) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 != null) {
            Uri.Scheme scheme = requestKey2.scheme();
            Uri.Authority auth = requestKey2.authority();
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            Uri.Scheme scheme3 = scheme;
            if (!(scheme2 != null ? !scheme2.equals(scheme3) : scheme3 != null)) {
                Option maybeSSLContext = SSLContextOption$.MODULE$.toMaybeSSLContext(this.sslContextOption);
                Option option = maybeSSLContext;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SSLContext sslContext = (SSLContext)some.value();
                    SSLEngine eng = sslContext.createSSLEngine(auth.host().value(), BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 443)));
                    eng.setUseClientMode(true);
                    if (this.checkEndpointIdentification) {
                        SSLParameters sslParams = eng.getSSLParameters();
                        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                        eng.setSSLParameters(sslParams);
                    }
                    return package$.MODULE$.Right().apply((Object)new Some((Object)new SSLStage(eng, SSLStage$.MODULE$.$lessinit$greater$default$2())));
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply((Object)new IllegalStateException("No SSLContext configured for this client. Try `withSslContext` on the `BlazeClientBuilder`, or do not make https calls."));
                }
                throw new MatchError((Object)option);
            }
        }
        return package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }

    public Http1Support(SSLContextOption sslContextOption, int bufferSize, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ExecutionContextConfig executionContextConfig, TickWheelExecutor scheduler, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, Option<User.minusAgent> userAgent, ChannelOptions channelOptions, Duration connectTimeout, Duration idleTimeout, Dispatcher<F> dispatcher, Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress, Async<F> F) {
        this.sslContextOption = sslContextOption;
        this.executionContextConfig = executionContextConfig;
        this.scheduler = scheduler;
        this.checkEndpointIdentification = checkEndpointIdentification;
        this.maxResponseLineSize = maxResponseLineSize;
        this.maxHeaderLength = maxHeaderLength;
        this.maxChunkSize = maxChunkSize;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.parserMode = parserMode;
        this.userAgent = userAgent;
        this.idleTimeout = idleTimeout;
        this.dispatcher = dispatcher;
        this.getAddress = getAddress;
        this.F = F;
        this.connectionManager = new ClientChannelFactory(bufferSize, asynchronousChannelGroup, channelOptions, scheduler, connectTimeout);
    }
}

