/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.blaze;

import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Bracket;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.ExitCase;
import cats.effect.Fiber;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.concurrent.Deferred$;
import cats.effect.implicits.package$;
import cats.effect.syntax.BracketOps$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ConnectException;
import java.util.concurrent.TimeoutException;
import org.http4s.Request;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.blazecore.ResponseHeaderTimeoutStage;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.Connection;
import org.http4s.client.ConnectionManager;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.client.blaze.BlazeClientConfig;
import org.http4s.client.blaze.BlazeConnection;
import org.http4s.client.blaze.bits$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class BlazeClient$ {
    public static final BlazeClient$ MODULE$ = new BlazeClient$();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.http4s.client.blaze.BlazeClient");

    public <F, A extends BlazeConnection<F>> Client<F> apply(ConnectionManager<F, A> manager, BlazeClientConfig config, F onShutdown, ExecutionContext ec, ConcurrentEffect<F> F) {
        return this.makeClient(manager, config.responseHeaderTimeout(), config.idleTimeout(), config.requestTimeout(), bits$.MODULE$.ClientTickWheel(), ec, F);
    }

    public <F, A extends BlazeConnection<F>> Client<F> makeClient(ConnectionManager<F, A> manager, Duration responseHeaderTimeout, Duration idleTimeout, Duration requestTimeout, TickWheelExecutor scheduler, ExecutionContext ec, ConcurrentEffect<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> {
            Object object;
            RequestKey key = RequestKey$.MODULE$.fromRequest(req);
            Object res = BlazeClient$.org$http4s$client$blaze$BlazeClient$$loop$1(F, req, manager, key, responseHeaderTimeout, scheduler, ec, idleTimeout);
            Duration duration = requestTimeout;
            if (duration instanceof FiniteDuration) {
                FiniteDuration finiteDuration = (FiniteDuration)duration;
                object = package.all$.MODULE$.toFlatMapOps(F.racePair(res, F.cancelable((Function1 & Serializable)cb -> {
                    Cancelable c = scheduler.schedule(new Runnable((Function1)cb, key, finiteDuration){
                        private final Function1 cb$2;
                        private final RequestKey key$1;
                        private final FiniteDuration x2$2;

                        public void run() {
                            this.cb$2.apply((Object)scala.package$.MODULE$.Right().apply((Object)new TimeoutException(new StringBuilder(31).append("Request to ").append(this.key$1).append(" timed out after ").append(this.x2$2.toMillis()).append(" ms").toString())));
                        }
                        {
                            this.cb$2 = cb$2;
                            this.key$1 = key$1;
                            this.x2$2 = x2$2;
                        }
                    }, ec, (Duration)finiteDuration);
                    return F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> c.cancel());
                })), (FlatMap)F).flatMap((Function1 & Serializable)x0$1 -> {
                    Right right;
                    Tuple2 tuple2;
                    Object object;
                    Left left;
                    Tuple2 tuple22;
                    Either either = x0$1;
                    if (either instanceof Left && (tuple22 = (Tuple2)(left = (Left)either).value()) != null) {
                        Resource r = (Resource)tuple22._1();
                        Fiber fiber = (Fiber)tuple22._2();
                        object = package.all$.MODULE$.toFunctorOps(fiber.cancel(), (Functor)F).as((Object)r);
                    } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                        Fiber fiber = (Fiber)tuple2._1();
                        TimeoutException t = (TimeoutException)tuple2._2();
                        object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(fiber.cancel(), (FlatMap)F), (Function0 & Serializable)() -> F.raiseError((Object)t), (FlatMap)F);
                    } else {
                        throw new MatchError((Object)either);
                    }
                    return object;
                });
            } else {
                object = res;
            }
            return Resource$.MODULE$.suspend(object);
        }, F);
    }

    public static final /* synthetic */ void $anonfun$makeClient$2(RequestKey key$1, Throwable e) {
        block0: {
            if (!logger.isErrorEnabled()) break block0;
            logger.error(new StringBuilder(34).append("Error invalidating connection for ").append(key$1).toString(), e);
        }
    }

    public static final Object org$http4s$client$blaze$BlazeClient$$invalidate$1(BlazeConnection connection, ConnectionManager manager$1, ConcurrentEffect F$1, RequestKey key$1) {
        return ApplicativeErrorOps$.MODULE$.handleError$extension(package.all$.MODULE$.catsSyntaxApplicativeError(manager$1.invalidate((Connection)connection), (ApplicativeError)F$1), (Function1 & Serializable)e -> {
            BlazeClient$.$anonfun$makeClient$2(key$1, e);
            return BoxedUnit.UNIT;
        }, (ApplicativeError)F$1);
    }

    private static final Resource borrow$1(ConnectionManager manager$1, RequestKey key$1, ConcurrentEffect F$1) {
        return Resource$.MODULE$.makeCase(manager$1.borrow(key$1), (Function2 & Serializable)(x0$1, x1$1) -> {
            ExitCase exitCase;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null && ExitCase.Completed$.MODULE$.equals(exitCase = (ExitCase)tuple2._2())) {
                return F$1.unit();
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ConnectionManager.NextConnection next = (ConnectionManager.NextConnection)tuple2._1();
            ExitCase exitCase2 = (ExitCase)tuple2._2();
            boolean bl = exitCase2 instanceof ExitCase.Error ? true : ExitCase.Canceled$.MODULE$.equals(exitCase2);
            if (!bl) throw new MatchError((Object)tuple2);
            return BlazeClient$.org$http4s$client$blaze$BlazeClient$$invalidate$1((BlazeConnection)next.connection(), manager$1, F$1, key$1);
        }, (Functor)F$1);
    }

    private static final Resource idleTimeoutStage$1(BlazeConnection conn, Duration idleTimeout$1, TickWheelExecutor scheduler$1, ExecutionContext ec$1, ConcurrentEffect F$1) {
        Object object;
        Duration duration = idleTimeout$1;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            IdleTimeoutStage stage = new IdleTimeoutStage(finiteDuration, scheduler$1, ec$1);
            object = package.all$.MODULE$.toFunctorOps(F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> conn.spliceBefore((MidStage)stage)), (Functor)F$1).as((Object)new Some((Object)stage));
        } else {
            object = F$1.pure((Object)None$.MODULE$);
        }
        return Resource$.MODULE$.makeCase(object, (Function2 & Serializable)(x0$1, x1$1) -> {
            Object object;
            ExitCase exitCase;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null && ExitCase.Completed$.MODULE$.equals(exitCase = (ExitCase)tuple2._2())) {
                object = F$1.unit();
            } else if (tuple2 != null) {
                Option stageOpt = (Option)tuple2._1();
                object = F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> stageOpt.foreach((Function1 & Serializable)x$1 -> {
                    x$1.removeStage($less$colon$less$.MODULE$.refl());
                    return BoxedUnit.UNIT;
                }));
            } else {
                throw new MatchError((Object)tuple2);
            }
            return object;
        }, (Functor)F$1);
    }

    public static final Object org$http4s$client$blaze$BlazeClient$$loop$1(ConcurrentEffect F$1, Request req$1, ConnectionManager manager$1, RequestKey key$1, Duration responseHeaderTimeout$1, TickWheelExecutor scheduler$1, ExecutionContext ec$1, Duration idleTimeout$1) {
        return BlazeClient$.borrow$1(manager$1, key$1, F$1).use((Function1 & Serializable)next -> BlazeClient$.idleTimeoutStage$1((BlazeConnection)next.connection(), idleTimeout$1, scheduler$1, ec$1, F$1).use((Function1 & Serializable)stageOpt -> {
            Object object;
            Object object2;
            Option option = stageOpt;
            if (option instanceof Some) {
                Some some = (Some)option;
                IdleTimeoutStage stage = (IdleTimeoutStage)some.value();
                object2 = F$1.async((Function1 & Serializable)cb -> {
                    stage.init(cb);
                    return BoxedUnit.UNIT;
                });
            } else if (None$.MODULE$.equals(option)) {
                object2 = F$1.never();
            } else {
                throw new MatchError((Object)option);
            }
            Object idleTimeoutF = object2;
            Object res = ApplicativeErrorOps$.MODULE$.recoverWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps(((BlazeConnection)next.connection()).runRequest(req$1, idleTimeoutF), (Functor)F$1).map((Function1 & Serializable)r -> Resource$.MODULE$.makeCase(F$1.pure(r), (Function2 & Serializable)(x0$1, x1$1) -> {
                ExitCase exitCase;
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                Object object = tuple2 != null && ExitCase.Completed$.MODULE$.equals(exitCase = (ExitCase)tuple2._2()) ? BracketOps$.MODULE$.guarantee$extension(package$.MODULE$.catsEffectSyntaxBracket(F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> stageOpt.foreach((Function1 & Serializable)x$2 -> {
                    x$2.removeStage($less$colon$less$.MODULE$.refl());
                    return BoxedUnit.UNIT;
                })), (Bracket)F$1), manager$1.release(next.connection()), (Bracket)F$1) : BracketOps$.MODULE$.guarantee$extension(package$.MODULE$.catsEffectSyntaxBracket(F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> stageOpt.foreach((Function1 & Serializable)x$3 -> {
                    x$3.removeStage($less$colon$less$.MODULE$.refl());
                    return BoxedUnit.UNIT;
                })), (Bracket)F$1), manager$1.invalidate(next.connection()), (Bracket)F$1);
                return object;
            }, (Functor)F$1)), (ApplicativeError)F$1), (PartialFunction)new Serializable((ConnectionManager.NextConnection)next, F$1, key$1, manager$1, req$1, responseHeaderTimeout$1, scheduler$1, ec$1, idleTimeout$1){
                private static final long serialVersionUID = 0L;
                private final ConnectionManager.NextConnection next$1;
                private final ConcurrentEffect F$1;
                private final RequestKey key$1;
                private final ConnectionManager manager$1;
                private final Request req$1;
                private final Duration responseHeaderTimeout$1;
                private final TickWheelExecutor scheduler$1;
                private final ExecutionContext ec$1;
                private final Duration idleTimeout$1;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    Object object = Command.EOF$.MODULE$.equals(A1) ? package.all$.MODULE$.toFlatMapOps(BlazeClient$.org$http4s$client$blaze$BlazeClient$$invalidate$1((BlazeConnection)this.next$1.connection(), this.manager$1, this.F$1, this.key$1), (FlatMap)this.F$1).flatMap((Function1 & Serializable)x$4 -> $this.next$1.fresh() ? $this.F$1.raiseError((Object)new ConnectException(new StringBuilder(31).append("Failed to connect to endpoint: ").append($this.key$1).toString())) : BlazeClient$.org$http4s$client$blaze$BlazeClient$$loop$1($this.F$1, $this.req$1, $this.manager$1, $this.key$1, $this.responseHeaderTimeout$1, $this.scheduler$1, $this.ec$1, $this.idleTimeout$1)) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    boolean bl = Command.EOF$.MODULE$.equals(throwable);
                    return bl;
                }
                {
                    this.next$1 = next$1;
                    this.F$1 = F$1;
                    this.key$1 = key$1;
                    this.manager$1 = manager$1;
                    this.req$1 = req$1;
                    this.responseHeaderTimeout$1 = responseHeaderTimeout$1;
                    this.scheduler$1 = scheduler$1;
                    this.ec$1 = ec$1;
                    this.idleTimeout$1 = idleTimeout$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.http4s.client.blaze.BlazeClient$$anonfun$1 scala.runtime.BoxedUnit )}, serializedLambda);
                }
            }, (ApplicativeError)F$1);
            Duration duration = responseHeaderTimeout$1;
            if (duration instanceof FiniteDuration) {
                FiniteDuration finiteDuration = (FiniteDuration)duration;
                object = package.all$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply((Concurrent)F$1), (FlatMap)F$1).flatMap((Function1 & Serializable)gate -> {
                    Object responseHeaderTimeoutF = BracketOps$.MODULE$.bracket$extension(package$.MODULE$.catsEffectSyntaxBracket(F$1.delay((Function0 & Serializable)() -> {
                        ResponseHeaderTimeoutStage stage = new ResponseHeaderTimeoutStage(finiteDuration, scheduler$1, ec$1);
                        ((Tail)next.connection()).spliceBefore((MidStage)stage);
                        return stage;
                    }), (Bracket)F$1), (Function1 & Serializable)stage -> F$1.asyncF((Function1 & Serializable)cb -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> stage.init(cb)), (FlatMap)F$1), (Function0 & Serializable)() -> gate.complete((Object)BoxedUnit.UNIT), (FlatMap)F$1)), (Function1 & Serializable)stage -> F$1.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> stage.removeStage($less$colon$less$.MODULE$.refl())), (Bracket)F$1);
                    return package.all$.MODULE$.toFlatMapOps(F$1.racePair(package.all$.MODULE$.catsSyntaxApply(gate.get(), (Apply)F$1).$times$greater(res), responseHeaderTimeoutF), (FlatMap)F$1).flatMap((Function1 & Serializable)x0$2 -> {
                        Right right;
                        Tuple2 tuple2;
                        Object object;
                        Left left;
                        Tuple2 tuple22;
                        Either either = x0$2;
                        if (either instanceof Left && (tuple22 = (Tuple2)(left = (Left)either).value()) != null) {
                            Resource r = (Resource)tuple22._1();
                            Fiber fiber = (Fiber)tuple22._2();
                            object = package.all$.MODULE$.toFunctorOps(fiber.cancel(), (Functor)F$1).as((Object)r);
                        } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                            Fiber fiber = (Fiber)tuple2._1();
                            TimeoutException t = (TimeoutException)tuple2._2();
                            object = FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(fiber.cancel(), (FlatMap)F$1), (Function0 & Serializable)() -> F$1.raiseError((Object)t), (FlatMap)F$1);
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return object;
                    });
                });
            } else {
                object = res;
            }
            return object;
        }, (Bracket)F$1), (Bracket)F$1);
    }

    private BlazeClient$() {
    }
}

