/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.blaze;

import cats.effect.ConcurrentEffect;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.http4s.Uri;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.client.ConnectionFailure;
import org.http4s.client.RequestKey;
import org.http4s.client.blaze.BlazeConnection;
import org.http4s.client.blaze.Http1Connection;
import org.http4s.client.blaze.ParserMode;
import org.http4s.client.blaze.ReadBufferStage;
import org.http4s.headers.User;
import org.http4s.internal.SSLContextOption;
import org.http4s.internal.SSLContextOption$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001B\f\u0019\r\u0005B\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002*\t\u0011U\u0003!\u0011!Q\u0001\nEB\u0001B\u0016\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t/\u0002\u0011\t\u0011)A\u0005c!A\u0001\f\u0001B\u0001B\u0003%\u0011\u0007\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!q\u0006A!A!\u0002\u0013y\u0006\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B4\t\u00115\u0004!\u0011!Q\u0001\n9D\u0001\u0002\u001e\u0001\u0003\u0002\u0003\u0006Y!\u001e\u0005\b\u0003/\u0001A\u0011AA\r\u0011%\ti\u0004\u0001b\u0001\n\u0013\ty\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA!\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!a\u001a\u0001\t\u0013\tI\u0007C\u0004\u0002\u0004\u0002!I!!\"\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\na\u0001\n\u001e;qcM+\b\u000f]8si*\u0011\u0011DG\u0001\u0006E2\f'0\u001a\u0006\u00037q\taa\u00197jK:$(BA\u000f\u001f\u0003\u0019AG\u000f\u001e95g*\tq$A\u0002pe\u001e\u001c\u0001!\u0006\u0002#\u007fN\u0011\u0001a\t\t\u0003I\u001dj\u0011!\n\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&\n\u0002\u0007\u0003:L(+\u001a4\u0002!M\u001cHnQ8oi\u0016DHo\u00149uS>t\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001d\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0018-\u0005A\u00196\u000bT\"p]R,\u0007\u0010^(qi&|g.\u0001\u0006ck\u001a4WM]*ju\u0016\u0004\"\u0001\n\u001a\n\u0005M*#aA%oi\u0006A\u0012m]=oG\"\u0014xN\\8vg\u000eC\u0017M\u001c8fY\u001e\u0013x.\u001e9\u0011\u0007\u00112\u0004(\u0003\u00028K\t1q\n\u001d;j_:\u0004\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\u0011\rD\u0017M\u001c8fYNT!!\u0010 \u0002\u00079LwNC\u0001@\u0003\u0011Q\u0017M^1\n\u0005\u0005S$\u0001G!ts:\u001c\u0007N]8o_V\u001c8\t[1o]\u0016dwI]8va\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u0016\n!bY8oGV\u0014(/\u001a8u\u0013\tAUI\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006I1o\u00195fIVdWM\u001d\t\u0003\u0017>k\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA!\u001e;jY*\u0011\u0011\u0004H\u0005\u0003!2\u0013\u0011\u0003V5dW^CW-\u001a7Fq\u0016\u001cW\u000f^8s\u0003m\u0019\u0007.Z2l\u000b:$\u0007o\\5oi&#WM\u001c;jM&\u001c\u0017\r^5p]B\u0011AeU\u0005\u0003)\u0016\u0012qAQ8pY\u0016\fg.A\nnCb\u0014Vm\u001d9p]N,G*\u001b8f'&TX-A\bnCbDU-\u00193fe2+gn\u001a;i\u00031i\u0017\r_\"ik:\\7+\u001b>f\u0003I\u0019\u0007.\u001e8l\u0005V4g-\u001a:NCb\u001c\u0016N_3\u0002\u0015A\f'o]3s\u001b>$W\r\u0005\u0002\\96\t\u0001$\u0003\u0002^1\tQ\u0001+\u0019:tKJlu\u000eZ3\u0002\u0013U\u001cXM]!hK:$\bc\u0001\u00137AB\u0011\u0011\rZ\u0007\u0002E*\u00111\rH\u0001\bQ\u0016\fG-\u001a:t\u0013\t)'MA\bVg\u0016\u0014H%\\5okN\fu-\u001a8u\u00039\u0019\u0007.\u00198oK2|\u0005\u000f^5p]N\u0004\"\u0001[6\u000e\u0003%T!A\u001b(\u0002\u000f\rD\u0017M\u001c8fY&\u0011A.\u001b\u0002\u000f\u0007\"\fgN\\3m\u001fB$\u0018n\u001c8t\u00039\u0019wN\u001c8fGR$\u0016.\\3pkR\u0004\"a\u001c:\u000e\u0003AT!!]#\u0002\u0011\u0011,(/\u0019;j_:L!a\u001d9\u0003\u0011\u0011+(/\u0019;j_:\f\u0011A\u0012\t\u0004mnlX\"A<\u000b\u0005aL\u0018AB3gM\u0016\u001cGOC\u0001{\u0003\u0011\u0019\u0017\r^:\n\u0005q<(\u0001E\"p]\u000e,(O]3oi\u00163g-Z2u!\tqx\u0010\u0004\u0001\u0005\u000f\u0005\u0005\u0001A1\u0001\u0002\u0004\t\ta)\u0006\u0003\u0002\u0006\u0005M\u0011\u0003BA\u0004\u0003\u001b\u00012\u0001JA\u0005\u0013\r\tY!\n\u0002\b\u001d>$\b.\u001b8h!\r!\u0013qB\u0005\u0004\u0003#)#aA!os\u00129\u0011QC@C\u0002\u0005\u0015!!A0\u0002\rqJg.\u001b;?)y\tY\"!\t\u0002$\u0005\u0015\u0012qEA\u0015\u0003W\ti#a\f\u00022\u0005M\u0012QGA\u001c\u0003s\tY\u0004\u0006\u0003\u0002\u001e\u0005}\u0001cA.\u0001{\")A\u000f\u0005a\u0002k\")\u0011\u0006\u0005a\u0001U!)\u0001\u0007\u0005a\u0001c!)A\u0007\u0005a\u0001k!)!\t\u0005a\u0001\u0007\")\u0011\n\u0005a\u0001\u0015\")\u0011\u000b\u0005a\u0001%\")Q\u000b\u0005a\u0001c!)a\u000b\u0005a\u0001c!)q\u000b\u0005a\u0001c!)\u0001\f\u0005a\u0001c!)\u0011\f\u0005a\u00015\")a\f\u0005a\u0001?\")a\r\u0005a\u0001O\")Q\u000e\u0005a\u0001]\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u0013j!!!\u0012\u000b\u0007\u0005\u001d\u0013.\u0001\u0003oS>\u0014\u0014\u0002BA&\u0003\u000b\u0012Ac\u00117jK:$8\t[1o]\u0016dg)Y2u_JL\u0018AE2p]:,7\r^5p]6\u000bg.Y4fe\u0002\n!\"\\1lK\u000ec\u0017.\u001a8u)\u0011\t\u0019&a\u0017\u0011\ty|\u0018Q\u000b\t\u00057\u0006]S0C\u0002\u0002Za\u0011qB\u00117bu\u0016\u001cuN\u001c8fGRLwN\u001c\u0005\b\u0003;\u001a\u0002\u0019AA0\u0003)\u0011X-];fgR\\U-\u001f\t\u0005\u0003C\n\u0019'D\u0001\u001b\u0013\r\t)G\u0007\u0002\u000b%\u0016\fX/Z:u\u0017\u0016L\u0018!\u00042vS2$\u0007+\u001b9fY&tW\r\u0006\u0004\u0002l\u0005E\u00141\u000f\t\u0006\t\u00065\u0014QK\u0005\u0004\u0003_*%A\u0002$viV\u0014X\rC\u0004\u0002^Q\u0001\r!a\u0018\t\u000f\u0005UD\u00031\u0001\u0002x\u0005!\u0011\r\u001a3s!\u0011\tI(a \u000e\u0005\u0005m$bAA?}\u0005\u0019a.\u001a;\n\t\u0005\u0005\u00151\u0010\u0002\u0012\u0013:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001c\u0018a\u00032vS2$7\u000b^1hKN$B!a\"\u0002FBA\u0011\u0011RAM\u0003?\u000bYK\u0004\u0003\u0002\f\u0006Ue\u0002BAG\u0003'k!!a$\u000b\u0007\u0005E\u0005%\u0001\u0004=e>|GOP\u0005\u0002M%\u0019\u0011qS\u0013\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u0011qS\u0013\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GS1!!*?\u0003\u0011a\u0017M\\4\n\t\u0005%\u00161\u0015\u0002\u0016\u00132dWmZ1m'R\fG/Z#yG\u0016\u0004H/[8o!\u001d!\u0013QVAY\u0003+J1!a,&\u0005\u0019!V\u000f\u001d7feA1\u00111WA]\u0003{k!!!.\u000b\u0007\u0005]f*\u0001\u0005qSB,G.\u001b8f\u0013\u0011\tY,!.\u0003\u00171+\u0017M\u001a\"vS2$WM\u001d\t\u0005\u0003\u007f\u000b\t-D\u0001=\u0013\r\t\u0019\r\u0010\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\bbBA/+\u0001\u0007\u0011qL\u0001\u000bO\u0016$\u0018\t\u001a3sKN\u001cH\u0003BAf\u0003'\u0004\u0002\"!#\u0002\u001a\u00065\u0017q\u000f\t\u0005\u0003\u0013\u000by-\u0003\u0003\u0002R\u0006u%!\u0003+ie><\u0018M\u00197f\u0011\u001d\tiF\u0006a\u0001\u0003?\u0002")
public final class Http1Support<F> {
    private final SSLContextOption sslContextOption;
    private final ExecutionContext executionContext;
    private final boolean checkEndpointIdentification;
    private final int maxResponseLineSize;
    private final int maxHeaderLength;
    private final int maxChunkSize;
    private final int chunkBufferMaxSize;
    private final ParserMode parserMode;
    private final Option<User.minusAgent> userAgent;
    private final ConcurrentEffect<F> F;
    private final ClientChannelFactory connectionManager;

    private ClientChannelFactory connectionManager() {
        return this.connectionManager;
    }

    public F makeClient(RequestKey requestKey) {
        Object object;
        Either<Throwable, InetSocketAddress> either = this.getAddress(requestKey);
        if (either instanceof Right) {
            Right right = (Right)either;
            InetSocketAddress a = (InetSocketAddress)right.value();
            object = org.http4s.blazecore.util.package$.MODULE$.fromFutureNoShift(this.F.delay((Function0 & Serializable)() -> this.buildPipeline(requestKey, a)), this.F);
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            object = this.F.raiseError((Object)t);
        } else {
            throw new MatchError(either);
        }
        return (F)object;
    }

    private Future<BlazeConnection<F>> buildPipeline(RequestKey requestKey, InetSocketAddress addr) {
        return this.connectionManager().connect((SocketAddress)addr, this.connectionManager().connect$default$2()).transformWith((Function1 & Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Future future2;
                Right right;
                Tuple2 tuple2;
                Success success = (Success)try_;
                HeadStage head = (HeadStage)success.value();
                Either either = this.buildStages(requestKey);
                if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                    LeafBuilder builder = (LeafBuilder)tuple2._1();
                    BlazeConnection t = (BlazeConnection)tuple2._2();
                    builder.base(head);
                    head.inboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
                    future2 = Future$.MODULE$.successful((Object)t);
                } else if (either instanceof Left) {
                    Left left = (Left)either;
                    IllegalStateException e = (IllegalStateException)left.value();
                    future2 = Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, (Throwable)e));
                } else {
                    throw new MatchError(either);
                }
                future = future2;
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                future = Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, e));
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, this.executionContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<IllegalStateException, Tuple2<LeafBuilder<ByteBuffer>, BlazeConnection<F>>> buildStages(RequestKey requestKey) {
        Left left;
        Option maybeSSLContext;
        Option option;
        Http1Connection<F> t = new Http1Connection<F>(requestKey, this.executionContext, this.maxResponseLineSize, this.maxHeaderLength, this.maxChunkSize, this.chunkBufferMaxSize, this.parserMode, this.userAgent, this.F);
        LeafBuilder builder = LeafBuilder$.MODULE$.apply(t).prepend(new ReadBufferStage());
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) return package$.MODULE$.Right().apply((Object)new Tuple2((Object)builder, t));
        Uri.Scheme scheme = requestKey2.scheme();
        Uri.Authority auth = requestKey2.authority();
        Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
        Uri.Scheme scheme3 = scheme;
        if (scheme2 == null) {
            if (scheme3 != null) {
                return package$.MODULE$.Right().apply((Object)new Tuple2((Object)builder, t));
            }
        } else if (!scheme2.equals(scheme3)) return package$.MODULE$.Right().apply((Object)new Tuple2((Object)builder, t));
        if ((option = (maybeSSLContext = SSLContextOption$.MODULE$.toMaybeSSLContext(this.sslContextOption))) instanceof Some) {
            Some some = (Some)option;
            SSLContext sslContext = (SSLContext)some.value();
            SSLEngine eng = sslContext.createSSLEngine(auth.host().value(), BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 443)));
            eng.setUseClientMode(true);
            if (this.checkEndpointIdentification) {
                SSLParameters sslParams = eng.getSSLParameters();
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                eng.setSSLParameters(sslParams);
            }
            left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)builder.prepend((MidStage)new SSLStage(eng, SSLStage$.MODULE$.$lessinit$greater$default$2())), t));
            return left;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            left = package$.MODULE$.Left().apply((Object)new IllegalStateException("No SSLContext configured for this client. Try `withSslContext` on the `BlazeClientBuilder`, or do not make https calls."));
        }
        return left;
    }

    private Either<Throwable, InetSocketAddress> getAddress(RequestKey requestKey) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 == null) {
            throw new MatchError((Object)requestKey2);
        }
        Uri.Scheme s = requestKey2.scheme();
        Uri.Authority auth = requestKey2.authority();
        int port = BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> {
            Uri.Scheme scheme = s;
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            return !(scheme != null ? !scheme.equals(scheme2) : scheme2 != null) ? 443 : 80;
        }));
        String host = auth.host().value();
        Either either = EitherObjectOps$.MODULE$.catchNonFatal$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()), (Function0 & Serializable)() -> new InetSocketAddress(host, port));
        return either;
    }

    public Http1Support(SSLContextOption sslContextOption, int bufferSize, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ExecutionContext executionContext, TickWheelExecutor scheduler, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, Option<User.minusAgent> userAgent, ChannelOptions channelOptions, Duration connectTimeout, ConcurrentEffect<F> F) {
        this.sslContextOption = sslContextOption;
        this.executionContext = executionContext;
        this.checkEndpointIdentification = checkEndpointIdentification;
        this.maxResponseLineSize = maxResponseLineSize;
        this.maxHeaderLength = maxHeaderLength;
        this.maxChunkSize = maxChunkSize;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.parserMode = parserMode;
        this.userAgent = userAgent;
        this.F = F;
        this.connectionManager = new ClientChannelFactory(bufferSize, asynchronousChannelGroup, channelOptions, scheduler, connectTimeout);
    }
}

