/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import cats.syntax.package;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.http4s.Uri;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.client.BlazeConnection;
import org.http4s.blaze.client.Http1Connection;
import org.http4s.blaze.client.ParserMode;
import org.http4s.blaze.core.ExecutionContextConfig;
import org.http4s.blaze.core.IdleTimeoutStage;
import org.http4s.blaze.core.util.package$;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.client.ConnectionFailure;
import org.http4s.client.RequestKey;
import org.http4s.headers.User;
import org.http4s.internal.SSLContextOption;
import org.http4s.internal.SSLContextOption$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t5b\u0001B\u000e\u001d\r\u0015B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u0013q\u0005\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B+\t\u0011a\u0003!\u0011!Q\u0001\nUB\u0001\"\u0017\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t5\u0002\u0011\t\u0011)A\u0005k!A1\f\u0001B\u0001B\u0003%Q\u0007\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!\t\u0007A!A!\u0002\u0013\u0011\u0007\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u0011A\u0004!\u0011!Q\u0001\nED\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\tu\u0002\u0011\t\u0011)A\u0005w\"Q\u0011q\u0005\u0001\u0003\u0002\u0003\u0006I!!\u000b\t\u0015\u0005\r\u0004A!A!\u0002\u0017\t)\u0007C\u0004\u0002r\u0001!\t!a\u001d\t\u0013\u0005u\u0005A1A\u0005\n\u0005}\u0005\u0002CAW\u0001\u0001\u0006I!!)\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u0011\u001d\u00119\u0002\u0001C\u0005\u00053\u0011A\u0002\u0013;uaF\u001aV\u000f\u001d9peRT!!\b\u0010\u0002\r\rd\u0017.\u001a8u\u0015\ty\u0002%A\u0003cY\u0006TXM\u0003\u0002\"E\u00051\u0001\u000e\u001e;qiMT\u0011aI\u0001\u0004_J<7\u0001A\u000b\u0004M\u0005=1C\u0001\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u0006\u00012o\u001d7D_:$X\r\u001f;PaRLwN\u001c\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003gA\u0012\u0001cU*M\u0007>tG/\u001a=u\u001fB$\u0018n\u001c8\u0002\u0015\t,hMZ3s'&TX\r\u0005\u0002)m%\u0011q'\u000b\u0002\u0004\u0013:$\u0018\u0001G1ts:\u001c\u0007N]8o_V\u001c8\t[1o]\u0016dwI]8vaB\u0019\u0001F\u000f\u001f\n\u0005mJ#AB(qi&|g\u000e\u0005\u0002>\t6\taH\u0003\u0002@\u0001\u0006A1\r[1o]\u0016d7O\u0003\u0002B\u0005\u0006\u0019a.[8\u000b\u0003\r\u000bAA[1wC&\u0011QI\u0010\u0002\u0019\u0003NLhn\u00195s_:|Wo]\"iC:tW\r\\$s_V\u0004\u0018AF3yK\u000e,H/[8o\u0007>tG/\u001a=u\u0007>tg-[4\u0011\u0005![U\"A%\u000b\u0005)s\u0012\u0001B2pe\u0016L!\u0001T%\u0003-\u0015CXmY;uS>t7i\u001c8uKb$8i\u001c8gS\u001e\f\u0011b]2iK\u0012,H.\u001a:\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Es\u0012\u0001B;uS2L!a\u0015)\u0003#QK7m[,iK\u0016dW\t_3dkR|'/A\u000edQ\u0016\u001c7.\u00128ea>Lg\u000e^%eK:$\u0018NZ5dCRLwN\u001c\t\u0003QYK!aV\u0015\u0003\u000f\t{w\u000e\\3b]\u0006\u0019R.\u0019=SKN\u0004xN\\:f\u0019&tWmU5{K\u0006yQ.\u0019=IK\u0006$WM\u001d'f]\u001e$\b.\u0001\u0007nCb\u001c\u0005.\u001e8l'&TX-\u0001\ndQVt7NQ;gM\u0016\u0014X*\u0019=TSj,\u0017A\u00039beN,'/T8eKB\u0011alX\u0007\u00029%\u0011\u0001\r\b\u0002\u000b!\u0006\u00148/\u001a:N_\u0012,\u0017!C;tKJ\fu-\u001a8u!\rA#h\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0002\nq\u0001[3bI\u0016\u00148/\u0003\u0002iK\nyQk]3sI5Lg.^:BO\u0016tG/\u0001\bdQ\u0006tg.\u001a7PaRLwN\\:\u0011\u0005-tW\"\u00017\u000b\u00055t\u0012aB2iC:tW\r\\\u0005\u0003_2\u0014ab\u00115b]:,Gn\u00149uS>t7/\u0001\bd_:tWm\u0019;US6,w.\u001e;\u0011\u0005I<X\"A:\u000b\u0005Q,\u0018\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005YL\u0013AC2p]\u000e,(O]3oi&\u0011\u0001p\u001d\u0002\t\tV\u0014\u0018\r^5p]\u0006Y\u0011\u000e\u001a7f)&lWm\\;u\u0003)!\u0017n\u001d9bi\u000eDWM\u001d\t\u0006y\u0006\u001d\u00111B\u0007\u0002{*\u0011ap`\u0001\u0004gR$'\u0002BA\u0001\u0003\u0007\ta!\u001a4gK\u000e$(BAA\u0003\u0003\u0011\u0019\u0017\r^:\n\u0007\u0005%QP\u0001\u0006ESN\u0004\u0018\r^2iKJ\u0004B!!\u0004\u0002\u00101\u0001AaBA\t\u0001\t\u0007\u00111\u0003\u0002\u0002\rV!\u0011QCA\u0012#\u0011\t9\"!\b\u0011\u0007!\nI\"C\u0002\u0002\u001c%\u0012qAT8uQ&tw\rE\u0002)\u0003?I1!!\t*\u0005\r\te.\u001f\u0003\t\u0003K\tyA1\u0001\u0002\u0016\t!q\f\n\u00132\u0003)9W\r^!eIJ,7o\u001d\t\bQ\u0005-\u0012qFA\u001d\u0013\r\ti#\u000b\u0002\n\rVt7\r^5p]F\u0002B!!\r\u000265\u0011\u00111\u0007\u0006\u0003;\u0001JA!a\u000e\u00024\tQ!+Z9vKN$8*Z=\u0011\u0011\u0005m\u00121JA)\u0003/rA!!\u0010\u0002H9!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D\u0011\na\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u0007\u0005%\u0013&A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0013q\n\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005%\u0013\u0006\u0005\u0003\u0002<\u0005M\u0013\u0002BA+\u0003\u001f\u0012\u0011\u0002\u00165s_^\f'\r\\3\u0011\t\u0005e\u0013qL\u0007\u0003\u00037R1!!\u0018C\u0003\rqW\r^\u0005\u0005\u0003C\nYFA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\f\u0011A\u0012\t\u0007\u0003O\ni'a\u0003\u000e\u0005\u0005%$bAA6\u007f\u000611.\u001a:oK2LA!a\u001c\u0002j\t)\u0011i]=oG\u00061A(\u001b8jiz\"B%!\u001e\u0002|\u0005u\u0014qPAA\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0015QRAH\u0003#\u000b\u0019*!&\u0002\u0018\u0006e\u00151\u0014\u000b\u0005\u0003o\nI\b\u0005\u0003_\u0001\u0005-\u0001bBA2'\u0001\u000f\u0011Q\r\u0005\u0006[M\u0001\rA\f\u0005\u0006iM\u0001\r!\u000e\u0005\u0006qM\u0001\r!\u000f\u0005\u0006\rN\u0001\ra\u0012\u0005\u0006\u001bN\u0001\rA\u0014\u0005\u0006)N\u0001\r!\u0016\u0005\u00061N\u0001\r!\u000e\u0005\u00063N\u0001\r!\u000e\u0005\u00065N\u0001\r!\u000e\u0005\u00067N\u0001\r!\u000e\u0005\u00069N\u0001\r!\u0018\u0005\u0006CN\u0001\rA\u0019\u0005\u0006SN\u0001\rA\u001b\u0005\u0006aN\u0001\r!\u001d\u0005\u0006sN\u0001\r!\u001d\u0005\u0006uN\u0001\ra\u001f\u0005\b\u0003O\u0019\u0002\u0019AA\u0015\u0003E\u0019wN\u001c8fGRLwN\\'b]\u0006<WM]\u000b\u0003\u0003C\u0003B!a)\u0002*6\u0011\u0011Q\u0015\u0006\u0004\u0003Oc\u0017\u0001\u00028j_JJA!a+\u0002&\n!2\t\\5f]R\u001c\u0005.\u00198oK24\u0015m\u0019;pef\f!cY8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3sA\u0005QQ.Y6f\u00072LWM\u001c;\u0015\t\u0005M\u00161\u0018\t\u0007\u0003\u001b\ty!!.\u0011\u000by\u000b9,a\u0003\n\u0007\u0005eFDA\bCY\u0006TXmQ8o]\u0016\u001cG/[8o\u0011\u001d\tiL\u0006a\u0001\u0003_\t!B]3rk\u0016\u001cHoS3z\u00035\u0011W/\u001b7e!&\u0004X\r\\5oKRA\u00111YAf\u0003\u001b\f\t\u000e\u0005\u0004\u0002F\u0006\u001d\u0017QW\u0007\u0002k&\u0019\u0011\u0011Z;\u0003\r\u0019+H/\u001e:f\u0011\u001d\til\u0006a\u0001\u0003_Aq!a4\u0018\u0001\u0004\t9&\u0001\u0003bI\u0012\u0014\bbBAj/\u0001\u0007\u0011Q[\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004B!!2\u0002X&\u0019\u0011\u0011\\;\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018a\u00032vS2$7\u000b^1hKN$\u0002\"a8\u0002n\u0006=(q\u0001\t\t\u0003w\tY%!9\u00026B!\u00111]Au\u001b\t\t)OC\u0002\u0002h\n\u000bA\u0001\\1oO&!\u00111^As\u0005UIE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:Dq!!0\u0019\u0001\u0004\ty\u0003C\u0004\u0002rb\u0001\r!a=\u0002\t!,\u0017\r\u001a\t\u0007\u0003k\fY0a@\u000e\u0005\u0005](bAA}=\u0005A\u0001/\u001b9fY&tW-\u0003\u0003\u0002~\u0006](!\u0003%fC\u0012\u001cF/Y4f!\u0011\u0011\tAa\u0001\u000e\u0003\u0001K1A!\u0002A\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\b\u0003'D\u0002\u0019AAk\u0003Qi\u0017m[3JI2,G+[7f_V$8\u000b^1hKR!!Q\u0002B\u000b!\u0011A#Ha\u0004\u0011\u000b!\u0013\t\"a@\n\u0007\tM\u0011J\u0001\tJI2,G+[7f_V$8\u000b^1hK\"9\u00111[\rA\u0002\u0005U\u0017\u0001D7bW\u0016\u001c6\u000f\\*uC\u001e,G\u0003\u0002B\u000e\u0005W\u0001\u0002\"a\u000f\u0002L\u0005\u0005(Q\u0004\t\u0005Qi\u0012y\u0002\u0005\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\u0011\u0011)#a>\u0002\rM$\u0018mZ3t\u0013\u0011\u0011ICa\t\u0003\u0011M\u001bFj\u0015;bO\u0016Dq!!0\u001b\u0001\u0004\ty\u0003")
public final class Http1Support<F> {
    private final SSLContextOption sslContextOption;
    private final ExecutionContextConfig executionContextConfig;
    private final TickWheelExecutor scheduler;
    private final boolean checkEndpointIdentification;
    private final int maxResponseLineSize;
    private final int maxHeaderLength;
    private final int maxChunkSize;
    private final int chunkBufferMaxSize;
    private final ParserMode parserMode;
    private final Option<User.minusAgent> userAgent;
    private final Duration idleTimeout;
    private final Dispatcher<F> dispatcher;
    private final Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress;
    private final Async<F> F;
    private final ClientChannelFactory connectionManager;

    private ClientChannelFactory connectionManager() {
        return this.connectionManager;
    }

    public F makeClient(RequestKey requestKey) {
        Either either = (Either)this.getAddress.apply((Object)requestKey);
        if (either instanceof Right) {
            Right right = (Right)either;
            InetSocketAddress a = (InetSocketAddress)right.value();
            return (F)package$.MODULE$.fromFutureNoShift(package.all$.MODULE$.toFlatMapOps(this.executionContextConfig.getExecutionContext(this.F), this.F).flatMap((Function1 & Serializable)ec -> $this.F.delay((Function0 & Serializable)() -> this.buildPipeline(requestKey, a, (ExecutionContext)ec))), this.F);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.value();
            return (F)this.F.raiseError((Object)t);
        }
        throw new MatchError((Object)either);
    }

    private Future<BlazeConnection<F>> buildPipeline(RequestKey requestKey, InetSocketAddress addr, ExecutionContext executionContext) {
        return this.connectionManager().connect((SocketAddress)addr, this.connectionManager().connect$default$2()).transformWith((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                HeadStage head = (HeadStage)success.value();
                Either either = this.buildStages(requestKey, (HeadStage<ByteBuffer>)head, executionContext);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    BlazeConnection connection = (BlazeConnection)right.value();
                    head.inboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
                    return Future$.MODULE$.successful((Object)connection);
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    IllegalStateException e = (IllegalStateException)left.value();
                    return Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, (Throwable)e));
                }
                throw new MatchError(either);
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                return Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, e));
            }
            throw new MatchError((Object)try_);
        }, executionContext);
    }

    private Either<IllegalStateException, BlazeConnection<F>> buildStages(RequestKey requestKey, HeadStage<ByteBuffer> head, ExecutionContext executionContext) {
        Option<IdleTimeoutStage<ByteBuffer>> idleTimeoutStage = this.makeIdleTimeoutStage(executionContext);
        Either<IllegalStateException, Option<SSLStage>> ssl = this.makeSslStage(requestKey);
        Http1Connection connection = new Http1Connection(requestKey, executionContext, this.maxResponseLineSize, this.maxHeaderLength, this.maxChunkSize, this.chunkBufferMaxSize, this.parserMode, this.userAgent, idleTimeoutStage, this.dispatcher, this.F);
        return ssl.map((Function1 & Serializable)sslStage -> {
            LeafBuilder builder1 = LeafBuilder$.MODULE$.apply((TailStage)connection);
            LeafBuilder builder2 = (LeafBuilder)idleTimeoutStage.fold((Function0 & Serializable)() -> builder1, (Function1 & Serializable)x$1 -> builder1.prepend((MidStage)x$1));
            LeafBuilder builder3 = (LeafBuilder)sslStage.fold((Function0 & Serializable)() -> builder2, (Function1 & Serializable)x$2 -> builder2.prepend((MidStage)x$2));
            builder3.base(head);
            return connection;
        });
    }

    private Option<IdleTimeoutStage<ByteBuffer>> makeIdleTimeoutStage(ExecutionContext executionContext) {
        Duration duration = this.idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            return new Some((Object)new IdleTimeoutStage(finiteDuration, this.scheduler, executionContext));
        }
        return None$.MODULE$;
    }

    private Either<IllegalStateException, Option<SSLStage>> makeSslStage(RequestKey requestKey) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 != null) {
            Uri.Scheme scheme = requestKey2.scheme();
            Uri.Authority auth = requestKey2.authority();
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            Uri.Scheme scheme3 = scheme;
            if (!(scheme2 != null ? !scheme2.equals(scheme3) : scheme3 != null)) {
                Option maybeSSLContext = SSLContextOption$.MODULE$.toMaybeSSLContext(this.sslContextOption);
                Option option = maybeSSLContext;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SSLContext sslContext = (SSLContext)some.value();
                    SSLEngine eng = sslContext.createSSLEngine(auth.host().value(), BoxesRunTime.unboxToInt((Object)auth.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 443)));
                    eng.setUseClientMode(true);
                    if (this.checkEndpointIdentification) {
                        SSLParameters sslParams = eng.getSSLParameters();
                        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                        eng.setSSLParameters(sslParams);
                    }
                    return scala.package$.MODULE$.Right().apply((Object)new Some((Object)new SSLStage(eng, SSLStage$.MODULE$.$lessinit$greater$default$2())));
                }
                if (None$.MODULE$.equals(option)) {
                    return scala.package$.MODULE$.Left().apply((Object)new IllegalStateException("No SSLContext configured for this client. Try `withSslContext` on the `BlazeClientBuilder`, or do not make https calls."));
                }
                throw new MatchError((Object)option);
            }
        }
        return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }

    public Http1Support(SSLContextOption sslContextOption, int bufferSize, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ExecutionContextConfig executionContextConfig, TickWheelExecutor scheduler, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, Option<User.minusAgent> userAgent, ChannelOptions channelOptions, Duration connectTimeout, Duration idleTimeout, Dispatcher<F> dispatcher, Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress, Async<F> F) {
        this.sslContextOption = sslContextOption;
        this.executionContextConfig = executionContextConfig;
        this.scheduler = scheduler;
        this.checkEndpointIdentification = checkEndpointIdentification;
        this.maxResponseLineSize = maxResponseLineSize;
        this.maxHeaderLength = maxHeaderLength;
        this.maxChunkSize = maxChunkSize;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.parserMode = parserMode;
        this.userAgent = userAgent;
        this.idleTimeout = idleTimeout;
        this.dispatcher = dispatcher;
        this.getAddress = getAddress;
        this.F = F;
        this.connectionManager = new ClientChannelFactory(bufferSize, asynchronousChannelGroup, channelOptions, scheduler, connectTimeout);
    }
}

