/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.Applicative;
import cats.effect.implicits$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Deferred$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.syntax.GenSpawnOps_$;
import cats.effect.std.Dispatcher;
import cats.syntax.MonadErrorRethrowOps$;
import cats.syntax.package;
import fs2.Compiler;
import fs2.Compiler$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.blaze.client.BlazeClient$;
import org.http4s.blaze.client.BlazeConnection;
import org.http4s.blaze.client.ConnectionManager;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.ResponseHeaderTimeoutStage;
import org.http4s.client.Client;
import org.http4s.client.DefaultClient;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.client.UnexpectedStatus$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;

public class BlazeClient<F, A extends BlazeConnection<F>>
extends DefaultClient<F> {
    private final ConnectionManager<F, A> manager;
    private final Duration responseHeaderTimeout;
    private final Duration requestTimeout;
    private final TickWheelExecutor scheduler;
    private final ExecutionContext ec;
    private final Dispatcher<F> dispatcher;
    private final Async<F> F;
    private final Resource<F, F> resourceNeverTimeoutException;

    public static <F, A extends BlazeConnection<F>> Client<F> makeClient(ConnectionManager<F, A> connectionManager, Duration duration, Duration duration2, TickWheelExecutor tickWheelExecutor, ExecutionContext executionContext, int n, Dispatcher<F> dispatcher, Async<F> async) {
        return BlazeClient$.MODULE$.makeClient(connectionManager, duration, duration2, tickWheelExecutor, executionContext, n, dispatcher, async);
    }

    public BlazeClient(ConnectionManager<F, A> manager, Duration responseHeaderTimeout, Duration requestTimeout, TickWheelExecutor scheduler, ExecutionContext ec, Dispatcher<F> dispatcher, Async<F> F) {
        this.manager = manager;
        this.responseHeaderTimeout = responseHeaderTimeout;
        this.requestTimeout = requestTimeout;
        this.scheduler = scheduler;
        this.ec = ec;
        this.dispatcher = dispatcher;
        this.F = F;
        super(F);
        this.resourceNeverTimeoutException = Resource$.MODULE$.pure(F.never());
    }

    public Resource<F, Response<F>> run(Request<F> req) {
        RequestKey key = RequestKey$.MODULE$.fromRequest(req);
        return this.scheduleRequestTimeout(key).flatMap((Function1 & Serializable)requestTimeoutF -> this.prepareConnection(key).map((Function1 & Serializable)preparedConnection -> {
            Tuple2 tuple2 = preparedConnection;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BlazeConnection conn = (BlazeConnection)tuple2._1();
            Object responseHeaderTimeoutF = tuple2._2();
            Tuple2 $1$ = tuple2;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)conn, responseHeaderTimeoutF);
            Tuple2 $1$2 = (Tuple2)tuple3._1();
            BlazeConnection conn2 = (BlazeConnection)tuple3._2();
            Object responseHeaderTimeoutF2 = tuple3._3();
            Object object = implicits$.MODULE$.genSpawnOps_(responseHeaderTimeoutF2);
            Object timeout = package.all$.MODULE$.toFunctorOps(GenSpawnOps_$.MODULE$.race$extension(object, requestTimeoutF, this.F), this.F).map((Function1 & Serializable)_$4 -> {
                Either either = Either$.MODULE$.MergeableEither(_$4);
                return (TimeoutException)Either.MergeableEither$.MODULE$.merge$extension(either);
            });
            return Tuple3$.MODULE$.apply(preparedConnection, (Object)$1$2, timeout);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Tuple2 tuple2 = (Tuple2)tuple3._2();
                Tuple2 preparedConnection = (Tuple2)tuple3._1();
                if (tuple2 != null) {
                    BlazeConnection conn = (BlazeConnection)tuple2._1();
                    Object responseHeaderTimeoutF = tuple2._2();
                    Object timeout = tuple3._3();
                    return Resource$.MODULE$.eval(this.runRequest(conn, req, timeout)).flatMap((Function1 & Serializable)responseResource -> responseResource.map((Function1 & Serializable)response -> response));
                }
            }
            throw new MatchError((Object)tuple3);
        }));
    }

    public F defaultOnError(Request<F> req, Response<F> resp, Applicative<F> G) {
        return (F)package.all$.MODULE$.toFunctorOps(resp.body().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.F))).drain(), G).as((Object)UnexpectedStatus$.MODULE$.apply(resp.status(), req.method(), req.uri()));
    }

    private Resource<F, Tuple2<A, F>> prepareConnection(RequestKey key) {
        return this.borrowConnection(key).flatMap((Function1 & Serializable)conn -> this.addResponseHeaderTimeout(conn).map((Function1 & Serializable)responseHeaderTimeoutF -> Tuple2$.MODULE$.apply(conn, responseHeaderTimeoutF)));
    }

    private Resource<F, A> borrowConnection(RequestKey key) {
        return Resource$.MODULE$.makeCase(package.all$.MODULE$.toFunctorOps(this.manager.borrow(key), this.F).map((Function1 & Serializable)_$5 -> (BlazeConnection)_$5.connection()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                BlazeConnection blazeConnection;
                BlazeConnection conn = blazeConnection = (BlazeConnection)tuple2._1();
                if (Resource.ExitCase$.Canceled$.MODULE$.equals(tuple2._2())) {
                    return this.manager.invalidate(conn);
                }
                BlazeConnection conn2 = blazeConnection;
                return this.manager.release(conn2);
            }
            throw new MatchError((Object)tuple2);
        }, this.F);
    }

    private Resource<F, F> addResponseHeaderTimeout(A conn) {
        Duration duration = this.responseHeaderTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            return Resource$.MODULE$.apply(package.all$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(this.F), this.F).flatMap((Function1 & Serializable)timeout -> this.F.delay(() -> this.addResponseHeaderTimeout$$anonfun$1$$anonfun$1(conn, d, timeout))), this.F);
        }
        return this.resourceNeverTimeoutException;
    }

    private Resource<F, F> scheduleRequestTimeout(RequestKey key) {
        Duration duration = this.requestTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            return Resource$.MODULE$.pure(this.F.async((Function1 & Serializable)cb -> package.all$.MODULE$.toFunctorOps(this.F.delay(() -> this.scheduleRequestTimeout$$anonfun$1$$anonfun$1(key, d, cb)), this.F).map((Function1 & Serializable)c -> Some$.MODULE$.apply(this.F.delay((Function0 & Serializable)() -> {
                BlazeClient.scheduleRequestTimeout$$anonfun$1$$anonfun$2$$anonfun$1(c);
                return BoxedUnit.UNIT;
            })))));
        }
        return this.resourceNeverTimeoutException;
    }

    private F runRequest(A conn, Request<F> req, F timeout) {
        Object object = implicits$.MODULE$.genSpawnOps_(conn.runRequest(req, timeout));
        return (F)package.all$.MODULE$.toFunctorOps(GenSpawnOps_$.MODULE$.race$extension(object, package.all$.MODULE$.toFlatMapOps(timeout, this.F).flatMap((Function1 & Serializable)_$6 -> this.F.raiseError(_$6)), this.F), this.F).map((Function1 & Serializable)_$7 -> {
            Either either = Either$.MODULE$.MergeableEither(_$7);
            return (Resource)Either.MergeableEither$.MODULE$.merge$extension(either);
        });
    }

    private static final void addResponseHeaderTimeout$$anonfun$1$$anonfun$1$$anonfun$2(ResponseHeaderTimeoutStage stage$1) {
        stage$1.removeStage($less$colon$less$.MODULE$.refl());
    }

    private final Tuple2 addResponseHeaderTimeout$$anonfun$1$$anonfun$1(BlazeConnection conn$3, FiniteDuration d$2, Deferred timeout$1) {
        ResponseHeaderTimeoutStage stage = new ResponseHeaderTimeoutStage(d$2, this.scheduler, this.ec);
        conn$3.spliceBefore((MidStage)stage);
        stage.init((Function1)(JProcedure1 & Serializable)e -> this.dispatcher.unsafeRunSync(package.all$.MODULE$.toFunctorOps(timeout$1.complete(e), this.F).void()));
        Object object = package.all$.MODULE$.catsSyntaxMonadErrorRethrow(timeout$1.get(), this.F);
        return Tuple2$.MODULE$.apply(MonadErrorRethrowOps$.MODULE$.rethrow$extension(object, this.F), this.F.delay((Function0 & Serializable)() -> {
            BlazeClient.addResponseHeaderTimeout$$anonfun$1$$anonfun$1$$anonfun$2(stage);
            return BoxedUnit.UNIT;
        }));
    }

    private final Cancelable scheduleRequestTimeout$$anonfun$1$$anonfun$1(RequestKey key$2, FiniteDuration d$3, Function1 cb$1) {
        return this.scheduler.schedule(() -> cb$1.apply((Object)package$.MODULE$.Right().apply((Object)new TimeoutException(new StringBuilder(31).append("Request to ").append(key$2).append(" timed out after ").append(d$3.toMillis()).append(" ms").toString()))), this.ec, (Duration)d$3);
    }

    private static final void scheduleRequestTimeout$$anonfun$1$$anonfun$2$$anonfun$1(Cancelable c$1) {
        c$1.cancel();
    }
}

