/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.Applicative;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.std.Dispatcher;
import cats.effect.std.Dispatcher$;
import cats.effect.unsafe.IORuntime$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import javax.net.ssl.SSLContext;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.client.BlazeClient$;
import org.http4s.blaze.client.BlazeClientBuilder$;
import org.http4s.blaze.client.BlazeClientState;
import org.http4s.blaze.client.BlazeConnection;
import org.http4s.blaze.client.ConnectionBuilder;
import org.http4s.blaze.client.ConnectionManager;
import org.http4s.blaze.client.ConnectionManager$;
import org.http4s.blaze.client.Http1Support;
import org.http4s.blaze.client.ParserMode;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.BlazeBackendBuilder;
import org.http4s.blazecore.ExecutionContextConfig;
import org.http4s.client.Client;
import org.http4s.client.RequestKey;
import org.http4s.headers.User;
import org.http4s.internal.BackendBuilder;
import org.http4s.internal.SSLContextOption;
import org.log4s.package$package$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public abstract class BlazeClientBuilder<F>
implements BlazeBackendBuilder<Client<F>>,
BackendBuilder<F, Client<F>> {
    private final Duration responseHeaderTimeout;
    private final Duration idleTimeout;
    private final Duration requestTimeout;
    private final Duration connectTimeout;
    private final Option userAgent;
    private final int maxTotalConnections;
    private final int maxWaitQueueLimit;
    private final Function1 maxConnectionsPerRequestKey;
    private final SSLContextOption sslContext;
    private final boolean checkEndpointIdentification;
    private final int maxResponseLineSize;
    private final int maxHeaderLength;
    private final int maxChunkSize;
    private final int chunkBufferMaxSize;
    private final ParserMode parserMode;
    private final int bufferSize;
    private final ExecutionContextConfig executionContextConfig;
    private final Resource scheduler;
    private final Option asynchronousChannelGroup;
    private final ChannelOptions channelOptions;
    private final Option customDnsResolver;
    private final int retries;
    private final Duration maxIdleDuration;
    private final Async F;
    private final Logger logger;

    public static <F> BlazeClientBuilder<F> apply(Async<F> async) {
        return BlazeClientBuilder$.MODULE$.apply(async);
    }

    public static <F> BlazeClientBuilder<F> apply(ExecutionContext executionContext, Async<F> async) {
        return BlazeClientBuilder$.MODULE$.apply(executionContext, async);
    }

    public static Either<Throwable, InetSocketAddress> getAddress(RequestKey requestKey) {
        return BlazeClientBuilder$.MODULE$.getAddress(requestKey);
    }

    public BlazeClientBuilder(Duration responseHeaderTimeout, Duration idleTimeout, Duration requestTimeout, Duration connectTimeout, Option<User.minusAgent> userAgent, int maxTotalConnections, int maxWaitQueueLimit, Function1<RequestKey, Object> maxConnectionsPerRequestKey, SSLContextOption sslContext, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, int bufferSize, ExecutionContextConfig executionContextConfig, Resource<F, TickWheelExecutor> scheduler, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ChannelOptions channelOptions, Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> customDnsResolver, int retries, Duration maxIdleDuration, Async<F> F) {
        this.responseHeaderTimeout = responseHeaderTimeout;
        this.idleTimeout = idleTimeout;
        this.requestTimeout = requestTimeout;
        this.connectTimeout = connectTimeout;
        this.userAgent = userAgent;
        this.maxTotalConnections = maxTotalConnections;
        this.maxWaitQueueLimit = maxWaitQueueLimit;
        this.maxConnectionsPerRequestKey = maxConnectionsPerRequestKey;
        this.sslContext = sslContext;
        this.checkEndpointIdentification = checkEndpointIdentification;
        this.maxResponseLineSize = maxResponseLineSize;
        this.maxHeaderLength = maxHeaderLength;
        this.maxChunkSize = maxChunkSize;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.parserMode = parserMode;
        this.bufferSize = bufferSize;
        this.executionContextConfig = executionContextConfig;
        this.scheduler = scheduler;
        this.asynchronousChannelGroup = asynchronousChannelGroup;
        this.channelOptions = channelOptions;
        this.customDnsResolver = customDnsResolver;
        this.retries = retries;
        this.maxIdleDuration = maxIdleDuration;
        this.F = F;
        this.logger = package$package$.MODULE$.getLogger(this.getClass());
    }

    public Duration responseHeaderTimeout() {
        return this.responseHeaderTimeout;
    }

    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    public Duration requestTimeout() {
        return this.requestTimeout;
    }

    public Duration connectTimeout() {
        return this.connectTimeout;
    }

    public Option<User.minusAgent> userAgent() {
        return this.userAgent;
    }

    public int maxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int maxWaitQueueLimit() {
        return this.maxWaitQueueLimit;
    }

    public Function1<RequestKey, Object> maxConnectionsPerRequestKey() {
        return this.maxConnectionsPerRequestKey;
    }

    public SSLContextOption sslContext() {
        return this.sslContext;
    }

    public boolean checkEndpointIdentification() {
        return this.checkEndpointIdentification;
    }

    public int maxResponseLineSize() {
        return this.maxResponseLineSize;
    }

    public int maxHeaderLength() {
        return this.maxHeaderLength;
    }

    public int maxChunkSize() {
        return this.maxChunkSize;
    }

    public int chunkBufferMaxSize() {
        return this.chunkBufferMaxSize;
    }

    public ParserMode parserMode() {
        return this.parserMode;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public Resource<F, TickWheelExecutor> scheduler() {
        return this.scheduler;
    }

    public Option<AsynchronousChannelGroup> asynchronousChannelGroup() {
        return this.asynchronousChannelGroup;
    }

    public ChannelOptions channelOptions() {
        return this.channelOptions;
    }

    public Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> customDnsResolver() {
        return this.customDnsResolver;
    }

    public int retries() {
        return this.retries;
    }

    public Duration maxIdleDuration() {
        return this.maxIdleDuration;
    }

    public Async<F> F() {
        return this.F;
    }

    public final Logger logger() {
        return this.logger;
    }

    public BlazeClientBuilder(Duration responseHeaderTimeout, Duration idleTimeout, Duration requestTimeout, Duration connectTimeout, Option<User.minusAgent> userAgent, int maxTotalConnections, int maxWaitQueueLimit, Function1<RequestKey, Object> maxConnectionsPerRequestKey, SSLContextOption sslContext, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, int bufferSize, ExecutionContextConfig executionContextConfig, Resource<F, TickWheelExecutor> scheduler, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ChannelOptions channelOptions, Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> customDnsResolver, Async<F> F) {
        this(responseHeaderTimeout, idleTimeout, requestTimeout, connectTimeout, userAgent, maxTotalConnections, maxWaitQueueLimit, maxConnectionsPerRequestKey, sslContext, checkEndpointIdentification, maxResponseLineSize, maxHeaderLength, maxChunkSize, chunkBufferMaxSize, parserMode, bufferSize, executionContextConfig, scheduler, asynchronousChannelGroup, channelOptions, customDnsResolver, 0, (Duration)Duration$.MODULE$.Inf(), F);
    }

    private BlazeClientBuilder<F> copy(Duration responseHeaderTimeout, Duration idleTimeout, Duration requestTimeout, Duration connectTimeout, Option<User.minusAgent> userAgent, int maxTotalConnections, int maxWaitQueueLimit, Function1<RequestKey, Object> maxConnectionsPerRequestKey, SSLContextOption sslContext, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, int bufferSize, ExecutionContextConfig executionContextConfig, Resource<F, TickWheelExecutor> scheduler, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ChannelOptions channelOptions, Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> customDnsResolver, int retries, Duration maxIdleDuration) {
        return new BlazeClientBuilder<F>(responseHeaderTimeout, idleTimeout, requestTimeout, connectTimeout, userAgent, maxTotalConnections, maxWaitQueueLimit, maxConnectionsPerRequestKey, sslContext, checkEndpointIdentification, maxResponseLineSize, maxHeaderLength, maxChunkSize, chunkBufferMaxSize, parserMode, bufferSize, executionContextConfig, scheduler, asynchronousChannelGroup, channelOptions, customDnsResolver, retries, maxIdleDuration, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(responseHeaderTimeout$6, idleTimeout$6, requestTimeout$6, connectTimeout$6, (Option<User.minusAgent>)userAgent$6, maxTotalConnections$6, maxWaitQueueLimit$6, (Function1<RequestKey, Object>)maxConnectionsPerRequestKey$6, sslContext$6, checkEndpointIdentification$6, maxResponseLineSize$6, maxHeaderLength$6, maxChunkSize$6, chunkBufferMaxSize$6, parserMode$6, bufferSize$6, executionContextConfig$6, scheduler$6, (Option<AsynchronousChannelGroup>)asynchronousChannelGroup$6, channelOptions$6, (Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>>)customDnsResolver$6, retries$6, maxIdleDuration$6, $outer.F());
            }
        };
    }

    private Duration copy$default$1() {
        return this.responseHeaderTimeout();
    }

    private Duration copy$default$2() {
        return this.idleTimeout();
    }

    private Duration copy$default$3() {
        return this.requestTimeout();
    }

    private Duration copy$default$4() {
        return this.connectTimeout();
    }

    private Option<User.minusAgent> copy$default$5() {
        return this.userAgent();
    }

    private int copy$default$6() {
        return this.maxTotalConnections();
    }

    private int copy$default$7() {
        return this.maxWaitQueueLimit();
    }

    private Function1<RequestKey, Object> copy$default$8() {
        return this.maxConnectionsPerRequestKey();
    }

    private SSLContextOption copy$default$9() {
        return this.sslContext();
    }

    private boolean copy$default$10() {
        return this.checkEndpointIdentification();
    }

    private int copy$default$11() {
        return this.maxResponseLineSize();
    }

    private int copy$default$12() {
        return this.maxHeaderLength();
    }

    private int copy$default$13() {
        return this.maxChunkSize();
    }

    private int copy$default$14() {
        return this.chunkBufferMaxSize();
    }

    private ParserMode copy$default$15() {
        return this.parserMode();
    }

    private int copy$default$16() {
        return this.bufferSize();
    }

    private ExecutionContextConfig copy$default$17() {
        return this.executionContextConfig;
    }

    private Resource<F, TickWheelExecutor> copy$default$18() {
        return this.scheduler();
    }

    private Option<AsynchronousChannelGroup> copy$default$19() {
        return this.asynchronousChannelGroup();
    }

    private ChannelOptions copy$default$20() {
        return this.channelOptions();
    }

    private Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> copy$default$21() {
        return this.customDnsResolver();
    }

    private int copy$default$22() {
        return this.retries();
    }

    private Duration copy$default$23() {
        return this.maxIdleDuration();
    }

    public ExecutionContext executionContext() {
        return IORuntime$.MODULE$.global().compute();
    }

    public BlazeClientBuilder<F> withResponseHeaderTimeout(Duration responseHeaderTimeout) {
        return this.copy(responseHeaderTimeout, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withMaxHeaderLength(int maxHeaderLength) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), maxHeaderLength, this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withIdleTimeout(Duration idleTimeout) {
        return this.copy(this.copy$default$1(), idleTimeout, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withRequestTimeout(Duration requestTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), requestTimeout, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withConnectTimeout(Duration connectTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), connectTimeout, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withUserAgentOption(Option<User.minusAgent> userAgent) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), userAgent, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withUserAgent(User.minusAgent userAgent) {
        return this.withUserAgentOption((Option<User.minusAgent>)Some$.MODULE$.apply((Object)userAgent));
    }

    public BlazeClientBuilder<F> withoutUserAgent() {
        return this.withUserAgentOption((Option<User.minusAgent>)None$.MODULE$);
    }

    public BlazeClientBuilder<F> withMaxTotalConnections(int maxTotalConnections) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), maxTotalConnections, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withMaxWaitQueueLimit(int maxWaitQueueLimit) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), maxWaitQueueLimit, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withMaxConnectionsPerRequestKey(Function1<RequestKey, Object> maxConnectionsPerRequestKey) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), maxConnectionsPerRequestKey, this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withSslContext(SSLContext sslContext) {
        SSLContextOption.Provided provided = SSLContextOption.Provided$.MODULE$.apply(sslContext);
        Duration duration = this.copy$default$1();
        Duration duration2 = this.copy$default$2();
        Duration duration3 = this.copy$default$3();
        Duration duration4 = this.copy$default$4();
        Option<User.minusAgent> option = this.copy$default$5();
        int n = this.copy$default$6();
        int n2 = this.copy$default$7();
        Function1<RequestKey, Object> function1 = this.copy$default$8();
        boolean bl = this.copy$default$10();
        int n3 = this.copy$default$11();
        int n4 = this.copy$default$12();
        int n5 = this.copy$default$13();
        int n6 = this.copy$default$14();
        ParserMode parserMode = this.copy$default$15();
        int n7 = this.copy$default$16();
        ExecutionContextConfig executionContextConfig = this.copy$default$17();
        Resource<F, TickWheelExecutor> resource = this.copy$default$18();
        Option<AsynchronousChannelGroup> option2 = this.copy$default$19();
        ChannelOptions channelOptions = this.copy$default$20();
        Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> option3 = this.copy$default$21();
        int n8 = this.copy$default$22();
        Duration duration5 = this.copy$default$23();
        return this.copy(duration, duration2, duration3, duration4, option, n, n2, function1, (SSLContextOption)provided, bl, n3, n4, n5, n6, parserMode, n7, executionContextConfig, resource, option2, channelOptions, option3, n8, duration5);
    }

    public BlazeClientBuilder<F> withDefaultSslContext() {
        return this.withSslContext(SSLContext.getDefault());
    }

    public BlazeClientBuilder<F> withRetries(int retries) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), retries, this.copy$default$23());
    }

    public int withRetries$default$1() {
        return this.retries();
    }

    public BlazeClientBuilder<F> withMaxIdleDuration(Duration maxIdleDuration) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), maxIdleDuration);
    }

    public Duration withMaxIdleDuration$default$1() {
        return this.maxIdleDuration();
    }

    public BlazeClientBuilder<F> withSslContextOption(Option<SSLContext> sslContext2) {
        SSLContextOption sSLContextOption = (SSLContextOption)sslContext2.fold(BlazeClientBuilder::$anonfun$1, (Function1 & Serializable)sslContext -> SSLContextOption.Provided$.MODULE$.apply(sslContext));
        Duration duration = this.copy$default$1();
        Duration duration2 = this.copy$default$2();
        Duration duration3 = this.copy$default$3();
        Duration duration4 = this.copy$default$4();
        Option<User.minusAgent> option = this.copy$default$5();
        int n = this.copy$default$6();
        int n2 = this.copy$default$7();
        Function1<RequestKey, Object> function1 = this.copy$default$8();
        boolean bl = this.copy$default$10();
        int n3 = this.copy$default$11();
        int n4 = this.copy$default$12();
        int n5 = this.copy$default$13();
        int n6 = this.copy$default$14();
        ParserMode parserMode = this.copy$default$15();
        int n7 = this.copy$default$16();
        ExecutionContextConfig executionContextConfig = this.copy$default$17();
        Resource<F, TickWheelExecutor> resource = this.copy$default$18();
        Option<AsynchronousChannelGroup> option2 = this.copy$default$19();
        ChannelOptions channelOptions = this.copy$default$20();
        Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> option3 = this.copy$default$21();
        int n8 = this.copy$default$22();
        Duration duration5 = this.copy$default$23();
        return this.copy(duration, duration2, duration3, duration4, option, n, n2, function1, sSLContextOption, bl, n3, n4, n5, n6, parserMode, n7, executionContextConfig, resource, option2, channelOptions, option3, n8, duration5);
    }

    public BlazeClientBuilder<F> withoutSslContext() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), (SSLContextOption)SSLContextOption.NoSSL$.MODULE$, this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withCheckEndpointAuthentication(boolean checkEndpointIdentification) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), checkEndpointIdentification, this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withMaxResponseLineSize(int maxResponseLineSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), maxResponseLineSize, this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withMaxChunkSize(int maxChunkSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), maxChunkSize, this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withChunkBufferMaxSize(int chunkBufferMaxSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), chunkBufferMaxSize, this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withParserMode(ParserMode parserMode) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), parserMode, this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withBufferSize(int bufferSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), bufferSize, this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withExecutionContext(ExecutionContext executionContext) {
        ExecutionContextConfig.ExplicitContext explicitContext = ExecutionContextConfig.ExplicitContext$.MODULE$.apply(executionContext);
        Duration duration = this.copy$default$1();
        Duration duration2 = this.copy$default$2();
        Duration duration3 = this.copy$default$3();
        Duration duration4 = this.copy$default$4();
        Option<User.minusAgent> option = this.copy$default$5();
        int n = this.copy$default$6();
        int n2 = this.copy$default$7();
        Function1<RequestKey, Object> function1 = this.copy$default$8();
        SSLContextOption sSLContextOption = this.copy$default$9();
        boolean bl = this.copy$default$10();
        int n3 = this.copy$default$11();
        int n4 = this.copy$default$12();
        int n5 = this.copy$default$13();
        int n6 = this.copy$default$14();
        ParserMode parserMode = this.copy$default$15();
        int n7 = this.copy$default$16();
        Resource<F, TickWheelExecutor> resource = this.copy$default$18();
        Option<AsynchronousChannelGroup> option2 = this.copy$default$19();
        ChannelOptions channelOptions = this.copy$default$20();
        Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> option3 = this.copy$default$21();
        int n8 = this.copy$default$22();
        Duration duration5 = this.copy$default$23();
        return this.copy(duration, duration2, duration3, duration4, option, n, n2, function1, sSLContextOption, bl, n3, n4, n5, n6, parserMode, n7, (ExecutionContextConfig)explicitContext, resource, option2, channelOptions, option3, n8, duration5);
    }

    public BlazeClientBuilder<F> withScheduler(TickWheelExecutor scheduler) {
        TickWheelExecutor tickWheelExecutor = (TickWheelExecutor)package.all$.MODULE$.catsSyntaxApplicativeId((Object)scheduler);
        Resource resource = (Resource)ApplicativeIdOps$.MODULE$.pure$extension((Object)tickWheelExecutor, (Applicative)Resource$.MODULE$.catsEffectAsyncForResource(this.F()));
        Duration duration = this.copy$default$1();
        Duration duration2 = this.copy$default$2();
        Duration duration3 = this.copy$default$3();
        Duration duration4 = this.copy$default$4();
        Option<User.minusAgent> option = this.copy$default$5();
        int n = this.copy$default$6();
        int n2 = this.copy$default$7();
        Function1<RequestKey, Object> function1 = this.copy$default$8();
        SSLContextOption sSLContextOption = this.copy$default$9();
        boolean bl = this.copy$default$10();
        int n3 = this.copy$default$11();
        int n4 = this.copy$default$12();
        int n5 = this.copy$default$13();
        int n6 = this.copy$default$14();
        ParserMode parserMode = this.copy$default$15();
        int n7 = this.copy$default$16();
        ExecutionContextConfig executionContextConfig = this.copy$default$17();
        Option<AsynchronousChannelGroup> option2 = this.copy$default$19();
        ChannelOptions channelOptions = this.copy$default$20();
        Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>> option3 = this.copy$default$21();
        int n8 = this.copy$default$22();
        Duration duration5 = this.copy$default$23();
        return this.copy(duration, duration2, duration3, duration4, option, n, n2, function1, sSLContextOption, bl, n3, n4, n5, n6, parserMode, n7, executionContextConfig, resource, option2, channelOptions, option3, n8, duration5);
    }

    public BlazeClientBuilder<F> withAsynchronousChannelGroupOption(Option<AsynchronousChannelGroup> asynchronousChannelGroup) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), asynchronousChannelGroup, this.copy$default$20(), this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withAsynchronousChannelGroup(AsynchronousChannelGroup asynchronousChannelGroup) {
        return this.withAsynchronousChannelGroupOption((Option<AsynchronousChannelGroup>)Some$.MODULE$.apply((Object)asynchronousChannelGroup));
    }

    public BlazeClientBuilder<F> withoutAsynchronousChannelGroup() {
        return this.withAsynchronousChannelGroupOption((Option<AsynchronousChannelGroup>)None$.MODULE$);
    }

    public BlazeClientBuilder<F> withChannelOptions(ChannelOptions channelOptions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19(), channelOptions, this.copy$default$21(), this.copy$default$22(), this.copy$default$23());
    }

    public BlazeClientBuilder<F> withCustomDnsResolver(Function1<RequestKey, Either<Throwable, InetSocketAddress>> customDnsResolver) {
        Some some = Some$.MODULE$.apply(customDnsResolver);
        Duration duration = this.copy$default$1();
        Duration duration2 = this.copy$default$2();
        Duration duration3 = this.copy$default$3();
        Duration duration4 = this.copy$default$4();
        Option<User.minusAgent> option = this.copy$default$5();
        int n = this.copy$default$6();
        int n2 = this.copy$default$7();
        Function1<RequestKey, Object> function1 = this.copy$default$8();
        SSLContextOption sSLContextOption = this.copy$default$9();
        boolean bl = this.copy$default$10();
        int n3 = this.copy$default$11();
        int n4 = this.copy$default$12();
        int n5 = this.copy$default$13();
        int n6 = this.copy$default$14();
        ParserMode parserMode = this.copy$default$15();
        int n7 = this.copy$default$16();
        ExecutionContextConfig executionContextConfig = this.copy$default$17();
        Resource<F, TickWheelExecutor> resource = this.copy$default$18();
        Option<AsynchronousChannelGroup> option2 = this.copy$default$19();
        ChannelOptions channelOptions = this.copy$default$20();
        int n8 = this.copy$default$22();
        Duration duration5 = this.copy$default$23();
        return this.copy(duration, duration2, duration3, duration4, option, n, n2, function1, sSLContextOption, bl, n3, n4, n5, n6, parserMode, n7, executionContextConfig, resource, option2, channelOptions, (Option<Function1<RequestKey, Either<Throwable, InetSocketAddress>>>)some, n8, duration5);
    }

    public Resource<F, Client<F>> resource() {
        return this.resourceWithState().map((Function1 & Serializable)_$3 -> (Client)_$3._1());
    }

    public Resource<F, Tuple2<Client<F>, BlazeClientState<F>>> resourceWithState() {
        return Dispatcher$.MODULE$.parallel(this.F()).flatMap((Function1 & Serializable)dispatcher -> this.scheduler().flatMap((Function1 & Serializable)scheduler -> Resource$.MODULE$.eval(this.verifyAllTimeoutsAccuracy((TickWheelExecutor)scheduler)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Resource$.MODULE$.eval(this.verifyTimeoutRelations()).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.connectionManager((TickWheelExecutor)scheduler, (Dispatcher<F>)dispatcher, this.F()).flatMap((Function1 & Serializable)manager -> Resource$.MODULE$.eval(this.executionContextConfig.getExecutionContext(this.F())).map((Function1 & Serializable)executionContext -> {
                    Client<F> client = BlazeClient$.MODULE$.makeClient(manager, this.responseHeaderTimeout(), this.requestTimeout(), (TickWheelExecutor)scheduler, (ExecutionContext)executionContext, this.retries(), dispatcher, this.F());
                    return Tuple2$.MODULE$.apply(executionContext, client);
                }).map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        ExecutionContext executionContext = (ExecutionContext)tuple2._1();
                        Client client = (Client)tuple2._2();
                        return Tuple2$.MODULE$.apply((Object)client, manager.state());
                    }
                    throw new MatchError((Object)tuple2);
                }));
            });
        })));
    }

    private F verifyAllTimeoutsAccuracy(TickWheelExecutor scheduler) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.verifyTimeoutAccuracy(scheduler.tick(), this.responseHeaderTimeout(), "responseHeaderTimeout"), this.F()).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return package.all$.MODULE$.toFlatMapOps(this.verifyTimeoutAccuracy(scheduler.tick(), this.idleTimeout(), "idleTimeout"), this.F()).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFlatMapOps(this.verifyTimeoutAccuracy(scheduler.tick(), this.requestTimeout(), "requestTimeout"), this.F()).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return package.all$.MODULE$.toFunctorOps(this.verifyTimeoutAccuracy(scheduler.tick(), this.connectTimeout(), "connectTimeout"), this.F()).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                });
            });
        });
    }

    private F verifyTimeoutAccuracy(Duration tick, Duration timeout, String timeoutName) {
        return (F)this.F().delay((Function0 & Serializable)() -> {
            this.verifyTimeoutAccuracy$$anonfun$1(tick, timeout, timeoutName);
            return BoxedUnit.UNIT;
        });
    }

    private F verifyTimeoutRelations() {
        return (F)this.F().delay((Function0 & Serializable)() -> {
            this.verifyTimeoutRelations$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private Resource<F, ConnectionManager.Stateful<F, BlazeConnection<F>>> connectionManager(TickWheelExecutor scheduler, Dispatcher<F> dispatcher, Async<F> F) {
        ConnectionBuilder http1 = requestKey -> {
            Function1 function1 = (Function1)this.customDnsResolver().getOrElse(BlazeClientBuilder::$anonfun$4);
            return new Http1Support(this.sslContext(), this.bufferSize(), this.asynchronousChannelGroup(), this.executionContextConfig, scheduler, this.checkEndpointIdentification(), this.maxResponseLineSize(), this.maxHeaderLength(), this.maxChunkSize(), this.chunkBufferMaxSize(), this.parserMode(), this.userAgent(), this.channelOptions(), this.connectTimeout(), this.idleTimeout(), dispatcher, (Function1<RequestKey, Either<Throwable, InetSocketAddress>>)function1, F).makeClient(requestKey);
        };
        return Resource$.MODULE$.make(package.all$.MODULE$.toFlatMapOps(this.executionContextConfig.getExecutionContext(F), F).flatMap((Function1 & Serializable)executionContext -> ConnectionManager$.MODULE$.pool(http1, this.maxTotalConnections(), this.maxWaitQueueLimit(), this.maxConnectionsPerRequestKey(), this.responseHeaderTimeout(), this.requestTimeout(), (ExecutionContext)executionContext, this.maxIdleDuration(), F)), (Function1 & Serializable)_$5 -> _$5.shutdown(), F);
    }

    private static final SSLContextOption $anonfun$1() {
        return SSLContextOption.NoSSL$.MODULE$;
    }

    private final void verifyTimeoutAccuracy$$anonfun$1(Duration tick$1, Duration timeout$1, String timeoutName$1) {
        double warningThreshold = 0.1;
        double inaccuracy = tick$1.$div(timeout$1);
        if (inaccuracy > warningThreshold) {
            Logger Logger_this = this.logger();
            if (Logger_this.isWarnEnabled()) {
                Logger_this.warn(new StringBuilder(71).append("With current configuration, ").append(timeoutName$1).append(" (").append(timeout$1).append(") may be up to ").append(inaccuracy * (double)100).append("% longer than configured. ").append(new StringBuilder(94).append("If timeout accuracy is important, consider using a scheduler with a shorter tick (currently ").append(tick$1).append(").").toString()).toString());
                return;
            }
            return;
        }
    }

    private final void verifyTimeoutRelations$$anonfun$1() {
        Logger Logger_this;
        Logger Logger_this2;
        String advice = new StringBuilder(151).append("It is recommended to configure responseHeaderTimeout < requestTimeout < idleTimeout ").append("or disable some of them explicitly by setting them to Duration.Inf.").toString();
        if (this.responseHeaderTimeout().isFinite() && this.responseHeaderTimeout().$greater$eq((Object)this.requestTimeout()) && (Logger_this2 = this.logger()).isWarnEnabled()) {
            Logger_this2.warn(new StringBuilder(50).append("responseHeaderTimeout (").append(this.responseHeaderTimeout()).append(") is >= requestTimeout (").append(this.requestTimeout()).append("). ").append(advice).toString());
        }
        if (this.responseHeaderTimeout().isFinite() && this.responseHeaderTimeout().$greater$eq((Object)this.idleTimeout()) && (Logger_this = this.logger()).isWarnEnabled()) {
            Logger_this.warn(new StringBuilder(47).append("responseHeaderTimeout (").append(this.responseHeaderTimeout()).append(") is >= idleTimeout (").append(this.idleTimeout()).append("). ").append(advice).toString());
        }
        if (this.requestTimeout().isFinite() && this.requestTimeout().$greater$eq((Object)this.idleTimeout())) {
            Logger Logger_this3 = this.logger();
            if (Logger_this3.isWarnEnabled()) {
                Logger_this3.warn(new StringBuilder(40).append("requestTimeout (").append(this.requestTimeout()).append(") is >= idleTimeout (").append(this.idleTimeout()).append("). ").append(advice).toString());
                return;
            }
            return;
        }
    }

    private static final Function1 $anonfun$4() {
        return (Function1 & Serializable)_$4 -> BlazeClientBuilder$.MODULE$.getAddress((RequestKey)_$4);
    }
}

