/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.HttpVersion$;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.blaze.client.ParserMode;
import org.http4s.blaze.client.ParserMode$Lenient$;
import org.http4s.blaze.http.parser.Http1ClientParser;
import org.typelevel.ci.CIString$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class BlazeHttp1ClientParser
extends Http1ClientParser {
    private final ListBuffer<Header.Raw> headers;
    private Status status;
    private HttpVersion httpVersion;

    public BlazeHttp1ClientParser(int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, ParserMode parserMode) {
        ParserMode parserMode2 = parserMode;
        ParserMode$Lenient$ parserMode$Lenient$ = ParserMode$Lenient$.MODULE$;
        super(maxResponseLineSize, maxHeaderLength, 2048, maxChunkSize, !(parserMode2 != null ? !parserMode2.equals(parserMode$Lenient$) : parserMode$Lenient$ != null));
        this.headers = new ListBuffer();
    }

    public void reset() {
        this.headers.clear();
        this.status = null;
        this.httpVersion = null;
        super.reset();
    }

    public HttpVersion getHttpVersion() {
        if (this.httpVersion == null) {
            return HttpVersion$.MODULE$.HTTP$div1$u002E0();
        }
        return this.httpVersion;
    }

    public Option<ByteBuffer> doParseContent(ByteBuffer buffer) {
        return Option$.MODULE$.apply((Object)this.parseContent(buffer));
    }

    public List getHeaders() {
        if (this.headers.isEmpty()) {
            return Headers$.MODULE$.empty();
        }
        List hs = Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)this.headers.result(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.rawToRaw(h))}));
        this.headers.clear();
        return hs;
    }

    public Status getStatus() {
        if (this.status == null) {
            return Status$.MODULE$.InternalServerError();
        }
        return this.status;
    }

    public boolean finishedResponseLine(ByteBuffer buffer) {
        return this.responseLineComplete() || this.parseResponseLine(buffer);
    }

    public boolean finishedHeaders(ByteBuffer buffer) {
        return this.headersComplete() || this.parseHeaders(buffer);
    }

    public void submitResponseLine(int code, String reason, String scheme, int majorversion, int minorversion) {
        Either either = package.all$.MODULE$.catsSyntaxEither(Status$.MODULE$.fromInt(code));
        this.status = (Status)EitherOps$.MODULE$.valueOr$extension(either, (Function1 & Serializable)_$3 -> {
            throw _$3;
        });
        this.httpVersion = majorversion == 1 && minorversion == 1 ? HttpVersion$.MODULE$.HTTP$div1$u002E1() : (majorversion == 1 && minorversion == 0 ? HttpVersion$.MODULE$.HTTP$div1$u002E0() : (HttpVersion)HttpVersion$.MODULE$.fromVersion(majorversion, minorversion).getOrElse(BlazeHttp1ClientParser::submitResponseLine$$anonfun$2));
    }

    public boolean headerComplete(String name, String value) {
        this.headers.$plus$eq((Object)Header.Raw$.MODULE$.apply(CIString$.MODULE$.apply(name), value));
        return false;
    }

    private static final HttpVersion submitResponseLine$$anonfun$2() {
        return HttpVersion$.MODULE$.HTTP$div1$u002E0();
    }
}

