/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.effect.implicits$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Deferred$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.syntax.AsyncOps$;
import cats.effect.kernel.syntax.GenSpawnOps$;
import cats.effect.kernel.syntax.GenSpawnOps_$;
import cats.effect.std.Dispatcher;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Stream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.HttpVersion$;
import org.http4s.InvalidBodyException$;
import org.http4s.Message;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status;
import org.http4s.Uri;
import org.http4s.blaze.client.BlazeConnection;
import org.http4s.blaze.client.BlazeHttp1ClientParser;
import org.http4s.blaze.client.Http1Connection$;
import org.http4s.blaze.client.Http1Connection$Error$;
import org.http4s.blaze.client.Http1Connection$InProgressException$;
import org.http4s.blaze.client.Http1Connection$ReadActive$;
import org.http4s.blaze.client.Http1Connection$ReadIdle$;
import org.http4s.blaze.client.ParserMode;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blazecore.Http1Stage;
import org.http4s.blazecore.Http1Stage$;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.blazecore.util.Http1Writer;
import org.http4s.client.RequestKey;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Host;
import org.http4s.headers.Host$;
import org.http4s.headers.User;
import org.http4s.headers.User$minusAgent$;
import org.http4s.package$;
import org.http4s.util.StringWriter;
import org.http4s.util.Writer;
import org.slf4j.Logger;
import org.typelevel.vault.InsertKey;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class Http1Connection<F>
implements Http1Stage<F>,
BlazeConnection<F> {
    private Some org$http4s$blazecore$Http1Stage$$shutdownCancelToken;
    private Logger logger;
    private Head _prevStage;
    private final RequestKey requestKey;
    private final ExecutionContext executionContext;
    private final int chunkBufferMaxSize;
    private final Option<User.minusAgent> userAgent;
    private final Option<IdleTimeoutStage<ByteBuffer>> idleTimeoutStage;
    private final Dispatcher dispatcher;
    private final Async F;
    private final BlazeHttp1ClientParser parser;
    private final AtomicReference<State> stageState;
    private final Deferred<F, BoxedUnit> closed;
    private final Some<F> shutdownCancelToken;

    public Http1Connection(RequestKey requestKey, ExecutionContext executionContext, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, Option<User.minusAgent> userAgent, Option<IdleTimeoutStage<ByteBuffer>> idleTimeoutStage, Dispatcher<F> dispatcher, Async<F> F) {
        this.requestKey = requestKey;
        this.executionContext = executionContext;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.userAgent = userAgent;
        this.idleTimeoutStage = idleTimeoutStage;
        this.dispatcher = dispatcher;
        this.F = F;
        Http1Stage.$init$((Http1Stage)this);
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        this.parser = new BlazeHttp1ClientParser(maxResponseLineSize, maxHeaderLength, maxChunkSize, parserMode);
        this.stageState = new AtomicReference<ReadIdle>(Http1Connection$ReadIdle$.MODULE$.apply((Option<Future<ByteBuffer>>)None$.MODULE$));
        this.closed = Deferred$.MODULE$.unsafe(F);
        this.shutdownCancelToken = Some$.MODULE$.apply(F.delay((Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        }));
        Statics.releaseFence();
    }

    public Some org$http4s$blazecore$Http1Stage$$shutdownCancelToken() {
        return this.org$http4s$blazecore$Http1Stage$$shutdownCancelToken;
    }

    public void org$http4s$blazecore$Http1Stage$_setter_$org$http4s$blazecore$Http1Stage$$shutdownCancelToken_$eq(Some x$0) {
        this.org$http4s$blazecore$Http1Stage$$shutdownCancelToken = x$0;
    }

    public final Logger logger() {
        return this.logger;
    }

    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Head _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    @Override
    public RequestKey requestKey() {
        return this.requestKey;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public int chunkBufferMaxSize() {
        return this.chunkBufferMaxSize;
    }

    public Dispatcher<F> dispatcher() {
        return this.dispatcher;
    }

    public Async<F> F() {
        return this.F;
    }

    public String name() {
        return this.getClass().getName();
    }

    @Override
    public boolean isClosed() {
        State state = this.stageState.get();
        if (state instanceof Error) {
            Error error = Http1Connection$Error$.MODULE$.unapply((Error)state);
            Throwable throwable = error._1();
            return true;
        }
        return false;
    }

    @Override
    public F isRecyclable() {
        return (F)this.F().delay(this::isRecyclable$$anonfun$1);
    }

    @Override
    public void shutdown() {
        this.stageShutdown();
    }

    public void stageShutdown() {
        this.org$http4s$blaze$client$Http1Connection$$shutdownWithError((Throwable)Command.EOF$.MODULE$);
    }

    public void fatalError(Throwable t, String msg) {
        Object object;
        Throwable throwable = t;
        if (throwable instanceof TimeoutException) {
            object = Command.EOF$.MODULE$;
        } else if (Command.EOF$.MODULE$.equals(throwable)) {
            object = Command.EOF$.MODULE$;
        } else {
            Throwable t2 = throwable;
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error(new StringBuilder(13).append("Fatal Error: ").append(msg).toString(), t2);
            }
            object = t2;
        }
        Command.EOF$ realErr = object;
        this.org$http4s$blaze$client$Http1Connection$$shutdownWithError((Throwable)realErr);
    }

    public void org$http4s$blaze$client$Http1Connection$$shutdownWithError(Throwable t) {
        while (true) {
            State state;
            if ((state = this.stageState.get()) instanceof Error) {
                Error error = (Error)state;
                Error error2 = Http1Connection$Error$.MODULE$.unapply(error);
                Throwable throwable = error2._1();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    Error st = error;
                    Throwable throwable2 = t;
                    Command.EOF$ eOF$ = Command.EOF$.MODULE$;
                    if (throwable2 == null ? eOF$ != null : !throwable2.equals(eOF$)) {
                        if (!this.stageState.compareAndSet(st, Http1Connection$Error$.MODULE$.apply(t))) continue;
                        this.closePipeline((Option)Some$.MODULE$.apply((Object)t));
                        return;
                    }
                }
                return;
            }
            State x = state;
            if (this.stageState.compareAndSet(x, Http1Connection$Error$.MODULE$.apply(t))) break;
        }
        Throwable throwable = t;
        None$ cmd = Command.EOF$.MODULE$.equals(throwable) ? None$.MODULE$ : Some$.MODULE$.apply((Object)t);
        this.closePipeline((Option)cmd);
        Stage.stageShutdown$((Stage)this);
        this.dispatcher().unsafeRunAndForget(this.closed.complete((Object)BoxedUnit.UNIT));
    }

    public void resetRead() {
        None$ none$;
        block4: {
            ReadIdle n;
            State state;
            do {
                None$ nextState;
                None$ none$2;
                State state2;
                if (Http1Connection$ReadActive$.MODULE$.equals(state2 = (state = this.stageState.get()))) {
                    this.idleTimeoutStage.foreach((Function1)(JProcedure1 & Serializable)_$2 -> _$2.cancelTimeout());
                    none$2 = Some$.MODULE$.apply((Object)Http1Connection$ReadIdle$.MODULE$.apply((Option<Future<ByteBuffer>>)Some$.MODULE$.apply(this.startIdleRead())));
                } else {
                    none$2 = None$.MODULE$;
                }
                none$ = nextState = none$2;
                if (!(none$ instanceof Some)) break block4;
            } while (!this.stageState.compareAndSet(state, n = (ReadIdle)((Some)none$).value()));
            this.parser.reset();
            return;
        }
        if (None$.MODULE$.equals(none$)) {
            return;
        }
        throw new MatchError((Object)none$);
    }

    private Future<ByteBuffer> startIdleRead() {
        Future f = this.channelRead(this.channelRead$default$1(), this.channelRead$default$2());
        f.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                this.org$http4s$blaze$client$Http1Connection$$shutdownWithError(t);
                return;
            }
        }, this.executionContext());
        return f;
    }

    @Override
    public F runRequest(Request<F> req, F cancellation) {
        return (F)this.F().defer(() -> this.runRequest$$anonfun$1(req, cancellation));
    }

    public Option<ByteBuffer> doParseContent(ByteBuffer buffer) {
        return this.parser.doParseContent(buffer);
    }

    public boolean contentComplete() {
        return this.parser.contentComplete();
    }

    private F executeRequest(Request<F> req, F cancellation, Option<Future<ByteBuffer>> idleRead) {
        Either<Exception, Request<F>> either;
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(20).append("Beginning request: ").append(req.method()).append(" ").append(req.uri()).toString());
        }
        if ((either = this.validateRequest(req)) instanceof Left) {
            Exception e = (Exception)((Left)either).value();
            return (F)this.F().raiseError((Object)e);
        }
        if (either instanceof Right) {
            Request req2 = (Request)((Right)either).value();
            Object object = package.all$.MODULE$.catsSyntaxMonadError(this.F().defer(() -> this.executeRequest$$anonfun$1(cancellation, idleRead, req2)), this.F());
            return (F)MonadErrorOps$.MODULE$.adaptError$extension(object, (PartialFunction)new Serializable(this){
                private final /* synthetic */ Http1Connection $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return Command.EOF$.MODULE$.equals(throwable);
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (Command.EOF$.MODULE$.equals(throwable)) {
                        return new SocketException(new StringBuilder(24).append("HTTP connection closed: ").append(this.$outer.requestKey()).toString());
                    }
                    return function1.apply((Object)x);
                }
            }, this.F());
        }
        throw new MatchError(either);
    }

    private F receiveResponse(boolean closeOnFinish, boolean doesntHaveBody, F idleTimeoutS, Option<Future<ByteBuffer>> idleRead) {
        return (F)this.F().async((Function1 & Serializable)cb -> this.F().delay(() -> this.receiveResponse$$anonfun$1$$anonfun$1(closeOnFinish, doesntHaveBody, idleTimeoutS, idleRead, cb)));
    }

    private void readAndParsePrelude(Function1<Either<Throwable, Response<F>>, BoxedUnit> cb, boolean closeOnFinish, boolean doesntHaveBody, String phase, F idleTimeoutS) {
        this.handleRead((Future<ByteBuffer>)this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()), cb, closeOnFinish, doesntHaveBody, phase, idleTimeoutS);
    }

    private void handleRead(Future<ByteBuffer> read, Function1<Either<Throwable, Response<F>>, BoxedUnit> cb, boolean closeOnFinish, boolean doesntHaveBody, String phase, F idleTimeoutS) {
        read.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                ByteBuffer buff = (ByteBuffer)((Success)try_).value();
                this.parsePrelude(buff, closeOnFinish, doesntHaveBody, cb, idleTimeoutS);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    State state = this.stageState.get();
                    if (state instanceof Error) {
                        Throwable throwable2;
                        Error error = Http1Connection$Error$.MODULE$.unapply((Error)state);
                        Throwable e = throwable2 = error._1();
                        cb.apply((Object)scala.package$.MODULE$.Left().apply((Object)e));
                        return;
                    }
                    this.shutdown();
                    cb.apply((Object)scala.package$.MODULE$.Left().apply((Object)Command.EOF$.MODULE$));
                    return;
                }
                Throwable t = throwable;
                this.fatalError(t, new StringBuilder(20).append("Error during phase: ").append(phase).toString());
                cb.apply((Object)scala.package$.MODULE$.Left().apply((Object)t));
                return;
            }
            throw new MatchError((Object)try_);
        }, this.executionContext());
    }

    private void parsePrelude(ByteBuffer buffer, boolean closeOnFinish, boolean doesntHaveBody, Function1<Either<Throwable, Response<F>>, BoxedUnit> cb, F idleTimeoutS) {
        block5: {
            try {
                if (!this.parser.finishedResponseLine(buffer)) {
                    this.readAndParsePrelude(cb, closeOnFinish, doesntHaveBody, "Response Line Parsing", idleTimeoutS);
                    break block5;
                }
                if (!this.parser.finishedHeaders(buffer)) {
                    this.readAndParsePrelude(cb, closeOnFinish, doesntHaveBody, "Header Parsing", idleTimeoutS);
                    break block5;
                }
                this.parsePreludeFinished(buffer, closeOnFinish, doesntHaveBody, cb, idleTimeoutS);
            }
            catch (Throwable t) {
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Error during client request decode loop", t);
                }
                cb.apply((Object)scala.package$.MODULE$.Left().apply((Object)t));
            }
        }
    }

    private void parsePreludeFinished(ByteBuffer buffer, boolean closeOnFinish, boolean doesntHaveBody, Function1<Either<Throwable, Response<F>>, BoxedUnit> cb, F idleTimeoutS) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        List headers = this.parser.getHeaders();
        Status status = this.parser.getStatus();
        HttpVersion httpVersion = this.parser.getHttpVersion();
        if (doesntHaveBody) {
            this.cleanUpAfterReceivingResponse(closeOnFinish, headers);
            tuple22 = Tuple2$.MODULE$.apply((Object)Vault$.MODULE$.empty(), (Object)package$.MODULE$.EmptyBody());
        } else {
            Tuple2 tuple23;
            Tuple2 tuple24;
            Tuple2 tuple25 = this.collectBodyFromParser(buffer, (Function0 & Serializable)() -> this.onEofWhileReadingBody());
            if (!(tuple25 instanceof Tuple2)) {
                throw new MatchError((Object)tuple25);
            }
            Stream rawBody = (Stream)tuple25._1();
            Stream rawBody2 = rawBody;
            if (this.parser.getHttpVersion().minor() == 1 && this.parser.isChunked()) {
                AtomicReference<Headers> trailers = new AtomicReference<Headers>(new Headers(Headers$.MODULE$.empty()));
                Vault attrs = Vault$.MODULE$.empty().insert((InsertKey)Message.Keys$.MODULE$.TrailerHeaders(), this.F().defer(() -> this.$anonfun$6(trailers)));
                tuple24 = Tuple2$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> trailers.set(new Headers(this.parser.getHeaders())), (Object)attrs);
            } else {
                tuple24 = tuple23 = Tuple2$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> {}, (Object)Vault$.MODULE$.empty());
            }
            if (!(tuple23 instanceof Tuple2)) {
                throw new MatchError((Object)tuple23);
            }
            Tuple2 tuple26 = tuple23;
            Function0 trailerCleanup = (Function0)tuple26._1();
            Vault attributes = (Vault)tuple26._2();
            Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)trailerCleanup, (Object)attributes);
            Function0 trailerCleanup2 = (Function0)tuple27._1();
            Vault attributes2 = (Vault)tuple27._2();
            if (this.parser.contentComplete()) {
                trailerCleanup2.apply$mcV$sp();
                this.cleanUpAfterReceivingResponse(closeOnFinish, headers);
                Vault vault = (Vault)Predef$.MODULE$.ArrowAssoc((Object)attributes2);
                tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vault, (Object)rawBody2);
            } else {
                Vault vault = (Vault)Predef$.MODULE$.ArrowAssoc((Object)attributes2);
                tuple22 = tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)vault, (Object)rawBody2.onFinalizeCaseWeak((Function1 & Serializable)x$1 -> {
                    Resource.ExitCase exitCase;
                    block6: {
                        block5: {
                            block4: {
                                exitCase = x$1;
                                if (Resource.ExitCase$.Succeeded$.MODULE$.equals(exitCase)) {
                                    Object object = implicits$.MODULE$.asyncOps(this.F().delay((Function0 & Serializable)() -> {
                                        this.$anonfun$9$$anonfun$1(closeOnFinish, headers, trailerCleanup2);
                                        return BoxedUnit.UNIT;
                                    }));
                                    return AsyncOps$.MODULE$.evalOn$extension(object, this.executionContext(), this.F());
                                }
                                if (!(exitCase instanceof Resource.ExitCase$.Errored)) break block4;
                                Resource.ExitCase$.Errored errored = Resource.ExitCase$.Errored$.MODULE$.unapply((Resource.ExitCase$.Errored)exitCase);
                                Throwable throwable = errored._1();
                                break block5;
                            }
                            if (!Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) break block6;
                        }
                        Object object = implicits$.MODULE$.asyncOps(this.F().delay((Function0 & Serializable)() -> {
                            this.$anonfun$9$$anonfun$2(closeOnFinish, headers, trailerCleanup2);
                            return BoxedUnit.UNIT;
                        }));
                        return AsyncOps$.MODULE$.evalOn$extension(object, this.executionContext(), this.F());
                    }
                    throw new MatchError((Object)exitCase);
                }, this.F()));
            }
        }
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple28 = tuple2;
        Vault attributes = (Vault)tuple28._1();
        Stream body = (Stream)tuple28._2();
        Tuple2 tuple29 = Tuple2$.MODULE$.apply((Object)attributes, (Object)body);
        Vault attributes3 = (Vault)tuple29._1();
        Stream body2 = (Stream)tuple29._2();
        cb.apply((Object)scala.package$.MODULE$.Right().apply((Object)Response$.MODULE$.apply(status, httpVersion, headers, body2.interruptWhen(idleTimeoutS), attributes3)));
    }

    private Either<Throwable, Option<Chunk<Object>>> onEofWhileReadingBody() {
        State state = this.stageState.get();
        if (state instanceof Error) {
            Throwable throwable;
            Throwable e;
            Error error = Http1Connection$Error$.MODULE$.unapply((Error)state);
            Throwable throwable2 = e = (throwable = error._1());
            Command.EOF$ eOF$ = Command.EOF$.MODULE$;
            if (throwable2 == null ? eOF$ != null : !throwable2.equals(eOF$)) {
                return EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)e);
            }
        }
        if (this.parser.definedContentLength() || this.parser.isChunked()) {
            return EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)InvalidBodyException$.MODULE$.apply("Received premature EOF."));
        }
        return EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(scala.package$.MODULE$.Either()), (Object)None$.MODULE$);
    }

    private void cleanUpAfterReceivingResponse(boolean closeOnFinish, List headers) {
        if (closeOnFinish || Headers$.MODULE$.get$extension(headers, Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).exists((Function1 & Serializable)_$6 -> _$6.hasClose())) {
            Logger Logger_this = this.logger();
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("Message body complete. Shutting down.");
            }
            this.stageShutdown();
            return;
        }
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(36).append("Resetting ").append(this.name()).append(" after completing request.").toString());
        }
        this.resetRead();
    }

    private Either<Exception, Request<F>> validateRequest(Request<F> req) {
        block10: {
            Option option;
            block11: {
                while (true) {
                    int minor;
                    int n;
                    if (0 == (n = (minor = Http1Connection$.MODULE$.org$http4s$blaze$client$Http1Connection$$$getHttpMinor(req))) && !Headers$.MODULE$.contains$extension(req.headers(), Content$minusLength$.MODULE$.headerInstance())) {
                        Logger Logger_this = this.logger();
                        if (Logger_this.isWarnEnabled()) {
                            Logger_this.warn(new StringBuilder(72).append("Request ").append(req).append(" is HTTP/1.0 but lacks a length header. Transforming to HTTP/1.1").toString());
                        }
                        req = (Request)req.withHttpVersion(HttpVersion$.MODULE$.HTTP$div1$u002E1());
                        continue;
                    }
                    if (1 != n || !req.uri().host().isEmpty()) break block10;
                    option = Headers$.MODULE$.get$extension(req.headers(), Header.Select$.MODULE$.singleHeaders(Host$.MODULE$.headerInstance()));
                    if (option instanceof Some) {
                        Uri.Authority authority;
                        Host host = (Host)((Some)option).value();
                        Option option2 = req.uri().authority();
                        if (option2 instanceof Some) {
                            Uri.Authority auth = (Uri.Authority)((Some)option2).value();
                            Uri.RegName regName = Uri.RegName$.MODULE$.apply(host.host());
                            Option option3 = auth.copy$default$1();
                            authority = auth.copy(option3, (Uri.Host)regName, host.port());
                        } else if (None$.MODULE$.equals(option2)) {
                            Uri.RegName regName = Uri.RegName$.MODULE$.apply(host.host());
                            Option option4 = Uri.Authority$.MODULE$.$lessinit$greater$default$1();
                            authority = Uri.Authority$.MODULE$.apply(option4, (Uri.Host)regName, host.port());
                        } else {
                            throw new MatchError((Object)option2);
                        }
                        Uri.Authority newAuth = authority;
                        Some some = Some$.MODULE$.apply((Object)newAuth);
                        Option option5 = req.uri().copy$default$1();
                        Uri.Path path = req.uri().copy$default$3();
                        Query query = req.uri().copy$default$4();
                        Option option6 = req.uri().copy$default$5();
                        req = req.withUri(req.uri().copy(option5, (Option)some, path, query, option6));
                        continue;
                    }
                    if (!None$.MODULE$.equals(option)) break block11;
                    if (!Headers$.MODULE$.contains$extension(req.headers(), Content$minusLength$.MODULE$.headerInstance())) break;
                    req = (Request)req.withHttpVersion(HttpVersion$.MODULE$.HTTP$div1$u002E0());
                }
                return scala.package$.MODULE$.Left().apply((Object)new IllegalArgumentException("Host header required for HTTP/1.1 request"));
            }
            throw new MatchError((Object)option);
        }
        Uri.Path path = req.uri().path();
        Uri.Path path2 = Uri.Path$.MODULE$.empty();
        if (!(path != null ? !path.equals(path2) : path2 != null)) {
            Uri.Path path3 = Uri.Path$.MODULE$.Root();
            Option option = req.uri().copy$default$1();
            Option option7 = req.uri().copy$default$2();
            Query query = req.uri().copy$default$4();
            Option option8 = req.uri().copy$default$5();
            return scala.package$.MODULE$.Right().apply((Object)req.withUri(req.uri().copy(option, option7, path3, query, option8)));
        }
        if (StringOps$.MODULE$.exists$extension(Predef$.MODULE$.augmentString(req.uri().path().renderString()), (Function1)Http1Connection$.org$http4s$blaze$client$Http1Connection$$$ForbiddenUriCharacters)) {
            return scala.package$.MODULE$.Left().apply((Object)new IllegalArgumentException(new StringBuilder(18).append("Invalid URI path: ").append(req.uri().path()).toString()));
        }
        return scala.package$.MODULE$.Right().apply((Object)req);
    }

    private Http1Writer<F> getChunkEncoder(Request<F> req, boolean closeHeader, StringWriter rr) {
        return this.getEncoder(req, rr, Http1Connection$.MODULE$.org$http4s$blaze$client$Http1Connection$$$getHttpMinor(req), closeHeader);
    }

    private final void $init$$$anonfun$1() {
        this.stageShutdown();
    }

    private final boolean isRecyclable$$anonfun$1() {
        State state = this.stageState.get();
        if (state instanceof ReadIdle) {
            ReadIdle readIdle = Http1Connection$ReadIdle$.MODULE$.unapply((ReadIdle)state);
            Option<Future<ByteBuffer>> option = readIdle._1();
            return true;
        }
        return false;
    }

    private final Object runRequest$$anonfun$1(Request req$1, Object cancellation$1) {
        State state = this.stageState.get();
        if (state instanceof ReadIdle) {
            Option<Future<ByteBuffer>> option;
            ReadIdle readIdle = (ReadIdle)state;
            ReadIdle readIdle2 = Http1Connection$ReadIdle$.MODULE$.unapply(readIdle);
            Option<Future<ByteBuffer>> idleRead = option = readIdle2._1();
            ReadIdle i = readIdle;
            if (this.stageState.compareAndSet(i, Http1Connection$ReadActive$.MODULE$)) {
                Logger Logger_this = this.logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug("Connection was idle. Running.");
                }
                return this.executeRequest(req$1, cancellation$1, idleRead);
            }
            Logger Logger_this = this.logger();
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("Connection changed state since checking it was idle. Looping.");
            }
            return this.runRequest(req$1, cancellation$1);
        }
        if (Http1Connection$ReadActive$.MODULE$.equals(state)) {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Tried to run a request already in running state.");
            }
            return this.F().raiseError((Object)Http1Connection$InProgressException$.MODULE$);
        }
        if (state instanceof Error) {
            Throwable throwable;
            Error error = Http1Connection$Error$.MODULE$.unapply((Error)state);
            Throwable e = throwable = error._1();
            Logger Logger_this = this.logger();
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(46).append("Tried to run a request in closed/error state: ").append(e).toString());
            }
            return this.F().raiseError((Object)e);
        }
        throw new MatchError((Object)state);
    }

    private static final void $anonfun$2$$anonfun$1(IdleTimeoutStage stage$2, Function1 cb$1) {
        stage$2.setTimeout(cb$1);
    }

    private static final void $anonfun$2$$anonfun$2(IdleTimeoutStage stage$3) {
        stage$3.cancelTimeout();
    }

    private final Object executeRequest$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Fiber writeFiber$3) {
        Object object = implicits$.MODULE$.genSpawnOps(writeFiber$3.cancel(), this.F());
        return GenSpawnOps$.MODULE$.start$extension(object, this.F());
    }

    private final void executeRequest$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1() {
        this.shutdown();
    }

    private final void executeRequest$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(Throwable e$1) {
        this.org$http4s$blaze$client$Http1Connection$$shutdownWithError(e$1);
    }

    private final Object executeRequest$$anonfun$1(Object cancellation$2, Option idleRead$1, Request req$2) {
        Object object;
        boolean bl;
        Option option;
        int initWriterSize = 512;
        StringWriter rr = new StringWriter(initWriterSize);
        boolean isServer = false;
        Http1Connection$.MODULE$.org$http4s$blaze$client$Http1Connection$$$encodeRequestLine(req$2, (Writer)rr);
        Http1Stage$.MODULE$.encodeHeaders((Iterable)req$2.headers(), (Writer)rr, isServer);
        if (this.userAgent.nonEmpty() && !Headers$.MODULE$.contains$extension(req$2.headers(), User$minusAgent$.MODULE$.headerInstance())) {
            rr.$less$less(this.userAgent.get(), User$minusAgent$.MODULE$.convert(Header.Select$.MODULE$.singleHeaders(User$minusAgent$.MODULE$.headerInstance()))).$less$less("\r\n");
        }
        if ((option = Headers$.MODULE$.get$extension(req$2.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance()))) instanceof Some) {
            Connection conn = (Connection)((Some)option).value();
            bl = this.checkCloseConnection(conn, rr);
        } else if (None$.MODULE$.equals(option)) {
            bl = Http1Connection$.MODULE$.org$http4s$blaze$client$Http1Connection$$$getHttpMinor(req$2) == 0;
        } else {
            throw new MatchError((Object)option);
        }
        boolean mustClose = bl;
        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(this.getChunkEncoder(req$2, mustClose, rr).write(rr, req$2.body()), this.F());
        Object writeRequest = ApplicativeErrorOps$.MODULE$.onError$extension(object2, (PartialFunction)new Serializable(this){
            private final /* synthetic */ Http1Connection $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    return true;
                }
                Throwable t = throwable;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    return this.$outer.F().delay((Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$1();
                        return BoxedUnit.UNIT;
                    });
                }
                Throwable t = throwable;
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.$outer.F().delay((Function0 & Serializable)() -> {
                    this.applyOrElse$$anonfun$2(t);
                    return BoxedUnit.UNIT;
                }), this.$outer.F());
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.applyOrElse$$anonfun$3(t), this.$outer.F());
            }

            private final void applyOrElse$$anonfun$1() {
                this.$outer.org$http4s$blaze$client$Http1Connection$$shutdownWithError((Throwable)Command.EOF$.MODULE$);
            }

            private final void applyOrElse$$anonfun$2(Throwable t$1) {
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Error rendering request", t$1);
                    return;
                }
            }

            private final void applyOrElse$$anonfun$3$$anonfun$1(Throwable t$3) {
                this.$outer.org$http4s$blaze$client$Http1Connection$$shutdownWithError(t$3);
            }

            private final Object applyOrElse$$anonfun$3(Throwable t$2) {
                return this.$outer.F().delay((Function0 & Serializable)() -> {
                    this.applyOrElse$$anonfun$3$$anonfun$1(t$2);
                    return BoxedUnit.UNIT;
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$adapted$1(), $anonfun$adapted$1(java.lang.Throwable ), applyOrElse$$anonfun$3(java.lang.Throwable ), applyOrElse$$anonfun$3$$anonfun$adapted$1(java.lang.Throwable )}, serializedLambda);
            }
        }, this.F());
        Option<IdleTimeoutStage<ByteBuffer>> option2 = this.idleTimeoutStage;
        if (option2 instanceof Some) {
            IdleTimeoutStage stage = (IdleTimeoutStage)((Some)option2).value();
            object = this.F().async((Function1 & Serializable)cb -> package.all$.MODULE$.toFunctorOps(this.F().delay((Function0 & Serializable)() -> {
                Http1Connection.$anonfun$2$$anonfun$1(stage, cb);
                return BoxedUnit.UNIT;
            }), this.F()).as((Object)Some$.MODULE$.apply(this.F().delay((Function0 & Serializable)() -> {
                Http1Connection.$anonfun$2$$anonfun$2(stage);
                return BoxedUnit.UNIT;
            }))));
        } else if (None$.MODULE$.equals(option2)) {
            object = this.F().never();
        } else {
            throw new MatchError(option2);
        }
        Object idleTimeoutF = object;
        Object object3 = implicits$.MODULE$.genSpawnOps(idleTimeoutF, this.F());
        return package.all$.MODULE$.toFlatMapOps(GenSpawnOps$.MODULE$.start$extension(object3, this.F()), this.F()).flatMap((Function1 & Serializable)timeoutFiber -> {
            Object object = implicits$.MODULE$.genSpawnOps_(cancellation$2);
            Object mergedTimeouts = package.all$.MODULE$.toFunctorOps(GenSpawnOps_$.MODULE$.race$extension(object, timeoutFiber.joinWithNever(this.F()), this.F()), this.F()).map((Function1 & Serializable)_$3 -> {
                Either either = Either$.MODULE$.MergeableEither(_$3);
                return (TimeoutException)Either.MergeableEither$.MODULE$.merge$extension(either);
            });
            Object object2 = implicits$.MODULE$.genSpawnOps(writeRequest, this.F());
            Object object3 = implicits$.MODULE$.genSpawnOps_(this.F().bracketCase(GenSpawnOps$.MODULE$.start$extension(object2, this.F()), (Function1 & Serializable)writeFiber -> {
                Method method = req$2.method();
                Method method2 = Method$.MODULE$.HEAD();
                return package.all$.MODULE$.toFunctorOps(this.receiveResponse(mustClose, !(method != null ? !method.equals(method2) : method2 != null), package.all$.MODULE$.toFunctorOps(mergedTimeouts, this.F()).map((Function1 & Serializable)_$4 -> scala.package$.MODULE$.Left().apply(_$4)), (Option<Future<ByteBuffer>>)idleRead$1), this.F()).map((Function1 & Serializable)response -> Resource$.MODULE$.make(this.F().pure(response), (Function1 & Serializable)_$5 -> {
                    Object object = package.all$.MODULE$.catsSyntaxApplicativeError(writeFiber.join(), this.F());
                    Object object2 = implicits$.MODULE$.genSpawnOps_(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F()));
                    Object object3 = package.all$.MODULE$.catsSyntaxFlatMapOps(this.closed.get(), this.F());
                    return package.all$.MODULE$.toFunctorOps(GenSpawnOps_$.MODULE$.race$extension(object2, FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> this.executeRequest$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(writeFiber), this.F()), this.F()), this.F()).void();
                }, this.F()));
            }, (Function2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Outcome outcome = (Outcome)tuple2._2();
                    if (outcome instanceof Outcome.Succeeded) {
                        Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                        Object object = succeeded._1();
                        return this.F().unit();
                    }
                    if (outcome instanceof Outcome.Canceled && Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                        return this.F().delay((Function0 & Serializable)() -> {
                            this.executeRequest$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1();
                            return BoxedUnit.UNIT;
                        });
                    }
                    if (outcome instanceof Outcome.Errored) {
                        Throwable throwable;
                        Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                        Throwable e = throwable = (Throwable)errored._1();
                        return this.F().delay((Function0 & Serializable)() -> {
                            this.executeRequest$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(e);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                throw new MatchError((Object)tuple2);
            }));
            return package.all$.MODULE$.toFlatMapOps(GenSpawnOps_$.MODULE$.race$extension(object3, mergedTimeouts, this.F()), this.F()).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Resource r = (Resource)((Left)either).value();
                    return this.F().pure((Object)r);
                }
                if (either instanceof Right) {
                    TimeoutException t = (TimeoutException)((Right)either).value();
                    return this.F().raiseError((Object)t);
                }
                throw new MatchError((Object)either);
            });
        });
    }

    private final Future $anonfun$4() {
        return this.channelRead(this.channelRead$default$1(), this.channelRead$default$2());
    }

    private final Option receiveResponse$$anonfun$1$$anonfun$1(boolean closeOnFinish$2, boolean doesntHaveBody$2, Object idleTimeoutS$2, Option idleRead$5, Function1 cb$2) {
        Future read = (Future)idleRead$5.getOrElse(this::$anonfun$4);
        this.handleRead((Future<ByteBuffer>)read, cb$2, closeOnFinish$2, doesntHaveBody$2, "Initial Read", idleTimeoutS$2);
        return this.shutdownCancelToken;
    }

    private final Object $anonfun$6(AtomicReference trailers$1) {
        if (this.parser.contentComplete()) {
            return this.F().pure(trailers$1.get());
        }
        return this.F().raiseError((Object)new IllegalStateException("Attempted to collect trailers before the body was complete."));
    }

    private final void $anonfun$9$$anonfun$1(boolean closeOnFinish$5, List headers$2, Function0 trailerCleanup$2) {
        trailerCleanup$2.apply$mcV$sp();
        this.cleanUpAfterReceivingResponse(closeOnFinish$5, headers$2);
    }

    private final void $anonfun$9$$anonfun$2(boolean closeOnFinish$6, List headers$3, Function0 trailerCleanup$3) {
        trailerCleanup$3.apply$mcV$sp();
        this.cleanUpAfterReceivingResponse(closeOnFinish$6, headers$3);
        this.stageShutdown();
    }

    public static final class Error
    implements State,
    Product,
    Serializable {
        private final Throwable exc;

        public static Error apply(Throwable throwable) {
            return Http1Connection$Error$.MODULE$.apply(throwable);
        }

        public static Error fromProduct(Product product) {
            return Http1Connection$Error$.MODULE$.fromProduct(product);
        }

        public static Error unapply(Error error) {
            return Http1Connection$Error$.MODULE$.unapply(error);
        }

        public Error(Throwable exc) {
            this.exc = exc;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Error)) return false;
            Error error = (Error)object;
            Throwable throwable = this.exc();
            Throwable throwable2 = error.exc();
            if (throwable != null) {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
            if (throwable2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Error;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Error";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "exc";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Throwable exc() {
            return this.exc;
        }

        public Error copy(Throwable exc) {
            return new Error(exc);
        }

        public Throwable copy$default$1() {
            return this.exc();
        }

        public Throwable _1() {
            return this.exc();
        }
    }

    public static final class ReadIdle
    implements State,
    Product,
    Serializable {
        private final Option idleRead;

        public static ReadIdle apply(Option<Future<ByteBuffer>> option) {
            return Http1Connection$ReadIdle$.MODULE$.apply(option);
        }

        public static ReadIdle fromProduct(Product product) {
            return Http1Connection$ReadIdle$.MODULE$.fromProduct(product);
        }

        public static ReadIdle unapply(ReadIdle readIdle) {
            return Http1Connection$ReadIdle$.MODULE$.unapply(readIdle);
        }

        public ReadIdle(Option<Future<ByteBuffer>> idleRead) {
            this.idleRead = idleRead;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReadIdle)) return false;
            ReadIdle readIdle = (ReadIdle)object;
            Option<Future<ByteBuffer>> option = this.idleRead();
            Option<Future<ByteBuffer>> option2 = readIdle.idleRead();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReadIdle;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReadIdle";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "idleRead";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Future<ByteBuffer>> idleRead() {
            return this.idleRead;
        }

        public ReadIdle copy(Option<Future<ByteBuffer>> idleRead) {
            return new ReadIdle(idleRead);
        }

        public Option<Future<ByteBuffer>> copy$default$1() {
            return this.idleRead();
        }

        public Option<Future<ByteBuffer>> _1() {
            return this.idleRead();
        }
    }

    public static interface State {
    }
}

