/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import cats.syntax.package;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.http4s.Uri;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.nio2.ClientChannelFactory;
import org.http4s.blaze.client.BlazeConnection;
import org.http4s.blaze.client.Http1Connection;
import org.http4s.blaze.client.ParserMode;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.ExecutionContextConfig;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.client.ConnectionFailure;
import org.http4s.client.RequestKey;
import org.http4s.client.RequestKey$;
import org.http4s.headers.User;
import org.http4s.internal.SSLContextOption;
import org.http4s.internal.SSLContextOption$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public final class Http1Support<F> {
    private final SSLContextOption sslContextOption;
    private final ExecutionContextConfig executionContextConfig;
    private final TickWheelExecutor scheduler;
    private final boolean checkEndpointIdentification;
    private final int maxResponseLineSize;
    private final int maxHeaderLength;
    private final int maxChunkSize;
    private final int chunkBufferMaxSize;
    private final ParserMode parserMode;
    private final Option<User.minusAgent> userAgent;
    private final Duration idleTimeout;
    private final Dispatcher<F> dispatcher;
    private final Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress;
    private final Async<F> F;
    private final ClientChannelFactory connectionManager;

    public Http1Support(SSLContextOption sslContextOption, int bufferSize, Option<AsynchronousChannelGroup> asynchronousChannelGroup, ExecutionContextConfig executionContextConfig, TickWheelExecutor scheduler, boolean checkEndpointIdentification, int maxResponseLineSize, int maxHeaderLength, int maxChunkSize, int chunkBufferMaxSize, ParserMode parserMode, Option<User.minusAgent> userAgent, ChannelOptions channelOptions, Duration connectTimeout, Duration idleTimeout, Dispatcher<F> dispatcher, Function1<RequestKey, Either<Throwable, InetSocketAddress>> getAddress, Async<F> F) {
        this.sslContextOption = sslContextOption;
        this.executionContextConfig = executionContextConfig;
        this.scheduler = scheduler;
        this.checkEndpointIdentification = checkEndpointIdentification;
        this.maxResponseLineSize = maxResponseLineSize;
        this.maxHeaderLength = maxHeaderLength;
        this.maxChunkSize = maxChunkSize;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.parserMode = parserMode;
        this.userAgent = userAgent;
        this.idleTimeout = idleTimeout;
        this.dispatcher = dispatcher;
        this.getAddress = getAddress;
        this.F = F;
        this.connectionManager = new ClientChannelFactory(bufferSize, asynchronousChannelGroup, channelOptions, scheduler, connectTimeout);
    }

    public F makeClient(RequestKey requestKey) {
        Either either = (Either)this.getAddress.apply((Object)requestKey);
        if (either instanceof Right) {
            InetSocketAddress a = (InetSocketAddress)((Right)either).value();
            return (F)org.http4s.blazecore.util.package$.MODULE$.fromFutureNoShift(package.all$.MODULE$.toFlatMapOps(this.executionContextConfig.getExecutionContext(this.F), this.F).flatMap((Function1 & Serializable)ec -> this.F.delay(() -> this.makeClient$$anonfun$1$$anonfun$1(requestKey, a, ec))), this.F);
        }
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            return (F)this.F.raiseError((Object)t);
        }
        throw new MatchError((Object)either);
    }

    private Future<BlazeConnection<F>> buildPipeline(RequestKey requestKey, InetSocketAddress addr, ExecutionContext executionContext) {
        return this.connectionManager.connect((SocketAddress)addr, this.connectionManager.connect$default$2()).transformWith((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                HeadStage head = (HeadStage)((Success)try_).value();
                Either<IllegalStateException, BlazeConnection<F>> either = this.buildStages(requestKey, (HeadStage<ByteBuffer>)head, executionContext);
                if (either instanceof Right) {
                    BlazeConnection connection = (BlazeConnection)((Right)either).value();
                    head.inboundCommand((Command.InboundCommand)Command.Connected$.MODULE$);
                    return Future$.MODULE$.successful((Object)connection);
                }
                if (either instanceof Left) {
                    IllegalStateException e = (IllegalStateException)((Left)either).value();
                    return Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, (Throwable)e));
                }
                throw new MatchError(either);
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                return Future$.MODULE$.failed((Throwable)new ConnectionFailure(requestKey, addr, e));
            }
            throw new MatchError((Object)try_);
        }, executionContext);
    }

    private Either<IllegalStateException, BlazeConnection<F>> buildStages(RequestKey requestKey, HeadStage<ByteBuffer> head, ExecutionContext executionContext) {
        Option<IdleTimeoutStage<ByteBuffer>> idleTimeoutStage = this.makeIdleTimeoutStage(executionContext);
        Either<IllegalStateException, Option<SSLStage>> ssl = this.makeSslStage(requestKey);
        Http1Connection connection = new Http1Connection(requestKey, executionContext, this.maxResponseLineSize, this.maxHeaderLength, this.maxChunkSize, this.chunkBufferMaxSize, this.parserMode, this.userAgent, idleTimeoutStage, this.dispatcher, this.F);
        return ssl.map((Function1 & Serializable)sslStage -> {
            LeafBuilder builder1 = LeafBuilder$.MODULE$.apply((TailStage)connection);
            LeafBuilder builder2 = (LeafBuilder)idleTimeoutStage.fold(() -> Http1Support.$anonfun$1(builder1), (Function1 & Serializable)_$2 -> builder1.prepend((MidStage)_$2));
            LeafBuilder builder3 = (LeafBuilder)sslStage.fold(() -> Http1Support.$anonfun$3(builder2), (Function1 & Serializable)_$3 -> builder2.prepend((MidStage)_$3));
            builder3.base(head);
            return connection;
        });
    }

    private Option<IdleTimeoutStage<ByteBuffer>> makeIdleTimeoutStage(ExecutionContext executionContext) {
        Duration duration = this.idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            return Some$.MODULE$.apply((Object)new IdleTimeoutStage(d, this.scheduler, executionContext));
        }
        return None$.MODULE$;
    }

    private Either<IllegalStateException, Option<SSLStage>> makeSslStage(RequestKey requestKey) {
        RequestKey requestKey2 = requestKey;
        if (requestKey2 != null) {
            RequestKey requestKey3 = RequestKey$.MODULE$.unapply(requestKey2);
            Uri.Scheme scheme = requestKey3._1();
            Uri.Authority authority = requestKey3._2();
            Uri.Scheme scheme2 = Uri.Scheme$.MODULE$.https();
            Uri.Scheme scheme3 = scheme;
            if (!(scheme2 != null ? !scheme2.equals(scheme3) : scheme3 != null)) {
                Uri.Authority auth = authority;
                Option maybeSSLContext = SSLContextOption$.MODULE$.toMaybeSSLContext(this.sslContextOption);
                Option option = maybeSSLContext;
                if (option instanceof Some) {
                    SSLContext sslContext = (SSLContext)((Some)option).value();
                    SSLEngine eng = sslContext.createSSLEngine(auth.host().value(), BoxesRunTime.unboxToInt((Object)auth.port().getOrElse(Http1Support::$anonfun$5)));
                    eng.setUseClientMode(true);
                    if (this.checkEndpointIdentification) {
                        SSLParameters sslParams = eng.getSSLParameters();
                        sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                        eng.setSSLParameters(sslParams);
                    }
                    return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)new SSLStage(eng, SSLStage$.MODULE$.$lessinit$greater$default$2())));
                }
                if (None$.MODULE$.equals(option)) {
                    return package$.MODULE$.Left().apply((Object)new IllegalStateException("No SSLContext configured for this client. Try `withSslContext` on the `BlazeClientBuilder`, or do not make https calls."));
                }
                throw new MatchError((Object)option);
            }
        }
        return package$.MODULE$.Right().apply((Object)None$.MODULE$);
    }

    private final Future makeClient$$anonfun$1$$anonfun$1(RequestKey requestKey$2, InetSocketAddress a$2, ExecutionContext ec$1) {
        return this.buildPipeline(requestKey$2, a$2, ec$1);
    }

    private static final LeafBuilder $anonfun$1(LeafBuilder builder1$1) {
        return builder1$1;
    }

    private static final LeafBuilder $anonfun$3(LeafBuilder builder2$1) {
        return builder2$1;
    }

    private static final int $anonfun$5() {
        return 443;
    }
}

