/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.client;

import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.syntax.AsyncOps$;
import cats.effect.std.Semaphore;
import cats.effect.syntax.package;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import org.http4s.WaitQueueTimeoutException$;
import org.http4s.blaze.client.BlazeClientState;
import org.http4s.blaze.client.Connection;
import org.http4s.blaze.client.ConnectionBuilder;
import org.http4s.blaze.client.ConnectionManager;
import org.http4s.blaze.client.ConnectionManager$NextConnection$;
import org.http4s.blaze.client.NoConnectionAllowedException$;
import org.http4s.blaze.client.PoolManager$PooledConnection$;
import org.http4s.blaze.client.PoolManager$Waiting$;
import org.http4s.blaze.client.WaitQueueFullFailure$;
import org.http4s.client.RequestKey;
import org.http4s.internal.CollectionCompat$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;

public final class PoolManager<F, A extends Connection<F>>
implements ConnectionManager.Stateful<F, A> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(PoolManager.class.getDeclaredField("NextConnection$lzy1"));
    private volatile Object NextConnection$lzy1;
    private final ConnectionBuilder<F, A> builder;
    private final int maxTotal;
    private final int maxWaitQueueLimit;
    private final Function1<RequestKey, Object> maxConnectionsPerRequestKey;
    private final Duration responseHeaderTimeout;
    private final Duration requestTimeout;
    private final Semaphore<F> semaphore;
    private final ExecutionContext executionContext;
    private final Duration maxIdleDuration;
    public final Async<F> org$http4s$blaze$client$PoolManager$$F;
    public final PoolManager$PooledConnection$ PooledConnection$lzy1;
    public final PoolManager$Waiting$ Waiting$lzy1;
    private final Logger logger;
    public boolean org$http4s$blaze$client$PoolManager$$isClosed;
    private int curTotal;
    public final Map<RequestKey, Object> org$http4s$blaze$client$PoolManager$$allocated;
    public final Map<RequestKey, Queue<PooledConnection>> org$http4s$blaze$client$PoolManager$$idleQueues;
    public Queue<Waiting> org$http4s$blaze$client$PoolManager$$waitQueue;
    private final Some<F> noopCancelToken;

    public PoolManager(ConnectionBuilder<F, A> builder, int maxTotal, int maxWaitQueueLimit, Function1<RequestKey, Object> maxConnectionsPerRequestKey, Duration responseHeaderTimeout, Duration requestTimeout, Semaphore<F> semaphore, ExecutionContext executionContext, Duration maxIdleDuration, Async<F> F) {
        this.builder = builder;
        this.maxTotal = maxTotal;
        this.maxWaitQueueLimit = maxWaitQueueLimit;
        this.maxConnectionsPerRequestKey = maxConnectionsPerRequestKey;
        this.responseHeaderTimeout = responseHeaderTimeout;
        this.requestTimeout = requestTimeout;
        this.semaphore = semaphore;
        this.executionContext = executionContext;
        this.maxIdleDuration = maxIdleDuration;
        this.org$http4s$blaze$client$PoolManager$$F = F;
        this.PooledConnection$lzy1 = new PoolManager$PooledConnection$(this);
        this.Waiting$lzy1 = new PoolManager$Waiting$(this);
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.client.PoolManager");
        this.org$http4s$blaze$client$PoolManager$$isClosed = false;
        this.curTotal = 0;
        this.org$http4s$blaze$client$PoolManager$$allocated = (Map)Map$.MODULE$.empty();
        this.org$http4s$blaze$client$PoolManager$$idleQueues = (Map)Map$.MODULE$.empty();
        this.org$http4s$blaze$client$PoolManager$$waitQueue = Queue$.MODULE$.empty();
        this.noopCancelToken = Some$.MODULE$.apply(F.unit());
    }

    @Override
    public final ConnectionManager$NextConnection$ NextConnection() {
        Object object = this.NextConnection$lzy1;
        if (object instanceof ConnectionManager$NextConnection$) {
            return (ConnectionManager$NextConnection$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ConnectionManager$NextConnection$)this.NextConnection$lzyINIT1();
    }

    private Object NextConnection$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.NextConnection$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ConnectionManager$NextConnection$ connectionManager$NextConnection$ = null;
                    try {
                        connectionManager$NextConnection$ = new ConnectionManager$NextConnection$(this);
                        object2 = connectionManager$NextConnection$ == null ? LazyVals.NullValue$.MODULE$ : connectionManager$NextConnection$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.NextConnection$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return connectionManager$NextConnection$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    public PoolManager(ConnectionBuilder<F, A> builder, int maxTotal, int maxWaitQueueLimit, Function1<RequestKey, Object> maxConnectionsPerRequestKey, Duration responseHeaderTimeout, Duration requestTimeout, Semaphore<F> semaphore, ExecutionContext executionContext, Async<F> F) {
        this(builder, maxTotal, maxWaitQueueLimit, maxConnectionsPerRequestKey, responseHeaderTimeout, requestTimeout, semaphore, executionContext, (Duration)Duration$.MODULE$.Inf(), F);
    }

    private final PoolManager$PooledConnection$ PooledConnection() {
        return this.PooledConnection$lzy1;
    }

    private final PoolManager$Waiting$ Waiting() {
        return this.Waiting$lzy1;
    }

    private String stats() {
        return new StringBuilder(73).append("curAllocated=").append(this.curTotal).append(" idleQueues.size=").append(this.org$http4s$blaze$client$PoolManager$$idleQueues.size()).append(" waitQueue.size=").append(this.org$http4s$blaze$client$PoolManager$$waitQueue.size()).append(" maxWaitQueueLimit=").append(this.maxWaitQueueLimit).append(" closed=").append(this.org$http4s$blaze$client$PoolManager$$isClosed).toString();
    }

    private F getConnectionFromQueue(RequestKey key) {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.delay(() -> this.getConnectionFromQueue$$anonfun$1(key));
    }

    private F incrConnection(RequestKey key) {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
            this.incrConnection$$anonfun$1(key);
            return BoxedUnit.UNIT;
        });
    }

    private F decrConnection(RequestKey key) {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
            this.decrConnection$$anonfun$1(key);
            return BoxedUnit.UNIT;
        });
    }

    private boolean numConnectionsCheckHolds(RequestKey key) {
        return this.curTotal < this.maxTotal && BoxesRunTime.unboxToInt((Object)this.org$http4s$blaze$client$PoolManager$$allocated.getOrElse((Object)key, PoolManager::numConnectionsCheckHolds$$anonfun$1)) < BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerRequestKey.apply((Object)key));
    }

    private boolean isRequestExpired(Instant t) {
        long elapsed = Instant.now().toEpochMilli() - t.toEpochMilli();
        return this.requestTimeout.isFinite() && elapsed >= this.requestTimeout.toMillis() || this.responseHeaderTimeout.isFinite() && elapsed >= this.responseHeaderTimeout.toMillis();
    }

    private F createConnection(RequestKey key, Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback) {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.ifM(this.org$http4s$blaze$client$PoolManager$$F.delay(() -> this.createConnection$$anonfun$1(key)), () -> this.createConnection$$anonfun$2(key, callback), () -> this.createConnection$$anonfun$3(key, callback));
    }

    private F addToWaitQueue(RequestKey key, Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback) {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
            this.addToWaitQueue$$anonfun$1(key, callback);
            return BoxedUnit.UNIT;
        });
    }

    private F addToIdleQueue(A conn, RequestKey key) {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
            this.addToIdleQueue$$anonfun$1((Connection)conn, key);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public F borrow(RequestKey key) {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.async((Function1 & Serializable)callback -> {
            Object object;
            Resource resource = this.semaphore.permit();
            if (!this.org$http4s$blaze$client$PoolManager$$isClosed) {
                Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.borrow$$anonfun$1$$anonfun$1(key);
                    return BoxedUnit.UNIT;
                }));
                object = ApplyOps$.MODULE$.productR$extension(object2, this.go$1(key, (Function1)callback), this.org$http4s$blaze$client$PoolManager$$F);
            } else {
                object = this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    PoolManager.borrow$$anonfun$1$$anonfun$2(callback);
                    return BoxedUnit.UNIT;
                });
            }
            return package.all$.MODULE$.toFunctorOps(resource.surround(object, this.org$http4s$blaze$client$PoolManager$$F), this.org$http4s$blaze$client$PoolManager$$F).as(this.noopCancelToken);
        });
    }

    private F releaseRecyclable(RequestKey key, A connection) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.org$http4s$blaze$client$PoolManager$$F.delay(() -> this.releaseRecyclable$$anonfun$1(key)), this.org$http4s$blaze$client$PoolManager$$F).flatMap((Function1 & Serializable)x$12 -> {
            Waiting waiting;
            Option option = x$12;
            if (option instanceof Some && (waiting = (Waiting)((Some)option).value()) != null) {
                Waiting waiting2 = this.Waiting().unapply(waiting);
                RequestKey requestKey = waiting2._1();
                Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> function1 = waiting2._2();
                Instant instant = waiting2._3();
                Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback = function1;
                Instant at = instant;
                if (this.isRequestExpired(at)) {
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.releaseRecyclable$$anonfun$2$$anonfun$1(key);
                        return BoxedUnit.UNIT;
                    }));
                    Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        PoolManager.releaseRecyclable$$anonfun$2$$anonfun$2(callback);
                        return BoxedUnit.UNIT;
                    }), this.org$http4s$blaze$client$PoolManager$$F));
                    return ApplyOps$.MODULE$.$times$greater$extension(object2, this.releaseRecyclable(key, connection), this.org$http4s$blaze$client$PoolManager$$F);
                }
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.releaseRecyclable$$anonfun$2$$anonfun$3(key);
                    return BoxedUnit.UNIT;
                }));
                return ApplyOps$.MODULE$.$times$greater$extension(object, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.releaseRecyclable$$anonfun$2$$anonfun$4((Connection)connection, (Function1)callback);
                    return BoxedUnit.UNIT;
                }), this.org$http4s$blaze$client$PoolManager$$F);
            }
            if (None$.MODULE$.equals(option)) {
                if (this.org$http4s$blaze$client$PoolManager$$waitQueue.isEmpty()) {
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.releaseRecyclable$$anonfun$2$$anonfun$5(key);
                        return BoxedUnit.UNIT;
                    }));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, this.addToIdleQueue(connection, key), this.org$http4s$blaze$client$PoolManager$$F);
                }
                return package.all$.MODULE$.toFlatMapOps(this.findFirstAllowedWaiter(), this.org$http4s$blaze$client$PoolManager$$F).flatMap((Function1 & Serializable)x$1 -> {
                    Waiting waiting;
                    Option option = x$1;
                    if (option instanceof Some && (waiting = (Waiting)((Some)option).value()) != null) {
                        Waiting waiting2 = this.Waiting().unapply(waiting);
                        RequestKey requestKey = waiting2._1();
                        Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> function1 = waiting2._2();
                        Instant instant = waiting2._3();
                        RequestKey k = requestKey;
                        Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> cb = function1;
                        Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                            PoolManager.releaseRecyclable$$anonfun$2$$anonfun$6$$anonfun$1(connection);
                            return BoxedUnit.UNIT;
                        }));
                        Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.decrConnection(key), this.org$http4s$blaze$client$PoolManager$$F));
                        return ApplyOps$.MODULE$.$times$greater$extension(object2, this.createConnection(k, cb), this.org$http4s$blaze$client$PoolManager$$F);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return this.addToIdleQueue(connection, key);
                    }
                    throw new MatchError((Object)option);
                });
            }
            throw new MatchError((Object)option);
        });
    }

    private F releaseNonRecyclable(RequestKey key, A connection) {
        Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.decrConnection(key));
        Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
            this.releaseNonRecyclable$$anonfun$1(key, (Connection)connection);
            return BoxedUnit.UNIT;
        }), this.org$http4s$blaze$client$PoolManager$$F));
        return (F)ApplyOps$.MODULE$.$times$greater$extension(object2, package.all$.MODULE$.toFlatMapOps(this.findFirstAllowedWaiter(), this.org$http4s$blaze$client$PoolManager$$F).flatMap((Function1 & Serializable)x$1 -> {
            Waiting waiting;
            Option option = x$1;
            if (option instanceof Some && (waiting = (Waiting)((Some)option).value()) != null) {
                Waiting waiting2 = this.Waiting().unapply(waiting);
                RequestKey requestKey = waiting2._1();
                Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> function1 = waiting2._2();
                Instant instant = waiting2._3();
                RequestKey k = requestKey;
                Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback = function1;
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.releaseNonRecyclable$$anonfun$2$$anonfun$1(key);
                    return BoxedUnit.UNIT;
                }));
                return ApplyOps$.MODULE$.$times$greater$extension(object, this.createConnection(k, callback), this.org$http4s$blaze$client$PoolManager$$F);
            }
            if (None$.MODULE$.equals(option)) {
                return this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.releaseNonRecyclable$$anonfun$2$$anonfun$2(key);
                    return BoxedUnit.UNIT;
                });
            }
            throw new MatchError((Object)option);
        }), this.org$http4s$blaze$client$PoolManager$$F);
    }

    @Override
    public F release(A connection) {
        RequestKey key = connection.requestKey();
        return (F)this.semaphore.permit().use((Function1 & Serializable)_$6 -> {
            Object object = package.all$.MODULE$.catsSyntaxIfM(connection.isRecyclable(), this.org$http4s$blaze$client$PoolManager$$F);
            return IfMOps$.MODULE$.ifM$extension(object, () -> this.release$$anonfun$1$$anonfun$1(connection, key), () -> this.release$$anonfun$1$$anonfun$2(connection, key), this.org$http4s$blaze$client$PoolManager$$F);
        }, this.org$http4s$blaze$client$PoolManager$$F);
    }

    private F findFirstAllowedWaiter() {
        return (F)this.org$http4s$blaze$client$PoolManager$$F.delay(this::findFirstAllowedWaiter$$anonfun$1);
    }

    @Override
    public F invalidate(A connection) {
        return (F)this.semaphore.permit().use((Function1 & Serializable)_$8 -> {
            RequestKey key = connection.requestKey();
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.decrConnection(key));
            Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                PoolManager.invalidate$$anonfun$1$$anonfun$1(connection);
                return BoxedUnit.UNIT;
            }), this.org$http4s$blaze$client$PoolManager$$F));
            return ApplyOps$.MODULE$.$times$greater$extension(object2, package.all$.MODULE$.toFlatMapOps(this.findFirstAllowedWaiter(), this.org$http4s$blaze$client$PoolManager$$F).flatMap((Function1 & Serializable)x$1 -> {
                Waiting waiting;
                Option option = x$1;
                if (option instanceof Some && (waiting = (Waiting)((Some)option).value()) != null) {
                    Waiting waiting2 = this.Waiting().unapply(waiting);
                    RequestKey requestKey = waiting2._1();
                    Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> function1 = waiting2._2();
                    Instant instant = waiting2._3();
                    RequestKey k = requestKey;
                    Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback = function1;
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.invalidate$$anonfun$1$$anonfun$2$$anonfun$1(key);
                        return BoxedUnit.UNIT;
                    }));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, this.createConnection(k, callback), this.org$http4s$blaze$client$PoolManager$$F);
                }
                if (None$.MODULE$.equals(option)) {
                    return this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.invalidate$$anonfun$1$$anonfun$2$$anonfun$2(key);
                        return BoxedUnit.UNIT;
                    });
                }
                throw new MatchError((Object)option);
            }), this.org$http4s$blaze$client$PoolManager$$F);
        }, this.org$http4s$blaze$client$PoolManager$$F);
    }

    private F disposeConnection(RequestKey key, Option<A> connection) {
        return (F)this.semaphore.permit().use((Function1 & Serializable)_$9 -> {
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                this.disposeConnection$$anonfun$1$$anonfun$1(key);
                return BoxedUnit.UNIT;
            }));
            Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.decrConnection(key), this.org$http4s$blaze$client$PoolManager$$F));
            return ApplyOps$.MODULE$.$times$greater$extension(object2, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                PoolManager.disposeConnection$$anonfun$1$$anonfun$2(connection);
                return BoxedUnit.UNIT;
            }), this.org$http4s$blaze$client$PoolManager$$F);
        }, this.org$http4s$blaze$client$PoolManager$$F);
    }

    @Override
    public F shutdown() {
        return (F)this.semaphore.permit().use((Function1 & Serializable)_$10 -> this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
            this.shutdown$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        }), this.org$http4s$blaze$client$PoolManager$$F);
    }

    @Override
    public BlazeClientState<F> state() {
        return new BlazeClientState<F>(this){
            private final /* synthetic */ PoolManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object isClosed() {
                return this.$outer.org$http4s$blaze$client$PoolManager$$F.delay(this::isClosed$$anonfun$1);
            }

            public Object allocated() {
                return this.$outer.org$http4s$blaze$client$PoolManager$$F.delay(this::allocated$$anonfun$1);
            }

            public Object idleQueueDepth() {
                return this.$outer.org$http4s$blaze$client$PoolManager$$F.delay(this::idleQueueDepth$$anonfun$1);
            }

            public Object waitQueueDepth() {
                return this.$outer.org$http4s$blaze$client$PoolManager$$F.delay(this::waitQueueDepth$$anonfun$1);
            }

            private final boolean isClosed$$anonfun$1() {
                return this.$outer.org$http4s$blaze$client$PoolManager$$isClosed;
            }

            private final scala.collection.immutable.Map allocated$$anonfun$1() {
                return this.$outer.org$http4s$blaze$client$PoolManager$$allocated.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            private final scala.collection.immutable.Map idleQueueDepth$$anonfun$1() {
                return CollectionCompat$.MODULE$.mapValues(this.$outer.org$http4s$blaze$client$PoolManager$$idleQueues.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), PoolManager::org$http4s$blaze$client$PoolManager$$anon$1$$_$idleQueueDepth$$anonfun$1$$anonfun$1);
            }

            private final int waitQueueDepth$$anonfun$1() {
                return this.$outer.org$http4s$blaze$client$PoolManager$$waitQueue.size();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{isClosed$$anonfun$1(), allocated$$anonfun$1(), idleQueueDepth$$anonfun$1(), waitQueueDepth$$anonfun$1(), org$http4s$blaze$client$PoolManager$$anon$1$$_$idleQueueDepth$$anonfun$1$$anonfun$1(scala.collection.mutable.Queue )}, serializedLambda);
            }
        };
    }

    private final Option getConnectionFromQueue$$anonfun$1(RequestKey key$1) {
        return this.org$http4s$blaze$client$PoolManager$$idleQueues.get((Object)key$1).flatMap((Function1 & Serializable)q -> {
            if (q.nonEmpty()) {
                PooledConnection pooled = (PooledConnection)q.dequeue();
                if (q.isEmpty()) {
                    this.org$http4s$blaze$client$PoolManager$$idleQueues.remove((Object)key$1);
                }
                return Some$.MODULE$.apply((Object)pooled);
            }
            return None$.MODULE$;
        });
    }

    private static final int incrConnection$$anonfun$1$$anonfun$1() {
        return 0;
    }

    private final void incrConnection$$anonfun$1(RequestKey key$3) {
        ++this.curTotal;
        this.org$http4s$blaze$client$PoolManager$$allocated.update((Object)key$3, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.org$http4s$blaze$client$PoolManager$$allocated.getOrElse((Object)key$3, PoolManager::incrConnection$$anonfun$1$$anonfun$1)) + 1)));
    }

    private static final int $anonfun$1() {
        return 0;
    }

    private final void decrConnection$$anonfun$1(RequestKey key$4) {
        --this.curTotal;
        int numConnections = BoxesRunTime.unboxToInt((Object)this.org$http4s$blaze$client$PoolManager$$allocated.getOrElse((Object)key$4, PoolManager::$anonfun$1));
        if (numConnections == 1) {
            this.org$http4s$blaze$client$PoolManager$$allocated.remove((Object)key$4);
            this.org$http4s$blaze$client$PoolManager$$idleQueues.remove((Object)key$4);
            return;
        }
        this.org$http4s$blaze$client$PoolManager$$allocated.update((Object)key$4, (Object)BoxesRunTime.boxToInteger((int)(numConnections - 1)));
    }

    private static final int numConnectionsCheckHolds$$anonfun$1() {
        return 0;
    }

    private final boolean createConnection$$anonfun$1(RequestKey key$5) {
        return this.numConnectionsCheckHolds(key$5);
    }

    private final void createConnection$$anonfun$2$$anonfun$1$$anonfun$1(Function1 callback$3, Connection conn$1) {
        callback$3.apply((Object)package$.MODULE$.Right().apply((Object)this.NextConnection().apply(conn$1, true)));
    }

    private static final void createConnection$$anonfun$2$$anonfun$1$$anonfun$2(Function1 callback$4, Throwable error$1) {
        callback$4.apply((Object)package$.MODULE$.Left().apply((Object)error$1));
    }

    private final Object createConnection$$anonfun$2(RequestKey key$6, Function1 callback$1) {
        Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.incrConnection(key$6));
        Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(this.builder.apply(key$6), this.org$http4s$blaze$client$PoolManager$$F);
        Object object3 = package.all$.MODULE$.asyncOps(package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.org$http4s$blaze$client$PoolManager$$F), this.org$http4s$blaze$client$PoolManager$$F).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Connection conn = (Connection)((Right)either).value();
                return this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.createConnection$$anonfun$2$$anonfun$1$$anonfun$1(callback$1, conn);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Left) {
                Throwable error = (Throwable)((Left)either).value();
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.disposeConnection(key$6, (Option<A>)None$.MODULE$));
                return ApplyOps$.MODULE$.$times$greater$extension(object, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    PoolManager.createConnection$$anonfun$2$$anonfun$1$$anonfun$2(callback$1, error);
                    return BoxedUnit.UNIT;
                }), this.org$http4s$blaze$client$PoolManager$$F);
            }
            throw new MatchError((Object)either);
        }));
        return ApplyOps$.MODULE$.$times$greater$extension(object, package.all$.MODULE$.toFunctorOps(this.org$http4s$blaze$client$PoolManager$$F.start(AsyncOps$.MODULE$.evalOn$extension(object3, this.executionContext(), this.org$http4s$blaze$client$PoolManager$$F)), this.org$http4s$blaze$client$PoolManager$$F).void(), this.org$http4s$blaze$client$PoolManager$$F);
    }

    private final Object createConnection$$anonfun$3(RequestKey key$8, Function1 callback$5) {
        return this.addToWaitQueue(key$8, (Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit>)callback$5);
    }

    private final void addToWaitQueue$$anonfun$1(RequestKey key$9, Function1 callback$6) {
        if (this.org$http4s$blaze$client$PoolManager$$waitQueue.length() < this.maxWaitQueueLimit) {
            this.org$http4s$blaze$client$PoolManager$$waitQueue.enqueue((Object)this.Waiting().apply(key$9, (Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit>)callback$6, Instant.now()));
            return;
        }
        Logger Logger_this = this.logger;
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error(new StringBuilder(58).append("Max wait queue for limit of ").append(this.maxWaitQueueLimit).append(" for ").append(key$9).append(" reached, not scheduling.").toString());
        }
        callback$6.apply((Object)package$.MODULE$.Left().apply((Object)WaitQueueFullFailure$.MODULE$.apply()));
    }

    private static final Queue $anonfun$2() {
        return Queue$.MODULE$.empty();
    }

    private final void addToIdleQueue$$anonfun$1(Connection conn$2, RequestKey key$10) {
        None$ none$;
        Duration duration = this.maxIdleDuration;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finite = (FiniteDuration)duration;
            none$ = Some$.MODULE$.apply((Object)Deadline$.MODULE$.now().$plus(finite));
        } else {
            none$ = None$.MODULE$;
        }
        None$ borrowDeadline = none$;
        Queue q = (Queue)this.org$http4s$blaze$client$PoolManager$$idleQueues.getOrElse((Object)key$10, PoolManager::$anonfun$2);
        q.enqueue((Object)this.PooledConnection().apply(conn$2, (Option<Deadline>)borrowDeadline));
        this.org$http4s$blaze$client$PoolManager$$idleQueues.update((Object)key$10, (Object)q);
    }

    private final void go$1$$anonfun$1$$anonfun$1(RequestKey key$14) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(33).append("Evicting closed connection for ").append(key$14).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private final void go$1$$anonfun$1$$anonfun$3(RequestKey key$15) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(52).append("Shutting down and evicting expired connection for ").append(key$15).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private static final void go$1$$anonfun$1$$anonfun$4(PooledConnection pooled$1) {
        pooled$1.conn().shutdown();
    }

    private final void go$1$$anonfun$1$$anonfun$5(RequestKey key$16) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(27).append("Recycling connection for ").append(key$16).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private final void go$1$$anonfun$1$$anonfun$6(Function1 callback$9, PooledConnection pooled$2) {
        callback$9.apply((Object)package$.MODULE$.Right().apply((Object)this.NextConnection().apply(pooled$2.conn(), false)));
    }

    private final void go$1$$anonfun$1$$anonfun$7(RequestKey key$17) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(52).append("Active connection not found for ").append(key$17).append(". Creating new one. ").append(this.stats()).toString());
            return;
        }
    }

    private static final void go$1$$anonfun$1$$anonfun$8(RequestKey key$18, Function1 callback$10) {
        callback$10.apply((Object)package$.MODULE$.Left().apply((Object)NoConnectionAllowedException$.MODULE$.apply(key$18)));
    }

    private final void go$1$$anonfun$1$$anonfun$9(RequestKey key$19) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(95).append("No connections available for the desired key, ").append(key$19).append(". Evicting random and creating a new connection: ").append(this.stats()).toString());
            return;
        }
    }

    private static final RequestKey go$1$$anonfun$1$$anonfun$10(Iterable keys$1) {
        return (RequestKey)keys$1.iterator().drop(Random$.MODULE$.nextInt(keys$1.size())).next();
    }

    private final void go$1$$anonfun$1$$anonfun$11$$anonfun$1$$anonfun$1(RequestKey randKey$2) {
        Logger Logger_this = this.logger;
        if (Logger_this.isWarnEnabled()) {
            Logger_this.warn(new StringBuilder(46).append("No connection to evict from the idleQueue for ").append(randKey$2).toString());
            return;
        }
    }

    private final void go$1$$anonfun$1$$anonfun$12(RequestKey key$20) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(69).append("No connections available for the desired key, ").append(key$20).append(". Adding to waitQueue: ").append(this.stats()).toString());
            return;
        }
    }

    private final void go$1$$anonfun$1$$anonfun$13(RequestKey key$21) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(59).append("No connections available for ").append(key$21).append(".  Waiting on new connection: ").append(this.stats()).toString());
            return;
        }
    }

    private final Object go$1(RequestKey key$12, Function1 callback$7) {
        return package.all$.MODULE$.toFlatMapOps(this.getConnectionFromQueue(key$12), this.org$http4s$blaze$client$PoolManager$$F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                PooledConnection pooledConnection = (PooledConnection)((Some)option).value();
                PooledConnection pooled = pooledConnection;
                if (pooled.conn().isClosed()) {
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.go$1$$anonfun$1$$anonfun$1(key$12);
                        return BoxedUnit.UNIT;
                    }));
                    Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.decrConnection(key$12), this.org$http4s$blaze$client$PoolManager$$F));
                    return ApplyOps$.MODULE$.$times$greater$extension(object2, this.go$1(key$12, callback$7), this.org$http4s$blaze$client$PoolManager$$F);
                }
                PooledConnection pooled2 = pooledConnection;
                if (pooled2.borrowDeadline().exists((Function1 & Serializable)_$2 -> _$2.isOverdue())) {
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.go$1$$anonfun$1$$anonfun$3(key$12);
                        return BoxedUnit.UNIT;
                    }));
                    Object object3 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, this.decrConnection(key$12), this.org$http4s$blaze$client$PoolManager$$F));
                    Object object4 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object3, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        PoolManager.go$1$$anonfun$1$$anonfun$4(pooled2);
                        return BoxedUnit.UNIT;
                    }), this.org$http4s$blaze$client$PoolManager$$F));
                    return ApplyOps$.MODULE$.$times$greater$extension(object4, this.go$1(key$12, callback$7), this.org$http4s$blaze$client$PoolManager$$F);
                }
                PooledConnection pooled3 = pooledConnection;
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.go$1$$anonfun$1$$anonfun$5(key$12);
                    return BoxedUnit.UNIT;
                }));
                return ApplyOps$.MODULE$.$times$greater$extension(object, this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.go$1$$anonfun$1$$anonfun$6(callback$7, pooled3);
                    return BoxedUnit.UNIT;
                }), this.org$http4s$blaze$client$PoolManager$$F);
            }
            if (None$.MODULE$.equals(option)) {
                if (this.numConnectionsCheckHolds(key$12)) {
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.go$1$$anonfun$1$$anonfun$7(key$12);
                        return BoxedUnit.UNIT;
                    }));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, this.createConnection(key$12, (Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit>)callback$7), this.org$http4s$blaze$client$PoolManager$$F);
                }
                if (BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerRequestKey.apply((Object)key$12)) <= 0) {
                    return this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        PoolManager.go$1$$anonfun$1$$anonfun$8(key$12, callback$7);
                        return BoxedUnit.UNIT;
                    });
                }
                if (this.curTotal == this.maxTotal) {
                    Iterable keys = this.org$http4s$blaze$client$PoolManager$$idleQueues.keys();
                    if (keys.nonEmpty()) {
                        Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                            this.go$1$$anonfun$1$$anonfun$9(key$12);
                            return BoxedUnit.UNIT;
                        }));
                        Object object5 = package.all$.MODULE$.catsSyntaxApplyOps(ApplyOps$.MODULE$.$times$greater$extension(object, package.all$.MODULE$.toFlatMapOps(this.org$http4s$blaze$client$PoolManager$$F.delay(() -> PoolManager.go$1$$anonfun$1$$anonfun$10(keys)), this.org$http4s$blaze$client$PoolManager$$F).flatMap((Function1 & Serializable)randKey -> {
                            Object object = package.all$.MODULE$.catsSyntaxApplyOps(package.all$.MODULE$.toFunctorOps(this.getConnectionFromQueue((RequestKey)randKey), this.org$http4s$blaze$client$PoolManager$$F).map((Function1)(JProcedure1 & Serializable)_$3 -> _$3.fold((Function0 & Serializable)() -> {
                                this.go$1$$anonfun$1$$anonfun$11$$anonfun$1$$anonfun$1((RequestKey)randKey);
                                return BoxedUnit.UNIT;
                            }, (Function1)(JProcedure1 & Serializable)_$4 -> _$4.conn().shutdown())));
                            return ApplyOps$.MODULE$.$times$greater$extension(object, this.decrConnection((RequestKey)randKey), this.org$http4s$blaze$client$PoolManager$$F);
                        }), this.org$http4s$blaze$client$PoolManager$$F));
                        return ApplyOps$.MODULE$.$times$greater$extension(object5, this.createConnection(key$12, (Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit>)callback$7), this.org$http4s$blaze$client$PoolManager$$F);
                    }
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                        this.go$1$$anonfun$1$$anonfun$12(key$12);
                        return BoxedUnit.UNIT;
                    }));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, this.addToWaitQueue(key$12, (Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit>)callback$7), this.org$http4s$blaze$client$PoolManager$$F);
                }
                Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.org$http4s$blaze$client$PoolManager$$F.delay((Function0 & Serializable)() -> {
                    this.go$1$$anonfun$1$$anonfun$13(key$12);
                    return BoxedUnit.UNIT;
                }));
                return ApplyOps$.MODULE$.$times$greater$extension(object, this.addToWaitQueue(key$12, (Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit>)callback$7), this.org$http4s$blaze$client$PoolManager$$F);
            }
            throw new MatchError((Object)option);
        });
    }

    private final void borrow$$anonfun$1$$anonfun$1(RequestKey key$22) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(28).append("Requesting connection for ").append(key$22).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private static final void borrow$$anonfun$1$$anonfun$2(Function1 callback$11) {
        callback$11.apply((Object)package$.MODULE$.Left().apply((Object)new IllegalStateException("Connection pool is closed")));
    }

    private final Option releaseRecyclable$$anonfun$1(RequestKey key$23) {
        return this.org$http4s$blaze$client$PoolManager$$waitQueue.dequeueFirst((Function1 & Serializable)_$5 -> {
            RequestKey requestKey = _$5.key();
            RequestKey requestKey2 = key$23;
            return !(requestKey != null ? !requestKey.equals(requestKey2) : requestKey2 != null);
        });
    }

    private final void releaseRecyclable$$anonfun$2$$anonfun$1(RequestKey key$26) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(20).append("Request expired for ").append(key$26).toString());
            return;
        }
    }

    private static final void releaseRecyclable$$anonfun$2$$anonfun$2(Function1 callback$12) {
        callback$12.apply((Object)package$.MODULE$.Left().apply((Object)WaitQueueTimeoutException$.MODULE$));
    }

    private final void releaseRecyclable$$anonfun$2$$anonfun$3(RequestKey key$27) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(44).append("Fulfilling waiting connection request for ").append(key$27).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private final void releaseRecyclable$$anonfun$2$$anonfun$4(Connection connection$2, Function1 callback$13) {
        callback$13.apply((Object)package$.MODULE$.Right().apply((Object)this.NextConnection().apply(connection$2, false)));
    }

    private final void releaseRecyclable$$anonfun$2$$anonfun$5(RequestKey key$28) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(40).append("Returning idle connection to pool for ").append(key$28).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private static final void releaseRecyclable$$anonfun$2$$anonfun$6$$anonfun$1(Connection connection$4) {
        connection$4.shutdown();
    }

    private final void releaseNonRecyclable$$anonfun$1(RequestKey key$30, Connection connection$5) {
        if (!connection$5.isClosed()) {
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(50).append("Connection returned was busy for ").append(key$30).append(". Shutting down: ").append(this.stats()).toString());
            }
            connection$5.shutdown();
            return;
        }
    }

    private final void releaseNonRecyclable$$anonfun$2$$anonfun$1(RequestKey key$32) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(71).append("Connection returned could not be recycled, new connection needed for ").append(key$32).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private final void releaseNonRecyclable$$anonfun$2$$anonfun$2(RequestKey key$33) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(76).append("Connection could not be recycled for ").append(key$33).append(", no pending requests. Shrinking pool: ").append(this.stats()).toString());
            return;
        }
    }

    private final Object release$$anonfun$1$$anonfun$1(Connection connection$7, RequestKey key$35) {
        return this.releaseRecyclable(key$35, connection$7);
    }

    private final Object release$$anonfun$1$$anonfun$2(Connection connection$8, RequestKey key$36) {
        return this.releaseNonRecyclable(key$36, connection$8);
    }

    private static final int findFirstAllowedWaiter$$anonfun$1$$anonfun$2$$anonfun$1() {
        return 0;
    }

    private final Option findFirstAllowedWaiter$$anonfun$1() {
        Tuple2 tuple2 = this.org$http4s$blaze$client$PoolManager$$waitQueue.span((Function1 & Serializable)w -> this.isRequestExpired(w.at()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Queue expired = (Queue)tuple2._1();
        Queue rest = (Queue)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)expired, (Object)rest);
        Queue expired2 = (Queue)tuple22._1();
        Queue rest2 = (Queue)tuple22._2();
        expired2.foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.callback().apply((Object)package$.MODULE$.Left().apply((Object)WaitQueueTimeoutException$.MODULE$)));
        if (expired2.nonEmpty()) {
            Logger Logger_this = this.logger;
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug(new StringBuilder(18).append("expired requests: ").append(expired2.length()).toString());
            }
            this.org$http4s$blaze$client$PoolManager$$waitQueue = rest2;
            Logger Logger_this2 = this.logger;
            if (Logger_this2.isDebugEnabled()) {
                Logger_this2.debug(new StringBuilder(26).append("Dropped expired requests: ").append(this.stats()).toString());
            }
        }
        return this.org$http4s$blaze$client$PoolManager$$waitQueue.dequeueFirst((Function1 & Serializable)waiter -> BoxesRunTime.unboxToInt((Object)this.org$http4s$blaze$client$PoolManager$$allocated.getOrElse((Object)waiter.key(), PoolManager::findFirstAllowedWaiter$$anonfun$1$$anonfun$2$$anonfun$1)) < BoxesRunTime.unboxToInt((Object)this.maxConnectionsPerRequestKey.apply((Object)waiter.key())));
    }

    private static final void invalidate$$anonfun$1$$anonfun$1(Connection connection$10) {
        if (!connection$10.isClosed()) {
            connection$10.shutdown();
            return;
        }
    }

    private final void invalidate$$anonfun$1$$anonfun$2$$anonfun$1(RequestKey key$38) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(52).append("Invalidated connection for ").append(key$38).append(", new connection needed: ").append(this.stats()).toString());
            return;
        }
    }

    private final void invalidate$$anonfun$1$$anonfun$2$$anonfun$2(RequestKey key$39) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(66).append("Invalidated connection for ").append(key$39).append(", no pending requests. Shrinking pool: ").append(this.stats()).toString());
            return;
        }
    }

    private final void disposeConnection$$anonfun$1$$anonfun$1(RequestKey key$41) {
        Logger Logger_this = this.logger;
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(30).append("Disposing of connection for ").append(key$41).append(": ").append(this.stats()).toString());
            return;
        }
    }

    private static final void disposeConnection$$anonfun$1$$anonfun$2(Option connection$12) {
        connection$12.foreach((Function1)(JProcedure1 & Serializable)s -> {
            if (!s.isClosed()) {
                s.shutdown();
                return;
            }
        });
    }

    private final void shutdown$$anonfun$1$$anonfun$1() {
        Logger Logger_this = this.logger;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info(new StringBuilder(31).append("Shutting down connection pool: ").append(this.stats()).toString());
        }
        if (!this.org$http4s$blaze$client$PoolManager$$isClosed) {
            this.org$http4s$blaze$client$PoolManager$$isClosed = true;
            this.org$http4s$blaze$client$PoolManager$$idleQueues.foreach((Function1)(JProcedure1 & Serializable)_$11 -> ((IterableOnceOps)_$11._2()).foreach((Function1)(JProcedure1 & Serializable)_$12 -> _$12.conn().shutdown()));
            this.org$http4s$blaze$client$PoolManager$$idleQueues.clear();
            this.org$http4s$blaze$client$PoolManager$$allocated.clear();
            this.curTotal = 0;
            return;
        }
    }

    public static final /* synthetic */ int org$http4s$blaze$client$PoolManager$$anon$1$$_$idleQueueDepth$$anonfun$1$$anonfun$1(Queue _$13) {
        return _$13.size();
    }

    public class PooledConnection
    implements Product,
    Serializable {
        private final Connection conn;
        private final Option borrowDeadline;
        private final /* synthetic */ PoolManager $outer;

        public PooledConnection(A conn, Option<Deadline> borrowDeadline) {
            this.conn = conn;
            this.borrowDeadline = borrowDeadline;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PooledConnection)) return false;
            if (((PooledConnection)object).org$http4s$blaze$client$PoolManager$PooledConnection$$$outer() != this.$outer) return false;
            PooledConnection pooledConnection = (PooledConnection)object;
            Object a = this.conn();
            Object a2 = pooledConnection.conn();
            if (a == null) {
                if (a2 != null) {
                    return false;
                }
            } else if (!a.equals(a2)) return false;
            Option<Deadline> option = this.borrowDeadline();
            Option<Deadline> option2 = pooledConnection.borrowDeadline();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!pooledConnection.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PooledConnection;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PooledConnection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "conn";
            }
            if (1 == n2) {
                return "borrowDeadline";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public A conn() {
            return this.conn;
        }

        public Option<Deadline> borrowDeadline() {
            return this.borrowDeadline;
        }

        public PooledConnection copy(A conn, Option<Deadline> borrowDeadline) {
            return new PooledConnection(this.$outer, conn, borrowDeadline);
        }

        public A copy$default$1() {
            return this.conn();
        }

        public Option<Deadline> copy$default$2() {
            return this.borrowDeadline();
        }

        public A _1() {
            return this.conn();
        }

        public Option<Deadline> _2() {
            return this.borrowDeadline();
        }

        public final /* synthetic */ PoolManager org$http4s$blaze$client$PoolManager$PooledConnection$$$outer() {
            return this.$outer;
        }
    }

    public class Waiting
    implements Product,
    Serializable {
        private final RequestKey key;
        private final Function1 callback;
        private final Instant at;
        private final /* synthetic */ PoolManager $outer;

        public Waiting(PoolManager $outer, RequestKey key, Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback, Instant at) {
            this.key = key;
            this.callback = callback;
            this.at = at;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Waiting)) return false;
            if (((Waiting)object).org$http4s$blaze$client$PoolManager$Waiting$$$outer() != this.$outer) return false;
            Waiting waiting = (Waiting)object;
            RequestKey requestKey = this.key();
            RequestKey requestKey2 = waiting.key();
            if (requestKey == null) {
                if (requestKey2 != null) {
                    return false;
                }
            } else if (!requestKey.equals(requestKey2)) return false;
            Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> function1 = this.callback();
            Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> function12 = waiting.callback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Instant instant = this.at();
            Instant instant2 = waiting.at();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            if (!waiting.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Waiting;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Waiting";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "callback";
                }
                case 2: {
                    return "at";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public RequestKey key() {
            return this.key;
        }

        public Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback() {
            return this.callback;
        }

        public Instant at() {
            return this.at;
        }

        public Waiting copy(RequestKey key, Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> callback, Instant at) {
            return new Waiting(this.$outer, key, callback, at);
        }

        public RequestKey copy$default$1() {
            return this.key();
        }

        public Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> copy$default$2() {
            return this.callback();
        }

        public Instant copy$default$3() {
            return this.at();
        }

        public RequestKey _1() {
            return this.key();
        }

        public Function1<Either<Throwable, ConnectionManager.NextConnection>, BoxedUnit> _2() {
            return this.callback();
        }

        public Instant _3() {
            return this.at();
        }

        public final /* synthetic */ PoolManager org$http4s$blaze$client$PoolManager$Waiting$$$outer() {
            return this.$outer;
        }
    }
}

