/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.Alternative$;
import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant$;
import cats.Semigroupal$;
import cats.data.Kleisli;
import cats.effect.ConcurrentEffect;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.syntax.FlatMapOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress$;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.Security;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.blaze.BuildInfo$;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.ServerChannel;
import org.http4s.blaze.channel.ServerChannelGroup;
import org.http4s.blaze.channel.SocketConnection;
import org.http4s.blaze.channel.nio1.NIO1SocketServerGroup$;
import org.http4s.blaze.http.http2.server.ALPNServerSelector;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.server.BlazeServerBuilder$;
import org.http4s.blaze.server.Http1ServerStage;
import org.http4s.blaze.server.Http1ServerStage$;
import org.http4s.blaze.server.ProtocolSelector$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.BlazeBackendBuilder;
import org.http4s.blazecore.package$;
import org.http4s.internal.tls$;
import org.http4s.server.SSLClientAuthMode;
import org.http4s.server.SSLKeyStoreSupport;
import org.http4s.server.SecureSession$;
import org.http4s.server.Server;
import org.http4s.server.ServerBuilder;
import org.http4s.server.package;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scodec.bits.ByteVector$;

public class BlazeServerBuilder<F>
implements ServerBuilder<F>,
BlazeBackendBuilder<Server> {
    private final InetSocketAddress socketAddress;
    private final ExecutionContext executionContext;
    private final Duration responseHeaderTimeout;
    private final Duration idleTimeout;
    private final int connectorPoolSize;
    private final int bufferSize;
    private final ThreadFactory selectorThreadFactory;
    private final boolean enableWebSockets;
    public final SslConfig<F> org$http4s$blaze$server$BlazeServerBuilder$$sslConfig;
    private final boolean isHttp2Enabled;
    private final int maxRequestLineLen;
    private final int maxHeadersLen;
    private final int chunkBufferMaxSize;
    private final Kleisli<F, Request<F>, Response<F>> httpApp;
    private final Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler;
    private final Seq<String> banner;
    private final int maxConnections;
    private final ChannelOptions channelOptions;
    private final Option<Object> maxWebSocketBufferSize;
    private final ConcurrentEffect F;
    private final Timer<F> timer;
    private final Logger logger;

    public static <F> BlazeServerBuilder<F> apply(ConcurrentEffect<F> concurrentEffect, Timer<F> timer) {
        return BlazeServerBuilder$.MODULE$.apply(concurrentEffect, timer);
    }

    public static <F> BlazeServerBuilder<F> apply(ExecutionContext executionContext, ConcurrentEffect<F> concurrentEffect, Timer<F> timer) {
        return BlazeServerBuilder$.MODULE$.apply(executionContext, concurrentEffect, timer);
    }

    public BlazeServerBuilder(InetSocketAddress socketAddress, ExecutionContext executionContext, Duration responseHeaderTimeout, Duration idleTimeout, int connectorPoolSize, int bufferSize, ThreadFactory selectorThreadFactory, boolean enableWebSockets, SslConfig<F> sslConfig, boolean isHttp2Enabled, int maxRequestLineLen, int maxHeadersLen, int chunkBufferMaxSize, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Request<F>, PartialFunction<Throwable, Object>> serviceErrorHandler, Seq<String> banner, int maxConnections, ChannelOptions channelOptions, Option<Object> maxWebSocketBufferSize, ConcurrentEffect<F> F, Timer<F> timer) {
        this.socketAddress = socketAddress;
        this.executionContext = executionContext;
        this.responseHeaderTimeout = responseHeaderTimeout;
        this.idleTimeout = idleTimeout;
        this.connectorPoolSize = connectorPoolSize;
        this.bufferSize = bufferSize;
        this.selectorThreadFactory = selectorThreadFactory;
        this.enableWebSockets = enableWebSockets;
        this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig = sslConfig;
        this.isHttp2Enabled = isHttp2Enabled;
        this.maxRequestLineLen = maxRequestLineLen;
        this.maxHeadersLen = maxHeadersLen;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.httpApp = httpApp;
        this.serviceErrorHandler = serviceErrorHandler;
        this.banner = banner;
        this.maxConnections = maxConnections;
        this.channelOptions = channelOptions;
        this.maxWebSocketBufferSize = maxWebSocketBufferSize;
        this.F = F;
        this.timer = timer;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.server.BlazeServerBuilder");
    }

    public ChannelOptions channelOptions() {
        return this.channelOptions;
    }

    public ConcurrentEffect<F> F() {
        return this.F;
    }

    private BlazeServerBuilder<F> copy(InetSocketAddress socketAddress, ExecutionContext executionContext, Duration idleTimeout, Duration responseHeaderTimeout, int connectorPoolSize, int bufferSize, ThreadFactory selectorThreadFactory, boolean enableWebSockets, SslConfig<F> sslConfig, boolean http2Support, int maxRequestLineLen, int maxHeadersLen, int chunkBufferMaxSize, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, Seq<String> banner, int maxConnections, ChannelOptions channelOptions, Option<Object> maxWebSocketBufferSize) {
        return new BlazeServerBuilder<F>(socketAddress, executionContext, responseHeaderTimeout, idleTimeout, connectorPoolSize, bufferSize, selectorThreadFactory, enableWebSockets, sslConfig, http2Support, maxRequestLineLen, maxHeadersLen, chunkBufferMaxSize, httpApp, serviceErrorHandler, banner, maxConnections, channelOptions, maxWebSocketBufferSize, this.F(), this.timer);
    }

    private InetSocketAddress copy$default$1() {
        return this.socketAddress;
    }

    private ExecutionContext copy$default$2() {
        return this.executionContext;
    }

    private Duration copy$default$3() {
        return this.idleTimeout;
    }

    private Duration copy$default$4() {
        return this.responseHeaderTimeout;
    }

    private int copy$default$5() {
        return this.connectorPoolSize;
    }

    private int copy$default$6() {
        return this.bufferSize;
    }

    private ThreadFactory copy$default$7() {
        return this.selectorThreadFactory;
    }

    private boolean copy$default$8() {
        return this.enableWebSockets;
    }

    private SslConfig<F> copy$default$9() {
        return this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig;
    }

    private boolean copy$default$10() {
        return this.isHttp2Enabled;
    }

    private int copy$default$11() {
        return this.maxRequestLineLen;
    }

    private int copy$default$12() {
        return this.maxHeadersLen;
    }

    private int copy$default$13() {
        return this.chunkBufferMaxSize;
    }

    private Kleisli<F, Request<F>, Response<F>> copy$default$14() {
        return this.httpApp;
    }

    private Function1<Request<F>, PartialFunction<Throwable, F>> copy$default$15() {
        return this.serviceErrorHandler;
    }

    private Seq<String> copy$default$16() {
        return this.banner;
    }

    private int copy$default$17() {
        return this.maxConnections;
    }

    private ChannelOptions copy$default$18() {
        return this.channelOptions();
    }

    private Option<Object> copy$default$19() {
        return this.maxWebSocketBufferSize;
    }

    public BlazeServerBuilder withLengthLimits(int maxRequestLineLen, int maxHeadersLen) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), maxRequestLineLen, maxHeadersLen, this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public int withLengthLimits$default$1() {
        return this.maxRequestLineLen;
    }

    public int withLengthLimits$default$2() {
        return this.maxHeadersLen;
    }

    public BlazeServerBuilder<F> withSSL(SSLKeyStoreSupport.StoreInfo keyStore, String keyManagerPassword, String protocol, Option<SSLKeyStoreSupport.StoreInfo> trustStore, SSLClientAuthMode clientAuth) {
        KeyStoreBits<F> bits = new KeyStoreBits<F>(keyStore, keyManagerPassword, protocol, trustStore, clientAuth, this.F());
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), bits, this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public String withSSL$default$3() {
        return "TLS";
    }

    public Option<SSLKeyStoreSupport.StoreInfo> withSSL$default$4() {
        return None$.MODULE$;
    }

    public SSLClientAuthMode withSSL$default$5() {
        return SSLClientAuthMode.NotRequested$.MODULE$;
    }

    public BlazeServerBuilder withSSLContext(SSLContext sslContext, SSLClientAuthMode clientAuth) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), new ContextWithClientAuth<F>(sslContext, clientAuth, this.F()), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public SSLClientAuthMode withSSLContext$default$2() {
        return SSLClientAuthMode.NotRequested$.MODULE$;
    }

    public BlazeServerBuilder withSslContext(SSLContext sslContext) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), new ContextOnly<F>(sslContext, this.F()), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withSslContextAndParameters(SSLContext sslContext, SSLParameters sslParameters) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), new ContextWithParameters<F>(sslContext, sslParameters, this.F()), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withoutSsl() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), new NoSsl<F>(this.F()), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder bindSocketAddress(InetSocketAddress socketAddress) {
        return this.copy(socketAddress, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withExecutionContext(ExecutionContext executionContext) {
        return this.copy(this.copy$default$1(), executionContext, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withIdleTimeout(Duration idleTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), idleTimeout, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withResponseHeaderTimeout(Duration responseHeaderTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), responseHeaderTimeout, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withConnectorPoolSize(int size) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), size, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withBufferSize(int size) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), size, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withSelectorThreadFactory(ThreadFactory selectorThreadFactory) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), selectorThreadFactory, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder withWebSockets(boolean enableWebsockets) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), enableWebsockets, this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder enableHttp2(boolean enabled) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), enabled, this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withHttpApp(Kleisli<F, Request<F>, Response<F>> httpApp) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), httpApp, this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withServiceErrorHandler(Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), serviceErrorHandler, this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withBanner(Seq<String> banner) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), banner, this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withChannelOptions(ChannelOptions channelOptions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), channelOptions, this.copy$default$19());
    }

    public BlazeServerBuilder<F> withMaxRequestLineLength(int maxRequestLineLength) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), maxRequestLineLength, this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withMaxHeadersLength(int maxHeadersLength) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), maxHeadersLength, this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withChunkBufferMaxSize(int chunkBufferMaxSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), chunkBufferMaxSize, this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withMaxConnections(int maxConnections) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), maxConnections, this.copy$default$18(), this.copy$default$19());
    }

    public BlazeServerBuilder<F> withMaxWebSocketBufferSize(Option<Object> maxWebSocketBufferSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18(), maxWebSocketBufferSize);
    }

    private Future<LeafBuilder<ByteBuffer>> pipelineFactory(TickWheelExecutor scheduler, Option<Tuple2<SSLContext, Function1<SSLEngine, BoxedUnit>>> engineConfig, SocketConnection conn) {
        LeafBuilder leafBuilder;
        Tuple2 tuple2;
        Option<Tuple2<SSLContext, Function1<SSLEngine, BoxedUnit>>> option = engineConfig;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Object object;
            SSLContext ctx = (SSLContext)tuple2._1();
            Function1 configure = (Function1)tuple2._2();
            SSLEngine engine = ctx.createSSLEngine();
            engine.setUseClientMode(false);
            configure.apply((Object)engine);
            if (this.isHttp2Enabled) {
                object = this.http2Stage$1(scheduler, conn, engine);
            } else {
                SSLEngine sSLEngine = (SSLEngine)package.all$.MODULE$.catsSyntaxOptionId((Object)engine);
                object = this.http1Stage$1(scheduler, conn, true, OptionIdOps$.MODULE$.some$extension((Object)sSLEngine));
            }
            leafBuilder = LeafBuilder$.MODULE$.apply((TailStage)object).prepend((MidStage)new SSLStage(engine, SSLStage$.MODULE$.$lessinit$greater$default$2()));
        } else if (None$.MODULE$.equals(option)) {
            Logger Logger_this;
            if (this.isHttp2Enabled && (Logger_this = this.logger).isWarnEnabled()) {
                Logger_this.warn("HTTP/2 support requires TLS. Falling back to HTTP/1.");
            }
            leafBuilder = LeafBuilder$.MODULE$.apply((TailStage)this.http1Stage$1(scheduler, conn, false, (Option)None$.MODULE$));
        } else {
            throw new MatchError(option);
        }
        return Future$.MODULE$.successful((Object)leafBuilder);
    }

    public Resource<F, Server> resource() {
        return package$.MODULE$.tickWheelResource(this.F()).flatMap((Function1 & Serializable)scheduler -> {
            Resource mkFactory = Resource$.MODULE$.make(this.F().delay(this::$anonfun$1), (Function1 & Serializable)factory -> this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)() -> BlazeServerBuilder.$anonfun$2$$anonfun$1(factory))), this.F());
            Resource resource = (Resource)package.all$.MODULE$.catsSyntaxFlatMapOps((Object)Resource$.MODULE$.eval(this.verifyTimeoutRelations(), this.F()), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource(this.F()));
            return (Resource)FlatMapOps$.MODULE$.$greater$greater$extension((Object)resource, () -> this.resource$$anonfun$5$$anonfun$4(scheduler, mkFactory), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource(this.F()));
        });
    }

    private F verifyTimeoutRelations() {
        return (F)this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)this::verifyTimeoutRelations$$anonfun$1));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Function0 requestAttributes$10(SocketConnection conn$1, boolean secure, Option optionalSslEngine) {
        Function0 & Serializable intersect;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)conn$1.local(), (Object)conn$1.remote());
        if (tuple2 != null) {
            SocketAddress socketAddress = (SocketAddress)tuple2._1();
            SocketAddress socketAddress2 = (SocketAddress)tuple2._2();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress local = (InetSocketAddress)socketAddress;
                if (socketAddress2 instanceof InetSocketAddress) {
                    InetSocketAddress remote = (InetSocketAddress)socketAddress2;
                    intersect = (Function0 & Serializable)() -> Vault$.MODULE$.empty().insert(Request.Keys$.MODULE$.ConnectionInfo(), (Object)Request.Connection$.MODULE$.apply(SocketAddress$.MODULE$.apply((Host)IpAddress$.MODULE$.fromBytes(local.getAddress().getAddress()).get(), (Port)Port$.MODULE$.fromInt(local.getPort()).get()), SocketAddress$.MODULE$.apply((Host)IpAddress$.MODULE$.fromBytes(remote.getAddress().getAddress()).get(), (Port)Port$.MODULE$.fromInt(remote.getPort()).get()), secure)).insert(package.ServerRequestKeys$.MODULE$.SecureSession(), (Object)((Option)Alternative$.MODULE$.apply(Invariant$.MODULE$.catsInstancesForOption()).guard(secure)).flatMap((Function1 & Serializable)_$2 -> optionalSslEngine).flatMap((Function1 & Serializable)engine -> Option$.MODULE$.apply((Object)engine.getSession())).flatMap((Function1 & Serializable)session -> {
                        List list = (List)package.all$.MODULE$.catsSyntaxOptionId((Object)tls$.MODULE$.getCertChain(session));
                        return (Option)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply((Object)Option$.MODULE$.apply((Object)session.getId()).map((Function1 & Serializable)_$3 -> ByteVector$.MODULE$.apply(_$3).toHex()), (Object)Option$.MODULE$.apply((Object)session.getCipherSuite()), (Object)Option$.MODULE$.apply((Object)session.getCipherSuite()).map((Function1 & Serializable)cipherSuite -> tls$.MODULE$.deduceKeyLength(cipherSuite)), (Object)OptionIdOps$.MODULE$.some$extension((Object)list))).mapN((Function4 & Serializable)(sslSessionId, cipherSuite, keySize, X509Certificate2) -> SecureSession$.MODULE$.apply((String)sslSessionId, (String)cipherSuite, BoxesRunTime.unboxToInt((Object)keySize), (List)X509Certificate2), (Functor)Invariant$.MODULE$.catsInstancesForOption(), Semigroupal$.MODULE$.catsSemigroupalForOption());
                    }));
                    return intersect;
                }
            }
        }
        intersect = (Function0 & Serializable)() -> Vault$.MODULE$.empty();
        return intersect;
    }

    private final Http1ServerStage http1Stage$1(TickWheelExecutor scheduler$1, SocketConnection conn$2, boolean secure, Option engine) {
        return Http1ServerStage$.MODULE$.apply(this.httpApp, (Function0<Vault>)BlazeServerBuilder.requestAttributes$10(conn$2, secure, engine), this.executionContext, this.enableWebSockets, this.maxRequestLineLen, this.maxHeadersLen, this.chunkBufferMaxSize, this.serviceErrorHandler, this.responseHeaderTimeout, this.idleTimeout, scheduler$1, this.maxWebSocketBufferSize, this.F());
    }

    private final ALPNServerSelector http2Stage$1(TickWheelExecutor scheduler$2, SocketConnection conn$3, SSLEngine engine) {
        SSLEngine sSLEngine = (SSLEngine)package.all$.MODULE$.catsSyntaxOptionId((Object)engine);
        return ProtocolSelector$.MODULE$.apply(engine, this.httpApp, this.maxRequestLineLen, this.maxHeadersLen, this.chunkBufferMaxSize, (Function0<Vault>)BlazeServerBuilder.requestAttributes$10(conn$3, true, OptionIdOps$.MODULE$.some$extension((Object)sSLEngine)), this.executionContext, this.serviceErrorHandler, this.responseHeaderTimeout, this.idleTimeout, scheduler$2, this.maxWebSocketBufferSize, this.F(), this.timer);
    }

    private static final InetSocketAddress resolveAddress$1(InetSocketAddress address) {
        return address.isUnresolved() ? new InetSocketAddress(address.getHostName(), address.getPort()) : address;
    }

    private final ServerChannelGroup $anonfun$1() {
        return NIO1SocketServerGroup$.MODULE$.fixed(this.connectorPoolSize, this.bufferSize, this.channelOptions(), this.selectorThreadFactory, NIO1SocketServerGroup$.MODULE$.fixed$default$5(), NIO1SocketServerGroup$.MODULE$.fixed$default$6(), this.maxConnections);
    }

    private static final void $anonfun$2$$anonfun$1(ServerChannelGroup factory$1) {
        factory$1.closeGroup();
    }

    private static final void mkServerChannel$4$$anonfun$4$$anonfun$1(ServerChannel serverChannel$1) {
        serverChannel$1.close();
    }

    private final Resource mkServerChannel$6(TickWheelExecutor scheduler$4, ServerChannelGroup factory) {
        return Resource$.MODULE$.make(package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig.makeContext(), this.F()).map((Function1 & Serializable)ctxOpt -> {
            Option engineCfg = ctxOpt.map((Function1 & Serializable)ctx -> Tuple2$.MODULE$.apply(ctx, (JProcedure1 & Serializable)sslEngine -> this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig.configureEngine((SSLEngine)sslEngine)));
            InetSocketAddress address = BlazeServerBuilder.resolveAddress$1(this.socketAddress);
            return Tuple3$.MODULE$.apply(ctxOpt, (Object)engineCfg, (Object)address);
        }), this.F()).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Option ctxOpt = (Option)tuple3._1();
            Option engineCfg = (Option)tuple3._2();
            InetSocketAddress address = (InetSocketAddress)tuple3._3();
            return (ServerChannel)factory.bind(address, (Function1 & Serializable)conn -> this.pipelineFactory(scheduler$4, (Option<Tuple2<SSLContext, Function1<SSLEngine, BoxedUnit>>>)engineCfg, (SocketConnection)conn)).get();
        }), (Function1 & Serializable)serverChannel -> this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)() -> BlazeServerBuilder.mkServerChannel$4$$anonfun$4$$anonfun$1(serverChannel))), this.F());
    }

    private final void logStart$4$$anonfun$4(Server server$1) {
        Option$.MODULE$.apply(this.banner).filter((Function1 & Serializable)_$4 -> _$4.nonEmpty()).map((Function1 & Serializable)_$5 -> _$5.mkString("\n", "\n", "")).foreach((Function1)(JProcedure1 & Serializable)_$6 -> {
            Logger Logger_this = this.logger;
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info(_$6);
            }
        });
        Logger Logger_this = this.logger;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info("http4s v" + org.http4s.BuildInfo$.MODULE$.version() + " on blaze v" + BuildInfo$.MODULE$.version() + " started at " + server$1.baseUri());
        }
    }

    private final Resource logStart$5(Server server) {
        return Resource$.MODULE$.eval(this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.logStart$4$$anonfun$4(server))), this.F());
    }

    private final Resource resource$$anonfun$5$$anonfun$4(TickWheelExecutor scheduler$6, Resource mkFactory$1) {
        return (Resource)package.all$.MODULE$.toFlatMapOps((Object)mkFactory$1.flatMap((Function1 & Serializable)factory -> this.mkServerChannel$6(scheduler$6, (ServerChannelGroup)factory)).map((Function1 & Serializable)serverChannel -> new Server((ServerChannel)serverChannel, this){
            private final InetSocketAddress address;
            private final boolean isSecure;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.address = serverChannel$2.socketAddress();
                this.isSecure = $outer.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig.isSecure();
            }

            public InetSocketAddress address() {
                return this.address;
            }

            public boolean isSecure() {
                return this.isSecure;
            }

            public String toString() {
                return "BlazeServer(" + this.address() + ")";
            }
        }, this.F()), (FlatMap)Resource$.MODULE$.catsEffectMonadErrorForResource(this.F())).flatTap((Function1 & Serializable)server -> this.logStart$5((Server)server));
    }

    private final void verifyTimeoutRelations$$anonfun$1() {
        Logger Logger_this;
        if (this.responseHeaderTimeout.isFinite() && this.responseHeaderTimeout.$greater$eq((Object)this.idleTimeout) && (Logger_this = this.logger).isWarnEnabled()) {
            Logger_this.warn("responseHeaderTimeout (" + this.responseHeaderTimeout + ") is >= idleTimeout (" + this.idleTimeout + "). " + "It is recommended to configure responseHeaderTimeout < idleTimeout, " + "otherwise timeout responses won't be delivered to clients.");
        }
    }

    private static class ContextOnly<F>
    implements SslConfig<F> {
        private final SSLContext sslContext;
        private final Applicative<F> F;

        public ContextOnly(SSLContext sslContext, Applicative<F> F) {
            this.sslContext = sslContext;
            this.F = F;
        }

        @Override
        public F makeContext() {
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)this.sslContext);
            return (F)this.F.pure((Object)OptionIdOps$.MODULE$.some$extension((Object)sSLContext));
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            SSLEngine sSLEngine = engine;
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    private static class ContextWithClientAuth<F>
    implements SslConfig<F> {
        private final SSLContext sslContext;
        private final SSLClientAuthMode clientAuth;
        private final Applicative<F> F;

        public ContextWithClientAuth(SSLContext sslContext, SSLClientAuthMode clientAuth, Applicative<F> F) {
            this.sslContext = sslContext;
            this.clientAuth = clientAuth;
            this.F = F;
        }

        @Override
        public F makeContext() {
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)this.sslContext);
            return (F)this.F.pure((Object)OptionIdOps$.MODULE$.some$extension((Object)sSLContext));
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            BlazeServerBuilder$.MODULE$.org$http4s$blaze$server$BlazeServerBuilder$$$configureEngineFromSslClientAuthMode(engine, this.clientAuth);
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    private static class ContextWithParameters<F>
    implements SslConfig<F> {
        private final SSLContext sslContext;
        private final SSLParameters sslParameters;
        private final Applicative<F> F;

        public ContextWithParameters(SSLContext sslContext, SSLParameters sslParameters, Applicative<F> F) {
            this.sslContext = sslContext;
            this.sslParameters = sslParameters;
            this.F = F;
        }

        @Override
        public F makeContext() {
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)this.sslContext);
            return (F)this.F.pure((Object)OptionIdOps$.MODULE$.some$extension((Object)sSLContext));
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            engine.setSSLParameters(this.sslParameters);
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    private static final class KeyStoreBits<F>
    implements SslConfig<F> {
        private final SSLKeyStoreSupport.StoreInfo keyStore;
        private final String keyManagerPassword;
        private final String protocol;
        private final Option<SSLKeyStoreSupport.StoreInfo> trustStore;
        private final SSLClientAuthMode clientAuth;
        private final Sync<F> F;

        public KeyStoreBits(SSLKeyStoreSupport.StoreInfo keyStore, String keyManagerPassword, String protocol, Option<SSLKeyStoreSupport.StoreInfo> trustStore, SSLClientAuthMode clientAuth, Sync<F> F) {
            this.keyStore = keyStore;
            this.keyManagerPassword = keyManagerPassword;
            this.protocol = protocol;
            this.trustStore = trustStore;
            this.clientAuth = clientAuth;
            this.F = F;
        }

        @Override
        public F makeContext() {
            return (F)this.F.delay(this::makeContext$$anonfun$1);
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            BlazeServerBuilder$.MODULE$.org$http4s$blaze$server$BlazeServerBuilder$$$configureEngineFromSslClientAuthMode(engine, this.clientAuth);
        }

        @Override
        public boolean isSecure() {
            return true;
        }

        private final String $anonfun$2() {
            return KeyManagerFactory.getDefaultAlgorithm();
        }

        private final Option makeContext$$anonfun$1() {
            FileInputStream ksStream = new FileInputStream(this.keyStore.path());
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(ksStream, this.keyStore.password().toCharArray());
            ksStream.close();
            Option tmf = this.trustStore.map((Function1 & Serializable)auth -> {
                FileInputStream ksStream = new FileInputStream(auth.path());
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(ksStream, auth.password().toCharArray());
                ksStream.close();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                return tmf.getTrustManagers();
            });
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)Option$.MODULE$.apply((Object)Security.getProperty("ssl.KeyManagerFactory.algorithm")).getOrElse(this::$anonfun$2));
            kmf.init(ks, this.keyManagerPassword.toCharArray());
            SSLContext context = SSLContext.getInstance(this.protocol);
            context.init(kmf.getKeyManagers(), (TrustManager[])tmf.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)context);
            return OptionIdOps$.MODULE$.some$extension((Object)sSLContext);
        }
    }

    private static class NoSsl<F>
    implements SslConfig<F> {
        private final Applicative<F> F;

        public NoSsl(Applicative<F> F) {
            this.F = F;
        }

        @Override
        public F makeContext() {
            return (F)this.F.pure((Object)None$.MODULE$);
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            SSLEngine sSLEngine = engine;
        }

        @Override
        public boolean isSecure() {
            return false;
        }
    }

    private static interface SslConfig<F> {
        public F makeContext();

        public void configureEngine(SSLEngine var1);

        public boolean isSecure();
    }
}

