/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import java.io.Serializable;
import java.net.ProtocolException;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Execution$;
import org.http4s.internal.package$;
import org.http4s.websocket.WebSocketFrame;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public class WSFrameAggregator
implements MidStage<WebSocketFrame, WebSocketFrame> {
    private Logger logger;
    private Head _prevStage;
    private Tail _nextStage;
    private final Accumulator accumulator;

    public WSFrameAggregator() {
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        Head.$init$((Head)this);
        this.accumulator = new Accumulator();
        Statics.releaseFence();
    }

    public final Logger logger() {
        return this.logger;
    }

    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Head _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    public Tail _nextStage() {
        return this._nextStage;
    }

    public void _nextStage_$eq(Tail x$1) {
        this._nextStage = x$1;
    }

    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$((Stage)this, (Command.InboundCommand)cmd);
    }

    public String name() {
        return "WebSocket Frame Aggregator";
    }

    public Future<WebSocketFrame> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.channelRead(size, this.channelRead$default$2()).onComplete((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                WebSocketFrame f = (WebSocketFrame)((Success)try_).value();
                this.readLoop(f, (Promise<WebSocketFrame>)p);
                boxedUnit = BoxedUnit.UNIT;
            } else if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                boxedUnit = p.failure(t);
            } else {
                throw new MatchError((Object)try_);
            }
            return boxedUnit;
        }, Execution$.MODULE$.directec());
        return p.future();
    }

    private void readLoop(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebSocketFrame.Text) {
            this.handleHead(frame, p);
        } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
            this.handleHead(frame, p);
        } else if (webSocketFrame instanceof WebSocketFrame.Continuation) {
            WebSocketFrame.Continuation c = (WebSocketFrame.Continuation)webSocketFrame;
            if (this.accumulator.isEmpty()) {
                ProtocolException e = new ProtocolException("Invalid state: Received a Continuation frame without accumulated state.");
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Invalid state", (Throwable)e);
                }
                p.failure((Throwable)e);
            } else {
                this.accumulator.append(frame);
                if (c.last()) {
                    p.success((Object)this.accumulator.take());
                } else {
                    this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Try try_ = x$1;
                        if (try_ instanceof Success) {
                            WebSocketFrame f = (WebSocketFrame)((Success)try_).value();
                            this.readLoop(f, p);
                        } else if (try_ instanceof Failure) {
                            Throwable t = ((Failure)try_).exception();
                            p.failure(t);
                        } else {
                            throw new MatchError((Object)try_);
                        }
                    }, Execution$.MODULE$.trampoline());
                }
            }
        } else {
            WebSocketFrame f = webSocketFrame;
            p.success((Object)f);
        }
    }

    private void handleHead(WebSocketFrame frame, Promise<WebSocketFrame> p) {
        if (!this.accumulator.isEmpty()) {
            ProtocolException e = new ProtocolException("Invalid state: Received a head frame with accumulated state");
            this.accumulator.clear();
            p.failure((Throwable)e);
        } else if (frame.last()) {
            p.success((Object)frame);
        } else {
            this.accumulator.append(frame);
            this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    WebSocketFrame f = (WebSocketFrame)((Success)try_).value();
                    this.readLoop(f, p);
                } else if (try_ instanceof Failure) {
                    Throwable t = ((Failure)try_).exception();
                    p.failure(t);
                } else {
                    throw new MatchError((Object)try_);
                }
            }, Execution$.MODULE$.directec());
        }
    }

    public Future<BoxedUnit> writeRequest(WebSocketFrame data) {
        return this.channelWrite(data);
    }

    public Future<BoxedUnit> writeRequest(Seq<WebSocketFrame> data) {
        return this.channelWrite(data);
    }

    private static final class Accumulator {
        private final Queue<WebSocketFrame> queue = new Queue(Queue$.MODULE$.$lessinit$greater$default$1());
        private int size = 0;

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void append(WebSocketFrame frame) {
            WebSocketFrame webSocketFrame;
            if (this.queue.isEmpty() && !((webSocketFrame = frame) instanceof WebSocketFrame.Text) && !(webSocketFrame instanceof WebSocketFrame.Binary)) {
                WebSocketFrame f = webSocketFrame;
                throw package$.MODULE$.bug("Shouldn't get here. Wrong type: " + f.getClass().getName());
            }
            this.size += frame.length();
            this.queue.$plus$eq((Object)frame);
        }

        public WebSocketFrame take() {
            boolean bl;
            WebSocketFrame webSocketFrame = (WebSocketFrame)this.queue.head();
            if (webSocketFrame instanceof WebSocketFrame.Text) {
                bl = true;
            } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
                bl = false;
            } else {
                WebSocketFrame f = webSocketFrame;
                AssertionError e = package$.MODULE$.bug("Shouldn't get here. Wrong type: " + f.getClass().getName());
                throw e;
            }
            boolean isText = bl;
            ObjectRef out = ObjectRef.create((Object)ByteVector$.MODULE$.empty());
            this.go$1(out);
            this.size = 0;
            return isText ? WebSocketFrame.Text$.MODULE$.apply((ByteVector)out.elem) : WebSocketFrame.Binary$.MODULE$.apply((ByteVector)out.elem, WebSocketFrame.Binary$.MODULE$.$lessinit$greater$default$2());
        }

        public void clear() {
            this.size = 0;
            this.queue.clear();
        }

        private final void go$1(ObjectRef out$1) {
            while (!this.queue.isEmpty()) {
                ByteVector frame = ((WebSocketFrame)this.queue.dequeue()).data();
                ByteVector byteVector = ((ByteVector)out$1.elem).$plus$plus(frame);
                out$1.elem = byteVector;
            }
        }
    }
}

