/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.Functor;
import cats.data.Kleisli;
import cats.effect.ConcurrentEffect;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.Sync$;
import cats.effect.Timer;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Headers$;
import org.http4s.HttpVersion$;
import org.http4s.InvalidBodyException$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.ParseFailure;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.http2.DataFrame;
import org.http4s.blaze.http.http2.DataFrame$;
import org.http4s.blaze.http.http2.HeadersFrame;
import org.http4s.blaze.http.http2.HeadersFrame$;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.PseudoHeaders$;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.blazecore.util.Http2Writer;
import org.http4s.headers.Connection$;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.package$;
import org.slf4j.Logger;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Vault;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public class Http2NodeStage<F>
implements TailStage<StreamFrame> {
    private Logger logger;
    private Head _prevStage;
    private final int streamId;
    private final Duration timeout;
    private final ExecutionContext executionContext;
    private final Function0<Vault> attributes;
    public final Function1<Request<F>, PartialFunction<Throwable, F>> org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler;
    private final Duration idleTimeout;
    private final TickWheelExecutor scheduler;
    public final ConcurrentEffect<F> org$http4s$blaze$server$Http2NodeStage$$F;
    private final Function1<Request<F>, F> runApp;
    public final Function1<Request<F>, F> org$http4s$blaze$server$Http2NodeStage$$raceTimeout;

    public Http2NodeStage(int streamId, Duration timeout, ExecutionContext executionContext, Function0<Vault> attributes, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Request<F>, PartialFunction<Throwable, Object>> serviceErrorHandler, Duration responseHeaderTimeout, Duration idleTimeout, TickWheelExecutor scheduler, ConcurrentEffect<F> F, Timer<F> timer) {
        Function1 & Serializable intersect;
        this.streamId = streamId;
        this.timeout = timeout;
        this.executionContext = executionContext;
        this.attributes = attributes;
        this.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler = serviceErrorHandler;
        this.idleTimeout = idleTimeout;
        this.scheduler = scheduler;
        this.org$http4s$blaze$server$Http2NodeStage$$F = F;
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        this.runApp = httpApp.run();
        Duration duration = responseHeaderTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finite = (FiniteDuration)duration;
            Object timeoutResponse = package.all$.MODULE$.toFunctorOps(timer.sleep(finite), F).as((Object)Response$.MODULE$.timeout());
            intersect = (Function1 & Serializable)req -> package.all$.MODULE$.toFunctorOps(F.race(this.runApp.apply(req), timeoutResponse), (Functor)F).map((Function1 & Serializable)_$3 -> {
                Either either = Either$.MODULE$.MergeableEither(_$3);
                return (Response)Either.MergeableEither$.MODULE$.merge$extension(either);
            });
        } else {
            intersect = this.runApp;
        }
        this.org$http4s$blaze$server$Http2NodeStage$$raceTimeout = intersect;
        Statics.releaseFence();
    }

    public final Logger logger() {
        return this.logger;
    }

    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Head _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    public String name() {
        return "Http2NodeStage";
    }

    public void stageStartup() {
        Stage.stageStartup$((Stage)this);
        this.initIdleTimeout();
        this.readHeaders();
    }

    private void initIdleTimeout() {
        block0: {
            Duration duration = this.idleTimeout;
            if (!(duration instanceof FiniteDuration)) break block0;
            FiniteDuration f = (FiniteDuration)duration;
            JProcedure1 & Serializable cb = (JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable t = (Throwable)((Left)either).value();
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error in idle timeout callback", t);
                    }
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)t));
                } else if (either instanceof Right) {
                    Logger Logger_this = this.logger();
                    if (Logger_this.isDebugEnabled()) {
                        Logger_this.debug("Shutting down due to idle timeout");
                    }
                    this.closePipeline((Option)None$.MODULE$);
                } else {
                    throw new MatchError((Object)either);
                }
            };
            IdleTimeoutStage stage = new IdleTimeoutStage(f, this.scheduler, this.executionContext());
            this.spliceBefore((MidStage)stage);
            stage.init((Function1)cb);
        }
    }

    private void readHeaders() {
        this.channelRead(this.channelRead$default$1(), this.timeout).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                StreamFrame streamFrame = (StreamFrame)((Success)try_).value();
                if (streamFrame instanceof HeadersFrame) {
                    HeadersFrame headersFrame = HeadersFrame$.MODULE$.unapply((HeadersFrame)streamFrame);
                    Priority priority = headersFrame._1();
                    boolean bl = headersFrame._2();
                    Seq seq = headersFrame._3();
                    boolean endStream = bl;
                    Seq hs = seq;
                    this.checkAndRunRequest(hs, endStream);
                } else {
                    StreamFrame frame = streamFrame;
                    Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, "Received invalid frame: " + frame);
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                }
            } else if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    this.closePipeline((Option)None$.MODULE$);
                } else {
                    Throwable t = throwable;
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Unknown error in readHeaders", t);
                    }
                    Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId, "Unknown error");
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                }
            } else {
                throw new MatchError((Object)try_);
            }
        }, this.executionContext());
    }

    private FreeC getBody(long maxlen) {
        BooleanRef complete = BooleanRef.create((boolean)false);
        LongRef bytesRead = LongRef.create((long)0L);
        Object t = this.org$http4s$blaze$server$Http2NodeStage$$F.async((Function1)(JProcedure1 & Serializable)cb -> {
            if (complete$1.elem) {
                cb.apply((Object)org.http4s.blazecore.util.package$.MODULE$.End());
            } else {
                this.channelRead(this.channelRead$default$1(), this.timeout).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (try_ instanceof Success) {
                        StreamFrame streamFrame = (StreamFrame)((Success)try_).value();
                        if (streamFrame instanceof DataFrame) {
                            long l;
                            boolean bl;
                            DataFrame dataFrame = DataFrame$.MODULE$.unapply((DataFrame)streamFrame);
                            boolean bl2 = dataFrame._1();
                            ByteBuffer byteBuffer = dataFrame._2();
                            boolean last = bl2;
                            ByteBuffer bytes = byteBuffer;
                            complete$2.elem = bl = last;
                            bytesRead$2.elem = l = bytesRead$2.elem + (long)bytes.remaining();
                            if (complete$2.elem && maxlen > 0L && bytesRead$2.elem != maxlen) {
                                String msg = "Entity too small. Expected " + maxlen + ", received " + bytesRead$2.elem;
                                Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                                this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                                cb.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                                return;
                            }
                            if (maxlen > 0L && bytesRead$2.elem > maxlen) {
                                String msg = "Entity too large. Expected " + maxlen + ", received bytesRead";
                                Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                                this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                                cb.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                                return;
                            }
                            cb.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)Some$.MODULE$.apply((Object)Chunk$.MODULE$.bytes(bytes.array()))));
                            return;
                        }
                        if (streamFrame instanceof HeadersFrame) {
                            HeadersFrame headersFrame = HeadersFrame$.MODULE$.unapply((HeadersFrame)streamFrame);
                            Priority priority = headersFrame._1();
                            boolean bl = headersFrame._2();
                            Seq seq = headersFrame._3();
                            if (bl) {
                                Seq ts = seq;
                                Logger Logger_this = this.logger();
                                if (Logger_this.isWarnEnabled()) {
                                    Logger_this.warn("Discarding trailers: " + ts);
                                }
                                cb.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)Some$.MODULE$.apply((Object)Chunk$.MODULE$.empty())));
                                return;
                            }
                        }
                        StreamFrame other = streamFrame;
                        String msg = "Received invalid frame while accumulating body: " + other;
                        Logger Logger_this = this.logger();
                        if (Logger_this.isInfoEnabled()) {
                            Logger_this.info(msg);
                        }
                        Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                        this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                        cb.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                        return;
                    }
                    if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                    Throwable throwable = ((Failure)try_).exception();
                    if (Command.EOF$.MODULE$.equals(throwable)) {
                        Logger Logger_this = this.logger();
                        if (Logger_this.isDebugEnabled()) {
                            Logger_this.debug("EOF while accumulating body");
                        }
                        cb.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply("Received premature EOF.")));
                        this.closePipeline((Option)None$.MODULE$);
                        return;
                    }
                    Throwable t = throwable;
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error in getBody().", t);
                    }
                    Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId, "Failed to read body");
                    cb.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)e));
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                }, this.executionContext());
            }
        });
        FreeC freeC = Stream$.MODULE$.repeatEval(t);
        FreeC freeC2 = Stream$.MODULE$.unNoneTerminate$extension(freeC, (.less.colon.less)$less$colon$less$.MODULE$.refl());
        return Stream$.MODULE$.flatMap$extension(freeC2, (Function1 & Serializable)_$2 -> new Stream(Http2NodeStage.getBody$$anonfun$1(_$2)));
    }

    private void checkAndRunRequest(Seq hs, boolean endStream) {
        ListBuffer headers = new ListBuffer();
        ObjectRef method = ObjectRef.create(null);
        ObjectRef scheme = ObjectRef.create(null);
        ObjectRef path = ObjectRef.create(null);
        LongRef contentLength = LongRef.create((long)-1L);
        ObjectRef error = ObjectRef.create((Object)"");
        BooleanRef pseudoDone = BooleanRef.create((boolean)false);
        hs.foreach((Function1 & Serializable)x$1 -> {
            boolean bl;
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                String string3 = PseudoHeaders$.MODULE$.Method();
                String string4 = string;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        String string5 = (String)error$1.elem + "Pseudo header in invalid position. ";
                        error$1.elem = string5;
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    if ((Method)method$1.elem != null) {
                        String string6 = (String)error$1.elem + "Multiple ':method' headers defined. ";
                        error$1.elem = string6;
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    Either either = Method$.MODULE$.fromString(v);
                    if (either instanceof Right) {
                        Method m;
                        Method method = m = (Method)((Right)either).value();
                        method$1.elem = method;
                    } else {
                        if (!(either instanceof Left)) throw new MatchError((Object)either);
                        ParseFailure e = (ParseFailure)((Left)either).value();
                        String string7 = "" + (String)error$1.elem + " Invalid method: " + e + " ";
                        error$1.elem = string7;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                String string8 = PseudoHeaders$.MODULE$.Scheme();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        String string10 = (String)error$1.elem + "Pseudo header in invalid position. ";
                        error$1.elem = string10;
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    if ((String)scheme$1.elem == null) {
                        String string11 = v;
                        scheme$1.elem = string11;
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    String string12 = (String)error$1.elem + "Multiple ':scheme' headers defined. ";
                    error$1.elem = string12;
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                String string13 = PseudoHeaders$.MODULE$.Path();
                String string14 = string;
                if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        String string15 = (String)error$1.elem + "Pseudo header in invalid position. ";
                        error$1.elem = string15;
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    if ((Uri)path$1.elem != null) {
                        String string16 = (String)error$1.elem + "Multiple ':path' headers defined. ";
                        error$1.elem = string16;
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    Either either = Uri$.MODULE$.requestTarget(v);
                    if (either instanceof Right) {
                        Uri p;
                        Uri uri = p = (Uri)((Right)either).value();
                        path$1.elem = uri;
                    } else {
                        if (!(either instanceof Left)) throw new MatchError((Object)either);
                        ParseFailure e = (ParseFailure)((Left)either).value();
                        String string17 = "" + (String)error$1.elem + " Invalid path: " + e;
                        error$1.elem = string17;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                String string18 = PseudoHeaders$.MODULE$.Authority();
                String string19 = string;
                if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                    if (pseudoDone$1.elem) {
                        String string20 = (String)error$1.elem + "Pseudo header in invalid position. ";
                        error$1.elem = string20;
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                String k = string;
                Tuple2 h = tuple2;
                if (k.startsWith(":")) {
                    String string21 = (String)error$1.elem + ("Invalid pseudo header: " + h + ". ");
                    error$1.elem = string21;
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                String k2 = string;
                if (!HeaderNames$.MODULE$.validH2HeaderKey(k2)) {
                    String string22 = (String)error$1.elem + ("Invalid header key: " + k2 + ". ");
                    error$1.elem = string22;
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
            }
            Tuple2 hs = tuple2;
            pseudoDone$1.elem = bl = true;
            Tuple2 tuple22 = hs;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            String string = (String)tuple22._1();
            String string23 = (String)tuple22._2();
            String string24 = HeaderNames$.MODULE$.Connection();
            String string25 = string;
            if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                Tuple2 h = tuple22;
                String string26 = (String)error$1.elem + ("HTTP/2 forbids connection specific headers: " + h + ". ");
                error$1.elem = string26;
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            String string27 = HeaderNames$.MODULE$.ContentLength();
            String string28 = string;
            if (!(string27 != null ? !string27.equals(string28) : string28 != null)) {
                String v = string23;
                if (contentLength$1.elem < 0L) {
                    Http2NodeStage.liftedTree1$1(endStream, contentLength, error, v);
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                String string29 = (String)error$1.elem + "Received multiple content-length headers";
                error$1.elem = string29;
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            String string30 = HeaderNames$.MODULE$.TE();
            String string31 = string;
            if (!(string30 != null ? !string30.equals(string31) : string31 != null)) {
                String v = string23;
                if (!v.equalsIgnoreCase("trailers")) {
                    String string32 = (String)error$1.elem + "HTTP/2 forbids TE header values other than 'trailers'. ";
                    error$1.elem = string32;
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            String k = string;
            String v = string23;
            String string33 = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
            boxedUnit = headers.$plus$eq((Object)Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string33, (Object)v)));
            return boxedUnit;
        });
        if ((Method)method.elem == null || (String)scheme.elem == null || (Uri)path.elem == null) {
            String string = (String)error.elem + ("Invalid request: missing pseudo headers. Method: " + (Method)method.elem + ", Scheme: " + (String)scheme.elem + ", path: " + (Uri)path.elem + ". ");
            error.elem = string;
        }
        if (((String)error.elem).length() > 0) {
            this.closePipeline((Option)Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, (String)error.elem)));
        } else {
            FreeC body = endStream ? package$.MODULE$.EmptyBody() : this.getBody(contentLength.elem);
            List hs2 = Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers.result(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.identityToRaw(h))}));
            Request req = Request$.MODULE$.apply((Method)method.elem, (Uri)path.elem, HttpVersion$.MODULE$.HTTP$div2(), hs2, body, (Vault)this.attributes.apply());
            this.executionContext().execute(new Runnable(req, this){
                private final Request req$1;
                private final Http2NodeStage $outer;
                {
                    this.req$1 = req$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    Object object = package.all$.MODULE$.catsSyntaxApplicativeError(Sync$.MODULE$.apply(this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).defer(this::$anonfun$1), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                    Object action = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)this.$outer.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler.apply((Object)this.req$1), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).flatMap((Function1 & Serializable)resp -> this.$outer.org$http4s$blaze$server$Http2NodeStage$$renderResponse(resp));
                    this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.runAsync(action, (Function1 & Serializable)x$1 -> {
                        IO iO;
                        Either either = x$1;
                        if (either instanceof Right) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            Object object = ((Right)either).value();
                            if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                                iO = IO$.MODULE$.unit();
                                return iO;
                            }
                        }
                        if (!(either instanceof Left)) throw new MatchError((Object)either);
                        Throwable t = (Throwable)((Left)either).value();
                        iO = IO$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)() -> this.run$$anonfun$2$$anonfun$1(t))).attempt().$times$greater(IO$.MODULE$.apply((Function0)((JFunction0.mcV.sp & Serializable)this::run$$anonfun$3$$anonfun$2)));
                        return iO;
                    }).unsafeRunSync();
                }

                private final Object $anonfun$1() {
                    return this.$outer.org$http4s$blaze$server$Http2NodeStage$$raceTimeout.apply((Object)this.req$1);
                }

                private final void run$$anonfun$2$$anonfun$1(Throwable t$1) {
                    Logger Logger_this = this.$outer.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error running request: " + this.req$1, t$1);
                    }
                }

                private final void run$$anonfun$3$$anonfun$2() {
                    this.$outer.closePipeline((Option)None$.MODULE$);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$1(), $anonfun$2(org.http4s.Response ), run$$anonfun$1(scala.util.Either ), run$$anonfun$2$$anonfun$1(java.lang.Throwable ), run$$anonfun$3$$anonfun$2()}, serializedLambda);
                }
            });
        }
    }

    public F org$http4s$blaze$server$Http2NodeStage$$renderResponse(Response<F> resp) {
        ArrayBuffer hs = new ArrayBuffer(16);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)PseudoHeaders$.MODULE$.Status());
        hs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Integer.toString(resp.status().code())));
        Headers$.MODULE$.foreach$extension(resp.headers(), (Function1)(JProcedure1 & Serializable)h -> {
            CIString cIString = h.name();
            CIString cIString2 = Transfer$minusEncoding$.MODULE$.name();
            if (cIString == null ? cIString2 != null : !cIString.equals(cIString2)) {
                CIString cIString3 = h.name();
                CIString cIString4 = Header$.MODULE$.apply(Connection$.MODULE$.headerInstance()).name();
                if (cIString3 == null ? cIString4 != null : !cIString3.equals(cIString4)) {
                    hs.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)h.name().toString().toLowerCase(Locale.ROOT), (Object)h.value()));
                }
            }
        });
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(new Http2Writer((TailStage)this, (Seq)hs, this.executionContext(), this.org$http4s$blaze$server$Http2NodeStage$$F).writeEntityBody(resp.body()), this.org$http4s$blaze$server$Http2NodeStage$$F);
        return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.org$http4s$blaze$server$Http2NodeStage$$F), this.org$http4s$blaze$server$Http2NodeStage$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                this.closePipeline((Option)None$.MODULE$);
            } else if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    this.stageShutdown();
                } else {
                    Throwable t = throwable;
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)t));
                }
            } else {
                throw new MatchError((Object)either);
            }
        });
    }

    private static final /* synthetic */ FreeC getBody$$anonfun$1(Chunk _$2) {
        FreeC freeC = Stream$.MODULE$.PureOps(Stream$.MODULE$.chunk(_$2));
        return Stream.PureOps$.MODULE$.covary$extension(freeC);
    }

    private static final void liftedTree1$1(boolean endStream$2, LongRef contentLength$2, ObjectRef error$2, String v$1) {
        block4: {
            try {
                long l;
                long sz = Long.parseLong(v$1);
                if (sz != 0L && endStream$2) {
                    String string = (String)error$2.elem + ("Nonzero content length (" + sz + ") for end of stream.");
                    error$2.elem = string;
                    break block4;
                }
                if (sz < 0L) {
                    String string = (String)error$2.elem + ("Negative content length: " + sz);
                    error$2.elem = string;
                    break block4;
                }
                contentLength$2.elem = l = sz;
            }
            catch (NumberFormatException numberFormatException) {
                String string = (String)error$2.elem + ("Invalid content-length: " + v$1 + ". ");
                error$2.elem = string;
            }
        }
    }
}

