/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.Functor;
import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import fs2.Stream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.InvalidBodyException$;
import org.http4s.Method$;
import org.http4s.ParseFailure;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Status$;
import org.http4s.blaze.http.parser.BaseExceptions;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.server.Http1ServerParser;
import org.http4s.blaze.server.Http1ServerStage$;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.Http1Stage;
import org.http4s.blazecore.Http1Stage$;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.blazecore.util.BodylessWriter;
import org.http4s.headers.Connection;
import org.http4s.headers.Connection$;
import org.http4s.headers.Content;
import org.http4s.headers.Content$minusLength$;
import org.http4s.headers.Transfer;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.util.Renderable$;
import org.http4s.util.Renderer$;
import org.http4s.util.StringWriter;
import org.http4s.util.Writer;
import org.http4s.websocket.WebSocketContext;
import org.slf4j.Logger;
import org.typelevel.ci.CIString;
import org.typelevel.ci.package$;
import org.typelevel.vault.Key;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;

public class Http1ServerStage<F>
implements Http1Stage<F>,
TailStage<ByteBuffer> {
    private Logger logger;
    private Head _prevStage;
    private final Function0<Vault> requestAttrs;
    private final ExecutionContext executionContext;
    private final int chunkBufferMaxSize;
    public final Function1<Request<F>, PartialFunction<Throwable, F>> org$http4s$blaze$server$Http1ServerStage$$serviceErrorHandler;
    private final Duration idleTimeout;
    private final TickWheelExecutor scheduler;
    private final Dispatcher dispatcher;
    private final Async F;
    private final Function1<Request<F>, F> runApp;
    public final Http1ServerParser<F> org$http4s$blaze$server$Http1ServerStage$$parser;
    private boolean isClosed;
    public Option<Function0<Future<BoxedUnit>>> org$http4s$blaze$server$Http1ServerStage$$cancelToken;
    private final String name;
    private final Function1<Try<ByteBuffer>, BoxedUnit> handleReqRead;
    public final Function1<Request<F>, F> org$http4s$blaze$server$Http1ServerStage$$raceTimeout;

    public static <F> Http1ServerStage<F> apply(Kleisli<F, Request<F>, Response<F>> kleisli, Function0<Vault> function0, ExecutionContext executionContext, Key<WebSocketContext<F>> key, int n, int n2, int n3, Function1<Request<F>, PartialFunction<Throwable, Object>> function1, Duration duration, Duration duration2, TickWheelExecutor tickWheelExecutor, Dispatcher<F> dispatcher, Option<Object> option, Async<F> async) {
        return Http1ServerStage$.MODULE$.apply(kleisli, function0, executionContext, key, n, n2, n3, function1, duration, duration2, tickWheelExecutor, dispatcher, option, async);
    }

    public Http1ServerStage(Kleisli<F, Request<F>, Response<F>> httpApp, Function0<Vault> requestAttrs, ExecutionContext executionContext, int maxRequestLineLen, int maxHeadersLen, int chunkBufferMaxSize, Function1<Request<F>, PartialFunction<Throwable, Object>> serviceErrorHandler, Duration responseHeaderTimeout, Duration idleTimeout, TickWheelExecutor scheduler, Dispatcher<F> dispatcher, Async<F> F) {
        Function1 & Serializable intersect;
        this.requestAttrs = requestAttrs;
        this.executionContext = executionContext;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.org$http4s$blaze$server$Http1ServerStage$$serviceErrorHandler = serviceErrorHandler;
        this.idleTimeout = idleTimeout;
        this.scheduler = scheduler;
        this.dispatcher = dispatcher;
        this.F = F;
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        this.runApp = httpApp.run();
        this.org$http4s$blaze$server$Http1ServerStage$$parser = new Http1ServerParser<F>(this.logger(), maxRequestLineLen, maxHeadersLen, F);
        this.isClosed = false;
        this.org$http4s$blaze$server$Http1ServerStage$$cancelToken = None$.MODULE$;
        this.name = "Http4sServerStage";
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace("Http4sStage starting up");
        }
        this.handleReqRead = (JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                ByteBuffer buff = (ByteBuffer)((Success)try_).value();
                this.reqLoopCallback(buff);
            } else if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    this.org$http4s$blaze$server$Http1ServerStage$$closeConnection();
                } else {
                    Throwable t = throwable;
                    this.fatalError(t, "Error in requestLoop()");
                }
            } else {
                throw new MatchError((Object)try_);
            }
        };
        Duration duration = responseHeaderTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finite = (FiniteDuration)duration;
            Object timeoutResponse = F.async((Function1 & Serializable)cb -> F.delay(() -> Http1ServerStage.$anonfun$1$$anonfun$1(executionContext, scheduler, F, finite, cb)));
            intersect = (Function1 & Serializable)req -> package.all$.MODULE$.toFunctorOps(F.race(this.runApp.apply(req), timeoutResponse), (Functor)F).map((Function1 & Serializable)_$6 -> {
                Either either = Either$.MODULE$.MergeableEither(_$6);
                return (Response)Either.MergeableEither$.MODULE$.merge$extension(either);
            });
        } else {
            intersect = this.runApp;
        }
        this.org$http4s$blaze$server$Http1ServerStage$$raceTimeout = intersect;
        Statics.releaseFence();
    }

    public final Logger logger() {
        return this.logger;
    }

    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Head _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public int chunkBufferMaxSize() {
        return this.chunkBufferMaxSize;
    }

    public Dispatcher<F> dispatcher() {
        return this.dispatcher;
    }

    public Async<F> F() {
        return this.F;
    }

    public String name() {
        return this.name;
    }

    public final Option<ByteBuffer> doParseContent(ByteBuffer buffer) {
        Option<ByteBuffer> option;
        Http1ServerParser<F> http1ServerParser = this.org$http4s$blaze$server$Http1ServerStage$$parser;
        synchronized (http1ServerParser) {
            option = this.org$http4s$blaze$server$Http1ServerStage$$parser.doParseContent(buffer);
        }
        return option;
    }

    public final boolean contentComplete() {
        boolean bl;
        Http1ServerParser<F> http1ServerParser = this.org$http4s$blaze$server$Http1ServerStage$$parser;
        synchronized (http1ServerParser) {
            bl = this.org$http4s$blaze$server$Http1ServerStage$$parser.contentComplete();
        }
        return bl;
    }

    public void stageStartup() {
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug("Starting HTTP pipeline");
        }
        this.initIdleTimeout();
        this.requestLoop();
    }

    private void initIdleTimeout() {
        block0: {
            Duration duration = this.idleTimeout;
            if (!(duration instanceof FiniteDuration)) break block0;
            FiniteDuration f = (FiniteDuration)duration;
            JProcedure1 & Serializable cb = (JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable t = (Throwable)((Left)either).value();
                    this.fatalError(t, "Error in idle timeout callback");
                } else if (either instanceof Right) {
                    Logger Logger_this = this.logger();
                    if (Logger_this.isDebugEnabled()) {
                        Logger_this.debug("Shutting down due to idle timeout");
                    }
                    this.closePipeline((Option)None$.MODULE$);
                } else {
                    throw new MatchError((Object)either);
                }
            };
            IdleTimeoutStage stage = new IdleTimeoutStage(f, this.scheduler, this.executionContext());
            this.spliceBefore((MidStage)stage);
            stage.init((Function1)cb);
        }
    }

    private void requestLoop() {
        this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete(this.handleReqRead, Execution$.MODULE$.trampoline());
    }

    private void reqLoopCallback(ByteBuffer buff) {
        this.logRequest(buff);
        Http1ServerParser<F> http1ServerParser = this.org$http4s$blaze$server$Http1ServerStage$$parser;
        synchronized (http1ServerParser) {
            BoxedUnit boxedUnit;
            if (!this.isClosed) {
                this.liftedTree1$1(buff);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void logRequest(ByteBuffer buffer) {
        Logger Logger_this = this.logger();
        if (Logger_this.isTraceEnabled()) {
            String msg = BufferTools$.MODULE$.bufferToString(buffer.duplicate(), BufferTools$.MODULE$.bufferToString$default$2()).replace("\r", "\\r").replace("\n", "\\n\n");
            Logger_this.trace(new StringBuilder(18).append("Received Request:\n").append(msg).toString());
        }
    }

    private void runRequest(ByteBuffer buffer) {
        Tuple2 tuple2;
        Tuple2 tuple22 = this.collectBodyFromParser(buffer, (Function0 & Serializable)() -> EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply("Received premature EOF.")));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Stream body = (Stream)tuple22._1();
        Function0 cleanup = (Function0)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)body, (Object)cleanup);
        Stream body2 = (Stream)tuple23._1();
        Function0 cleanup2 = (Function0)tuple23._2();
        Either<Tuple2<ParseFailure, HttpVersion>, Request<F>> either = this.org$http4s$blaze$server$Http1ServerStage$$parser.collectMessage(body2, (Vault)this.requestAttrs.apply());
        if (either instanceof Right) {
            Request req = (Request)((Right)either).value();
            this.executionContext().execute(new Runnable(cleanup2, req, this){
                private final Function0 cleanup$1;
                private final Request req$1;
                private final Http1ServerStage $outer;
                {
                    this.cleanup$1 = cleanup$2;
                    this.req$1 = req$3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.$outer.org$http4s$blaze$server$Http1ServerStage$$raceTimeout.apply((Object)this.req$1), this.$outer.F());
                    Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)this.$outer.org$http4s$blaze$server$Http1ServerStage$$serviceErrorHandler.apply((Object)this.req$1), this.$outer.F()), this.$outer.F()).flatMap((Function1 & Serializable)resp -> this.$outer.F().delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$5$$anonfun$1(resp)))), this.$outer.F());
                    Object action = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.$outer.F()), this.$outer.F()).flatMap((Function1 & Serializable)x$1 -> {
                        Object object;
                        Either either = x$1;
                        if (either instanceof Right) {
                            object = this.$outer.F().unit();
                        } else if (either instanceof Left) {
                            Throwable t = (Throwable)((Left)either).value();
                            Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(this.$outer.F().delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$6$$anonfun$1(t))), this.$outer.F());
                            object = package.all$.MODULE$.catsSyntaxApply(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.$outer.F()), this.$outer.F()).$times$greater(this.$outer.F().delay((Function0)((JFunction0.mcV.sp & Serializable)this::$anonfun$6$$anonfun$2)));
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return object;
                    });
                    Some token = Some$.MODULE$.apply(this.$outer.dispatcher().unsafeToFutureCancelable(action)._2());
                    Http1ServerParser<F> http1ServerParser = this.$outer.org$http4s$blaze$server$Http1ServerStage$$parser;
                    synchronized (http1ServerParser) {
                        this.$outer.org$http4s$blaze$server$Http1ServerStage$$cancelToken = token;
                    }
                }

                private final void $anonfun$5$$anonfun$1(Response resp$1) {
                    this.$outer.renderResponse(this.req$1, resp$1, (Function0<Future<ByteBuffer>>)this.cleanup$1);
                }

                private final void $anonfun$6$$anonfun$1(Throwable t$1) {
                    Logger Logger_this = this.$outer.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error(new StringBuilder(23).append("Error running request: ").append(this.req$1).toString(), t$1);
                    }
                }

                private final void $anonfun$6$$anonfun$2() {
                    this.$outer.org$http4s$blaze$server$Http1ServerStage$$closeConnection();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$5(org.http4s.Response ), $anonfun$6(scala.util.Either ), $anonfun$5$$anonfun$1(org.http4s.Response ), $anonfun$6$$anonfun$1(java.lang.Throwable ), $anonfun$6$$anonfun$2()}, serializedLambda);
                }
            });
        } else if (either instanceof Left && (tuple2 = (Tuple2)((Left)either).value()) != null) {
            ParseFailure e = (ParseFailure)tuple2._1();
            HttpVersion protocol = (HttpVersion)tuple2._2();
            this.badMessage(e.details(), (BaseExceptions.ParserException)new BaseExceptions.BadMessage(e.sanitized()), (Request)Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), Request$.MODULE$.apply$default$2(), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withHttpVersion(protocol));
        } else {
            throw new MatchError(either);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void renderResponse(Request<F> req, Response<F> resp, Function0<Future<ByteBuffer>> bodyCleanup) {
        block6: {
            block4: {
                block5: {
                    rr = new StringWriter(512);
                    rr.$less$less((Object)req.httpVersion(), Renderable$.MODULE$.renderableInst()).$less$less(' ').$less$less((Object)resp.status(), Renderable$.MODULE$.renderableInst()).$less$less("\r\n");
                    Http1Stage$.MODULE$.encodeHeaders((Iterable)resp.headers(), (Writer)rr, true);
                    respTransferCoding = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Transfer$minusEncoding$.MODULE$.headerSemigroupInstance(), Transfer$minusEncoding$.MODULE$.headerInstance()));
                    lengthHeader = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.singleHeaders(Content$minusLength$.MODULE$.headerInstance()));
                    respConn = Headers$.MODULE$.get$extension(resp.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance()));
                    closeOnFinish = BoxesRunTime.unboxToBoolean((Object)respConn.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$7(org.http4s.headers.Connection ), (Lorg/http4s/headers/Connection;)Z)()).orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$8(org.http4s.Request org.http4s.util.StringWriter ), ()Lscala/Option;)((Http1ServerStage)this, req, (StringWriter)rr)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$9(), ()Z)((Http1ServerStage)this)));
                    v0 = req.method();
                    var10_9 = Method$.MODULE$.HEAD();
                    if ((v0 == null ? var10_9 != null : v0.equals(var10_9) == false) && resp.status().isEntityAllowed()) break block4;
                    if (!resp.status().isEntityAllowed() && (lengthHeader.isDefined() || respTransferCoding.isDefined()) && (Logger_this = this.logger()).isWarnEnabled()) {
                        Logger_this.warn(new StringBuilder(74).append("Body detected for response code ").append(resp.status().code()).append(" which doesn't permit an entity. Dropping.").toString());
                    }
                    v1 = req.method();
                    var12_11 = Method$.MODULE$.HEAD();
                    if ((v1 != null ? v1.equals(var12_11) == false : var12_11 != null) || (var13_12 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.org$http4s$blaze$server$Http1ServerStage$$parser.minorVersion()), (Object)respTransferCoding, (Object)lengthHeader)) == null) break block5;
                    var14_13 = (Option)var13_12._2();
                    var15_14 = (Option)var13_12._3();
                    minor = BoxesRunTime.unboxToInt((Object)var13_12._1());
                    if (!(var14_13 instanceof Some)) ** GOTO lbl-1000
                    enc = (Transfer.minusEncoding)((Some)var14_13).value();
                    if (minor > 0 && enc.hasChunked()) {
                        rr.$less$less("Transfer-Encoding: chunked\r\n");
                    } else if (var15_14 instanceof Some) {
                        len = (Content.minusLength)((Some)var15_14).value();
                        rr.$less$less((Object)len, Renderer$.MODULE$.headerSelectRenderer(Header.Select$.MODULE$.singleHeaders(Content$minusLength$.MODULE$.headerInstance()))).$less$less("\r\n");
                    }
                }
                rr.$less$less(closeOnFinish == false && this.org$http4s$blaze$server$Http1ServerStage$$parser.minorVersion() == 0 && respConn.isEmpty() != false ? "Connection: keep-alive\r\n\r\n" : "\r\n");
                v2 = new BodylessWriter((TailStage)this, closeOnFinish, this.F());
                break block6;
            }
            v2 = this.getEncoder(respConn, respTransferCoding, lengthHeader, resp.trailerHeaders(this.F()), rr, this.org$http4s$blaze$server$Http1ServerStage$$parser.minorVersion(), closeOnFinish, false);
        }
        bodyEncoder = v2;
        var21_19 = package.all$.MODULE$.catsSyntaxApplicativeError(bodyEncoder.write(rr, resp.body()), this.F());
        var20_20 = package.all$.MODULE$.catsSyntaxApplicativeError(ApplicativeErrorOps$.MODULE$.recover$extension(var21_19, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return Command.EOF$.MODULE$.equals(throwable);
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return Command.EOF$.MODULE$.equals(throwable) ? BoxesRunTime.boxToBoolean((boolean)true) : function1.apply((Object)x);
            }
        }, this.F()), this.F());
        fa = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(var20_20, this.F()), this.F()).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$10(scala.Function0 boolean scala.util.Either ), (Lscala/util/Either;)Ljava/lang/Object;)((Http1ServerStage)this, bodyCleanup, (boolean)closeOnFinish));
        this.dispatcher().unsafeRunAndForget(fa);
    }

    public void org$http4s$blaze$server$Http1ServerStage$$closeConnection() {
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug("closeConnection()");
        }
        this.stageShutdown();
        this.closePipeline((Option)None$.MODULE$);
    }

    public void stageShutdown() {
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug("Shutting down HttpPipeline");
        }
        Http1ServerParser<F> http1ServerParser = this.org$http4s$blaze$server$Http1ServerStage$$parser;
        synchronized (http1ServerParser) {
            this.cancel();
            this.isClosed = true;
            this.org$http4s$blaze$server$Http1ServerStage$$parser.shutdownParser();
        }
        Stage.stageShutdown$((Stage)this);
    }

    private void cancel() {
        this.org$http4s$blaze$server$Http1ServerStage$$cancelToken.foreach((Function1)(JProcedure1 & Serializable)_$5 -> ((Future)_$5.apply()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (!(try_ instanceof Success)) {
                if (try_ instanceof Failure) {
                    Throwable t = ((Failure)try_).exception();
                    Logger Logger_this = this.logger();
                    if (Logger_this.isWarnEnabled()) {
                        Logger_this.warn("Error canceling request. No request details are available.", t);
                    }
                } else {
                    throw new MatchError((Object)try_);
                }
            }
        }, this.executionContext()));
    }

    public final void badMessage(String debugMessage, BaseExceptions.ParserException t, Request<F> req) {
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(13).append("Bad Request: ").append(debugMessage).toString(), (Throwable)t);
        }
        Response resp = (Response)Response$.MODULE$.apply(Status$.MODULE$.BadRequest(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Connection$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"close"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])), Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.zero(), Content$minusLength$.MODULE$.headerInstance())}));
        this.renderResponse(req, resp, (Function0<Future<ByteBuffer>>)(Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BufferTools$.MODULE$.emptyBuffer()));
    }

    public final void internalServerError(String errorMsg, Throwable t, Request<F> req, Function0<Future<ByteBuffer>> bodyCleanup) {
        Logger Logger_this = this.logger();
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error(errorMsg, t);
        }
        Response resp = (Response)Response$.MODULE$.apply(Status$.MODULE$.InternalServerError(), Response$.MODULE$.apply$default$2(), Response$.MODULE$.apply$default$3(), Response$.MODULE$.apply$default$4(), Response$.MODULE$.apply$default$5()).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Connection$.MODULE$.apply(package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"close"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CIString[0])), Connection$.MODULE$.headerInstance()), Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusLength$.MODULE$.zero(), Content$minusLength$.MODULE$.headerInstance())}));
        this.renderResponse(req, resp, bodyCleanup);
    }

    private static final void $anonfun$1$$anonfun$1$$anonfun$1(Cancelable cancellable$1) {
        cancellable$1.cancel();
    }

    private static final Some $anonfun$1$$anonfun$1(ExecutionContext executionContext$2, TickWheelExecutor scheduler$2, Async F$2, FiniteDuration finite$2, Function1 cb$1) {
        Cancelable cancellable = scheduler$2.schedule(() -> cb$1.apply((Object)Right$.MODULE$.apply((Object)Response$.MODULE$.timeout())), executionContext$2, (Duration)finite$2);
        return Some$.MODULE$.apply(F$2.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> Http1ServerStage.$anonfun$1$$anonfun$1$$anonfun$1(cancellable))));
    }

    private final void liftedTree1$1(ByteBuffer buff$1) {
        block5: {
            try {
                if (!this.org$http4s$blaze$server$Http1ServerStage$$parser.requestLineComplete() && !this.org$http4s$blaze$server$Http1ServerStage$$parser.doParseRequestLine(buff$1)) {
                    this.requestLoop();
                    break block5;
                }
                if (!this.org$http4s$blaze$server$Http1ServerStage$$parser.headersComplete() && !this.org$http4s$blaze$server$Http1ServerStage$$parser.doParseHeaders(buff$1)) {
                    this.requestLoop();
                    break block5;
                }
                this.runRequest(buff$1);
            }
            catch (BaseExceptions.BadMessage t) {
                this.badMessage("Error parsing status or headers in requestLoop()", (BaseExceptions.ParserException)t, Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), Request$.MODULE$.apply$default$2(), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()));
            }
            catch (Throwable t) {
                this.internalServerError("error in requestLoop()", t, Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), Request$.MODULE$.apply$default$2(), Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()), (Function0<Future<ByteBuffer>>)(Function0 & Serializable)() -> Future$.MODULE$.successful((Object)BufferTools$.MODULE$.emptyBuffer()));
            }
        }
    }

    private static final /* synthetic */ boolean $anonfun$7(Connection _$3) {
        return _$3.hasClose();
    }

    private final Option $anonfun$8(Request req$2, StringWriter rr$1) {
        return Headers$.MODULE$.get$extension(req$2.headers(), Header.Select$.MODULE$.recurringHeadersWithMerge(Connection$.MODULE$.headerSemigroupInstance(), Connection$.MODULE$.headerInstance())).map((Function1 & Serializable)_$4 -> this.checkCloseConnection((Connection)_$4, rr$1));
    }

    private final boolean $anonfun$9() {
        return this.org$http4s$blaze$server$Http1ServerStage$$parser.minorVersion() == 0;
    }

    private final void $anonfun$10$$anonfun$1() {
        this.org$http4s$blaze$server$Http1ServerStage$$closeConnection();
    }

    private final void $anonfun$10$$anonfun$2(Function0 bodyCleanup$2) {
        ((Future)bodyCleanup$2.apply()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Success s = (Success)try_;
                this.org$http4s$blaze$server$Http1ServerStage$$parser.reset();
                this.handleReqRead.apply((Object)s);
            } else if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    this.org$http4s$blaze$server$Http1ServerStage$$closeConnection();
                } else {
                    Throwable t = throwable;
                    this.fatalError(t, "Failure in body cleanup");
                }
            } else {
                throw new MatchError((Object)try_);
            }
        }, Execution$.MODULE$.trampoline());
    }

    private final void $anonfun$10$$anonfun$3() {
        this.org$http4s$blaze$server$Http1ServerStage$$closeConnection();
    }

    private final /* synthetic */ Object $anonfun$10(Function0 bodyCleanup$1, boolean closeOnFinish$1, Either x$1) {
        Object object;
        Either either = x$1;
        if (either instanceof Right) {
            boolean requireClose = BoxesRunTime.unboxToBoolean((Object)((Right)either).value());
            if (closeOnFinish$1 || requireClose) {
                Logger Logger_this = this.logger();
                if (Logger_this.isTraceEnabled()) {
                    Logger_this.trace("Request/route requested closing connection.");
                }
                object = this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)this::$anonfun$10$$anonfun$1));
            } else {
                object = this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$10$$anonfun$2(bodyCleanup$1)));
            }
        } else if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Error writing body", t);
            }
            object = this.F().delay((Function0)((JFunction0.mcV.sp & Serializable)this::$anonfun$10$$anonfun$3));
        } else {
            throw new MatchError((Object)either);
        }
        return object;
    }
}

