/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.syntax.GenTemporalOps_$;
import cats.effect.std.Dispatcher;
import cats.effect.syntax.package;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherObjectOps$;
import cats.syntax.package;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.http4s.Header;
import org.http4s.Header$;
import org.http4s.Headers$;
import org.http4s.HttpVersion$;
import org.http4s.InvalidBodyException$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.ParseFailure;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Response$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.blaze.http.HeaderNames$;
import org.http4s.blaze.http.http2.DataFrame;
import org.http4s.blaze.http.http2.DataFrame$;
import org.http4s.blaze.http.http2.HeadersFrame;
import org.http4s.blaze.http.http2.HeadersFrame$;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2StreamException;
import org.http4s.blaze.http.http2.Priority;
import org.http4s.blaze.http.http2.PseudoHeaders$;
import org.http4s.blaze.http.http2.StreamFrame;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blazecore.IdleTimeoutStage;
import org.http4s.blazecore.util.Http2Writer;
import org.http4s.headers.Connection$;
import org.http4s.headers.Transfer$minusEncoding$;
import org.http4s.package$;
import org.slf4j.Logger;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Failure;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public class Http2NodeStage<F>
implements TailStage<StreamFrame> {
    private Logger logger;
    private Head _prevStage;
    private final int streamId;
    private final Duration timeout;
    private final ExecutionContext executionContext;
    private final Function0<Vault> attributes;
    public final Function1<Request<F>, PartialFunction<Throwable, F>> org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler;
    private final Duration idleTimeout;
    private final TickWheelExecutor scheduler;
    public final Dispatcher<F> org$http4s$blaze$server$Http2NodeStage$$dispatcher;
    public final Async<F> org$http4s$blaze$server$Http2NodeStage$$F;
    private final Function1<Request<F>, F> runApp;
    public final Function1<Request<F>, F> org$http4s$blaze$server$Http2NodeStage$$raceTimeout;

    public Http2NodeStage(int streamId, Duration timeout, ExecutionContext executionContext, Function0<Vault> attributes, Kleisli<F, Request<F>, Response<F>> httpApp, Function1<Request<F>, PartialFunction<Throwable, Object>> serviceErrorHandler, Duration responseHeaderTimeout, Duration idleTimeout, TickWheelExecutor scheduler, Dispatcher<F> dispatcher, Async<F> F) {
        Function1 & Serializable intersect;
        this.streamId = streamId;
        this.timeout = timeout;
        this.executionContext = executionContext;
        this.attributes = attributes;
        this.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler = serviceErrorHandler;
        this.idleTimeout = idleTimeout;
        this.scheduler = scheduler;
        this.org$http4s$blaze$server$Http2NodeStage$$dispatcher = dispatcher;
        this.org$http4s$blaze$server$Http2NodeStage$$F = F;
        Stage.$init$((Stage)this);
        Tail.$init$((Tail)this);
        this.runApp = httpApp.run();
        Duration duration = responseHeaderTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration finite = (FiniteDuration)duration;
            intersect = (Function1 & Serializable)req -> {
                Object object = package.temporal$.MODULE$.genTemporalOps_(this.runApp.apply(req));
                return GenTemporalOps_$.MODULE$.timeoutTo$extension(object, finite, F.pure((Object)Response$.MODULE$.timeout()), (GenTemporal)F);
            };
        } else {
            intersect = this.runApp;
        }
        this.org$http4s$blaze$server$Http2NodeStage$$raceTimeout = intersect;
        Statics.releaseFence();
    }

    public final Logger logger() {
        return this.logger;
    }

    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    public Head _prevStage() {
        return this._prevStage;
    }

    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    private ExecutionContext executionContext() {
        return this.executionContext;
    }

    public String name() {
        return "Http2NodeStage";
    }

    public void stageStartup() {
        Stage.stageStartup$((Stage)this);
        this.initIdleTimeout();
        this.readHeaders();
    }

    private void initIdleTimeout() {
        Duration duration = this.idleTimeout;
        if (duration instanceof FiniteDuration) {
            FiniteDuration f = (FiniteDuration)duration;
            JProcedure1 & Serializable cb = (JProcedure1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Throwable t = (Throwable)((Left)either).value();
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error in idle timeout callback", t);
                    }
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)t));
                    return;
                }
                if (either instanceof Right) {
                    Logger Logger_this = this.logger();
                    if (Logger_this.isDebugEnabled()) {
                        Logger_this.debug("Shutting down due to idle timeout");
                    }
                    this.closePipeline((Option)None$.MODULE$);
                    return;
                }
                throw new MatchError((Object)either);
            };
            IdleTimeoutStage stage = new IdleTimeoutStage(f, this.scheduler, this.executionContext());
            this.spliceBefore((MidStage)stage);
            stage.init((Function1)cb);
            return;
        }
    }

    private void readHeaders() {
        this.channelRead(this.channelRead$default$1(), this.timeout).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                StreamFrame streamFrame = (StreamFrame)((Success)try_).value();
                if (streamFrame instanceof HeadersFrame) {
                    HeadersFrame headersFrame = HeadersFrame$.MODULE$.unapply((HeadersFrame)streamFrame);
                    Priority priority = headersFrame._1();
                    boolean bl = headersFrame._2();
                    Seq seq = headersFrame._3();
                    boolean endStream = bl;
                    Seq hs = seq;
                    this.checkAndRunRequest((Seq<Tuple2<String, String>>)hs, endStream);
                    return;
                }
                StreamFrame frame = streamFrame;
                Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, new StringBuilder(24).append("Received invalid frame: ").append(frame).toString());
                this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    this.closePipeline((Option)None$.MODULE$);
                    return;
                }
                Throwable t = throwable;
                Logger Logger_this = this.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Unknown error in readHeaders", t);
                }
                Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId, "Unknown error");
                this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                return;
            }
            throw new MatchError((Object)try_);
        }, this.executionContext());
    }

    private Stream<F, Object> getBody(long maxlen) {
        BooleanRef complete = BooleanRef.create((boolean)false);
        LongRef bytesRead = LongRef.create((long)0L);
        Object t = this.org$http4s$blaze$server$Http2NodeStage$$F.async((Function1 & Serializable)cb -> this.org$http4s$blaze$server$Http2NodeStage$$F.delay(() -> this.$anonfun$2$$anonfun$1(maxlen, complete, bytesRead, cb)));
        Stream stream = Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.repeatEval(t));
        return Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(stream).flatMap((Function1 & Serializable)_$2 -> Stream$.MODULE$.chunk(_$2), NotGiven$.MODULE$.value());
    }

    private void checkAndRunRequest(Seq<Tuple2<String, String>> hs, boolean endStream) {
        ListBuffer headers = new ListBuffer();
        ObjectRef method = ObjectRef.create(null);
        ObjectRef scheme = ObjectRef.create(null);
        ObjectRef path = ObjectRef.create(null);
        LongRef contentLength = LongRef.create((long)-1L);
        ObjectRef error = ObjectRef.create((Object)"");
        BooleanRef pseudoDone = BooleanRef.create((boolean)false);
        hs.foreach((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                String string2 = (String)tuple2._2();
                String string3 = PseudoHeaders$.MODULE$.Method();
                String string4 = string;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        String string5 = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        error$1.elem = string5;
                        string5 = null;
                        return BoxedUnit.UNIT;
                    }
                    if ((Method)method$1.elem == null) {
                        Either either = Method$.MODULE$.fromString(v);
                        if (either instanceof Right) {
                            Method m;
                            Method method = m = (Method)((Right)either).value();
                            method$1.elem = method;
                            method = null;
                        } else if (either instanceof Left) {
                            ParseFailure e = (ParseFailure)((Left)either).value();
                            String string6 = new StringBuilder(18).append((String)error$1.elem).append(" Invalid method: ").append(e).append(" ").toString();
                            error$1.elem = string6;
                            string6 = null;
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return BoxedUnit.UNIT;
                    }
                    String string7 = new StringBuilder(36).append((String)error$1.elem).append("Multiple ':method' headers defined. ").toString();
                    error$1.elem = string7;
                    string7 = null;
                    return BoxedUnit.UNIT;
                }
                String string8 = PseudoHeaders$.MODULE$.Scheme();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        String string10 = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        error$1.elem = string10;
                        string10 = null;
                        return BoxedUnit.UNIT;
                    }
                    if ((String)scheme$1.elem == null) {
                        String string11 = v;
                        scheme$1.elem = string11;
                        string11 = null;
                        return BoxedUnit.UNIT;
                    }
                    String string12 = new StringBuilder(36).append((String)error$1.elem).append("Multiple ':scheme' headers defined. ").toString();
                    error$1.elem = string12;
                    string12 = null;
                    return BoxedUnit.UNIT;
                }
                String string13 = PseudoHeaders$.MODULE$.Path();
                String string14 = string;
                if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                    String v = string2;
                    if (pseudoDone$1.elem) {
                        String string15 = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        error$1.elem = string15;
                        string15 = null;
                        return BoxedUnit.UNIT;
                    }
                    if ((Uri)path$1.elem == null) {
                        Either either = Uri$.MODULE$.requestTarget(v);
                        if (either instanceof Right) {
                            Uri p;
                            Uri uri = p = (Uri)((Right)either).value();
                            path$1.elem = uri;
                            uri = null;
                        } else if (either instanceof Left) {
                            ParseFailure e = (ParseFailure)((Left)either).value();
                            String string16 = new StringBuilder(15).append((String)error$1.elem).append(" Invalid path: ").append(e).toString();
                            error$1.elem = string16;
                            string16 = null;
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return BoxedUnit.UNIT;
                    }
                    String string17 = new StringBuilder(34).append((String)error$1.elem).append("Multiple ':path' headers defined. ").toString();
                    error$1.elem = string17;
                    string17 = null;
                    return BoxedUnit.UNIT;
                }
                String string18 = PseudoHeaders$.MODULE$.Authority();
                String string19 = string;
                if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                    if (pseudoDone$1.elem) {
                        String string20 = new StringBuilder(35).append((String)error$1.elem).append("Pseudo header in invalid position. ").toString();
                        error$1.elem = string20;
                        string20 = null;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                String k = string;
                Tuple2 h = tuple2;
                if (k.startsWith(":")) {
                    String string21 = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(25).append("Invalid pseudo header: ").append(h).append(". ").toString()).toString();
                    error$1.elem = string21;
                    string21 = null;
                    return BoxedUnit.UNIT;
                }
                String k2 = string;
                if (!HeaderNames$.MODULE$.validH2HeaderKey(k2)) {
                    String string22 = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(22).append("Invalid header key: ").append(k2).append(". ").toString()).toString();
                    error$1.elem = string22;
                    string22 = null;
                    return BoxedUnit.UNIT;
                }
            }
            Tuple2 hs = tuple2;
            pseudoDone$1.elem = bl = true;
            Tuple2 tuple22 = hs;
            if (tuple22 != null) {
                String string = (String)tuple22._1();
                String string23 = (String)tuple22._2();
                String string24 = HeaderNames$.MODULE$.Connection();
                String string25 = string;
                if (!(string24 != null ? !string24.equals(string25) : string25 != null)) {
                    Tuple2 h = tuple22;
                    String string26 = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(46).append("HTTP/2 forbids connection specific headers: ").append(h).append(". ").toString()).toString();
                    error$1.elem = string26;
                    string26 = null;
                    return BoxedUnit.UNIT;
                }
                String string27 = HeaderNames$.MODULE$.ContentLength();
                String string28 = string;
                if (!(string27 != null ? !string27.equals(string28) : string28 != null)) {
                    String v = string23;
                    if (contentLength$1.elem < 0L) {
                        BoxedUnit boxedUnit;
                        try {
                            long sz = Long.parseLong(v);
                            if (sz != 0L && endStream) {
                                String string29 = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(44).append("Nonzero content length (").append(sz).append(") for end of stream.").toString()).toString();
                                error$1.elem = string29;
                                string29 = null;
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (sz < 0L) {
                                String string30 = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(25).append("Negative content length: ").append(sz).toString()).toString();
                                error$1.elem = string30;
                                string30 = null;
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                long l;
                                contentLength$1.elem = l = sz;
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string31 = new StringBuilder(0).append((String)error$1.elem).append(new StringBuilder(26).append("Invalid content-length: ").append(v).append(". ").toString()).toString();
                            error$1.elem = string31;
                            string31 = null;
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    String string32 = new StringBuilder(40).append((String)error$1.elem).append("Received multiple content-length headers").toString();
                    error$1.elem = string32;
                    string32 = null;
                    return BoxedUnit.UNIT;
                }
                String string33 = HeaderNames$.MODULE$.TE();
                String string34 = string;
                if (!(string33 != null ? !string33.equals(string34) : string34 != null)) {
                    String v = string23;
                    if (!v.equalsIgnoreCase("trailers")) {
                        String string35 = new StringBuilder(55).append((String)error$1.elem).append("HTTP/2 forbids TE header values other than 'trailers'. ").toString();
                        error$1.elem = string35;
                        string35 = null;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                String k = string;
                String v = string23;
                String string36 = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                return headers.$plus$eq((Object)Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string36, (Object)v)));
            }
            throw new MatchError((Object)tuple22);
        });
        if ((Method)method.elem == null || (String)scheme.elem == null || (Uri)path.elem == null) {
            String string = new StringBuilder(0).append((String)error.elem).append(new StringBuilder(69).append("Invalid request: missing pseudo headers. Method: ").append((Method)method.elem).append(", Scheme: ").append((String)scheme.elem).append(", path: ").append((Uri)path.elem).append(". ").toString()).toString();
            error.elem = string;
            string = null;
        }
        if (((String)error.elem).length() > 0) {
            this.closePipeline((Option)Some$.MODULE$.apply((Object)Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, (String)error.elem)));
            return;
        }
        Stream<F, Object> body = endStream ? package$.MODULE$.EmptyBody() : this.getBody(contentLength.elem);
        List hs2 = Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)headers.result(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.identityToRaw(h))}));
        Request req = Request$.MODULE$.apply((Method)method.elem, (Uri)path.elem, HttpVersion$.MODULE$.HTTP$div2(), hs2, body, (Vault)this.attributes.apply());
        this.executionContext().execute(new Runnable(req, this){
            private final Request req$1;
            private final /* synthetic */ Http2NodeStage $outer;
            {
                this.req$1 = req$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.defer(this::$anonfun$4), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                Object action = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)this.$outer.org$http4s$blaze$server$Http2NodeStage$$serviceErrorHandler.apply((Object)this.req$1), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).flatMap((Function1 & Serializable)_$3 -> this.$outer.org$http4s$blaze$server$Http2NodeStage$$renderResponse(_$3));
                Object object2 = package.all$.MODULE$.catsSyntaxApplicativeError(action, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                Object fa = package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object2, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Right) {
                        return this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.unit();
                    }
                    if (either instanceof Left) {
                        Throwable t = (Throwable)((Left)either).value();
                        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.delay((Function0 & Serializable)() -> {
                            this.$anonfun$6$$anonfun$1(t);
                            return BoxedUnit.UNIT;
                        }), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F);
                        return package.all$.MODULE$.catsSyntaxApply(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.$outer.org$http4s$blaze$server$Http2NodeStage$$F), this.$outer.org$http4s$blaze$server$Http2NodeStage$$F).$times$greater(this.$outer.org$http4s$blaze$server$Http2NodeStage$$F.delay((Function0 & Serializable)() -> {
                            this.$anonfun$6$$anonfun$2();
                            return BoxedUnit.UNIT;
                        }));
                    }
                    throw new MatchError((Object)either);
                });
                this.$outer.org$http4s$blaze$server$Http2NodeStage$$dispatcher.unsafeRunSync(fa);
            }

            private final Object $anonfun$4() {
                return this.$outer.org$http4s$blaze$server$Http2NodeStage$$raceTimeout.apply((Object)this.req$1);
            }

            private final void $anonfun$6$$anonfun$1(Throwable t$1) {
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error(new StringBuilder(23).append("Error running request: ").append(this.req$1).toString(), t$1);
                    return;
                }
            }

            private final void $anonfun$6$$anonfun$2() {
                this.$outer.closePipeline((Option)None$.MODULE$);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$4(), $anonfun$5(org.http4s.Response ), $anonfun$6(scala.util.Either ), $anonfun$adapted$1(java.lang.Throwable ), $anonfun$6$$anonfun$adapted$1()}, serializedLambda);
            }
        });
    }

    public F org$http4s$blaze$server$Http2NodeStage$$renderResponse(Response<F> resp) {
        ArrayBuffer hs = new ArrayBuffer(16);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)PseudoHeaders$.MODULE$.Status());
        hs.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Integer.toString(resp.status().code())));
        Headers$.MODULE$.foreach$extension(resp.headers(), (Function1)(JProcedure1 & Serializable)h -> {
            CIString cIString = h.name();
            CIString cIString2 = Transfer$minusEncoding$.MODULE$.name();
            if (cIString == null ? cIString2 != null : !cIString.equals(cIString2)) {
                CIString cIString3 = h.name();
                CIString cIString4 = Header$.MODULE$.apply(Connection$.MODULE$.headerInstance()).name();
                if (cIString3 == null ? cIString4 != null : !cIString3.equals(cIString4)) {
                    hs.$plus$eq((Object)Tuple2$.MODULE$.apply((Object)h.name().toString().toLowerCase(Locale.ROOT), (Object)h.value()));
                    return;
                }
            }
        });
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(new Http2Writer((TailStage)this, (Seq)hs, this.org$http4s$blaze$server$Http2NodeStage$$F).writeEntityBody(resp.body()), this.org$http4s$blaze$server$Http2NodeStage$$F);
        return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.org$http4s$blaze$server$Http2NodeStage$$F), this.org$http4s$blaze$server$Http2NodeStage$$F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                this.closePipeline((Option)None$.MODULE$);
                return;
            }
            if (either instanceof Left) {
                Throwable throwable = (Throwable)((Left)either).value();
                if (Command.EOF$.MODULE$.equals(throwable)) {
                    this.stageShutdown();
                    return;
                }
                Throwable t = throwable;
                this.closePipeline((Option)Some$.MODULE$.apply((Object)t));
                return;
            }
            throw new MatchError((Object)either);
        });
    }

    private final Option $anonfun$2$$anonfun$1(long maxlen$2, BooleanRef complete$2, LongRef bytesRead$2, Function1 cb$1) {
        if (complete$2.elem) {
            cb$1.apply((Object)org.http4s.blazecore.util.package$.MODULE$.End());
        } else {
            this.channelRead(this.channelRead$default$1(), this.timeout).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    StreamFrame streamFrame = (StreamFrame)((Success)try_).value();
                    if (streamFrame instanceof DataFrame) {
                        long l;
                        boolean bl;
                        DataFrame dataFrame = DataFrame$.MODULE$.unapply((DataFrame)streamFrame);
                        boolean bl2 = dataFrame._1();
                        ByteBuffer byteBuffer = dataFrame._2();
                        boolean last = bl2;
                        ByteBuffer bytes = byteBuffer;
                        complete$3.elem = bl = last;
                        bytesRead$3.elem = l = bytesRead$3.elem + (long)bytes.remaining();
                        if (complete$3.elem && maxlen$2 > 0L && bytesRead$3.elem != maxlen$2) {
                            String msg = new StringBuilder(38).append("Entity too small. Expected ").append(maxlen$2).append(", received ").append(bytesRead$3.elem).toString();
                            Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                            this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                            cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                            return;
                        }
                        if (maxlen$2 > 0L && bytesRead$3.elem > maxlen$2) {
                            String msg = new StringBuilder(47).append("Entity too large. Expected ").append(maxlen$2).append(", received bytesRead").toString();
                            Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                            this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                            cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                            return;
                        }
                        cb$1.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)Some$.MODULE$.apply((Object)Chunk$.MODULE$.array((Object)bytes.array(), ClassTag$.MODULE$.apply(Byte.TYPE)))));
                        return;
                    }
                    if (streamFrame instanceof HeadersFrame) {
                        HeadersFrame headersFrame = HeadersFrame$.MODULE$.unapply((HeadersFrame)streamFrame);
                        Priority priority = headersFrame._1();
                        boolean bl = headersFrame._2();
                        Seq seq = headersFrame._3();
                        if (bl) {
                            Seq ts = seq;
                            Logger Logger_this = this.logger();
                            if (Logger_this.isWarnEnabled()) {
                                Logger_this.warn(new StringBuilder(21).append("Discarding trailers: ").append(ts).toString());
                            }
                            cb$1.apply((Object)EitherObjectOps$.MODULE$.right$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)Some$.MODULE$.apply((Object)Chunk$.MODULE$.empty())));
                            return;
                        }
                    }
                    StreamFrame other = streamFrame;
                    String msg = new StringBuilder(48).append("Received invalid frame while accumulating body: ").append(other).toString();
                    Logger Logger_this = this.logger();
                    if (Logger_this.isInfoEnabled()) {
                        Logger_this.info(msg);
                    }
                    Http2StreamException e = Http2Exception$.MODULE$.PROTOCOL_ERROR().rst(this.streamId, msg);
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                    cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply(msg)));
                    return;
                }
                if (try_ instanceof Failure) {
                    Throwable throwable = ((Failure)try_).exception();
                    if (Command.EOF$.MODULE$.equals(throwable)) {
                        Logger Logger_this = this.logger();
                        if (Logger_this.isDebugEnabled()) {
                            Logger_this.debug("EOF while accumulating body");
                        }
                        cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)InvalidBodyException$.MODULE$.apply("Received premature EOF.")));
                        this.closePipeline((Option)None$.MODULE$);
                        return;
                    }
                    Throwable t = throwable;
                    Logger Logger_this = this.logger();
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error in getBody().", t);
                    }
                    Http2StreamException e = Http2Exception$.MODULE$.INTERNAL_ERROR().rst(this.streamId, "Failed to read body");
                    cb$1.apply((Object)EitherObjectOps$.MODULE$.left$extension(package.all$.MODULE$.catsSyntaxEitherObject(Either$.MODULE$), (Object)e));
                    this.closePipeline((Option)Some$.MODULE$.apply((Object)e));
                    return;
                }
                throw new MatchError((Object)try_);
            }, this.executionContext());
        }
        return None$.MODULE$;
    }
}

