/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.effect.kernel.Async;
import cats.syntax.EitherOps$;
import cats.syntax.package;
import fs2.Stream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.http4s.Header;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.HttpVersion$;
import org.http4s.Message;
import org.http4s.Method$;
import org.http4s.ParseFailure;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Uri$;
import org.slf4j.Logger;
import org.typelevel.vault.InsertKey;
import org.typelevel.vault.Vault;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Http1ServerParser<F>
extends org.http4s.blaze.http.parser.Http1ServerParser {
    private final Logger logger;
    private final Async<F> F;
    private String uri;
    private String method;
    private int minor;
    private final ListBuffer<Header.ToRaw> headers;

    public Http1ServerParser(Logger logger, int maxRequestLine, int maxHeadersLen, Async<F> F) {
        this.logger = logger;
        this.F = F;
        super(maxRequestLine, maxHeadersLen, 2048);
        this.minor = -1;
        this.headers = new ListBuffer();
    }

    public int minorVersion() {
        return this.minor;
    }

    public boolean doParseRequestLine(ByteBuffer buff) {
        return this.parseRequestLine(buff);
    }

    public boolean doParseHeaders(ByteBuffer buff) {
        return this.parseHeaders(buff);
    }

    public Option<ByteBuffer> doParseContent(ByteBuffer buff) {
        return Option$.MODULE$.apply((Object)this.parseContent(buff));
    }

    public Either<Tuple2<ParseFailure, HttpVersion>, Request<F>> collectMessage(Stream<F, Object> body, Vault attrs) {
        List h2 = Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)this.headers.result(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.identityToRaw(h))}));
        this.headers.clear();
        HttpVersion protocol = this.minorVersion() == 1 ? HttpVersion$.MODULE$.HTTP$div1$u002E1() : HttpVersion$.MODULE$.HTTP$div1$u002E0();
        Vault attrsWithTrailers = this.minorVersion() == 1 && this.isChunked() ? attrs.insert((InsertKey)Message.Keys$.MODULE$.TrailerHeaders(), this.F.defer(this::$anonfun$2)) : attrs;
        Either either = package.all$.MODULE$.catsSyntaxEither(Method$.MODULE$.fromString(this.method).flatMap((Function1 & Serializable)method -> Uri$.MODULE$.requestTarget(this.uri).map((Function1 & Serializable)uri -> Request$.MODULE$.apply(method, uri, protocol, h2, body, attrsWithTrailers))));
        return EitherOps$.MODULE$.leftMap$extension(either, (Function1 & Serializable)_$4 -> {
            ParseFailure parseFailure = (ParseFailure)Predef$.MODULE$.ArrowAssoc(_$4);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)parseFailure, (Object)protocol);
        });
    }

    public boolean submitRequestLine(String methodString, String uri, String scheme, int majorversion, int minorversion) {
        Logger Logger_this = this.logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(22).append("Received request(").append(methodString).append(" ").append(uri).append(" ").append(scheme).append("/").append(majorversion).append(".").append(minorversion).append(")").toString());
        }
        this.uri = uri;
        this.method = methodString;
        this.minor = minorversion;
        return false;
    }

    public boolean headerComplete(String name, String value) {
        Logger Logger_this = this.logger;
        if (Logger_this.isTraceEnabled()) {
            Logger_this.trace(new StringBuilder(20).append("Received header '").append(name).append(": ").append(value).append("'").toString());
        }
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
        this.headers.$plus$eq((Object)Header.ToRaw$.MODULE$.keyValuesToRaw(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value)));
        return false;
    }

    public void reset() {
        this.uri = null;
        this.method = null;
        this.minor = -1;
        this.headers.clear();
        super.reset();
    }

    private final Object $anonfun$2() {
        if (!this.contentComplete()) {
            return this.F.raiseError((Object)new IllegalStateException("Attempted to collect trailers before the body was complete."));
        }
        return this.F.pure((Object)new Headers(Headers$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.scalaCollectionSeqToRaw((Seq)this.headers.result(), (Function1 & Serializable)h -> Header.ToRaw$.MODULE$.identityToRaw(h))}))));
    }
}

