/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.server;

import cats.Applicative;
import cats.data.Kleisli;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.effect.std.Dispatcher;
import cats.effect.std.Dispatcher$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.comcast.ip4s.Host;
import com.comcast.ip4s.IpAddress$;
import com.comcast.ip4s.Port;
import com.comcast.ip4s.Port$;
import com.comcast.ip4s.SocketAddress$;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.Security;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.blaze.BuildInfo$;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.ServerChannel;
import org.http4s.blaze.channel.ServerChannelGroup;
import org.http4s.blaze.channel.SocketConnection;
import org.http4s.blaze.channel.nio1.NIO1SocketServerGroup$;
import org.http4s.blaze.core.BlazeBackendBuilder;
import org.http4s.blaze.core.ExecutionContextConfig;
import org.http4s.blaze.internal.tls$;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.LeafBuilder$;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.pipeline.stages.SSLStage;
import org.http4s.blaze.pipeline.stages.SSLStage$;
import org.http4s.blaze.server.BlazeServerBuilder$;
import org.http4s.blaze.server.Http1ServerStage$;
import org.http4s.blaze.server.ProtocolSelector$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.server.SSLClientAuthMode;
import org.http4s.server.SSLKeyStoreSupport;
import org.http4s.server.SecureSession$;
import org.http4s.server.Server;
import org.http4s.server.ServerBuilder;
import org.http4s.server.package;
import org.http4s.server.websocket.WebSocketBuilder;
import org.http4s.server.websocket.WebSocketBuilder$;
import org.slf4j.Logger;
import org.typelevel.log4cats.LoggerFactory;
import org.typelevel.vault.InsertKey;
import org.typelevel.vault.Vault;
import org.typelevel.vault.Vault$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scodec.bits.ByteVector$;

public class BlazeServerBuilder<F>
implements ServerBuilder<F>,
BlazeBackendBuilder<Server> {
    private final InetSocketAddress socketAddress;
    private final ExecutionContextConfig executionContextConfig;
    private final Duration responseHeaderTimeout;
    private final Duration idleTimeout;
    private final int connectorPoolSize;
    private final int bufferSize;
    private final ThreadFactory selectorThreadFactory;
    public final SslConfig<F> org$http4s$blaze$server$BlazeServerBuilder$$sslConfig;
    private final boolean isHttp2Enabled;
    private final int maxRequestLineLen;
    private final int maxHeadersLen;
    private final int chunkBufferMaxSize;
    private final Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> httpApp;
    private final Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler;
    private final Seq<String> banner;
    private final int maxConnections;
    private final ChannelOptions channelOptions;
    private final Option<Object> maxWebSocketBufferSize;
    private final Async F;
    private final Logger logger;

    public static <F> BlazeServerBuilder<F> apply(Async<F> async, LoggerFactory<F> loggerFactory) {
        return BlazeServerBuilder$.MODULE$.apply(async, loggerFactory);
    }

    public static <F> BlazeServerBuilder<F> apply(ExecutionContext executionContext, Async<F> async, LoggerFactory<F> loggerFactory) {
        return BlazeServerBuilder$.MODULE$.apply(executionContext, async, loggerFactory);
    }

    public BlazeServerBuilder(InetSocketAddress socketAddress, ExecutionContextConfig executionContextConfig, Duration responseHeaderTimeout, Duration idleTimeout, int connectorPoolSize, int bufferSize, ThreadFactory selectorThreadFactory, SslConfig<F> sslConfig, boolean isHttp2Enabled, int maxRequestLineLen, int maxHeadersLen, int chunkBufferMaxSize, Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> httpApp, Function1<Request<F>, PartialFunction<Throwable, Object>> serviceErrorHandler, Seq<String> banner, int maxConnections, ChannelOptions channelOptions, Option<Object> maxWebSocketBufferSize, Async<F> F) {
        this.socketAddress = socketAddress;
        this.executionContextConfig = executionContextConfig;
        this.responseHeaderTimeout = responseHeaderTimeout;
        this.idleTimeout = idleTimeout;
        this.connectorPoolSize = connectorPoolSize;
        this.bufferSize = bufferSize;
        this.selectorThreadFactory = selectorThreadFactory;
        this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig = sslConfig;
        this.isHttp2Enabled = isHttp2Enabled;
        this.maxRequestLineLen = maxRequestLineLen;
        this.maxHeadersLen = maxHeadersLen;
        this.chunkBufferMaxSize = chunkBufferMaxSize;
        this.httpApp = httpApp;
        this.serviceErrorHandler = serviceErrorHandler;
        this.banner = banner;
        this.maxConnections = maxConnections;
        this.channelOptions = channelOptions;
        this.maxWebSocketBufferSize = maxWebSocketBufferSize;
        this.F = F;
        this.logger = org.slf4j.LoggerFactory.getLogger((String)"org.http4s.blaze.server.BlazeServerBuilder");
    }

    public ChannelOptions channelOptions() {
        return this.channelOptions;
    }

    public Async<F> F() {
        return this.F;
    }

    private BlazeServerBuilder<F> copy(InetSocketAddress socketAddress, ExecutionContextConfig executionContextConfig, Duration idleTimeout, Duration responseHeaderTimeout, int connectorPoolSize, int bufferSize, ThreadFactory selectorThreadFactory, SslConfig<F> sslConfig, boolean http2Support, int maxRequestLineLen, int maxHeadersLen, int chunkBufferMaxSize, Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> httpApp, Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler, Seq<String> banner, int maxConnections, ChannelOptions channelOptions, Option<Object> maxWebSocketBufferSize) {
        return new BlazeServerBuilder<F>(socketAddress, executionContextConfig, responseHeaderTimeout, idleTimeout, connectorPoolSize, bufferSize, selectorThreadFactory, sslConfig, http2Support, maxRequestLineLen, maxHeadersLen, chunkBufferMaxSize, httpApp, serviceErrorHandler, banner, maxConnections, channelOptions, maxWebSocketBufferSize, this.F());
    }

    private InetSocketAddress copy$default$1() {
        return this.socketAddress;
    }

    private ExecutionContextConfig copy$default$2() {
        return this.executionContextConfig;
    }

    private Duration copy$default$3() {
        return this.idleTimeout;
    }

    private Duration copy$default$4() {
        return this.responseHeaderTimeout;
    }

    private int copy$default$5() {
        return this.connectorPoolSize;
    }

    private int copy$default$6() {
        return this.bufferSize;
    }

    private ThreadFactory copy$default$7() {
        return this.selectorThreadFactory;
    }

    private SslConfig<F> copy$default$8() {
        return this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig;
    }

    private boolean copy$default$9() {
        return this.isHttp2Enabled;
    }

    private int copy$default$10() {
        return this.maxRequestLineLen;
    }

    private int copy$default$11() {
        return this.maxHeadersLen;
    }

    private int copy$default$12() {
        return this.chunkBufferMaxSize;
    }

    private Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> copy$default$13() {
        return this.httpApp;
    }

    private Function1<Request<F>, PartialFunction<Throwable, F>> copy$default$14() {
        return this.serviceErrorHandler;
    }

    private Seq<String> copy$default$15() {
        return this.banner;
    }

    private int copy$default$16() {
        return this.maxConnections;
    }

    private ChannelOptions copy$default$17() {
        return this.channelOptions();
    }

    private Option<Object> copy$default$18() {
        return this.maxWebSocketBufferSize;
    }

    public BlazeServerBuilder<F> withLengthLimits(int maxRequestLineLen, int maxHeadersLen) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), maxRequestLineLen, maxHeadersLen, this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public int withLengthLimits$default$1() {
        return this.maxRequestLineLen;
    }

    public int withLengthLimits$default$2() {
        return this.maxHeadersLen;
    }

    public BlazeServerBuilder<F> withSSL(SSLKeyStoreSupport.StoreInfo keyStore, String keyManagerPassword, String protocol, Option<SSLKeyStoreSupport.StoreInfo> trustStore, SSLClientAuthMode clientAuth) {
        KeyStoreBits<F> bits = new KeyStoreBits<F>(keyStore, keyManagerPassword, protocol, trustStore, clientAuth, this.F());
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), bits, this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public String withSSL$default$3() {
        return "TLS";
    }

    public Option<SSLKeyStoreSupport.StoreInfo> withSSL$default$4() {
        return None$.MODULE$;
    }

    public SSLClientAuthMode withSSL$default$5() {
        return SSLClientAuthMode.NotRequested$.MODULE$;
    }

    public BlazeServerBuilder<F> withSSLContext(SSLContext sslContext, SSLClientAuthMode clientAuth) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), new ContextWithClientAuth<F>(sslContext, clientAuth, this.F()), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public SSLClientAuthMode withSSLContext$default$2() {
        return SSLClientAuthMode.NotRequested$.MODULE$;
    }

    public BlazeServerBuilder<F> withSslContext(SSLContext sslContext) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), new ContextOnly<F>(sslContext, this.F()), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withSslContextAndParameters(SSLContext sslContext, SSLParameters sslParameters) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), new ContextWithParameters<F>(sslContext, sslParameters, this.F()), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withoutSsl() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), new NoSsl<F>(this.F()), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> bindSocketAddress(InetSocketAddress socketAddress) {
        return this.copy(socketAddress, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withExecutionContext(ExecutionContext executionContext) {
        ExecutionContextConfig.ExplicitContext explicitContext = ExecutionContextConfig.ExplicitContext$.MODULE$.apply(executionContext);
        InetSocketAddress inetSocketAddress = this.copy$default$1();
        Duration duration = this.copy$default$3();
        Duration duration2 = this.copy$default$4();
        int n = this.copy$default$5();
        int n2 = this.copy$default$6();
        ThreadFactory threadFactory = this.copy$default$7();
        SslConfig<F> sslConfig = this.copy$default$8();
        boolean bl = this.copy$default$9();
        int n3 = this.copy$default$10();
        int n4 = this.copy$default$11();
        int n5 = this.copy$default$12();
        Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> function1 = this.copy$default$13();
        Function1<Request<F>, PartialFunction<Throwable, F>> function12 = this.copy$default$14();
        Seq<String> seq = this.copy$default$15();
        int n6 = this.copy$default$16();
        ChannelOptions channelOptions = this.copy$default$17();
        Option<Object> option = this.copy$default$18();
        return this.copy(inetSocketAddress, (ExecutionContextConfig)explicitContext, duration, duration2, n, n2, threadFactory, sslConfig, bl, n3, n4, n5, function1, function12, seq, n6, channelOptions, option);
    }

    public BlazeServerBuilder<F> withIdleTimeout(Duration idleTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), idleTimeout, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withResponseHeaderTimeout(Duration responseHeaderTimeout) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), responseHeaderTimeout, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withConnectorPoolSize(int size) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), size, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withBufferSize(int size) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), size, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withSelectorThreadFactory(ThreadFactory selectorThreadFactory) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), selectorThreadFactory, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withWebSockets(boolean enableWebsockets) {
        return this;
    }

    public BlazeServerBuilder<F> enableHttp2(boolean enabled) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), enabled, this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withHttpApp(Kleisli<F, Request<F>, Response<F>> httpApp) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), (Function1 & Serializable)_$2 -> httpApp, this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withHttpWebSocketApp(Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> f) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), f, this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withServiceErrorHandler(Function1<Request<F>, PartialFunction<Throwable, F>> serviceErrorHandler) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), serviceErrorHandler, this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withBanner(Seq<String> banner) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), banner, this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withChannelOptions(ChannelOptions channelOptions) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), channelOptions, this.copy$default$18());
    }

    public BlazeServerBuilder<F> withMaxRequestLineLength(int maxRequestLineLength) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), maxRequestLineLength, this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withMaxHeadersLength(int maxHeadersLength) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), maxHeadersLength, this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withChunkBufferMaxSize(int chunkBufferMaxSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), chunkBufferMaxSize, this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withMaxConnections(int maxConnections) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), maxConnections, this.copy$default$17(), this.copy$default$18());
    }

    public BlazeServerBuilder<F> withMaxWebSocketBufferSize(Option<Object> maxWebSocketBufferSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17(), maxWebSocketBufferSize);
    }

    private Future<LeafBuilder<ByteBuffer>> pipelineFactory(TickWheelExecutor scheduler, Option<Tuple2<SSLContext, Function1<SSLEngine, BoxedUnit>>> engineConfig, Dispatcher<F> dispatcher, SocketConnection conn) {
        return dispatcher.unsafeToFuture(package.all$.MODULE$.toFlatMapOps(this.executionContextConfig.getExecutionContext(this.F()), this.F()).flatMap((Function1 & Serializable)executionContext -> {
            Tuple2 tuple2;
            Option option = engineConfig;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Object object;
                SSLContext ctx = (SSLContext)tuple2._1();
                Function1 configure = (Function1)tuple2._2();
                SSLEngine engine = ctx.createSSLEngine();
                engine.setUseClientMode(false);
                configure.apply((Object)engine);
                if (this.isHttp2Enabled) {
                    object = package.all$.MODULE$.toFunctorOps(this.http2Stage$1(scheduler, (Dispatcher)dispatcher, conn, (ExecutionContext)executionContext, engine), this.F()).map((Function1 & Serializable)_$4 -> LeafBuilder$.MODULE$.apply((TailStage)_$4));
                } else {
                    SSLEngine sSLEngine = (SSLEngine)package.all$.MODULE$.catsSyntaxOptionId((Object)engine);
                    object = package.all$.MODULE$.toFunctorOps(this.http1Stage$1(scheduler, (Dispatcher)dispatcher, conn, (ExecutionContext)executionContext, true, OptionIdOps$.MODULE$.some$extension((Object)sSLEngine)), this.F()).map((Function1 & Serializable)_$5 -> LeafBuilder$.MODULE$.apply((TailStage)_$5));
                }
                Object leafBuilder = object;
                return package.all$.MODULE$.toFunctorOps(leafBuilder, this.F()).map((Function1 & Serializable)_$6 -> _$6.prepend((MidStage)new SSLStage(engine, SSLStage$.MODULE$.$lessinit$greater$default$2())));
            }
            if (None$.MODULE$.equals(option)) {
                Logger Logger_this;
                if (this.isHttp2Enabled && (Logger_this = this.logger).isWarnEnabled()) {
                    Logger_this.warn("HTTP/2 support requires TLS. Falling back to HTTP/1.");
                }
                return package.all$.MODULE$.toFunctorOps(this.http1Stage$1(scheduler, (Dispatcher)dispatcher, conn, (ExecutionContext)executionContext, false, (Option)None$.MODULE$), this.F()).map((Function1 & Serializable)_$7 -> LeafBuilder$.MODULE$.apply((TailStage)_$7));
            }
            throw new MatchError((Object)option);
        }));
    }

    public Resource<F, Server> resource() {
        Resource mkFactory = package$.MODULE$.Resource().make(this.F().delay(this::$anonfun$3), (Function1 & Serializable)factory -> this.F().delay((Function0 & Serializable)() -> {
            BlazeServerBuilder.$anonfun$4$$anonfun$1(factory);
            return BoxedUnit.UNIT;
        }), this.F());
        return package$.MODULE$.Resource().eval(package.all$.MODULE$.toFunctorOps(Dispatcher$.MODULE$.parallel(this.F()).allocated(this.F()), this.F()).map((Function1 & Serializable)_$11 -> (Dispatcher)_$11._1())).flatMap((Function1 & Serializable)dispatcher -> org.http4s.blaze.core.package$.MODULE$.tickWheelResource(this.F()).flatMap((Function1 & Serializable)scheduler -> package$.MODULE$.Resource().eval(this.verifyTimeoutRelations()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return mkFactory.flatMap((Function1 & Serializable)factory -> this.mkServerChannel$1((ServerChannelGroup)factory, (TickWheelExecutor)scheduler, (Dispatcher)dispatcher).map((Function1 & Serializable)serverChannel -> {
                Server server = new Server((ServerChannel)serverChannel, this){
                    private final com.comcast.ip4s.SocketAddress address;
                    private final boolean isSecure;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.address = SocketAddress$.MODULE$.fromInetSocketAddress(serverChannel$2.socketAddress());
                        this.isSecure = $outer.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig.isSecure();
                    }

                    public com.comcast.ip4s.SocketAddress address() {
                        return this.address;
                    }

                    public boolean isSecure() {
                        return this.isSecure;
                    }

                    public String toString() {
                        return new StringBuilder(13).append("BlazeServer(").append(this.address()).append(")").toString();
                    }
                };
                return Tuple2$.MODULE$.apply(serverChannel, (Object)server);
            }).flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    ServerChannel serverChannel = (ServerChannel)tuple2._1();
                    Server server = (Server)tuple2._2();
                    return this.logStart$1(server).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return server;
                    });
                }
                throw new MatchError((Object)tuple2);
            }));
        })));
    }

    private F verifyTimeoutRelations() {
        return (F)this.F().delay((Function0 & Serializable)() -> {
            this.verifyTimeoutRelations$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    private static final Option secureSession$1(Option optionalSslEngine$2) {
        return optionalSslEngine$2.flatMap((Function1 & Serializable)engine -> Option$.MODULE$.apply((Object)engine.getSession()).flatMap((Function1 & Serializable)session -> Option$.MODULE$.apply((Object)session.getId()).map((Function1 & Serializable)_$3 -> ByteVector$.MODULE$.apply(_$3).toHex()).flatMap((Function1 & Serializable)hex -> Option$.MODULE$.apply((Object)session.getCipherSuite()).map((Function1 & Serializable)cipher -> SecureSession$.MODULE$.apply(hex, cipher, tls$.MODULE$.deduceKeyLength(cipher), tls$.MODULE$.getCertChain(session))))));
    }

    private static final Function0 requestAttributes$1(SocketConnection conn$1, boolean secure, Option optionalSslEngine) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)conn$1.local(), (Object)conn$1.remote());
        if (tuple2 != null) {
            SocketAddress socketAddress = (SocketAddress)tuple2._1();
            SocketAddress socketAddress2 = (SocketAddress)tuple2._2();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress local = (InetSocketAddress)socketAddress;
                if (socketAddress2 instanceof InetSocketAddress) {
                    InetSocketAddress remote = (InetSocketAddress)socketAddress2;
                    return (Function0 & Serializable)() -> {
                        Request.Connection connection = Request.Connection$.MODULE$.apply(SocketAddress$.MODULE$.apply((Host)IpAddress$.MODULE$.fromBytes(local.getAddress().getAddress()).get(), (Port)Port$.MODULE$.fromInt(local.getPort()).get()), SocketAddress$.MODULE$.apply((Host)IpAddress$.MODULE$.fromBytes(remote.getAddress().getAddress()).get(), (Port)Port$.MODULE$.fromInt(remote.getPort()).get()), secure);
                        return Vault$.MODULE$.empty().insert((InsertKey)Request.Keys$.MODULE$.ConnectionInfo(), (Object)connection).insert((InsertKey)package.ServerRequestKeys$.MODULE$.SecureSession(), secure ? BlazeServerBuilder.secureSession$1(optionalSslEngine) : None$.MODULE$);
                    };
                }
            }
        }
        return (Function0 & Serializable)() -> Vault$.MODULE$.empty();
    }

    private final Object http1Stage$1(TickWheelExecutor scheduler$2, Dispatcher dispatcher$2, SocketConnection conn$3, ExecutionContext executionContext, boolean secure, Option engine) {
        return package.all$.MODULE$.toFunctorOps(WebSocketBuilder$.MODULE$.apply(this.F(), this.F()), this.F()).map((Function1 & Serializable)builder -> Http1ServerStage$.MODULE$.apply((Kleisli)this.httpApp.apply(builder), (Function0<Vault>)BlazeServerBuilder.requestAttributes$1(conn$3, secure, engine), executionContext, builder.webSocketKey(), this.maxRequestLineLen, this.maxHeadersLen, this.chunkBufferMaxSize, this.serviceErrorHandler, this.responseHeaderTimeout, this.idleTimeout, scheduler$2, dispatcher$2, this.maxWebSocketBufferSize, this.F()));
    }

    private final Object http2Stage$1(TickWheelExecutor scheduler$4, Dispatcher dispatcher$4, SocketConnection conn$5, ExecutionContext executionContext, SSLEngine engine) {
        return package.all$.MODULE$.toFunctorOps(WebSocketBuilder$.MODULE$.apply(this.F(), this.F()), this.F()).map((Function1 & Serializable)builder -> {
            SSLEngine sSLEngine = (SSLEngine)package.all$.MODULE$.catsSyntaxOptionId((Object)engine);
            return ProtocolSelector$.MODULE$.apply(engine, (Kleisli)this.httpApp.apply(builder), this.maxRequestLineLen, this.maxHeadersLen, this.chunkBufferMaxSize, (Function0<Vault>)BlazeServerBuilder.requestAttributes$1(conn$5, true, OptionIdOps$.MODULE$.some$extension((Object)sSLEngine)), executionContext, this.serviceErrorHandler, this.responseHeaderTimeout, this.idleTimeout, scheduler$4, dispatcher$4, builder.webSocketKey(), this.maxWebSocketBufferSize, this.F());
        });
    }

    private static final InetSocketAddress resolveAddress$1(InetSocketAddress address) {
        if (address.isUnresolved()) {
            return new InetSocketAddress(address.getHostName(), address.getPort());
        }
        return address;
    }

    private final ServerChannelGroup $anonfun$3() {
        return NIO1SocketServerGroup$.MODULE$.fixed(this.connectorPoolSize, this.bufferSize, this.channelOptions(), this.selectorThreadFactory, NIO1SocketServerGroup$.MODULE$.fixed$default$5(), NIO1SocketServerGroup$.MODULE$.fixed$default$6(), this.maxConnections);
    }

    private static final void $anonfun$4$$anonfun$1(ServerChannelGroup factory$1) {
        factory$1.closeGroup();
    }

    private static final void mkServerChannel$1$$anonfun$3$$anonfun$1(ServerChannel serverChannel$1) {
        serverChannel$1.close();
    }

    private final Resource mkServerChannel$1(ServerChannelGroup factory, TickWheelExecutor scheduler, Dispatcher dispatcher) {
        return package$.MODULE$.Resource().make(package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFunctorOps(this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig.makeContext(), this.F()).map((Function1 & Serializable)ctxOpt -> {
            Option engineCfg = ctxOpt.map((Function1 & Serializable)ctx -> Tuple2$.MODULE$.apply(ctx, (JProcedure1 & Serializable)sslEngine -> this.org$http4s$blaze$server$BlazeServerBuilder$$sslConfig.configureEngine((SSLEngine)sslEngine)));
            InetSocketAddress address = BlazeServerBuilder.resolveAddress$1(this.socketAddress);
            return Tuple3$.MODULE$.apply(ctxOpt, (Object)engineCfg, (Object)address);
        }), this.F()).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Option ctxOpt = (Option)tuple3._1();
                Option engineCfg = (Option)tuple3._2();
                InetSocketAddress address = (InetSocketAddress)tuple3._3();
                return (ServerChannel)factory.bind(address, (Function1 & Serializable)conn -> this.pipelineFactory(scheduler, (Option<Tuple2<SSLContext, Function1<SSLEngine, BoxedUnit>>>)engineCfg, (Dispatcher<F>)dispatcher, (SocketConnection)conn)).get();
            }
            throw new MatchError((Object)tuple3);
        }), (Function1 & Serializable)serverChannel -> this.F().delay((Function0 & Serializable)() -> {
            BlazeServerBuilder.mkServerChannel$1$$anonfun$3$$anonfun$1(serverChannel);
            return BoxedUnit.UNIT;
        }), this.F());
    }

    private final void logStart$1$$anonfun$1(Server server$1) {
        Option$.MODULE$.apply(this.banner).filter((Function1 & Serializable)_$8 -> _$8.nonEmpty()).map((Function1 & Serializable)_$9 -> _$9.mkString("\n", "\n", "")).foreach((Function1)(JProcedure1 & Serializable)_$10 -> {
            Logger Logger_this = this.logger;
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info(_$10);
                return;
            }
        });
        Logger Logger_this = this.logger;
        if (Logger_this.isInfoEnabled()) {
            Logger_this.info(new StringBuilder(31).append("http4s v").append(org.http4s.BuildInfo$.MODULE$.version()).append(" on blaze v").append(BuildInfo$.MODULE$.version()).append(" started at ").append(server$1.baseUri()).toString());
            return;
        }
    }

    private final Resource logStart$1(Server server) {
        return package$.MODULE$.Resource().eval(this.F().delay((Function0 & Serializable)() -> {
            this.logStart$1$$anonfun$1(server);
            return BoxedUnit.UNIT;
        }));
    }

    private final void verifyTimeoutRelations$$anonfun$1() {
        if (this.responseHeaderTimeout.isFinite() && this.responseHeaderTimeout.$greater$eq((Object)this.idleTimeout)) {
            Logger Logger_this = this.logger;
            if (Logger_this.isWarnEnabled()) {
                Logger_this.warn(new StringBuilder(173).append("responseHeaderTimeout (").append(this.responseHeaderTimeout).append(") is >= idleTimeout (").append(this.idleTimeout).append("). ").append("It is recommended to configure responseHeaderTimeout < idleTimeout, ").append("otherwise timeout responses won't be delivered to clients.").toString());
                return;
            }
            return;
        }
    }

    public static class ContextOnly<F>
    implements SslConfig<F> {
        private final SSLContext sslContext;
        private final Applicative<F> F;

        public ContextOnly(SSLContext sslContext, Applicative<F> F) {
            this.sslContext = sslContext;
            this.F = F;
        }

        @Override
        public F makeContext() {
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)this.sslContext);
            return (F)this.F.pure((Object)OptionIdOps$.MODULE$.some$extension((Object)sSLContext));
        }

        @Override
        public void configureEngine(SSLEngine engine) {
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    public static class ContextWithClientAuth<F>
    implements SslConfig<F> {
        private final SSLContext sslContext;
        private final SSLClientAuthMode clientAuth;
        private final Applicative<F> F;

        public ContextWithClientAuth(SSLContext sslContext, SSLClientAuthMode clientAuth, Applicative<F> F) {
            this.sslContext = sslContext;
            this.clientAuth = clientAuth;
            this.F = F;
        }

        @Override
        public F makeContext() {
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)this.sslContext);
            return (F)this.F.pure((Object)OptionIdOps$.MODULE$.some$extension((Object)sSLContext));
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            BlazeServerBuilder$.MODULE$.org$http4s$blaze$server$BlazeServerBuilder$$$configureEngineFromSslClientAuthMode(engine, this.clientAuth);
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    public static class ContextWithParameters<F>
    implements SslConfig<F> {
        private final SSLContext sslContext;
        private final SSLParameters sslParameters;
        private final Applicative<F> F;

        public ContextWithParameters(SSLContext sslContext, SSLParameters sslParameters, Applicative<F> F) {
            this.sslContext = sslContext;
            this.sslParameters = sslParameters;
            this.F = F;
        }

        @Override
        public F makeContext() {
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)this.sslContext);
            return (F)this.F.pure((Object)OptionIdOps$.MODULE$.some$extension((Object)sSLContext));
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            engine.setSSLParameters(this.sslParameters);
        }

        @Override
        public boolean isSecure() {
            return true;
        }
    }

    public static final class KeyStoreBits<F>
    implements SslConfig<F> {
        private final SSLKeyStoreSupport.StoreInfo keyStore;
        private final String keyManagerPassword;
        private final String protocol;
        private final Option<SSLKeyStoreSupport.StoreInfo> trustStore;
        private final SSLClientAuthMode clientAuth;
        private final Sync<F> F;

        public KeyStoreBits(SSLKeyStoreSupport.StoreInfo keyStore, String keyManagerPassword, String protocol, Option<SSLKeyStoreSupport.StoreInfo> trustStore, SSLClientAuthMode clientAuth, Sync<F> F) {
            this.keyStore = keyStore;
            this.keyManagerPassword = keyManagerPassword;
            this.protocol = protocol;
            this.trustStore = trustStore;
            this.clientAuth = clientAuth;
            this.F = F;
        }

        @Override
        public F makeContext() {
            return (F)this.F.delay(this::makeContext$$anonfun$1);
        }

        @Override
        public void configureEngine(SSLEngine engine) {
            BlazeServerBuilder$.MODULE$.org$http4s$blaze$server$BlazeServerBuilder$$$configureEngineFromSslClientAuthMode(engine, this.clientAuth);
        }

        @Override
        public boolean isSecure() {
            return true;
        }

        private final String $anonfun$7() {
            return KeyManagerFactory.getDefaultAlgorithm();
        }

        private final Option makeContext$$anonfun$1() {
            FileInputStream ksStream = new FileInputStream(this.keyStore.path());
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(ksStream, this.keyStore.password().toCharArray());
            ksStream.close();
            Option tmf = this.trustStore.map((Function1 & Serializable)auth -> {
                FileInputStream ksStream = new FileInputStream(auth.path());
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(ksStream, auth.password().toCharArray());
                ksStream.close();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
                return tmf.getTrustManagers();
            });
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)Option$.MODULE$.apply((Object)Security.getProperty("ssl.KeyManagerFactory.algorithm")).getOrElse(this::$anonfun$7));
            kmf.init(ks, this.keyManagerPassword.toCharArray());
            SSLContext context = SSLContext.getInstance(this.protocol);
            context.init(kmf.getKeyManagers(), (TrustManager[])tmf.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
            SSLContext sSLContext = (SSLContext)package.all$.MODULE$.catsSyntaxOptionId((Object)context);
            return OptionIdOps$.MODULE$.some$extension((Object)sSLContext);
        }
    }

    public static class NoSsl<F>
    implements SslConfig<F> {
        private final Applicative<F> F;

        public NoSsl(Applicative<F> F) {
            this.F = F;
        }

        @Override
        public F makeContext() {
            return (F)this.F.pure((Object)None$.MODULE$);
        }

        @Override
        public void configureEngine(SSLEngine engine) {
        }

        @Override
        public boolean isSecure() {
            return false;
        }
    }

    public static interface SslConfig<F> {
        public F makeContext();

        public void configureEngine(SSLEngine var1);

        public boolean isSecure();
    }
}

