/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.testkit;

import cats.Applicative;
import cats.Monad;
import cats.MonadError;
import cats.UnorderedFoldable$;
import cats.data.Kleisli;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.syntax.EitherOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.ParallelTraversableOps1$;
import cats.syntax.package;
import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.SocketAddress;
import fs2.Collector$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.Locale;
import munit.CatsEffectAssertions;
import munit.CatsEffectSuite;
import munit.Location;
import munit.catseffect.IOFixture;
import org.http4s.Entity;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpRoutes$;
import org.http4s.HttpVersion;
import org.http4s.Media;
import org.http4s.Media$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.ParseFailure;
import org.http4s.Query;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.client.dsl.Http4sClientDsl;
import org.http4s.client.dsl.MethodOps$;
import org.http4s.client.testkit.scaffold.ServerScaffold;
import org.http4s.client.testkit.scaffold.ServerScaffold$;
import org.http4s.client.testkit.testroutes.GetRoutes$;
import org.http4s.dsl.io$;
import org.http4s.multipart.Multiparts$;
import org.http4s.multipart.Part;
import org.http4s.multipart.Part$;
import org.typelevel.log4cats.LoggerFactory;
import org.typelevel.log4cats.noop.NoOpFactory$;
import org.typelevel.vault.Vault;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IndexedSeqOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;

public abstract class ClientRouteTestBattery
extends CatsEffectSuite
implements Http4sClientDsl<IO> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ClientRouteTestBattery.class.getDeclaredField("suiteFixtures$lzy1"));
    private final String name;
    private final LoggerFactory loggerFactory;
    private final FiniteDuration timeout;
    private final Kleisli testHandler;
    private final IOFixture server;
    private final IOFixture client;
    private volatile Object suiteFixtures$lzy1;

    public ClientRouteTestBattery(String name) {
        this.name = name;
        this.loggerFactory = NoOpFactory$.MODULE$.apply((Applicative)IO$.MODULE$.asyncForIO());
        this.timeout = new package.DurationInt(package$.MODULE$.DurationInt(20)).seconds();
        this.testHandler = HttpRoutes$.MODULE$.of((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Request x) {
                Some some;
                Request request = x;
                if (request != null && !(some = io$.MODULE$.$minus$greater().unapply(request)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)some.get();
                    Method method = (Method)tuple2._1();
                    Uri.Path path = (Uri.Path)tuple2._2();
                    Method method2 = Method$.MODULE$.GET();
                    Method method3 = method;
                    if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                        Option option;
                        if (path != null && !(option = io$.MODULE$.$div().unapply(path)).isEmpty()) {
                            Tuple2 tuple22 = (Tuple2)option.get();
                            Uri.Path path2 = io$.MODULE$.Root();
                            Object object = tuple22._1();
                            if (!(path2 != null ? !path2.equals(object) : object != null) && "request-splitting".equals(tuple22._2())) {
                                Request req = request;
                                return true;
                            }
                        }
                        Uri.Path path3 = path;
                        return true;
                    }
                    Method method4 = Method$.MODULE$.POST();
                    Method method5 = method;
                    if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                        Request req = request;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Request x, Function1 function1) {
                Some some;
                Request request = x;
                if (request != null && !(some = io$.MODULE$.$minus$greater().unapply(request)).isEmpty()) {
                    Tuple2 tuple2 = (Tuple2)some.get();
                    Method method = (Method)tuple2._1();
                    Uri.Path path = (Uri.Path)tuple2._2();
                    Method method2 = Method$.MODULE$.GET();
                    Method method3 = method;
                    if (!(method2 != null ? !method2.equals(method3) : method3 != null)) {
                        Option option;
                        if (path != null && !(option = io$.MODULE$.$div().unapply(path)).isEmpty()) {
                            Tuple2 tuple22 = (Tuple2)option.get();
                            Uri.Path path2 = io$.MODULE$.Root();
                            Object object = tuple22._1();
                            if (!(path2 != null ? !path2.equals(object) : object != null) && "request-splitting".equals(tuple22._2())) {
                                Request req = request;
                                if (Headers$.MODULE$.get$extension(req.headers(), org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Evil"}))).ci((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))).isDefined()) {
                                    return io$.MODULE$.http4sInternalServerErrorSyntax(io$.MODULE$.InternalServerError()).apply((Applicative)IO$.MODULE$.asyncForIO());
                                }
                                return io$.MODULE$.http4sOkSyntax(io$.MODULE$.Ok()).apply((Applicative)IO$.MODULE$.asyncForIO());
                            }
                        }
                        Uri.Path path3 = path;
                        return GetRoutes$.MODULE$.getPaths((GenTemporal<IO, Throwable>)IO$.MODULE$.asyncForIO()).get((Object)path3.toString()).getOrElse(ClientRouteTestBattery::org$http4s$client$testkit$ClientRouteTestBattery$$anon$1$$_$applyOrElse$$anonfun$1);
                    }
                    Method method4 = Method$.MODULE$.POST();
                    Method method5 = method;
                    if (!(method4 != null ? !method4.equals(method5) : method5 != null)) {
                        Request req = request;
                        return io$.MODULE$.http4sOkSyntax(io$.MODULE$.Ok()).apply((Object)req.body(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), (Applicative)IO$.MODULE$.asyncForIO(), EntityEncoder$.MODULE$.entityBodyEncoder());
                    }
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$http4s$client$testkit$ClientRouteTestBattery$$anon$1$$_$applyOrElse$$anonfun$1()}, serializedLambda);
            }
        }, (Monad)IO$.MODULE$.asyncForIO());
        this.server = this.resourceSuiteFixture("server", ServerScaffold$.MODULE$.apply(1, false, this.testHandler(), this.loggerFactory(), IO$.MODULE$.asyncForIO()));
        this.client = this.resourceSuiteFixture("client", this.clientResource());
        this.test(new StringBuilder(24).append(name).append(" Repeat a simple request").toString(), this::$init$$$anonfun$1, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 90));
        this.test(new StringBuilder(19).append(name).append(" POST an empty body").toString(), this::$init$$$anonfun$2, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 98));
        this.test(new StringBuilder(19).append(name).append(" POST a normal body").toString(), this::$init$$$anonfun$3, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 106));
        this.test(this.testOptionsFromString(new StringBuilder(20).append(name).append(" POST a chunked body").toString(), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 108)).flaky(), this::$init$$$anonfun$4, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 114));
        this.test(new StringBuilder(22).append(name).append(" POST a multipart body").toString(), this::$init$$$anonfun$5, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 129));
        GetRoutes$.MODULE$.getPaths((GenTemporal<IO, Throwable>)IO$.MODULE$.asyncForIO()).toList().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String path = (String)tuple2._1();
                IO expected = (IO)tuple2._2();
                this.test(new StringBuilder(13).append(name).append(" Execute GET ").append(path).toString(), () -> this.$init$$$anonfun$6$$anonfun$1(path, expected), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 139));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.test("Mitigates request splitting attack in URI path", this::$init$$$anonfun$7, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 155));
        this.test("Mitigates request splitting attack in URI RegName", this::$init$$$anonfun$8, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 169));
        this.test("Mitigates request splitting attack in field name", this::$init$$$anonfun$9, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 176));
        this.test("Mitigates request splitting attack in field value", this::$init$$$anonfun$10, new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 183));
    }

    public LoggerFactory<IO> loggerFactory() {
        return this.loggerFactory;
    }

    public FiniteDuration timeout() {
        return this.timeout;
    }

    public abstract Resource<IO, Client<IO>> clientResource();

    public Kleisli<?, Request<IO>, Response<IO>> testHandler() {
        return this.testHandler;
    }

    public IOFixture<ServerScaffold<IO>> server() {
        return this.server;
    }

    public IOFixture<Client<IO>> client() {
        return this.client;
    }

    private IO<Object> checkResponse(Response<IO> rec, Response<IO> expected) {
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(IO$.MODULE$.apply(() -> ClientRouteTestBattery.$anonfun$6(rec)));
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)expected.status(), () -> ClientRouteTestBattery.checkResponse$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 192), (.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = x$1;
            return ((IO)rec.body().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).to(Collector$.MODULE$.supportsArray(Array$.MODULE$, ClassTag$.MODULE$.apply(Byte.TYPE)))).flatMap((Function1 & Serializable)body -> ((IO)expected.body().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).to(Collector$.MODULE$.supportsArray(Array$.MODULE$, ClassTag$.MODULE$.apply(Byte.TYPE)))).flatMap((Function1 & Serializable)expBody -> this.MUnitCatsAssertionsForIOBooleanOps(IO$.MODULE$.apply(() -> ClientRouteTestBattery.checkResponse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(body)).map((Function1 & Serializable)_$13 -> Arrays.equals(_$13, expBody))).assert(new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 195)).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit;
                BoxedUnit $8$ = boxedUnit = x$1;
                List headers = rec.headers().map((Function1 & Serializable)h -> ClientRouteTestBattery.normalizeHeaderValue$1(h));
                List expectedHeaders = expected.headers().map((Function1 & Serializable)h -> ClientRouteTestBattery.normalizeHeaderValue$1(h));
                return Tuple3$.MODULE$.apply((Object)$8$, (Object)headers, (Object)expectedHeaders);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    List headers = (List)tuple3._2();
                    List expectedHeaders = (List)tuple3._3();
                    CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(IO$.MODULE$.apply(() -> ClientRouteTestBattery.$anonfun$9(headers, expectedHeaders)));
                    return mUnitCatsAssertionsForIOOps.assertEquals((Object)scala.package$.MODULE$.Nil(), () -> ClientRouteTestBattery.checkResponse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 198), (.less.colon.less)$less$colon$less$.MODULE$.refl()).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = x$12;
                        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(IO$.MODULE$.apply(() -> ClientRouteTestBattery.$anonfun$10(rec)));
                        return mUnitCatsAssertionsForIOOps.assertEquals((Object)expected.httpVersion(), () -> ClientRouteTestBattery.checkResponse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 199), (.less.colon.less)$less$colon$less$.MODULE$.refl()).map((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = x$1;
                            return true;
                        });
                    });
                }
                throw new MatchError((Object)tuple3);
            })));
        });
    }

    private <A> IOFixture<A> registerSuiteFixture(IOFixture<A> fixture) {
        this.suiteFixtures().$plus$eq(fixture);
        return fixture;
    }

    private <A> IOFixture<A> resourceSuiteFixture(String name, Resource<IO, A> resource) {
        return this.registerSuiteFixture(this.ResourceSuiteLocalFixture().apply(name, resource));
    }

    private final <A> ParseResultSyntax<A> ParseResultSyntax(Either<ParseFailure, A> self) {
        return new ParseResultSyntax<A>(self);
    }

    private Builder<IOFixture<?>, List<IOFixture<?>>> suiteFixtures() {
        Object object = this.suiteFixtures$lzy1;
        if (object instanceof Builder) {
            return (Builder)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Builder)this.suiteFixtures$lzyINIT1();
    }

    private Object suiteFixtures$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.suiteFixtures$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Builder builder = null;
                    try {
                        builder = scala.package$.MODULE$.List().newBuilder();
                        object2 = builder == null ? LazyVals.NullValue$.MODULE$ : builder;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.suiteFixtures$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return builder;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public scala.collection.immutable.Seq<IOFixture<?>> munitFixtures() {
        return (scala.collection.immutable.Seq)this.suiteFixtures().result();
    }

    public static final IO org$http4s$client$testkit$ClientRouteTestBattery$$anon$1$$_$applyOrElse$$anonfun$1() {
        return (IO)io$.MODULE$.http4sNotFoundSyntax(io$.MODULE$.NotFound()).apply((Applicative)IO$.MODULE$.asyncForIO());
    }

    private final Kleisli fetchBody$1() {
        return ((Client)this.client().apply()).toKleisli((Function1 & Serializable)_$1 -> {
            Media media = Media$.MODULE$.InvariantOps((Media)_$1);
            return (IO)Media.InvariantOps$.MODULE$.as$extension(media, (MonadError)IO$.MODULE$.asyncForIO(), EntityDecoder$.MODULE$.text((GenConcurrent)IO$.MODULE$.asyncForIO(), EntityDecoder$.MODULE$.text$default$2()));
        }).local((Function1 & Serializable)uri -> Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), uri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()));
    }

    private final /* synthetic */ IO $init$$$anonfun$1$$anonfun$1(Uri url$1, int _$2) {
        return ((IO)this.fetchBody$1().run().apply((Object)url$1)).map((Function1 & Serializable)_$3 -> _$3.length());
    }

    private final Object $init$$$anonfun$1() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        String path = GetRoutes$.MODULE$.SimplePath();
        Uri url = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(7).append("http://").append(address).append(path).toString())).yolo();
        Vector vector = (Vector)package.all$.MODULE$.catsSyntaxParallelTraverse1((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).toVector(), UnorderedFoldable$.MODULE$.catsTraverseForVector());
        return this.MUnitCatsAssertionsForIOBooleanOps(((IO)ParallelTraversableOps1$.MODULE$.parTraverse$extension((Object)vector, (Function1 & Serializable)_$2 -> this.$init$$$anonfun$1$$anonfun$1(url, BoxesRunTime.unboxToInt((Object)_$2)), UnorderedFoldable$.MODULE$.catsTraverseForVector(), IO$.MODULE$.parallelForIO())).map((Function1 & Serializable)_$4 -> _$4.forall((Function1)(JFunction1.mcZI.sp & Serializable)_$5 -> package.all$.MODULE$.catsSyntaxEq((Object)BoxesRunTime.boxToInteger((int)_$5), (Eq)Eq$.MODULE$.catsKernelInstancesForInt()).$eq$bang$eq((Object)BoxesRunTime.boxToInteger((int)0))))).assert(new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 88));
    }

    private static final Object $init$$$anonfun$2$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $1$$1) {
        return $1$$1.assertEquals$default$2();
    }

    private final Object $init$$$anonfun$2() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        Uri uri = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(12).append("http://").append(address).append("/echo").toString())).yolo();
        Method method = this.http4sClientSyntaxMethod(io$.MODULE$.POST());
        Request req = MethodOps$.MODULE$.apply$extension(method, uri, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]));
        IO body = (IO)((Client)this.client().apply()).expect(req, EntityDecoder$.MODULE$.text((GenConcurrent)IO$.MODULE$.asyncForIO(), EntityDecoder$.MODULE$.text$default$2()));
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(body);
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)"", () -> ClientRouteTestBattery.$init$$$anonfun$2$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 97), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Object $init$$$anonfun$3$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $2$$1) {
        return $2$$1.assertEquals$default$2();
    }

    private final Object $init$$$anonfun$3() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        Uri uri = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(12).append("http://").append(address).append("/echo").toString())).yolo();
        Method method = this.http4sClientSyntaxMethod(io$.MODULE$.POST());
        Request req = MethodOps$.MODULE$.apply$extension(method, (Object)"This is normal.", uri, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1()));
        IO body = (IO)((Client)this.client().apply()).expect(req, EntityDecoder$.MODULE$.text((GenConcurrent)IO$.MODULE$.asyncForIO(), EntityDecoder$.MODULE$.text$default$2()));
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(body);
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)"This is normal.", () -> ClientRouteTestBattery.$init$$$anonfun$3$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 105), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final /* synthetic */ String $anonfun$1(char _$6) {
        return BoxesRunTime.boxToCharacter((char)_$6).toString();
    }

    private static final Object $init$$$anonfun$4$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $3$$1) {
        return $3$$1.assertEquals$default$2();
    }

    private final Object $init$$$anonfun$4() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        Uri uri = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(12).append("http://").append(address).append("/echo").toString())).yolo();
        Method method = this.http4sClientSyntaxMethod(io$.MODULE$.POST());
        Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.emits((Seq)((IndexedSeqOps)Predef$.MODULE$.wrapString("This is chunked.").toSeq()).map((Function1 & Serializable)_$6 -> ClientRouteTestBattery.$anonfun$1(BoxesRunTime.unboxToChar((Object)_$6)))));
        Request req = MethodOps$.MODULE$.apply$extension(method, (Object)Stream.PureOps$.MODULE$.covary$extension(stream), uri, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), EntityEncoder$.MODULE$.streamEncoder(EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1())));
        IO body = (IO)((Client)this.client().apply()).expect(req, EntityDecoder$.MODULE$.text((GenConcurrent)IO$.MODULE$.asyncForIO(), EntityDecoder$.MODULE$.text$default$2()));
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(body);
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)"This is chunked.", () -> ClientRouteTestBattery.$init$$$anonfun$4$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 113), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final Object $init$$$anonfun$5() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        Uri uri = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(12).append("http://").append(address).append("/echo").toString())).yolo();
        return this.MUnitCatsAssertionsForIOBooleanOps(((IO)Multiparts$.MODULE$.forSync((Sync)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)multiparts -> ((IO)multiparts.multipart((Vector)scala.package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Part[]{Part$.MODULE$.formData("text", "This is text.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]))})))).flatMap((Function1 & Serializable)multipart -> {
            Method method = this.http4sClientSyntaxMethod(io$.MODULE$.POST());
            Request req = (Request)MethodOps$.MODULE$.apply$extension(method, multipart, uri, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), EntityEncoder$.MODULE$.multipartEncoder()).withHeaders(multipart.headers());
            IO body = (IO)((Client)this.client().apply()).expect(req, EntityDecoder$.MODULE$.text((GenConcurrent)IO$.MODULE$.asyncForIO(), EntityDecoder$.MODULE$.text$default$2()));
            return body.map((Function1 & Serializable)_$7 -> _$7.contains("This is text."));
        }))).assert(new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 128));
    }

    private final Object $init$$$anonfun$6$$anonfun$1(String path$3, IO expected$1) {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        Uri uri = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(7).append("http://").append(address).append(path$3).toString())).yolo();
        Method method = Request$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
        List list = Request$.MODULE$.apply$default$4();
        Entity entity = Request$.MODULE$.apply$default$5();
        Vault vault = Request$.MODULE$.apply$default$6();
        Request req = Request$.MODULE$.apply(method, uri, httpVersion, list, entity, vault);
        return this.MUnitCatsAssertionsForIOBooleanOps((IO)((Client)this.client().apply()).run(req).use((Function1 & Serializable)resp -> expected$1.flatMap((Function1 & Serializable)_$8 -> this.checkResponse((Response<IO>)resp, (Response<IO>)_$8)), (MonadCancel)IO$.MODULE$.asyncForIO())).assert(new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 138));
    }

    private static final Object $init$$$anonfun$7$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $4$$1) {
        return $4$$1.assertEquals$default$2();
    }

    private final Object $init$$$anonfun$7() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        String name = address.host().toString();
        int port = address.port().value();
        Integer n = (Integer)package.all$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToInteger((int)port));
        Uri.Authority authority = (Uri.Authority)package.all$.MODULE$.catsSyntaxOptionId((Object)Uri.Authority$.MODULE$.apply((Option)None$.MODULE$, (Uri.Host)Uri.RegName$.MODULE$.apply(name), OptionIdOps$.MODULE$.some$extension((Object)n)));
        Option option = OptionIdOps$.MODULE$.some$extension((Object)authority);
        Uri.Path path = Uri.Path$.MODULE$.Root().$div(Uri.Path$.Segment$.MODULE$.encoded("request-splitting HTTP/1.0\r\nEvil:true\r\nHide-Protocol-Version:"));
        Option option2 = Uri$.MODULE$.$lessinit$greater$default$1();
        Query query = Uri$.MODULE$.$lessinit$greater$default$4();
        Option option3 = Uri$.MODULE$.$lessinit$greater$default$5();
        Uri uri = Uri$.MODULE$.apply(option2, option, path, query, option3);
        Method method = Request$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
        List list = Request$.MODULE$.apply$default$4();
        Entity entity = Request$.MODULE$.apply$default$5();
        Vault vault = Request$.MODULE$.apply$default$6();
        Request req = Request$.MODULE$.apply(method, uri, httpVersion, list, entity, vault);
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(((IO)((Client)this.client().apply()).status(req)).handleError((Function1 & Serializable)_$9 -> Status$.MODULE$.Ok()));
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)Status$.MODULE$.Ok(), () -> ClientRouteTestBattery.$init$$$anonfun$7$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 154), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Object $init$$$anonfun$8$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $5$$1) {
        return $5$$1.assertEquals$default$2();
    }

    private final Object $init$$$anonfun$8() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        IpAddress name = (IpAddress)address.host();
        int port = address.port().value();
        Integer n = (Integer)package.all$.MODULE$.catsSyntaxOptionId((Object)BoxesRunTime.boxToInteger((int)port));
        Uri.Authority authority = (Uri.Authority)package.all$.MODULE$.catsSyntaxOptionId((Object)Uri.Authority$.MODULE$.apply((Option)None$.MODULE$, (Uri.Host)Uri.RegName$.MODULE$.apply(new StringBuilder(13).append(name).append("\r\nEvil:true\r\n").toString()), OptionIdOps$.MODULE$.some$extension((Object)n)));
        Option option = OptionIdOps$.MODULE$.some$extension((Object)authority);
        Uri.Path path = Uri.Path$.MODULE$.unsafeFromString("/request-splitting");
        Option option2 = Uri$.MODULE$.$lessinit$greater$default$1();
        Query query = Uri$.MODULE$.$lessinit$greater$default$4();
        Option option3 = Uri$.MODULE$.$lessinit$greater$default$5();
        Uri uri = Uri$.MODULE$.apply(option2, option, path, query, option3);
        Method method = Request$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
        List list = Request$.MODULE$.apply$default$4();
        Entity entity = Request$.MODULE$.apply$default$5();
        Vault vault = Request$.MODULE$.apply$default$6();
        Request req = Request$.MODULE$.apply(method, uri, httpVersion, list, entity, vault);
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(((IO)((Client)this.client().apply()).status(req)).handleError((Function1 & Serializable)_$10 -> Status$.MODULE$.Ok()));
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)Status$.MODULE$.Ok(), () -> ClientRouteTestBattery.$init$$$anonfun$8$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 168), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Object $init$$$anonfun$9$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $6$$1) {
        return $6$$1.assertEquals$default$2();
    }

    private final Object $init$$$anonfun$9() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        Uri uri = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(25).append("http://").append(address).append("/request-splitting").toString())).yolo();
        Method method = Request$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
        List list = Request$.MODULE$.apply$default$4();
        Entity entity = Request$.MODULE$.apply$default$5();
        Vault vault = Request$.MODULE$.apply$default$6();
        Request req = (Request)Request$.MODULE$.apply(method, uri, httpVersion, list, entity, vault).putHeaders((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(Header.Raw$.MODULE$.apply(org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Fine:\\r\\nEvil:true\\r\\n"}))).ci((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), "oops"))}));
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(((IO)((Client)this.client().apply()).status(req)).handleError((Function1 & Serializable)_$11 -> Status$.MODULE$.Ok()));
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)Status$.MODULE$.Ok(), () -> ClientRouteTestBattery.$init$$$anonfun$9$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 175), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Object $init$$$anonfun$10$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $7$$1) {
        return $7$$1.assertEquals$default$2();
    }

    private final Object $init$$$anonfun$10() {
        SocketAddress address = (SocketAddress)((ServerScaffold)this.server().apply()).addresses().head();
        Uri uri = (Uri)this.ParseResultSyntax(Uri$.MODULE$.fromString(new StringBuilder(25).append("http://").append(address).append("/request-splitting").toString())).yolo();
        Method method = Request$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
        List list = Request$.MODULE$.apply$default$4();
        Entity entity = Request$.MODULE$.apply$default$5();
        Vault vault = Request$.MODULE$.apply$default$6();
        Request req = (Request)Request$.MODULE$.apply(method, uri, httpVersion, list, entity, vault).putHeaders((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.rawToRaw(Header.Raw$.MODULE$.apply(org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"X-Carrier"}))).ci((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), "\r\nEvil:true\r\n"))}));
        CatsEffectAssertions.MUnitCatsAssertionsForIOOps mUnitCatsAssertionsForIOOps = this.MUnitCatsAssertionsForIOOps(((IO)((Client)this.client().apply()).status(req)).handleError((Function1 & Serializable)_$12 -> Status$.MODULE$.Ok()));
        return mUnitCatsAssertionsForIOOps.assertEquals((Object)Status$.MODULE$.Ok(), () -> ClientRouteTestBattery.$init$$$anonfun$10$$anonfun$1(mUnitCatsAssertionsForIOOps), new Location("/home/runner/work/http4s/http4s/client-testkit/js-jvm/src/main/scala/org/http4s/client/testkit/ClientRouteTestBattery.scala", 182), (.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static final Header.Raw normalizeHeaderValue$1(Header.Raw h) {
        return Header.Raw$.MODULE$.apply(h.name(), h.value().replace("; ", ";").toLowerCase(Locale.ROOT));
    }

    private static final Status $anonfun$6(Response rec$1) {
        return rec$1.status();
    }

    private static final Object checkResponse$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $9$$1) {
        return $9$$1.assertEquals$default$2();
    }

    private static final byte[] checkResponse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(byte[] body$2) {
        return body$2;
    }

    private static final List $anonfun$9(List headers$6, List expectedHeaders$1) {
        return (List)expectedHeaders$1.diff((Seq)headers$6);
    }

    private static final Object checkResponse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $10$$1) {
        return $10$$1.assertEquals$default$2();
    }

    private static final HttpVersion $anonfun$10(Response rec$8) {
        return rec$8.httpVersion();
    }

    private static final Object checkResponse$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$1(CatsEffectAssertions.MUnitCatsAssertionsForIOOps $11$$1) {
        return $11$$1.assertEquals$default$2();
    }

    public static final /* synthetic */ Object org$http4s$client$testkit$ClientRouteTestBattery$ParseResultSyntax$$_$yolo$$anonfun$1(ParseFailure e) {
        throw scala.sys.package$.MODULE$.error(e.toString());
    }

    public class ParseResultSyntax<A> {
        private final Either<ParseFailure, A> self;

        public ParseResultSyntax(Either<ParseFailure, A> self) {
            this.self = self;
        }

        public A yolo() {
            Either either = package.all$.MODULE$.catsSyntaxEither(this.self);
            return (A)EitherOps$.MODULE$.valueOr$extension(either, ClientRouteTestBattery::org$http4s$client$testkit$ClientRouteTestBattery$ParseResultSyntax$$_$yolo$$anonfun$1);
        }
    }
}

