/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.testkit;

import cats.Applicative$;
import cats.data.Kleisli;
import cats.effect.kernel.GenConcurrent;
import cats.package;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.testkit.WSTestClient$;
import org.http4s.client.websocket.WSFrame;
import org.http4s.server.websocket.WebSocketBuilder;
import org.http4s.websocket.WebSocketFrame;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scodec.bits.ByteVector;

public final class WSTestClient {
    public static WebSocketFrameOps WebSocketFrameOps(WebSocketFrame webSocketFrame) {
        return WSTestClient$.MODULE$.WebSocketFrameOps(webSocketFrame);
    }

    public static <F> WsFrameOps<F> WsFrameOps(WSFrame wSFrame, GenConcurrent<F, Throwable> genConcurrent) {
        return WSTestClient$.MODULE$.WsFrameOps(wSFrame, genConcurrent);
    }

    public static <F> Object fromHttpWebSocketApp(boolean bl, Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> function1, GenConcurrent<F, Throwable> genConcurrent) {
        return WSTestClient$.MODULE$.fromHttpWebSocketApp(bl, function1, genConcurrent);
    }

    public static <F> Object fromHttpWebSocketApp(Function1<WebSocketBuilder<F>, Kleisli<F, Request<F>, Response<F>>> function1, GenConcurrent<F, Throwable> genConcurrent) {
        return WSTestClient$.MODULE$.fromHttpWebSocketApp(function1, genConcurrent);
    }

    public static class WebSocketClientInitException
    extends RuntimeException {
        public String message() {
            return "WebSocket client initialization failed";
        }
    }

    public static class WebSocketFrameOps {
        private final WebSocketFrame wsf;

        public WebSocketFrameOps(WebSocketFrame wsf) {
            this.wsf = wsf;
        }

        public WebSocketFrame wsf() {
            return this.wsf;
        }

        public WSFrame toWSFrame() {
            Option option;
            WebSocketFrame webSocketFrame = this.wsf();
            if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close c = (WebSocketFrame.Close)webSocketFrame;
                return WSFrame.Close$.MODULE$.apply(c.closeCode(), c.reason());
            }
            if (webSocketFrame instanceof WebSocketFrame.Ping) {
                ByteVector byteVector;
                WebSocketFrame.Ping ping = WebSocketFrame.Ping$.MODULE$.unapply((WebSocketFrame.Ping)webSocketFrame);
                ByteVector data = byteVector = ping._1();
                return WSFrame.Ping$.MODULE$.apply(data);
            }
            if (webSocketFrame instanceof WebSocketFrame.Pong) {
                ByteVector byteVector;
                WebSocketFrame.Pong pong = WebSocketFrame.Pong$.MODULE$.unapply((WebSocketFrame.Pong)webSocketFrame);
                ByteVector data = byteVector = pong._1();
                return WSFrame.Pong$.MODULE$.apply(data);
            }
            if (webSocketFrame instanceof WebSocketFrame.Text && !(option = WebSocketFrame.Text$.MODULE$.unapply((WebSocketFrame.Text)webSocketFrame)).isEmpty()) {
                Tuple2 tuple2 = (Tuple2)option.get();
                String data = (String)tuple2._1();
                boolean last = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
                return WSFrame.Text$.MODULE$.apply(data, last);
            }
            if (webSocketFrame instanceof WebSocketFrame.Binary) {
                WebSocketFrame.Binary binary = WebSocketFrame.Binary$.MODULE$.unapply((WebSocketFrame.Binary)webSocketFrame);
                ByteVector byteVector = binary._1();
                boolean bl = binary._2();
                ByteVector data = byteVector;
                boolean last = bl;
                return WSFrame.Binary$.MODULE$.apply(data, last);
            }
            throw new MatchError((Object)webSocketFrame);
        }
    }

    public static class WsFrameOps<F> {
        private final WSFrame wsFrame;
        private final GenConcurrent<F, Throwable> evidence$3;

        public WsFrameOps(WSFrame wsFrame, GenConcurrent<F, Throwable> evidence$3) {
            this.wsFrame = wsFrame;
            this.evidence$3 = evidence$3;
        }

        public WSFrame wsFrame() {
            return this.wsFrame;
        }

        public F toWebSocketFrame() {
            WSFrame wSFrame = this.wsFrame();
            if (wSFrame instanceof WSFrame.Close) {
                WSFrame.Close close = WSFrame.Close$.MODULE$.unapply((WSFrame.Close)wSFrame);
                int n = close._1();
                String string = close._2();
                int code = n;
                String reason = string;
                return (F)package.MonadThrow$.MODULE$.apply(this.evidence$3).fromEither(WebSocketFrame.Close$.MODULE$.apply(code, reason));
            }
            if (wSFrame instanceof WSFrame.Ping) {
                ByteVector byteVector;
                WSFrame.Ping ping = WSFrame.Ping$.MODULE$.unapply((WSFrame.Ping)wSFrame);
                ByteVector data = byteVector = ping._1();
                return (F)Applicative$.MODULE$.apply(this.evidence$3).pure((Object)WebSocketFrame.Ping$.MODULE$.apply(data));
            }
            if (wSFrame instanceof WSFrame.Pong) {
                ByteVector byteVector;
                WSFrame.Pong pong = WSFrame.Pong$.MODULE$.unapply((WSFrame.Pong)wSFrame);
                ByteVector data = byteVector = pong._1();
                return (F)Applicative$.MODULE$.apply(this.evidence$3).pure((Object)WebSocketFrame.Pong$.MODULE$.apply(data));
            }
            if (wSFrame instanceof WSFrame.Text) {
                WSFrame.Text text = WSFrame.Text$.MODULE$.unapply((WSFrame.Text)wSFrame);
                String string = text._1();
                boolean bl = text._2();
                String data = string;
                boolean last = bl;
                return (F)Applicative$.MODULE$.apply(this.evidence$3).pure((Object)WebSocketFrame.Text$.MODULE$.apply(data, last));
            }
            if (wSFrame instanceof WSFrame.Binary) {
                WSFrame.Binary binary = WSFrame.Binary$.MODULE$.unapply((WSFrame.Binary)wSFrame);
                ByteVector byteVector = binary._1();
                boolean bl = binary._2();
                ByteVector data = byteVector;
                boolean last = bl;
                return (F)Applicative$.MODULE$.apply(this.evidence$3).pure((Object)WebSocketFrame.Binary$.MODULE$.apply(data, last));
            }
            throw new MatchError((Object)wSFrame);
        }
    }
}

