/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.testkit.scaffold;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class HandlerHelpers$
implements Serializable {
    public static final HandlerHelpers$ MODULE$ = new HandlerHelpers$();

    private HandlerHelpers$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HandlerHelpers$.class);
    }

    public ChannelFuture sendResponse(ChannelHandlerContext ctx, HttpResponseStatus status, ByteBuf content, HttpHeaders headers, boolean closeConnection) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().setAll(headers);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)BoxesRunTime.boxToInteger((int)response.content().readableBytes()));
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        if (closeConnection) {
            return ctx.writeAndFlush((Object)response).addListener(f -> f.channel().disconnect());
        }
        return ctx.writeAndFlush((Object)response);
    }

    public ByteBuf sendResponse$default$3() {
        return Unpooled.buffer((int)0);
    }

    public HttpHeaders sendResponse$default$4() {
        return EmptyHttpHeaders.INSTANCE;
    }

    public boolean sendResponse$default$5() {
        return false;
    }

    public ChannelFuture sendChunkedResponseHead(ChannelHandlerContext ctx, HttpResponseStatus status, HttpHeaders headers) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().setAll(headers);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        return ctx.writeAndFlush((Object)response);
    }

    public HttpHeaders sendChunkedResponseHead$default$3() {
        return EmptyHttpHeaders.INSTANCE;
    }

    public ChannelFuture sendChunk(ChannelHandlerContext ctx, ByteBuf content) {
        return ctx.writeAndFlush((Object)new DefaultHttpContent(content));
    }

    public ChannelFuture sendEmptyLastChunk(ChannelHandlerContext ctx) {
        return ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    public ByteBuf utf8Text(String s) {
        return Unpooled.copiedBuffer((CharSequence)s, (Charset)CharsetUtil.UTF_8);
    }
}

