/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.testkit.scaffold;

import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.effect.kernel.Sync;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.URI;
import org.http4s.client.testkit.scaffold.Handler;
import org.http4s.client.testkit.scaffold.HandlersToNettyAdapter$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import org.typelevel.log4cats.slf4j.Slf4jLogger$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;

public class HandlersToNettyAdapter
extends SimpleChannelInboundHandler<HttpObject> {
    private final Map<Tuple2<HttpMethod, String>, Handler> handlers;
    private final Handler fallbackHandler;
    private final SelfAwareStructuredLogger<SyncIO> logger;
    private HttpRequest currentRequest;
    private Handler currentHandler;

    public static <F> Object apply(Map<Tuple2<HttpMethod, String>, Handler> map, Handler handler, Sync<F> sync) {
        return HandlersToNettyAdapter$.MODULE$.apply(map, handler, sync);
    }

    public static Handler defaultFallbackHandler() {
        return HandlersToNettyAdapter$.MODULE$.defaultFallbackHandler();
    }

    public static <F> Handler apply$default$2() {
        return HandlersToNettyAdapter$.MODULE$.apply$default$2();
    }

    public HandlersToNettyAdapter(Map<Tuple2<HttpMethod, String>, Handler> handlers, Handler fallbackHandler) {
        this.handlers = handlers;
        this.fallbackHandler = fallbackHandler;
        this.logger = Slf4jLogger$.MODULE$.getLogger(SyncIO$.MODULE$.syncForSyncIO(), "org.http4s.client.testkit.scaffold.HandlersToNettyAdapter");
        this.currentRequest = null;
        this.currentHandler = null;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        HttpObject httpObject;
        BoxedUnit boxedUnit;
        HttpObject httpObject2 = msg;
        if (httpObject2 instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)httpObject2;
            ((SyncIO)this.logger.trace(() -> HandlersToNettyAdapter.channelRead0$$anonfun$1(ctx, request))).unsafeRunSync();
            if (HttpUtil.is100ContinueExpected((HttpMessage)request)) {
                boxedUnit = ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            } else {
                this.currentRequest = request;
                this.currentHandler = (Handler)this.handlers.getOrElse((Object)Tuple2$.MODULE$.apply((Object)request.method(), (Object)new URI(request.uri()).getPath()), this::channelRead0$$anonfun$2);
                this.currentHandler.onRequestStart(ctx, this.currentRequest);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        HttpObject httpObject3 = msg;
        if (httpObject3 instanceof HttpContent) {
            HttpContent content = (HttpContent)httpObject3;
            ((SyncIO)this.logger.trace(HandlersToNettyAdapter::channelRead0$$anonfun$3)).unsafeRunSync();
            this.currentHandler.onContent(ctx, this.currentRequest, content);
        }
        if ((httpObject = msg) instanceof LastHttpContent) {
            ((SyncIO)this.logger.trace(HandlersToNettyAdapter::channelRead0$$anonfun$4)).unsafeRunSync();
            this.currentHandler.onRequestEnd(ctx, this.currentRequest);
            this.currentRequest = null;
            this.currentHandler = null;
            return;
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        ((SyncIO)this.logger.warn(cause, HandlersToNettyAdapter::exceptionCaught$$anonfun$1)).unsafeRunSync();
        ctx.close();
    }

    private static final String channelRead0$$anonfun$1(ChannelHandlerContext ctx$1, HttpRequest request$1) {
        return new StringBuilder(31).append("Recieved [").append(request$1.method()).append("] [").append(request$1.uri()).append("] request from [").append(ctx$1.channel().remoteAddress()).append("].").toString();
    }

    private final Handler channelRead0$$anonfun$2() {
        return this.fallbackHandler;
    }

    private static final String channelRead0$$anonfun$3() {
        return "Recieved content.";
    }

    private static final String channelRead0$$anonfun$4() {
        return "Request finished.";
    }

    private static final String exceptionCaught$$anonfun$1() {
        return "";
    }
}

