/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.data.Kleisli;
import cats.effect.Async;
import cats.effect.Effect;
import cats.effect.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import fs2.Scheduler;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.http4s.HeaderKey;
import org.http4s.HttpDate;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.DisposableResponse;
import org.http4s.headers.Retry;
import org.http4s.headers.Retry$minusAfter$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static Retry$ MODULE$;
    private final Logger logger;

    static {
        new Retry$();
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Client<F> client, Effect<F> F, Scheduler scheduler, ExecutionContext executionContext) {
        return client.copy((Kleisli<F, Request<F>, DisposableResponse<F>>)new Kleisli((Function1 & Serializable & scala.Serializable)x$2 -> Retry$.prepareLoop$1(x$2, 1, policy, client, F, scheduler, executionContext)), client.copy$default$2(), (MonadError<F, Throwable>)F);
    }

    private static final Object prepareLoop$1(Request req, int attempts, Function3 policy$1, Client client$1, Effect F$1, Scheduler scheduler$1, ExecutionContext executionContext$1) {
        return implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(client$1.open().apply((Object)req), (ApplicativeError)F$1), (ApplicativeError)F$1), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Right right;
            DisposableResponse dr;
            Either either = x0$1;
            if (either instanceof Right && (dr = (DisposableResponse)(right = (Right)either).value()) != null) {
                Object object2;
                Response response = dr.response();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Right().apply(dr.response()), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " has failed on attempt #", " with reason ", ". Retrying after ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{req, BoxesRunTime.boxToInteger((int)attempts), response.status(), duration})));
                    }
                    object2 = implicits$.MODULE$.toFlatMapOps(dr.dispose(), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Retry$.nextAttempt$1(req, attempts, duration, response.headers().get((HeaderKey.Extractable)Retry$minusAfter$.MODULE$), F$1, executionContext$1, policy$1, client$1, F$1, scheduler$1, executionContext$1));
                } else if (None$.MODULE$.equals(option)) {
                    object2 = F$1.pure((Object)dr);
                } else {
                    throw new MatchError((Object)option);
                }
                object = object2;
            } else if (either instanceof Left) {
                Object object3;
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Left().apply((Object)e), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request ", " threw an exception on attempt #", " attempts. Giving up."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{req, BoxesRunTime.boxToInteger((int)attempts)})));
                    }
                    object3 = Retry$.nextAttempt$1(req, attempts, duration, (Option)None$.MODULE$, F$1, executionContext$1, policy$1, client$1, F$1, scheduler$1, executionContext$1);
                } else if (None$.MODULE$.equals(option)) {
                    object3 = F$1.raiseError((Object)e);
                } else {
                    throw new MatchError((Object)option);
                }
                object = object3;
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        });
    }

    public static final /* synthetic */ long $anonfun$apply$3(Retry.minusAfter h) {
        long l;
        Either either = h.retry();
        if (either instanceof Left) {
            Left left = (Left)either;
            HttpDate d = (HttpDate)left.value();
            l = Instant.now().until(d.toInstant(), ChronoUnit.SECONDS);
        } else if (either instanceof Right) {
            long secs;
            Right right = (Right)either;
            l = secs = BoxesRunTime.unboxToLong((Object)right.value());
        } else {
            throw new MatchError((Object)either);
        }
        return l;
    }

    private static final Object nextAttempt$1(Request req, int attempts, FiniteDuration duration, Option retryHeader, Effect F, ExecutionContext executionContext, Function3 policy$1, Client client$1, Effect F$1, Scheduler scheduler$1, ExecutionContext executionContext$1) {
        long headerDuration = BoxesRunTime.unboxToLong((Object)retryHeader.map((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToLong((long)Retry$.$anonfun$apply$3(h))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        FiniteDuration sleepDuration = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(Math.max(headerDuration, duration.length()))).seconds();
        return implicits$.MODULE$.catsSyntaxApply(Stream.ToEffect$.MODULE$.drain$extension(Stream.InvariantOps$.MODULE$.compile$extension(Stream$.MODULE$.InvariantOps(scheduler$1.sleep_(sleepDuration, (Async)F, executionContext))), (Sync)F), (Apply)F).$times$greater(Retry$.prepareLoop$1((Request)req.withEmptyBody((Functor)F), attempts + 1, policy$1, client$1, F$1, scheduler$1, executionContext$1));
    }

    private Retry$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.Retry");
    }
}

