/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Sync;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.Message;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString;
import org.typelevel.vault.Vault;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ResponseLogger$ {
    public static ResponseLogger$ MODULE$;
    private final Logger logger;

    static {
        new ResponseLogger$();
    }

    private <F> F defaultLogAction(String s, Sync<F> evidence$1) {
        return (F)cats.effect.package$.MODULE$.Sync().apply(evidence$1).delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (!ResponseLogger$.MODULE$.logger.isInfoEnabled()) break block0;
                ResponseLogger$.MODULE$.logger.info(s);
            }
        });
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$2) {
        return this.impl(client, logBody, (Function1 & Serializable & scala.Serializable)response -> Logger$.MODULE$.logMessage(response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$2)), evidence$2), evidence$2);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$apply$default$3$1(elem));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<F>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$3) {
        return this.impl(client, true, (Function1 & Serializable & scala.Serializable)response -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$3)), (Monad)evidence$3), evidence$3);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$logBodyText$default$3$1(elem));
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, F>> logAction, Function1<Response<F>, F> responseToText, Async<F> evidence$4) {
        return this.impl(client, logBody, (Function1 & Serializable & scala.Serializable)response -> {
            Function1 log = (Function1)logAction.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Function1 & Serializable & scala.Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$4));
            return package.all$.MODULE$.toFlatMapOps(responseToText.apply(response), (FlatMap)evidence$4).flatMap(log);
        }, evidence$4);
    }

    public <F> boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Response<F>, F> logMessage, Async<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable & scala.Serializable)req -> client.run((Request)req).flatMap((Function1 & Serializable & scala.Serializable)response -> !logBody ? cats.effect.package$.MODULE$.Resource().eval(package.all$.MODULE$.catsSyntaxApply(logMessage.apply(response), (Apply)F).$times$greater(F.delay((Function0 & Serializable & scala.Serializable)() -> response))) : cats.effect.package$.MODULE$.Resource().suspend(package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(cats.effect.package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)F)), (Object)package$.MODULE$.Vector().empty()), (Functor)F).map((Function1 & Serializable & scala.Serializable)vec -> {
            Stream x$12 = Stream.InvariantOps$.MODULE$.observe$extension(Stream$.MODULE$.InvariantOps(response.body()), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.chunks().flatMap((Function1 & Serializable & scala.Serializable)s -> Stream$.MODULE$.exec(vec.update((Function1 & Serializable & scala.Serializable)x$2 -> (Vector)x$2.$colon$plus(s, Vector$.MODULE$.canBuildFrom()))), NotGiven$.MODULE$.default()), (GenConcurrent)F);
            Status x$2 = response.copy$default$1();
            HttpVersion x$32 = response.copy$default$2();
            List x$4 = response.copy$default$3();
            Vault x$5 = response.copy$default$5();
            return cats.effect.package$.MODULE$.Resource().make(F.pure((Object)response.copy(x$2, x$32, x$4, x$12, x$5)), (Function1 & Serializable & scala.Serializable)x$3 -> {
                Stream newBody = Stream$.MODULE$.eval(vec.get()).flatMap((Function1 & Serializable & scala.Serializable)v -> Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.emits((Seq)v))), NotGiven$.MODULE$.default()).flatMap((Function1 & Serializable & scala.Serializable)c -> Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.chunk(c))), NotGiven$.MODULE$.default());
                return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(logMessage.apply((Object)response.withBodyStream(newBody)), (ApplicativeError)F), (ApplicativeError)F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable t = (Throwable)left.value();
                        return F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ResponseLogger$.MODULE$.logger.error("Error logging response body", t));
                    }
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Right right = (Right)either;
                    BoxedUnit boxedUnit = (BoxedUnit)right.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (boxedUnit2 != null) {
                        if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)either);
                        return F.unit();
                    }
                    if (boxedUnit3 == null) return F.unit();
                    throw new MatchError((Object)either);
                });
            }, (Functor)F);
        }))), F);
    }

    public <F> String defaultResponseColor(Response<F> response) {
        String string;
        Status.ResponseClass responseClass = response.status().responseClass();
        boolean bl = Status.Informational$.MODULE$.equals(responseClass) ? true : (Status.Successful$.MODULE$.equals(responseClass) ? true : Status.Redirection$.MODULE$.equals(responseClass));
        if (bl) {
            string = "\u001b[32m";
        } else if (Status.ClientError$.MODULE$.equals(responseClass)) {
            string = "\u001b[33m";
        } else if (Status.ServerError$.MODULE$.equals(responseClass)) {
            string = "\u001b[31m";
        } else {
            throw new MatchError((Object)responseClass);
        }
        return string;
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Function1<Response<F>, String> color, Option<Function1<String, F>> logAction, Client<F> client, Async<F> evidence$5) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable & scala.Serializable)response -> {
            Object object;
            String prelude = new StringBuilder(1).append(response.httpVersion()).append(" ").append(response.status()).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)response, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)response, logBody, (GenConcurrent)evidence$5);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object textF = some.value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)evidence$5).map((Function1 & Serializable & scala.Serializable)text -> new StringBuilder(7).append("body=\"").append((String)text).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = cats.effect.package$.MODULE$.Sync().apply((Sync)evidence$5).pure((Object)"");
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)evidence$5).map((Function1 & Serializable & scala.Serializable)body -> new StringBuilder(4).append(color.apply(response)).append(prelude).append(ResponseLogger$.spaced$1(headers)).append(ResponseLogger$.spaced$1(body)).append("\u001b[0m").toString());
        }, evidence$5);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$colored$default$3$1(elem));
    }

    public <F> Function1<Response<Nothing$>, String> colored$default$4() {
        return (Function1 & Serializable & scala.Serializable)response -> MODULE$.defaultResponseColor((Response)response);
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$logBodyText$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private static final String spaced$1(String x) {
        return x.isEmpty() ? x : new StringBuilder(1).append(" ").append(x).toString();
    }

    public static final /* synthetic */ boolean $anonfun$colored$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private ResponseLogger$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.ResponseLogger");
    }
}

