/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Resource$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.syntax.FlatMapOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.http4s.Header;
import org.http4s.Headers$;
import org.http4s.HttpDate;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.headers.Retry;
import org.http4s.headers.Retry$minusAfter$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class Retry$ {
    public static Retry$ MODULE$;
    private final Logger logger;

    static {
        new Retry$();
    }

    public <F> Client<F> apply(Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> policy, Function1<CIString, Object> redactHeaderWhen, Client<F> client, GenTemporal<F, Throwable> F) {
        return Client$.MODULE$.apply((Function1 & Serializable & scala.Serializable)req -> Hotswap$.MODULE$.create((GenConcurrent)F).flatMap((Function1 & Serializable & scala.Serializable)hotswap -> Resource$.MODULE$.eval(Retry$.retryLoop$1(req, 1, hotswap, F, client, policy, redactHeaderWhen))), F);
    }

    public <F> Function1<CIString, Object> apply$default$2() {
        return (Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)Retry$.$anonfun$apply$default$2$1(elem));
    }

    private static final String showRequest$1(Request request, Function1 redactWhen) {
        String headers = Headers$.MODULE$.redactSensitive$extension(request.headers(), redactWhen).mkString(",");
        String uri = request.uri().renderString();
        Method method = request.method();
        return new StringBuilder(21).append("method=").append(method).append(" uri=").append(uri).append(" headers=").append(headers).toString();
    }

    public static final /* synthetic */ long $anonfun$apply$1(Retry.minusAfter h) {
        long l;
        Either either = h.retry();
        if (either instanceof Left) {
            Left left = (Left)either;
            HttpDate d = (HttpDate)left.value();
            l = Instant.now().until(d.toInstant(), ChronoUnit.SECONDS);
        } else if (either instanceof Right) {
            long secs;
            Right right = (Right)either;
            l = secs = BoxesRunTime.unboxToLong((Object)right.value());
        } else {
            throw new MatchError((Object)either);
        }
        return l;
    }

    private static final Object nextAttempt$1(Request req, int attempts, FiniteDuration duration, Option retryHeader, Hotswap hotswap, GenTemporal F$1, Client client$1, Function3 policy$1, Function1 redactHeaderWhen$1) {
        long headerDuration = BoxesRunTime.unboxToLong((Object)retryHeader.map((Function1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToLong((long)Retry$.$anonfun$apply$1(h))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        FiniteDuration sleepDuration = new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(headerDuration)).seconds().max(duration);
        return FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(F$1.sleep(sleepDuration), (FlatMap)F$1), (Function0 & Serializable & scala.Serializable)() -> Retry$.retryLoop$1(req, attempts + 1, hotswap, F$1, client$1, policy$1, redactHeaderWhen$1), (FlatMap)F$1);
    }

    private static final Object retryLoop$1(Request req, int attempts, Hotswap hotswap, GenTemporal F$1, Client client$1, Function3 policy$1, Function1 redactHeaderWhen$1) {
        return package.all$.MODULE$.catsSyntaxApply(hotswap.clear(), (Apply)F$1).$times$greater(package.all$.MODULE$.toFlatMapOps(hotswap.swap(client$1.run(req).attempt((ApplicativeError)F$1)), (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Either either = x0$1;
            if (either instanceof Right) {
                Object object2;
                Right right = (Right)either;
                Response response = (Response)right.value();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Right().apply((Object)response), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(63).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" has failed on attempt #").append(attempts).append(" with reason ").append(response.status()).append(". Retrying after ").append(duration).append(".").toString());
                    }
                    object2 = Retry$.nextAttempt$1(req, attempts, duration, Headers$.MODULE$.get$extension0(response.headers(), Header.Select$.MODULE$.singleHeaders(Retry$minusAfter$.MODULE$.headerInstance())), hotswap, F$1, client$1, policy$1, redactHeaderWhen$1);
                } else if (None$.MODULE$.equals(option)) {
                    object2 = F$1.pure((Object)response);
                } else {
                    throw new MatchError((Object)option);
                }
                object = object2;
            } else if (either instanceof Left) {
                Object object3;
                Left left = (Left)either;
                Throwable e = (Throwable)left.value();
                Option option = (Option)policy$1.apply((Object)req, (Object)package$.MODULE$.Left().apply((Object)e), (Object)BoxesRunTime.boxToInteger((int)attempts));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    FiniteDuration duration = (FiniteDuration)some.value();
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(56).append("Request threw an exception on attempt #").append(attempts).append(". Retrying after ").append(duration).toString(), e);
                    }
                    object3 = Retry$.nextAttempt$1(req, attempts, duration, (Option)None$.MODULE$, hotswap, F$1, client$1, policy$1, redactHeaderWhen$1);
                } else if (None$.MODULE$.equals(option)) {
                    if (Retry$.MODULE$.logger.isInfoEnabled()) {
                        Retry$.MODULE$.logger.info(new StringBuilder(52).append("Request ").append(Retry$.showRequest$1(req, redactHeaderWhen$1)).append(" threw an exception on attempt #").append(attempts).append(". Giving up.").toString(), e);
                    }
                    object3 = F$1.raiseError((Object)e);
                } else {
                    throw new MatchError((Object)option);
                }
                object = object3;
            } else {
                throw new MatchError((Object)either);
            }
            return object;
        }));
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$2$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private Retry$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.Retry");
    }
}

