/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.client.WaitQueueTimeoutException$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RetryPolicy$ {
    public static final RetryPolicy$ MODULE$ = new RetryPolicy$();
    private static final Set<Status> RetriableStatuses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Status[]{Status$.MODULE$.RequestTimeout(), Status$.MODULE$.InternalServerError(), Status$.MODULE$.ServiceUnavailable(), Status$.MODULE$.BadGateway(), Status$.MODULE$.GatewayTimeout()}));

    public <F> Function3<Request<F>, Either<Throwable, Response<F>>, Object, Option<FiniteDuration>> apply(Function1<Object, Option<FiniteDuration>> backoff, Function2<Request<F>, Either<Throwable, Response<F>>, Object> retriable) {
        return (Function3 & Serializable)(req, result, retries) -> RetryPolicy$.$anonfun$apply$7(retriable, backoff, req, result, BoxesRunTime.unboxToInt((Object)retries));
    }

    public <F> Function2<Request<F>, Either<Throwable, Response<F>>, Object> apply$default$2() {
        return (Function2 & Serializable)(req, result) -> BoxesRunTime.boxToBoolean((boolean)RetryPolicy$.MODULE$.defaultRetriable(req, result));
    }

    public Set<Status> RetriableStatuses() {
        return RetriableStatuses;
    }

    public <F> boolean defaultRetriable(Request<F> req, Either<Throwable, Response<F>> result) {
        return req.method().isIdempotent() && this.isErrorOrRetriableStatus(result);
    }

    public <F> boolean unsafeRetriable(Request<F> req, Either<Throwable, Response<F>> result) {
        return this.defaultRetriable(req, result);
    }

    public <F> boolean recklesslyRetriable(Either<Throwable, Response<F>> result) {
        return this.isErrorOrRetriableStatus(result);
    }

    public <F> boolean isErrorOrRetriableStatus(Either<Throwable, Response<F>> result) {
        boolean bl;
        Either<Throwable, Response<F>> either = result;
        if (either instanceof Right) {
            Right right = (Right)either;
            Response resp = (Response)right.value();
            bl = this.RetriableStatuses().apply((Object)resp.status());
        } else {
            Left left;
            Throwable throwable;
            bl = !(either instanceof Left) || !WaitQueueTimeoutException$.MODULE$.equals(throwable = (Throwable)(left = (Left)either).value());
        }
        return bl;
    }

    public Function1<Object, Option<FiniteDuration>> exponentialBackoff(Duration maxWait, int maxRetry) {
        long maxInMillis = maxWait.toMillis();
        return (Function1 & Serializable)k -> RetryPolicy$.$anonfun$exponentialBackoff$1(maxRetry, maxInMillis, BoxesRunTime.unboxToInt((Object)k));
    }

    private FiniteDuration expBackoff(int k, long maxInMillis) {
        double millis = (package$.MODULE$.pow(2.0, (double)k) - 1.0) * 1000.0;
        double interval = package$.MODULE$.min(millis, (double)maxInMillis);
        return FiniteDuration$.MODULE$.apply((long)(package$.MODULE$.random() * interval), TimeUnit.MILLISECONDS);
    }

    public static final /* synthetic */ Option $anonfun$apply$7(Function2 retriable$1, Function1 backoff$1, Request req, Either result, int retries) {
        return BoxesRunTime.unboxToBoolean((Object)retriable$1.apply((Object)req, (Object)result)) ? (Option)backoff$1.apply((Object)BoxesRunTime.boxToInteger((int)retries)) : None$.MODULE$;
    }

    public static final /* synthetic */ Option $anonfun$exponentialBackoff$1(int maxRetry$1, long maxInMillis$1, int k) {
        return k > maxRetry$1 ? None$.MODULE$ : new Some((Object)MODULE$.expBackoff(k, maxInMillis$1));
    }

    private RetryPolicy$() {
    }
}

