/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.effect.Concurrent;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.Message;
import org.http4s.Request;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RequestLogger$ {
    public static final RequestLogger$ MODULE$ = new RequestLogger$();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.RequestLogger");
    private static final String defaultRequestColor = "\u001b[34m";

    private <F> F defaultLogAction(String s, Sync<F> evidence$1) {
        return (F)Sync$.MODULE$.apply(evidence$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (!logger.isInfoEnabled()) break block0;
                logger.info(s);
            }
        });
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Concurrent<F> evidence$2) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> Logger$.MODULE$.logMessage(request, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$2)), evidence$2), evidence$2);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)RequestLogger$.$anonfun$apply$default$3$1(elem));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<F>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Concurrent<F> evidence$3) {
        return this.impl(client, true, (Function1 & Serializable)request -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)request, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$3)), (Sync)evidence$3), evidence$3);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)RequestLogger$.$anonfun$logBodyText$default$3$1(elem));
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, F>> logAction, Function1<Request<F>, F> requestToText, Concurrent<F> evidence$4) {
        return this.impl(client, logBody, (Function1 & Serializable)request -> {
            Function1 log = (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$4));
            return package.all$.MODULE$.toFlatMapOps(requestToText.apply(request), (FlatMap)evidence$4).flatMap(log);
        }, evidence$4);
    }

    public <F> boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Request<F>, F> logMessage, Concurrent<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> !logBody ? (Resource)package.all$.MODULE$.catsSyntaxApply((Object)Resource$.MODULE$.eval(logMessage.apply(req), (Applicative)F), (Apply)Resource$.MODULE$.catsEffectMonadErrorForResource((MonadError)F)).$times$greater(client.run((Request)req)) : Resource$.MODULE$.suspend(package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(Ref$.MODULE$.apply((Sync)F), (Object)package$.MODULE$.Vector().empty()), (Functor)F).map((Function1 & Serializable)vec -> {
            FreeC newBody = Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(vec.get()), (Function1 & Serializable)v -> new Stream(Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.emits((Seq)v))))), (Function1 & Serializable)c -> new Stream(Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.chunk(c)))));
            Request changedRequest = (Request)req.withBodyStream(Stream$.MODULE$.onFinalizeWeak$extension(Stream.InvariantOps$.MODULE$.observe$extension(Stream$.MODULE$.InvariantOps(req.body()), (Function1 & Serializable)x$1 -> new Stream(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.chunks$extension(((Stream)x$1).fs2$Stream$$free()), (Function1 & Serializable)s -> new Stream(Stream$.MODULE$.eval_(vec$1.update((Function1 & Serializable)x$2 -> (Vector)x$2.$colon$plus((Object)s)))))), F), package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(logMessage.apply((Object)req.withBodyStream(newBody)), (ApplicativeError)F), (ApplicativeError)F), (FlatMap)F).flatMap((Function1 & Serializable)x0$1 -> {
                Either either = x0$1;
                if (either instanceof Left) {
                    Left left = (Left)either;
                    Throwable t = (Throwable)left.value();
                    return F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> logger.error("Error logging request body", t));
                }
                if (!(either instanceof Right)) throw new MatchError((Object)either);
                Right right = (Right)either;
                BoxedUnit boxedUnit = (BoxedUnit)right.value();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = boxedUnit;
                if (boxedUnit2 != null) {
                    if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)either);
                    return F.unit();
                }
                if (boxedUnit3 == null) return F.unit();
                throw new MatchError((Object)either);
            }), (Applicative)F));
            return client.run(changedRequest);
        })), F);
    }

    public String defaultRequestColor() {
        return defaultRequestColor;
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, String color, Option<Function1<String, F>> logAction, Client<F> client, Concurrent<F> evidence$5) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable)request -> {
            Object object;
            String methodColor = request.method().isSafe() ? color : "\u001b[33m";
            String prelude = new StringBuilder(14).append(request.httpVersion()).append(" ").append(methodColor).append(request.method()).append("\u001b[0m").append(color).append(" ").append("\u001b[1m").append(request.uri()).append("\u001b[0m").append(color).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)request, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)request, logBody, (Sync)evidence$5);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object textF = some.value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)evidence$5).map((Function1 & Serializable)text -> new StringBuilder(7).append("body=\"").append((String)text).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = Sync$.MODULE$.apply((Sync)evidence$5).pure((Object)"");
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)evidence$5).map((Function1 & Serializable)body -> new StringBuilder(4).append(color).append(prelude).append(RequestLogger$.spaced$1(headers)).append(RequestLogger$.spaced$1(body)).append("\u001b[0m").toString());
        }, evidence$5);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)RequestLogger$.$anonfun$colored$default$3$1(elem));
    }

    public <F> String colored$default$4() {
        return this.defaultRequestColor();
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$logBodyText$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private static final String spaced$1(String x) {
        return x.isEmpty() ? x : new StringBuilder(1).append(" ").append(x).toString();
    }

    public static final /* synthetic */ boolean $anonfun$colored$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private RequestLogger$() {
    }
}

