/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.oauth1;

import cats.Functor;
import cats.Monad;
import cats.MonadError;
import cats.Show;
import cats.Show$;
import cats.data.Chain;
import cats.data.NonEmptyList;
import cats.effect.SyncIO;
import cats.effect.SyncIO$;
import cats.instances.package;
import cats.kernel.Eq$;
import cats.syntax.package;
import java.io.Serializable;
import org.http4s.Charset;
import org.http4s.Charset$;
import org.http4s.Credentials;
import org.http4s.EntityDecoder;
import org.http4s.Header;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Query;
import org.http4s.Query$;
import org.http4s.Request;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.UrlForm;
import org.http4s.UrlForm$;
import org.http4s.client.oauth1.Consumer;
import org.http4s.client.oauth1.HmacSha1$;
import org.http4s.client.oauth1.ProtocolParameter;
import org.http4s.client.oauth1.ProtocolParameter$;
import org.http4s.client.oauth1.ProtocolParameter$SignatureMethod$;
import org.http4s.client.oauth1.ProtocolParameter$Version$;
import org.http4s.client.oauth1.SignatureAlgorithm;
import org.http4s.client.oauth1.SignatureAlgorithm$;
import org.http4s.client.oauth1.Token;
import org.http4s.headers.Authorization;
import org.http4s.headers.Authorization$;
import org.http4s.headers.Content;
import org.http4s.internal.CharPredicate;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.runtime.ScalaRunTime$;

public final class package$ {
    public static final package$ MODULE$ = new package$();
    private static final String OutOfBand = "oob";

    private String OutOfBand() {
        return OutOfBand;
    }

    public <F> F signRequest(Request<F> req, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token, MonadError<F, Throwable> F, EntityDecoder<F, UrlForm> W) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.getUserParams(req, F, W), F).flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Request req = (Request)tuple2._1();
            Seq params = (Seq)tuple2._2();
            Object object = package.all$.MODULE$.toFunctorOps(MODULE$.genAuthHeader(req.method(), req.uri(), (Seq<Tuple2<String, String>>)params, consumer, callback, verifier, token, HmacSha1$.MODULE$, F), (Functor)F).map((Function1 & Serializable)auth -> (Request)req.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(auth, Authorization$.MODULE$.headerInstance())})));
            return object;
        });
    }

    public <F> F signRequest(Request<F> req, ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, Option<ProtocolParameter.Realm> realm, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, MonadError<F, Throwable> F, EntityDecoder<F, UrlForm> W) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.getUserParams(req, F, W), F).flatMap((Function1 & Serializable)reqParams -> {
            Tuple2 tuple2 = reqParams;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Request req = (Request)tuple2._1();
            Seq params = (Seq)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)req, (Object)params);
            Tuple3 tuple32 = tuple3;
            Tuple2 tuple22 = (Tuple2)tuple32._1();
            Request req2 = (Request)tuple32._2();
            Seq params2 = (Seq)tuple32._3();
            return package.all$.MODULE$.toFunctorOps(MODULE$.genAuthHeader(req2.method(), req2.uri(), consumer, token, realm, signatureMethod, timestampGenerator, version, nonceGenerator, callback, verifier, (Seq<ProtocolParameter>)((Seq)params2.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                ProtocolParameter.Custom custom = new ProtocolParameter.Custom(k, v);
                return custom;
            })), F), (Functor)F).map((Function1 & Serializable)auth -> (Request)req2.putHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[]{Header.ToRaw$.MODULE$.modelledHeadersToRaw(auth, Authorization$.MODULE$.headerInstance())})));
        });
    }

    public <F> ProtocolParameter.SignatureMethod signRequest$default$5() {
        return new ProtocolParameter.SignatureMethod(ProtocolParameter$SignatureMethod$.MODULE$.apply$default$1());
    }

    public <F> ProtocolParameter.Version signRequest$default$7() {
        return new ProtocolParameter.Version(ProtocolParameter$Version$.MODULE$.apply$default$1());
    }

    public <F> Option<ProtocolParameter.Callback> signRequest$default$9() {
        return None$.MODULE$;
    }

    public <F> Option<ProtocolParameter.Verifier> signRequest$default$10() {
        return None$.MODULE$;
    }

    public <F> F takeSigHeaders(ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, Monad<F> evidence$1) {
        return (F)package.all$.MODULE$.toFlatMapOps(timestampGenerator, evidence$1).flatMap((Function1 & Serializable)timestamp -> package.all$.MODULE$.toFunctorOps(nonceGenerator, (Functor)evidence$1).map((Function1 & Serializable)nonce -> {
            List headers = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Product[]{consumer, signatureMethod, timestamp, nonce, version}));
            return (List)headers.$plus$plus((IterableOnce)((StrictOptimizedIterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{token, callback, verifier}))).flatten(Predef$.MODULE$.$conforms()));
        }));
    }

    public <F> F genAuthHeader(Method method, Uri uri, ProtocolParameter.Consumer consumer, Option<ProtocolParameter.Token> token, Option<ProtocolParameter.Realm> realm, ProtocolParameter.SignatureMethod signatureMethod, F timestampGenerator, ProtocolParameter.Version version, F nonceGenerator, Option<ProtocolParameter.Callback> callback, Option<ProtocolParameter.Verifier> verifier, Seq<ProtocolParameter> queryParams, MonadError<F, Throwable> evidence$2) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.takeSigHeaders(consumer, token, signatureMethod, timestampGenerator, version, nonceGenerator, callback, verifier, (Monad<F>)evidence$2), evidence$2).flatMap((Function1 & Serializable)headers -> {
            Show show = Show$.MODULE$.apply(ProtocolParameter$.MODULE$.oauth1HeaderShow());
            String baseStr = MODULE$.mkBaseString(method, uri, ((IterableOnceOps)((IterableOps)((SeqOps)headers.$plus$plus((IterableOnce)queryParams)).sorted(package.order$.MODULE$.catsKernelOrderingForOrder(ProtocolParameter$.MODULE$.http4sClientOauth1SortForProtocolParameters()))).map((Function1 & Serializable)t -> show.show(t))).mkString("&"));
            SignatureAlgorithm alg = SignatureAlgorithm$.MODULE$.unsafeFromMethod(signatureMethod);
            return package.all$.MODULE$.toFunctorOps(MODULE$.makeSHASig(baseStr, consumer.secret(), (Option<String>)token.map((Function1 & Serializable)x$4 -> x$4.secret()), alg, evidence$2), (Functor)evidence$2).map((Function1 & Serializable)sig -> {
                Credentials.AuthParams creds = new Credentials.AuthParams(org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"OAuth"}))).ci((Seq)Nil$.MODULE$), new NonEmptyList((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_signature"), (Object)MODULE$.encode((String)sig)), ((IterableOnceOps)realm.fold((Function0 & Serializable)() -> (Seq)headers.map((Function1 & Serializable)x$5 -> x$5.toTuple()), (Function1 & Serializable)x$6 -> {
                    Tuple2<String, String> tuple2 = x$6.toTuple();
                    return (Seq)((SeqOps)headers.map((Function1 & Serializable)x$7 -> x$7.toTuple())).$plus$colon(tuple2);
                })).toList()));
                return new Authorization((Credentials)creds);
            });
        });
    }

    public Authorization genAuthHeader(Method method, Uri uri, Seq<Tuple2<String, String>> userParams, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token) {
        return (Authorization)((SyncIO)this.genAuthHeader(method, uri, userParams, consumer, callback, verifier, token, HmacSha1$.MODULE$, (MonadError)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    public <F> F genAuthHeader(Method method, Uri uri, Seq<Tuple2<String, String>> userParams, Consumer consumer, Option<Uri> callback, Option<String> verifier, Option<Token> token, SignatureAlgorithm algorithm, MonadError<F, Throwable> evidence$3) {
        ListBuffer params = new ListBuffer();
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_consumer_key"), (Object)this.encode(consumer.key())));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_signature_method"), (Object)algorithm.name()));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_timestamp"), (Object)Long.toString(System.currentTimeMillis() / 1000L)));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_nonce"), (Object)Long.toString(System.nanoTime())));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_version"), (Object)"1.0"));
        params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_callback"), callback.map((Function1 & Serializable)c -> MODULE$.encode(c.renderString())).getOrElse((Function0 & Serializable)() -> MODULE$.OutOfBand())));
        token.foreach((Function1 & Serializable)t -> (ListBuffer)params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_token"), (Object)MODULE$.encode(t.value()))));
        verifier.foreach((Function1 & Serializable)v -> (ListBuffer)params.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_verifier"), (Object)MODULE$.encode((String)v))));
        List params2 = params.result();
        String baseString = this.genBaseString(method, uri, (Seq<Tuple2<String, String>>)((Seq)params2.$plus$plus((IterableOnce)userParams.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)MODULE$.encode(k), (Object)MODULE$.encode(v));
            return tuple22;
        }))));
        return (F)package.all$.MODULE$.toFunctorOps(this.makeSHASig(baseString, consumer.secret(), (Option<String>)token.map((Function1 & Serializable)x$8 -> x$8.secret()), algorithm, evidence$3), evidence$3).map((Function1 & Serializable)sig -> {
            Credentials.AuthParams creds = new Credentials.AuthParams(org.typelevel.ci.package$.MODULE$.CIStringSyntax(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"OAuth"}))).ci((Seq)Nil$.MODULE$), new NonEmptyList((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_signature"), (Object)MODULE$.encode((String)sig)), params2));
            return new Authorization((Credentials)creds);
        });
    }

    public String makeSHASig(String baseString, Consumer consumer, Option<Token> token) {
        return this.makeSHASig(baseString, consumer.secret(), (Option<String>)token.map((Function1 & Serializable)x$9 -> x$9.secret()));
    }

    public String makeSHASig(String baseString, String consumerSecret, Option<String> tokenSecret) {
        return (String)((SyncIO)this.makeSHASig(baseString, consumerSecret, tokenSecret, HmacSha1$.MODULE$, (MonadError)SyncIO$.MODULE$.syncForSyncIO())).unsafeRunSync();
    }

    public <F> F makeSHASig(String baseString, String consumerSecret, Option<String> tokenSecret, SignatureAlgorithm algorithm, MonadError<F, Throwable> evidence$4) {
        String key = new StringBuilder(1).append(this.encode(consumerSecret)).append("&").append(tokenSecret.map((Function1 & Serializable)t -> MODULE$.encode((String)t)).getOrElse((Function0 & Serializable)() -> "")).toString();
        return algorithm.generate(baseString, key, evidence$4);
    }

    public String genBaseString(Method method, Uri uri, Seq<Tuple2<String, String>> params) {
        String paramsStr = ((IterableOnceOps)((SeqOps)params.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        })).sorted(package.order$.MODULE$.catsKernelOrderingForOrder(Eq$.MODULE$.catsKernelInstancesForString()))).mkString("&");
        return this.mkBaseString(method, uri, paramsStr);
    }

    public String mkBaseString(Method method, Uri uri, String paramsStr) {
        Query x$1 = Query$.MODULE$.empty();
        None$ x$2 = None$.MODULE$;
        Option x$3 = uri.copy$default$1();
        Option x$4 = uri.copy$default$2();
        Uri.Path x$5 = uri.copy$default$3();
        return new .colon.colon((Object)method.name(), (List)new .colon.colon((Object)this.encode(uri.copy(x$3, x$4, x$5, x$1, (Option)x$2).renderString()), (List)new .colon.colon((Object)this.encode(paramsStr), (List)Nil$.MODULE$))).mkString("&");
    }

    public String encode(String str) {
        String x$1 = str;
        boolean x$2 = false;
        CharPredicate x$3 = Uri$.MODULE$.Unreserved();
        java.nio.charset.Charset x$4 = Uri$.MODULE$.encode$default$2();
        return Uri$.MODULE$.encode(x$1, x$4, false, (Function1)x$3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public <F> F getUserParams(Request<F> req, MonadError<F, Throwable> F, EntityDecoder<F, UrlForm> W) {
        Object object;
        Vector qparams;
        block4: {
            Content.minusType t;
            block5: {
                qparams = (Vector)req.uri().query().pairs().map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    Option ov = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)k, ov.getOrElse((Function0 & Serializable)() -> ""));
                    return tuple22;
                });
                Option option = req.contentType();
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                t = (Content.minusType)some.value();
                Method method = req.method();
                Method method2 = Method$.MODULE$.POST();
                if (!(method == null ? method2 != null : !method.equals(method2))) break block5;
                Method method3 = req.method();
                Method method4 = Method$.MODULE$.PUT();
                if (method3 != null ? !method3.equals(method4) : method4 != null) break block4;
            }
            MediaType mediaType = t.mediaType();
            MediaType mediaType2 = MediaType$.MODULE$.application().x$minuswww$minusform$minusurlencoded();
            if (!(mediaType != null ? !mediaType.equals(mediaType2) : mediaType2 != null)) {
                object = package.all$.MODULE$.toFunctorOps(req.as(F, W), F).map((Function1 & Serializable)urlform -> package$.$anonfun$getUserParams$3(req, qparams, ((UrlForm)urlform).values()));
                return (F)object;
            }
        }
        object = F.pure((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(req), (Object)qparams));
        return (F)object;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getUserParams$3(Request req$3, Vector qparams$1, Map urlform) {
        Seq bodyparams = (Seq)urlform.toSeq().flatMap((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Chain vs = (Chain)tuple2._2();
            List list = vs.isEmpty() ? (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)"")})) : vs.toList().map((Function1 & Serializable)x$10 -> new Tuple2((Object)k, x$10));
            return list;
        });
        Charset charset = (Charset)req$3.charset().getOrElse((Function0 & Serializable)() -> Charset$.MODULE$.UTF$minus8());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)req$3.withEntity((Object)new UrlForm(urlform), UrlForm$.MODULE$.entityEncoder(charset))), qparams$1.$plus$plus((IterableOnce)bodyparams));
    }

    private package$() {
    }
}

