/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Concurrent;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import io.chrisdavenport.vault.Vault;
import java.io.Serializable;
import org.http4s.Headers$;
import org.http4s.HttpVersion;
import org.http4s.Message;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.typelevel.ci.CIString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ResponseLogger$ {
    public static final ResponseLogger$ MODULE$ = new ResponseLogger$();
    private static final Logger logger = LoggerFactory.getLogger((String)"org.http4s.client.middleware.ResponseLogger");

    private <F> F defaultLogAction(String s, Sync<F> evidence$1) {
        return (F)Sync$.MODULE$.apply(evidence$1).delay((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            block0: {
                if (!logger.isInfoEnabled()) break block0;
                logger.info(s);
            }
        });
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Concurrent<F> evidence$2) {
        return this.impl(client, logBody, (Function1 & Serializable)response -> Logger$.MODULE$.logMessage(response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$2)), evidence$2), evidence$2);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$apply$default$3$1(elem));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<F>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, Concurrent<F> evidence$3) {
        return this.impl(client, true, (Function1 & Serializable)response -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$3)), (Sync)evidence$3), evidence$3);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$logBodyText$default$3$1(elem));
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, F>> logAction, Function1<Response<F>, F> responseToText, Concurrent<F> evidence$4) {
        return this.impl(client, logBody, (Function1 & Serializable)response -> {
            Function1 log = (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Sync)evidence$4));
            return package.all$.MODULE$.toFlatMapOps(responseToText.apply(response), (FlatMap)evidence$4).flatMap(log);
        }, evidence$4);
    }

    public <F> boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Response<F>, F> logMessage, Concurrent<F> F) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> client.run((Request)req).flatMap((Function1 & Serializable)response -> !logBody ? Resource$.MODULE$.liftF(package.all$.MODULE$.catsSyntaxApply(logMessage.apply(response), (Apply)F).$times$greater(F.delay((Function0 & Serializable)() -> response)), (Applicative)F) : Resource$.MODULE$.suspend(package.all$.MODULE$.toFunctorOps(Ref.ApplyBuilders$.MODULE$.of$extension(Ref$.MODULE$.apply((Sync)F), (Object)package$.MODULE$.Vector().empty()), (Functor)F).map((Function1 & Serializable)vec -> {
            FreeC x$12 = Stream.InvariantOps$.MODULE$.observe$extension(Stream$.MODULE$.InvariantOps(response.body()), (Function1 & Serializable)x$1 -> new Stream(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.chunks$extension(((Stream)x$1).fs2$Stream$$free()), (Function1 & Serializable)s -> new Stream(Stream$.MODULE$.eval_(vec$1.update((Function1 & Serializable)x$2 -> (Vector)x$2.$colon$plus((Object)s)))))), F);
            Status x$2 = response.copy$default$1();
            HttpVersion x$32 = response.copy$default$2();
            List x$4 = response.copy$default$3();
            Vault x$5 = response.copy$default$5();
            return Resource$.MODULE$.make(F.pure((Object)response.copy(x$2, x$32, x$4, x$12, x$5)), (Function1 & Serializable)x$3 -> {
                FreeC newBody = Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(vec.get()), (Function1 & Serializable)v -> new Stream(Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.emits((Seq)v))))), (Function1 & Serializable)c -> new Stream(Stream.PureOps$.MODULE$.covary$extension(Stream$.MODULE$.PureOps(Stream$.MODULE$.chunk(c)))));
                return package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(logMessage.apply((Object)response.withBodyStream(newBody)), (ApplicativeError)F), (ApplicativeError)F), (FlatMap)F).flatMap((Function1 & Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        Throwable t = (Throwable)left.value();
                        return F.delay((Function0)(JFunction0.mcV.sp & Serializable)() -> logger.error("Error logging response body", t));
                    }
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Right right = (Right)either;
                    BoxedUnit boxedUnit = (BoxedUnit)right.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (boxedUnit2 != null) {
                        if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)either);
                        return F.unit();
                    }
                    if (boxedUnit3 == null) return F.unit();
                    throw new MatchError((Object)either);
                });
            }, (Functor)F);
        }))), F);
    }

    public <F> String defaultResponseColor(Response<F> response) {
        String string;
        Status.ResponseClass responseClass = response.status().responseClass();
        boolean bl = Status.Informational$.MODULE$.equals(responseClass) ? true : (Status.Successful$.MODULE$.equals(responseClass) ? true : Status.Redirection$.MODULE$.equals(responseClass));
        if (bl) {
            string = "\u001b[32m";
        } else if (Status.ClientError$.MODULE$.equals(responseClass)) {
            string = "\u001b[33m";
        } else if (Status.ServerError$.MODULE$.equals(responseClass)) {
            string = "\u001b[31m";
        } else {
            throw new MatchError((Object)responseClass);
        }
        return string;
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Function1<Response<F>, String> color, Option<Function1<String, F>> logAction, Client<F> client, Concurrent<F> evidence$5) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable)response -> {
            Object object;
            String prelude = new StringBuilder(1).append(response.httpVersion()).append(" ").append(response.status()).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)response, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)response, logBody, (Sync)evidence$5);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object textF = some.value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)evidence$5).map((Function1 & Serializable)text -> new StringBuilder(7).append("body=\"").append((String)text).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = Sync$.MODULE$.apply((Sync)evidence$5).pure((Object)"");
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)evidence$5).map((Function1 & Serializable)body -> new StringBuilder(4).append(color.apply(response)).append(prelude).append(ResponseLogger$.spaced$1(headers)).append(ResponseLogger$.spaced$1(body)).append("\u001b[0m").toString());
        }, evidence$5);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$colored$default$3$1(elem));
    }

    public <F> Function1<Response<Nothing$>, String> colored$default$4() {
        return (Function1 & Serializable)response -> MODULE$.defaultResponseColor((Response)response);
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$logBodyText$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private static final String spaced$1(String x) {
        return x.isEmpty() ? x : new StringBuilder(1).append(" ").append(x).toString();
    }

    public static final /* synthetic */ boolean $anonfun$colored$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private ResponseLogger$() {
    }
}

