/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client.middleware;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.Monad;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import org.http4s.Entity;
import org.http4s.Headers$;
import org.http4s.Message;
import org.http4s.Request;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.client.Client;
import org.http4s.client.Client$;
import org.http4s.client.middleware.Logger$;
import org.typelevel.ci.CIString;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.LoggerFactory;
import org.typelevel.log4cats.LoggerFactory$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ResponseLogger$ {
    public static final ResponseLogger$ MODULE$ = new ResponseLogger$();

    private <F> F defaultLogAction(String s, Logger<F> evidence$1) {
        return (F)org.typelevel.log4cats.Logger$.MODULE$.apply(evidence$1).info((Function0 & Serializable)() -> s);
    }

    public <F> Client<F> apply(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, GenConcurrent<F, Throwable> evidence$2, LoggerFactory<F> evidence$3) {
        Logger logger = LoggerFactory$.MODULE$.apply(evidence$3).getLogger("org.http4s.client.middleware.ResponseLogger");
        return this.impl(client, logBody, (Function1 & Serializable)response -> Logger$.MODULE$.logMessage(response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Logger)logger)), evidence$2), evidence$2, logger);
    }

    public <F> Function1<CIString, Object> apply$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$apply$default$3$1(elem));
    }

    public <F> None$ apply$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> logBodyText(boolean logHeaders, Function1<Stream<F, Object>, Option<F>> logBody, Function1<CIString, Object> redactHeadersWhen, Option<Function1<String, F>> logAction, Client<F> client, GenConcurrent<F, Throwable> evidence$4, LoggerFactory<F> evidence$5) {
        Logger logger = LoggerFactory$.MODULE$.apply(evidence$5).getLogger("org.http4s.client.middleware.ResponseLogger");
        return this.impl(client, true, (Function1 & Serializable)response -> org.http4s.internal.Logger$.MODULE$.logMessageWithBodyText((Message)response, logHeaders, logBody, redactHeadersWhen, (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Logger)logger)), (Monad)evidence$4), evidence$4, logger);
    }

    public <F> Function1<CIString, Object> logBodyText$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$logBodyText$default$3$1(elem));
    }

    public <F> None$ logBodyText$default$4() {
        return None$.MODULE$;
    }

    public <F> Client<F> customized(Client<F> client, boolean logBody, Option<Function1<String, F>> logAction, Function1<Response<F>, F> responseToText, GenConcurrent<F, Throwable> evidence$6, LoggerFactory<F> evidence$7) {
        Logger logger = LoggerFactory$.MODULE$.apply(evidence$7).getLogger("org.http4s.client.middleware.ResponseLogger");
        return this.impl(client, logBody, (Function1 & Serializable)response -> {
            Function1 log = (Function1)logAction.getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)s -> MODULE$.defaultLogAction((String)s, (Logger)logger));
            return package.all$.MODULE$.toFlatMapOps(responseToText.apply(response), (FlatMap)evidence$6).flatMap(log);
        }, evidence$6, logger);
    }

    public <F> boolean customized$default$2() {
        return true;
    }

    public <F> None$ customized$default$3() {
        return None$.MODULE$;
    }

    private <F> Client<F> impl(Client<F> client, boolean logBody, Function1<Response<F>, F> logMessage, GenConcurrent<F, Throwable> F, Logger<F> logger) {
        return Client$.MODULE$.apply((Function1 & Serializable)req -> client.run((Request)req).flatMap((Function1 & Serializable)response -> ResponseLogger$.logResponse$1(response, logBody, logMessage, F, logger)), F);
    }

    public <F> String defaultResponseColor(Response<F> response) {
        Status.ResponseClass responseClass = response.status().responseClass();
        if (Status.Informational$.MODULE$.equals(responseClass) ? true : (Status.Successful$.MODULE$.equals(responseClass) ? true : Status.Redirection$.MODULE$.equals(responseClass))) {
            return "\u001b[32m";
        }
        if (Status.ClientError$.MODULE$.equals(responseClass)) {
            return "\u001b[33m";
        }
        if (Status.ServerError$.MODULE$.equals(responseClass)) {
            return "\u001b[31m";
        }
        throw new MatchError((Object)responseClass);
    }

    public <F> Client<F> colored(boolean logHeaders, boolean logBody, Function1<CIString, Object> redactHeadersWhen, Function1<Response<F>, String> color, Option<Function1<String, F>> logAction, Client<F> client, GenConcurrent<F, Throwable> evidence$8, LoggerFactory<F> evidence$9) {
        return this.customized(client, logBody, logAction, (Function1 & Serializable)response -> {
            Object object;
            String prelude = new StringBuilder(1).append(response.httpVersion()).append(" ").append(response.status()).toString();
            String headers = org.http4s.internal.Logger$.MODULE$.defaultLogHeaders((Message)response, logHeaders, redactHeadersWhen);
            Option option = org.http4s.internal.Logger$.MODULE$.defaultLogBody((Message)response, logBody, evidence$8);
            if (option instanceof Some) {
                Some some = (Some)option;
                Object textF = some.value();
                object = package.all$.MODULE$.toFunctorOps(textF, (Functor)evidence$8).map((Function1 & Serializable)text -> new StringBuilder(7).append("body=\"").append((String)text).append("\"").toString());
            } else if (None$.MODULE$.equals(option)) {
                object = ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)""), (Applicative)evidence$8);
            } else {
                throw new MatchError((Object)option);
            }
            Object bodyText = object;
            return package.all$.MODULE$.toFunctorOps(bodyText, (Functor)evidence$8).map((Function1 & Serializable)body -> new StringBuilder(4).append(color.apply(response)).append(prelude).append(ResponseLogger$.spaced$1(headers)).append(ResponseLogger$.spaced$1(body)).append("\u001b[0m").toString());
        }, evidence$8, evidence$9);
    }

    public <F> Function1<CIString, Object> colored$default$3() {
        return (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ResponseLogger$.$anonfun$colored$default$3$1(elem));
    }

    public <F> Function1<Response<Object>, String> colored$default$4() {
        return (Function1 & Serializable)response -> MODULE$.defaultResponseColor((Response)response);
    }

    public <F> None$ colored$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    public static final /* synthetic */ boolean $anonfun$logBodyText$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private static final Resource logResponse$1(Response response, boolean logBody$3, Function1 logMessage$1, GenConcurrent F$1, Logger logger$4) {
        if (!logBody$3) {
            return cats.effect.package$.MODULE$.Resource().eval(package.all$.MODULE$.toFunctorOps(logMessage$1.apply((Object)response), (Functor)F$1).as((Object)response));
        }
        Entity entity = response.entity();
        if (entity instanceof Entity.Streamed) {
            return cats.effect.package$.MODULE$.Resource().suspend(package.all$.MODULE$.toFunctorOps(F$1.ref((Object)package$.MODULE$.Vector().empty()), (Functor)F$1).map((Function1 & Serializable)vec -> {
                Function1 & Serializable dumpChunksToVec = (Function1 & Serializable)x$1 -> x$1.chunks().flatMap((Function1 & Serializable)s -> Stream$.MODULE$.exec(vec.update((Function1 & Serializable)x$2 -> (Vector)x$2.$colon$plus(s))), NotGiven$.MODULE$.default());
                return cats.effect.package$.MODULE$.Resource().make(F$1.pure((Object)response.pipeBodyThrough((Function1 & Serializable)x$3 -> Stream.InvariantOps$.MODULE$.observe$extension(Stream$.MODULE$.InvariantOps(x$3), dumpChunksToVec, F$1))), (Function1 & Serializable)x$4 -> {
                    Stream newBody = Stream$.MODULE$.eval(vec.get()).flatMap((Function1 & Serializable)os -> Stream$.MODULE$.emits(os), NotGiven$.MODULE$.default()).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    return ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(logMessage$1.apply((Object)response.withBodyStream(newBody)), (ApplicativeError)F$1), (Function1 & Serializable)t -> logger$4.error(t, (Function0 & Serializable)() -> "Error logging response body"), (ApplicativeError)F$1);
                }, (Functor)F$1);
            }));
        }
        if (Entity.Empty$.MODULE$.equals(entity) ? true : entity instanceof Entity.Strict) {
            return cats.effect.package$.MODULE$.Resource().eval(package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(package.all$.MODULE$.catsSyntaxApplicativeError(logMessage$1.apply((Object)response), (ApplicativeError)F$1), (Function1 & Serializable)t -> logger$4.error(t, (Function0 & Serializable)() -> "Error logging response body"), (ApplicativeError)F$1), (Functor)F$1).as((Object)response));
        }
        throw new MatchError((Object)entity);
    }

    private static final String spaced$1(String x) {
        if (x.isEmpty()) {
            return x;
        }
        return new StringBuilder(1).append(" ").append(x).toString();
    }

    public static final /* synthetic */ boolean $anonfun$colored$default$3$1(CIString elem) {
        return Headers$.MODULE$.SensitiveHeaders().contains((Object)elem);
    }

    private ResponseLogger$() {
    }
}

