/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.client;

import cats.Applicative;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.Kleisli;
import cats.data.Kleisli$;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import org.http4s.EntityDecoder;
import org.http4s.HttpVersion;
import org.http4s.Media;
import org.http4s.MediaRange;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.client.UnexpectedStatus$;
import org.http4s.headers.Accept$;
import org.http4s.headers.MediaRangeAndQValue$;
import org.typelevel.vault.Vault;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.util.NotGiven$;

public abstract class DefaultClient<F>
implements Client<F> {
    private final MonadCancel<F, Throwable> F;

    public DefaultClient(MonadCancel<F, Throwable> F) {
        this.F = F;
    }

    @Override
    public abstract Resource<F, Response<F>> run(Request<F> var1);

    @Override
    public <A> F fetch(Request<F> req, Function1<Response<F>, F> f) {
        return (F)this.run(req).use(f, this.F);
    }

    @Override
    public <A> F fetch(F req, Function1<Response<F>, F> f) {
        return (F)package.all$.MODULE$.toFlatMapOps(req, this.F).flatMap((Function1 & Serializable)_$2 -> this.run((Request<F>)_$2).use(f, this.F));
    }

    @Override
    public <A> Kleisli<F, Request<F>, A> toKleisli(Function1<Response<F>, F> f) {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)_$3 -> this.run((Request<F>)_$3).use(f, this.F));
    }

    @Override
    public Kleisli<F, Request<F>, Response<F>> toHttpApp() {
        return Kleisli$.MODULE$.apply((Function1 & Serializable)req -> this.F.map(this.run((Request<F>)req).allocated(this.F), (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Response resp = (Response)tuple2._1();
            Object release = tuple2._2();
            return (Response)resp.pipeBodyThrough((Function1 & Serializable)_$4 -> _$4.onFinalizeWeak(release, this.F));
        }));
    }

    @Override
    public Stream<F, Response<F>> stream(Request<F> req) {
        return Stream$.MODULE$.resource(this.run(req), this.F);
    }

    public <A> Stream<F, A> streaming(Request<F> req, Function1<Response<F>, Stream<F, A>> f) {
        return this.stream(req).flatMap(f, NotGiven$.MODULE$.value());
    }

    public <A> Stream<F, A> streaming(F req2, Function1<Response<F>, Stream<F, A>> f) {
        return Stream$.MODULE$.eval(req2).flatMap((Function1 & Serializable)req -> this.stream((Request<F>)req), NotGiven$.MODULE$.value()).flatMap(f, NotGiven$.MODULE$.value());
    }

    @Override
    public <A> F expectOr(Request<F> req, Function1<Response<F>, F> onError, EntityDecoder<F, A> d) {
        Request request;
        if (d.consumes().nonEmpty()) {
            List m = d.consumes().toList();
            request = (Request)req.addHeader((Object)Accept$.MODULE$.apply(MediaRangeAndQValue$.MODULE$.apply((MediaRange)m.head(), MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()), (Seq)((List)m.tail()).map((Function1 & Serializable)_$5 -> MediaRangeAndQValue$.MODULE$.apply(_$5, MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()))), Accept$.MODULE$.headerInstance());
        } else {
            request = req;
        }
        Request r = request;
        return (F)this.run(r).use((Function1 & Serializable)x$1 -> {
            Object object;
            Option option;
            Response response = x$1;
            if (response != null && !(option = Status.Successful$.MODULE$.unapply(response)).isEmpty()) {
                Response response2;
                Response resp = response2 = (Response)option.get();
                object = ((EitherT)package.all$.MODULE$.toBifunctorOps((Object)d.decode((Media)resp, false), EitherT$.MODULE$.catsDataBifunctorForEitherT(this.F)).leftWiden()).rethrowT(this.F);
            } else {
                Response failedResponse = response;
                object = package.all$.MODULE$.toFlatMapOps(onError.apply((Object)failedResponse), this.F).flatMap((Function1 & Serializable)e -> this.F.raiseError(e));
            }
            return object;
        }, this.F);
    }

    @Override
    public <A> F expect(Request<F> req, EntityDecoder<F, A> d) {
        return (F)this.expectOr((F)req, (Function1<Response<F>, F>)(Function1 & Serializable)resp -> this.defaultOnError(req, (Response<F>)resp, (Applicative<F>)this.F), d);
    }

    @Override
    public <A> F expectOr(F req, Function1<Response<F>, F> onError, EntityDecoder<F, A> d) {
        return (F)package.all$.MODULE$.toFlatMapOps(req, this.F).flatMap((Function1 & Serializable)_$6 -> this.expectOr((F)_$6, onError, d));
    }

    @Override
    public <A> F expect(F req2, EntityDecoder<F, A> d) {
        return (F)package.all$.MODULE$.toFlatMapOps(req2, this.F).flatMap((Function1 & Serializable)req -> this.expectOr((F)req, (Function1<Response<F>, F>)(Function1 & Serializable)resp -> this.defaultOnError((Request<F>)req, (Response<F>)resp, (Applicative<F>)this.F), d));
    }

    @Override
    public <A> F expectOr(Uri uri, Function1<Response<F>, F> onError, EntityDecoder<F, A> d) {
        return (F)this.expectOr((F)Request$.MODULE$.apply(Method$.MODULE$.GET(), uri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()), onError, d);
    }

    @Override
    public <A> F expect(Uri uri, EntityDecoder<F, A> d) {
        Request request = Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), uri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6());
        return this.expectOr(uri, (Function1<Response<F>, F>)(Function1 & Serializable)resp -> this.defaultOnError((Request<F>)request, (Response<F>)resp, (Applicative<F>)this.F), d);
    }

    @Override
    public <A> F expectOr(String s, Function1<Response<F>, F> onError, EntityDecoder<F, A> d) {
        return (F)Uri$.MODULE$.fromString(s).fold((Function1 & Serializable)e -> this.F.raiseError(e), (Function1 & Serializable)uri -> this.expectOr((Uri)uri, onError, d));
    }

    @Override
    public <A> F expect(String s, EntityDecoder<F, A> d) {
        Uri uri = Uri$.MODULE$.unsafeFromString(s);
        Method method = Request$.MODULE$.apply$default$1();
        HttpVersion httpVersion = Request$.MODULE$.apply$default$3();
        List list = Request$.MODULE$.apply$default$4();
        Stream stream = Request$.MODULE$.apply$default$5();
        Vault vault = Request$.MODULE$.apply$default$6();
        Request request = Request$.MODULE$.apply(method, uri, httpVersion, list, stream, vault);
        return this.expectOr(s, (Function1<Response<F>, F>)(Function1 & Serializable)resp -> this.defaultOnError((Request<F>)request, (Response<F>)resp, (Applicative<F>)this.F), d);
    }

    @Override
    public <A> F expectOptionOr(Request<F> req, Function1<Response<F>, F> onError, EntityDecoder<F, A> d) {
        Request request;
        if (d.consumes().nonEmpty()) {
            List m = d.consumes().toList();
            request = (Request)req.addHeader((Object)Accept$.MODULE$.apply(MediaRangeAndQValue$.MODULE$.apply((MediaRange)m.head(), MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()), (Seq)((List)m.tail()).map((Function1 & Serializable)_$7 -> MediaRangeAndQValue$.MODULE$.apply(_$7, MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()))), Accept$.MODULE$.headerInstance());
        } else {
            request = req;
        }
        Request r = request;
        return (F)this.run(r).use((Function1 & Serializable)x$1 -> {
            Object object;
            Option option;
            Response response = x$1;
            if (response != null && !(option = Status.Successful$.MODULE$.unapply(response)).isEmpty()) {
                Response response2;
                Response resp = response2 = (Response)option.get();
                object = package.all$.MODULE$.toFunctorOps(((EitherT)package.all$.MODULE$.toBifunctorOps((Object)d.decode((Media)resp, false), EitherT$.MODULE$.catsDataBifunctorForEitherT(this.F)).leftWiden()).rethrowT(this.F), this.F).map((Function1 & Serializable)_$8 -> {
                    Object object = package.all$.MODULE$.catsSyntaxOptionId(_$8);
                    return OptionIdOps$.MODULE$.some$extension(object);
                });
            } else {
                Response failedResponse = response;
                Status status = failedResponse.status();
                Status status2 = Status$.MODULE$.NotFound();
                Status status3 = status;
                if (!(status2 != null ? !status2.equals(status3) : status3 != null)) {
                    Option option2 = (Option)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Option$.MODULE$.empty());
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)option2, this.F);
                } else {
                    Status status4 = Status$.MODULE$.Gone();
                    Status status5 = status;
                    if (!(status4 != null ? !status4.equals(status5) : status5 != null)) {
                        Option option3 = (Option)package.all$.MODULE$.catsSyntaxApplicativeId((Object)Option$.MODULE$.empty());
                        object = ApplicativeIdOps$.MODULE$.pure$extension((Object)option3, this.F);
                    } else {
                        object = package.all$.MODULE$.toFlatMapOps(onError.apply((Object)failedResponse), this.F).flatMap((Function1 & Serializable)e -> this.F.raiseError(e));
                    }
                }
            }
            return object;
        }, this.F);
    }

    @Override
    public <A> F expectOption(Request<F> req, EntityDecoder<F, A> d) {
        return this.expectOptionOr(req, (Function1 & Serializable)resp -> this.defaultOnError(req, (Response<F>)resp, (Applicative<F>)this.F), d);
    }

    @Override
    public <A> F fetchAs(Request<F> req, EntityDecoder<F, A> d) {
        Request request;
        if (d.consumes().nonEmpty()) {
            List m = d.consumes().toList();
            request = (Request)req.addHeader((Object)Accept$.MODULE$.apply(MediaRangeAndQValue$.MODULE$.apply((MediaRange)m.head(), MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()), (Seq)((List)m.tail()).map((Function1 & Serializable)_$9 -> MediaRangeAndQValue$.MODULE$.apply(_$9, MediaRangeAndQValue$.MODULE$.$lessinit$greater$default$2()))), Accept$.MODULE$.headerInstance());
        } else {
            request = req;
        }
        Request r = request;
        return (F)this.run(r).use((Function1 & Serializable)resp -> ((EitherT)package.all$.MODULE$.toBifunctorOps((Object)d.decode((Media)resp, false), EitherT$.MODULE$.catsDataBifunctorForEitherT(this.F)).leftWiden()).rethrowT(this.F), this.F);
    }

    @Override
    public <A> F fetchAs(F req, EntityDecoder<F, A> d) {
        return (F)package.all$.MODULE$.toFlatMapOps(req, this.F).flatMap((Function1 & Serializable)_$10 -> this.fetchAs((F)_$10, d));
    }

    @Override
    public F status(Request<F> req) {
        return (F)this.run(req).use((Function1 & Serializable)resp -> this.F.pure((Object)resp.status()), this.F);
    }

    @Override
    public F status(F req2) {
        return (F)package.all$.MODULE$.toFlatMapOps(req2, this.F).flatMap((Function1 & Serializable)req -> this.status((F)req));
    }

    @Override
    public F statusFromUri(Uri uri) {
        return (F)this.status((F)Request$.MODULE$.apply(Request$.MODULE$.apply$default$1(), uri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()));
    }

    @Override
    public F statusFromString(String s) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.F.fromEither(Uri$.MODULE$.fromString(s)), this.F).flatMap((Function1 & Serializable)uri -> this.statusFromUri((Uri)uri));
    }

    @Override
    public F successful(Request<F> req) {
        return (F)package.all$.MODULE$.toFunctorOps(this.status((F)req), this.F).map((Function1 & Serializable)_$11 -> _$11.isSuccess());
    }

    @Override
    public F successful(F req2) {
        return (F)package.all$.MODULE$.toFlatMapOps(req2, this.F).flatMap((Function1 & Serializable)req -> this.successful((F)req));
    }

    @Override
    public <A> F get(Uri uri, Function1<Response<F>, F> f) {
        return (F)this.run(Request$.MODULE$.apply(Method$.MODULE$.GET(), uri, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6())).use(f, this.F);
    }

    @Override
    public <A> F get(String s, Function1<Response<F>, F> f) {
        return (F)Uri$.MODULE$.fromString(s).fold((Function1 & Serializable)e -> this.F.raiseError(e), (Function1 & Serializable)uri -> this.get((Uri)uri, f));
    }

    private F defaultOnError(Request<F> req, Response<F> resp, Applicative<F> F) {
        return (F)F.pure((Object)UnexpectedStatus$.MODULE$.apply(resp.status(), req.method(), req.uri()));
    }
}

